/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.Reorderable;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class TableRowTransferHandler
extends TransferHandler {
    DataFlavor localObjectFlavor = new DataFlavor(Integer.class, "Integer Row Index");
    private JTable table = null;

    public TableRowTransferHandler(JTable jTable) {
        this.table = jTable;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        assert (jComponent == this.table);
        return new DataHandler((Object)new Integer(this.table.getSelectedRow()), this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        boolean bl = transferSupport.getComponent() == this.table && transferSupport.isDrop() && transferSupport.isDataFlavorSupported(this.localObjectFlavor);
        this.table.setCursor(bl ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return bl;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        JTable jTable = (JTable)transferSupport.getComponent();
        JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
        int n = dropLocation.getRow();
        int n2 = this.table.getModel().getRowCount();
        if (n < 0 || n > n2) {
            n = n2;
        }
        jTable.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Integer n3 = (Integer)transferSupport.getTransferable().getTransferData(this.localObjectFlavor);
            if (n3 != -1 && n3 != n) {
                ((Reorderable)((Object)this.table.getModel())).reorder(n3, n);
                if (n > n3) {
                    --n;
                }
                jTable.getSelectionModel().addSelectionInterval(n, n);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2) {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

