/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.graph.Dot;
import g2d.npa.examples.Examples;
import g2d.terms.Algebra;
import g2d.terms.HoleTerm;
import g2d.terms.Sort;
import g2d.terms.Term;
import g2d.util.IO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Syntax {
    public final String[] sorts;
    public final String[][] edges;
    public final String[][] declarations;
    public final String[][] subsorter;
    public final String[][] operators;
    public final Algebra baseAlgebra;
    public final Algebra knowledgeAlgebra;
    public final Sort knowledgeSort = new Sort("IntruderKnowledge");
    public final Term knowledgeTemplate = HoleTerm.fromSort(this.knowledgeSort);
    public final Algebra strandAlgebra;
    public final Sort strandSort = new Sort("SMsg");
    public final Term strandTemplate = HoleTerm.fromSort(this.strandSort);
    public final Algebra attackAlgebra;
    public static final Syntax example;

    public Syntax(String[] stringArray, String[][] stringArray2, String[][] stringArray3, String[][] stringArray4, String[][] stringArray5) {
        this.sorts = stringArray;
        this.edges = stringArray2;
        this.declarations = stringArray3;
        this.subsorter = stringArray4;
        this.operators = stringArray5;
        if (stringArray5 != null && stringArray4 != null) {
            this.baseAlgebra = new Algebra(this.sorts, this.subsorter, this.operators);
            this.knowledgeAlgebra = Algebra.union(this.baseAlgebra, Examples.IK);
            this.strandAlgebra = Algebra.union(this.baseAlgebra, Examples.STRANDS);
            this.attackAlgebra = Algebra.union(this.knowledgeAlgebra, Examples.STRANDS);
        } else {
            this.baseAlgebra = null;
            this.knowledgeAlgebra = null;
            this.strandAlgebra = null;
            this.attackAlgebra = null;
        }
    }

    public Syntax(String[] stringArray, String[][] stringArray2, String[][] stringArray3) {
        this(stringArray, stringArray2, stringArray3, null, null);
    }

    public String makeDotInput() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph S {");
        for (String string : this.sorts) {
            stringBuffer.append("\n\t").append(string).append(" [shape=plaintext];");
        }
        for (String string : this.edges) {
            String string2 = string[0];
            for (int i = 1; i < ((String)string).length; ++i) {
                stringBuffer.append("\n\t").append(string[i]).append(" -> ").append(string2);
            }
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    public BufferedImage makeImage() {
        BufferedImage bufferedImage = null;
        Dot.DotFormat dotFormat = Dot.DotFormat.PNG;
        try {
            File file = File.createTempFile("syntax", "." + dotFormat.extension);
            String string = this.makeDotInput();
            String string2 = Dot.askDot(dotFormat, string);
            IO.b64String2File(string2, file);
            bufferedImage = ImageIO.read(file);
            file.delete();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return bufferedImage;
    }

    public static void main(String[] stringArray) {
        IO.string2File(example.makeDotInput(), "syntax.dot");
    }

    static {
        String[] stringArray = new String[]{"Msg", "Public", "Enc", "Key", "Nonce", "Name"};
        String[][] stringArray2 = new String[][]{{"Enc", "Msg"}, {"Key", "Msg"}, {"Name", "Key"}, {"Name", "Msg"}, {"Name", "Public"}, {"Nonce", "Msg"}};
        String[][] stringArray3 = new String[][]{{"Constants:", "  a :: Name", "  b :: Name", "  i :: Name"}, {" Constructors:", "   n(?Name:Name,?Fresh:Fresh) :: Nonce ", "   pk(?Key:Key,?Msg:Msg) :: Enc   --- public key encryption", "   sk(?Key:Key,?Msg:Msg) :: Enc   --- private/secret key encryption", " ", "   (?Msg:Msg ; ?Msg:Msg) :: Msg  --- Concatenation"}};
        example = new Syntax(stringArray, stringArray2, stringArray3);
    }
}

