/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.Substitution;
import g2d.npa.SubstitutionTable;
import g2d.terms.Term;
import javax.swing.table.AbstractTableModel;

class SubstitutionTableModel
extends AbstractTableModel {
    final SubstitutionTable table;
    final Substitution substitution;
    static final String[] columnNames = new String[]{"Variable", "Sort", "Value"};

    public SubstitutionTableModel(SubstitutionTable substitutionTable, AttackEditor attackEditor, Substitution substitution) {
        if (substitutionTable == null || attackEditor == null || substitution == null) {
            throw new IllegalArgumentException("SubstitutionTableModel: bad arguments");
        }
        this.table = substitutionTable;
        this.substitution = substitution;
    }

    @Override
    public int getRowCount() {
        return this.substitution.variables.length;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.substitution.variables[n];
        }
        if (n2 == 1) {
            return this.substitution.sorts[n];
        }
        Term term = this.substitution.values[n];
        return term != null ? term : this.substitution.variables[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object != null && object instanceof Term) {
            Term term = (Term)object;
            this.substitution.values[n] = term.holeCount() == 0 ? term : null;
        }
    }
}

