/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.Protocol;
import g2d.npa.Role;
import g2d.terms.Sort;
import g2d.terms.Term;

public class Substitution {
    String[] variables;
    Sort[] sorts;
    Term[] values;

    Substitution(Role role, Protocol protocol) {
        if (role == null || protocol == null) {
            throw new IllegalArgumentException("Substitution: bad argument");
        }
        int n = role.variables.length;
        this.variables = new String[n];
        this.sorts = new Sort[n];
        this.values = new Term[n];
        int n2 = 0;
        for (String[] stringArray : role.variables) {
            this.variables[n2] = stringArray[0];
            this.sorts[n2] = new Sort(stringArray[1]);
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < this.variables.length; ++i) {
            Term term = this.values[i];
            String string = this.variables[i];
            if (term == null || term.equals(string)) continue;
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string).append(" <- ").append(((Object)term).toString());
            bl = true;
        }
        return stringBuffer.toString();
    }

    public String toMaudeString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < this.variables.length; ++i) {
            String string = this.variables[i];
            Sort sort = this.sorts[i];
            Term term = this.values[i];
            if (term == null || term.equals(string)) continue;
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(").append(string).append(" ").append(sort.toString()).append(" ").append(((Object)term).toString()).append(")");
            bl = true;
        }
        return stringBuffer.toString();
    }
}

