/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.Role;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

class RoleTableModel
extends AbstractTableModel {
    int columnCount;
    int rowCount;
    String[][] data;
    String[] columnNames;
    protected int[] columnHeight;

    public RoleTableModel(AttackEditor attackEditor) {
        this.init(attackEditor);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public String getColumnName(int n) {
        if (0 <= n && n < this.columnCount) {
            return this.columnNames[n];
        }
        return null;
    }

    private void init(AttackEditor attackEditor) {
        int n;
        Role role;
        HashMap<String, Role> hashMap = attackEditor.protocol.rolesByName;
        this.columnCount = hashMap.size();
        this.columnNames = new String[this.columnCount];
        this.columnHeight = new int[this.columnCount];
        int n2 = 0;
        for (Map.Entry<String, Role> entry : hashMap.entrySet()) {
            role = entry.getValue();
            if (role.events == null) continue;
            n = role.events.size();
            this.columnNames[n2] = role.name;
            this.columnHeight[n2] = n;
            if (n > this.rowCount) {
                this.rowCount = n;
            }
            ++n2;
        }
        this.data = new String[this.rowCount][this.columnCount];
        n2 = 0;
        for (Map.Entry<String, Role> entry : hashMap.entrySet()) {
            role = entry.getValue();
            if (role.events == null) continue;
            n = role.events.size();
            for (int i = 0; i < n; ++i) {
                this.data[i][n2] = role.events.get(i).toString();
            }
            ++n2;
        }
    }
}

