/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.netviewer.StatusBar;
import g2d.npa.AttackEditor;
import g2d.npa.NeverPattern;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class NeverPatterns
extends JPanel {
    public final StatusBar statusBar = new StatusBar("Never Patterns:");
    private final JButton addButton = new JButton();
    private final JButton deleteButton = new JButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int rows = 4;
    private GridLayout layout = new GridLayout(this.rows, 1);
    private final JPanel patterns = new JPanel(this.layout);
    private final ArrayList<NeverPattern> patternList = new ArrayList();
    private final AttackEditor editor;

    public void clear() {
        this.buttonGroup = new ButtonGroup();
        this.rows = 4;
        this.layout.setRows(this.rows);
        for (NeverPattern neverPattern : this.patternList) {
            this.patterns.remove(neverPattern);
        }
        this.patternList.clear();
        this.validate();
        this.repaint();
    }

    public NeverPatterns(AttackEditor attackEditor) {
        super(new BorderLayout(10, 10));
        this.editor = attackEditor;
        this.addButton.setAction(new AbstractAction("Add Never Pattern"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NeverPatterns.this.add();
            }
        });
        this.deleteButton.setAction(new AbstractAction("Delete Selected"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NeverPatterns.this.delete();
            }
        });
        this.statusBar.buttons.add(this.addButton);
        this.statusBar.buttons.add(this.deleteButton);
        this.add((Component)this.statusBar, "North");
        this.add((Component)new JScrollPane(this.patterns), "Center");
    }

    public void addRole(String string) {
        boolean bl = false;
        for (NeverPattern neverPattern : this.patternList) {
            if (!neverPattern.selected.isSelected()) continue;
            neverPattern.attackTable.addRole(string);
            bl = true;
        }
        if (bl) {
            this.repaint();
        }
    }

    public boolean hasSelectedPattern() {
        for (NeverPattern neverPattern : this.patternList) {
            if (!neverPattern.selected.isSelected()) continue;
            return true;
        }
        return false;
    }

    private void add() {
        NeverPattern neverPattern = new NeverPattern(this.editor);
        this.invalidate();
        if (this.patternList.size() == this.rows) {
            this.rows = 2 * this.rows;
            this.layout.setRows(this.rows);
        }
        this.buttonGroup.add(neverPattern.selected);
        neverPattern.selected.setSelected(true);
        this.patterns.add(neverPattern);
        this.patternList.add(neverPattern);
        this.validate();
        this.repaint();
    }

    private void delete() {
        int n = this.patternList.size() - 1;
        this.invalidate();
        for (int i = n; i >= 0; --i) {
            NeverPattern neverPattern = this.patternList.get(i);
            if (!neverPattern.selected.isSelected()) continue;
            this.patterns.remove(neverPattern);
            this.buttonGroup.remove(neverPattern.selected);
            this.patternList.remove(i);
        }
        this.buttonGroup.clearSelection();
        this.validate();
        this.repaint();
    }

    @Override
    public String toString() {
        String string = "";
        for (NeverPattern neverPattern : this.patternList) {
            string = string + neverPattern.toString();
        }
        return string;
    }
}

