/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.FreshSet;
import g2d.npa.Role;
import g2d.npa.Substitution;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class AttackTableModel
extends AbstractTableModel {
    private final AttackEditor editor;
    private ArrayList<String> roles = new ArrayList();
    private ArrayList<Integer> bars = new ArrayList();
    private ArrayList<Integer> heights = new ArrayList();
    private ArrayList<Integer> ceilings = new ArrayList();
    private ArrayList<FreshSet> fresh = new ArrayList();
    private ArrayList<Substitution> substitutions = new ArrayList();
    static final String[] columnNames = new String[]{"Role", "Bar", "Height", "Fresh Set", "Substitution"};

    public AttackTableModel(AttackEditor attackEditor) {
        this.editor = attackEditor;
    }

    public void clear() {
        int n;
        for (int i = n = this.getRowCount(); i > 0; --i) {
            this.removeRow(i - 1);
        }
    }

    @Override
    public int getRowCount() {
        return this.roles.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.roles.get(n);
        }
        if (n2 == 1) {
            return this.bars.get(n);
        }
        if (n2 == 2) {
            return this.heights.get(n);
        }
        if (n2 == 3) {
            return this.fresh.get(n);
        }
        return this.substitutions.get(n);
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            this.tosser(n, (String)object);
        } else if (n2 == 1) {
            this.bars.set(n, (Integer)object);
        } else if (n2 == 2) {
            this.heights.set(n, (Integer)object);
        } else if (n2 == 3) {
            this.fresh.set(n, (FreshSet)object);
        } else if (n2 == 4) {
            this.substitutions.set(n, (Substitution)object);
        }
    }

    void tosser(int n, String string) {
        if ("Delete".equals(string)) {
            this.removeRow(n);
        }
    }

    int getBar(int n) {
        return this.bars.get(n);
    }

    int getCeiling(int n) {
        return this.ceilings.get(n);
    }

    int getHeight(int n) {
        return this.heights.get(n);
    }

    FreshSet getFreshSet(int n) {
        return this.fresh.get(n);
    }

    Role getRole(int n) {
        String string = this.roles.get(n);
        return this.editor.protocol.getRole(string);
    }

    private void removeRow(int n) {
        this.roles.remove(n);
        this.bars.remove(n);
        this.heights.remove(n);
        this.ceilings.remove(n);
        this.fresh.remove(n);
        this.substitutions.remove(n);
        this.fireTableRowsUpdated(0, this.roles.size());
    }

    protected void addRole(String string) {
        Role role = this.editor.protocol.getRole(string);
        if (role != null && !this.roles.contains(string)) {
            int n = role.events.size();
            this.roles.add(string);
            this.bars.add(n);
            this.heights.add(n);
            this.ceilings.add(n);
            this.fresh.add(role.fresh);
            this.substitutions.add(new Substitution(role, this.editor.protocol));
            this.fireTableStructureChanged();
        }
    }

    protected void removeRole(String string) {
        int n = this.roles.indexOf(string);
        if (n != -1) {
            this.removeRow(n);
            this.fireTableRowsUpdated(0, this.roles.size());
        }
    }

    protected void toStringBuffer(StringBuffer stringBuffer) {
        int n = this.getRowCount();
        boolean bl = false;
        stringBuffer.append("(");
        for (int i = 0; i < n; ++i) {
            Substitution substitution = this.substitutions.get(i);
            FreshSet freshSet = this.fresh.get(i);
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(");
            stringBuffer.append(this.roles.get(i));
            stringBuffer.append(" ");
            stringBuffer.append(this.bars.get(i));
            stringBuffer.append(" ");
            stringBuffer.append(this.heights.get(i));
            stringBuffer.append(" ");
            stringBuffer.append("(");
            stringBuffer.append(freshSet.toString());
            stringBuffer.append(")");
            stringBuffer.append(" ");
            stringBuffer.append("(");
            if (substitution != null) {
                stringBuffer.append(substitution.toMaudeString());
            }
            stringBuffer.append(")");
            stringBuffer.append(")");
            bl = true;
        }
        stringBuffer.append(")");
    }
}

