/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.netviewer.StatusBar;
import g2d.npa.AttackTable;
import g2d.npa.HelpWindow;
import g2d.npa.NPAFrame;
import g2d.npa.NeverPatterns;
import g2d.npa.Protocol;
import g2d.npa.Role;
import g2d.npa.RolePanel;
import g2d.npa.SortedTermTable;
import g2d.npa.Syntax;
import g2d.npa.SyntaxInput;
import g2d.npa.SyntaxPanel;
import g2d.npa.TermPanel;
import g2d.terms.Algebra;
import g2d.terms.AppTerm;
import g2d.terms.Constructor;
import g2d.terms.Sort;
import g2d.terms.Term;
import g2d.util.ActorMsg;
import g2d.util.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AttackEditor
extends NPAFrame
implements ChangeListener {
    Tabs mode = Tabs.STRANDS;
    private static final boolean debug = false;
    public static final Preferences npaPreferences = NPAFrame.npaPreferences;
    public static final String RETAIN = "Retain";
    public static final String DELETE = "Delete";
    public final String name;
    public final Protocol protocol;
    public final Syntax syntax;
    public final SortedTermTable termTable;
    public final SyntaxInput syntaxInput;
    public final StatusBar statusBar;
    public final HelpWindow helpWindow;
    private Term questionableTerm;
    private final SyntaxPanel syntaxPanel;
    private final RolePanel roleTabs;
    protected final AttackTable attackTable;
    protected final TermPanel knowledgePanel;
    protected final NeverPatterns neverPatterns;
    private final JMenuBar menubar = new JMenuBar();
    private final JLabel attackLabel = new JLabel("Attack Name: ");
    private final JTextField attackName = new JTextField(30);
    private final JButton okButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton helpButton = new JButton();
    private final JButton viewButton = new JButton();
    private final JToolBar toolBar = new JToolBar();
    private final JTabbedPane rhsTabs = new JTabbedPane();
    private final JTabbedPane lhsTabs = new JTabbedPane();
    private final JPanel contentPane = new JPanel(new BorderLayout(10, 10));

    public AttackEditor(String string, Protocol protocol, Syntax syntax) {
        super("Attack Editor", "Attack_Editor_");
        this.name = string;
        this.protocol = protocol;
        this.syntax = syntax;
        this.setDefaultCloseOperation(1);
        this.termTable = new SortedTermTable(this);
        this.syntaxInput = new SyntaxInput(this);
        this.statusBar = new StatusBar("Status:");
        this.syntaxPanel = new SyntaxPanel(this);
        this.attackTable = new AttackTable(this);
        this.knowledgePanel = new TermPanel(this, "Intruder Knowledge", null, this.syntax.knowledgeTemplate, true);
        this.neverPatterns = new NeverPatterns(this);
        this.helpWindow = new HelpWindow();
        this.toolBar.add(this.attackLabel);
        this.toolBar.add(this.attackName);
        this.toolBar.setFloatable(false);
        this.roleTabs = new RolePanel(this);
        this.lhsTabs.addTab("Roles", this.roleTabs);
        this.rhsTabs.add((Component)new JScrollPane(this.attackTable), Tabs.STRANDS.ordinal());
        this.rhsTabs.setTitleAt(Tabs.STRANDS.ordinal(), Tabs.STRANDS.uc);
        this.attackTable.setFillsViewportHeight(true);
        this.rhsTabs.add((Component)new JScrollPane(this.knowledgePanel), Tabs.KNOWLEDGE.ordinal());
        this.rhsTabs.setTitleAt(Tabs.KNOWLEDGE.ordinal(), Tabs.KNOWLEDGE.uc);
        this.rhsTabs.add((Component)this.neverPatterns, Tabs.PATTERNS.ordinal());
        this.rhsTabs.setTitleAt(Tabs.PATTERNS.ordinal(), Tabs.PATTERNS.uc);
        this.rhsTabs.addChangeListener(this);
        JSplitPane jSplitPane = new JSplitPane(1, false, this.syntaxPanel, this.lhsTabs);
        npaPreferences.manageJSplitPane(jSplitPane, "Horizontal1_");
        JSplitPane jSplitPane2 = new JSplitPane(1, false, jSplitPane, this.rhsTabs);
        npaPreferences.manageJSplitPane(jSplitPane2, "Horizontal2_");
        this.okButton.setAction(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttackEditor.this.ok();
            }
        });
        this.cancelButton.setAction(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttackEditor.this.cancel();
            }
        });
        this.viewButton.setAction(new AbstractAction("View"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttackEditor.this.view();
            }
        });
        this.helpButton.setAction(new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttackEditor.this.helpWindow.setVisible(true);
            }
        });
        this.statusBar.buttons.add(this.helpButton);
        this.statusBar.buttons.add(this.viewButton);
        this.statusBar.buttons.add(this.cancelButton);
        this.statusBar.buttons.add(this.okButton);
        this.configureMenuBar();
        this.setJMenuBar(this.menubar);
        this.populateSortedTermTable();
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.contentPane.add((Component)this.toolBar, "First");
        this.contentPane.add((Component)jSplitPane2, "Center");
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.setOpaque(true);
        this.setContentPane(this.contentPane);
        this.pack();
    }

    private void configureMenuBar() {
        JMenu jMenu = new JMenu("Commands");
        JMenuItem jMenuItem = new JMenuItem("Close Editor", 87);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem.setMnemonic(87);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttackEditor.this.dispatchEvent(new WindowEvent(AttackEditor.this, 201));
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Iconify", 77);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem2.setMnemonic(77);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttackEditor.this.setState(1);
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Clear Tables", 76);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem3.setMnemonic(76);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttackEditor.this.attackTable.clear();
                AttackEditor.this.knowledgePanel.clear();
                AttackEditor.this.neverPatterns.clear();
            }
        });
        jMenu.add(jMenuItem3);
        this.menubar.add(jMenu);
    }

    public void tellterm(boolean bl, String string) {
        if (bl) {
            if (this.questionableTerm != null) {
                Sort sort = this.questionableTerm.sort();
                this.termTable.addTerm(this.questionableTerm, sort);
                this.setStatus("Okay, the term " + this.questionableTerm + " of sort " + sort + " has been added to the term table.", false);
                this.questionableTerm = null;
            } else {
                System.err.println("tellterm:  has no memory of asking about term.");
            }
        } else {
            this.setStatus("Sorry maude doesn't like the term: " + this.questionableTerm + ", thats all I know", true);
        }
        this.syntaxInput.enableInput();
    }

    public void askterm(Term term) {
        this.questionableTerm = term;
        ActorMsg.send("maude", this.name, "checkterm " + term.toString());
        this.syntaxInput.disableInput();
    }

    public void setHelp(String string) {
        if (string != null) {
            this.helpWindow.setHTML(string);
        }
    }

    public void ok() {
        String string = this.attackName.getText();
        if (string == null || "".equals(string)) {
            this.setStatus("Please name your attack first!", true);
        } else {
            String string2 = this.attackTable.toString();
            String string3 = this.knowledgePanel.toString();
            String string4 = this.neverPatterns.toString();
            String string5 = "addNewAttack " + string + " " + string2 + " " + string3 + " " + string4;
            ActorMsg.send("maude", this.name, string5);
            this.setStatus("OK I sent your attack to Maude (Check for it in the Manager's attack list)", false);
        }
    }

    public void view() {
        String string = this.attackName.getText();
        if (string == null || "".equals(string)) {
            this.setStatus("Please name your attack first!", true);
        } else {
            String string2 = this.attackTable.toString();
            String string3 = this.knowledgePanel.toString();
            String string4 = this.neverPatterns.toString();
            String string5 = "showEdAttack " + string + " " + string2 + " " + string3 + " " + string4;
            ActorMsg.send("maude", this.name, string5);
            this.setStatus("OK", false);
        }
    }

    public void cancel() {
        this.setVisible(false);
    }

    public void addTerm(Term term) {
        this.askterm(term);
    }

    private void populateSortedTermTable() {
        Constructor[] constructorArray;
        Algebra algebra = this.syntax.baseAlgebra;
        for (Constructor constructor : constructorArray = algebra.ops) {
            if (constructor.arity != 0) continue;
            Sort sort = constructor.sort;
            AppTerm appTerm = new AppTerm(constructor, new ArrayList<Term>(), null);
            this.termTable.addTerm(appTerm, sort);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.mode = Tabs.values()[this.rhsTabs.getSelectedIndex()];
    }

    public synchronized void setStatus(String string) {
        this.statusBar.setStatus(string);
    }

    public synchronized void setStatus(String string, boolean bl) {
        this.statusBar.setStatus(string, bl);
    }

    public void addRole(Role role) {
        System.err.println("AttackEditor.addRole(" + role + ")");
        this.protocol.addRole(role);
        this.roleTabs.addRole(role);
    }

    public void deleteRole(String string) {
        System.err.println("AttackEditor.deleteRole(" + string + ")");
        this.protocol.deleteRole(string);
        this.roleTabs.deleteRole(string);
    }

    public void addRoleToAttack(String string, Tabs tabs) {
        if (tabs == Tabs.STRANDS) {
            this.attackTable.addRole(string);
            this.setStatus("Added the role " + string + " to the " + tabs.uc + " table.", false);
        } else if (tabs == Tabs.PATTERNS) {
            this.neverPatterns.addRole(string);
            this.setStatus("Added the role " + string + " to the " + tabs.uc + " table.", false);
        } else {
            this.setStatus("Can't added the role " + string + " to the " + tabs.lc + " tab.", false);
        }
    }

    public void addRoleToAttack(String string) {
        if (this.mode == Tabs.STRANDS) {
            this.attackTable.addRole(string);
            this.setStatus("Added the role " + string + " to the " + this.mode.uc + " table.", false);
        } else if (this.mode == Tabs.PATTERNS) {
            this.neverPatterns.addRole(string);
            this.setStatus("Added the role " + string + " to the " + this.mode.uc + " table.", false);
        } else {
            this.setStatus("Can't added the role " + string + " to the " + this.mode.lc + " tab.", false);
        }
    }

    public void removeRoleFromAttack(String string) {
        this.attackTable.removeRole(string);
        this.setStatus("Removed the role " + string + " from the Attack table.", false);
    }

    public static enum Tabs {
        STRANDS("Strands", "strands"),
        KNOWLEDGE("Intruder Knowledge", "intruder knowledge"),
        PATTERNS("Never Patterns", "never patterns");

        public final String uc;
        public final String lc;

        private Tabs(String string2, String string3) {
            this.uc = string2;
            this.lc = string3;
        }
    }
}

