/*
 * Decompiled with CFR 0.152.
 */
package g2d.netviewer;

import g2d.graph.IOPGraph;
import g2d.jlambda.Closure;
import g2d.netviewer.NetPanel;
import g2d.runtime.ShutdownHook;
import g2d.swing.HierarchyMenu;
import g2d.swing.HierarchyMenuBuilder;
import g2d.swing.WindowTreeIcon;
import g2d.tabwin.TabFrame;
import g2d.tabwin.TabUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenuItem;

public class Utils
extends TabUtils
implements HierarchyMenuBuilder {
    public static final String APPLICATION_NAME;
    private static final ArrayList<IOPGraph> roots;
    private static final HashMap<String, NetPanel> name2PanelMap;
    private static final HashMap<String, IOPGraph> name2GraphMap;

    public static NetPanel launchTab(IOPGraph iOPGraph) {
        return Utils.launchTab(iOPGraph, false);
    }

    public static NetPanel launchTab(IOPGraph iOPGraph, boolean bl) {
        Closure closure;
        Closure closure2;
        String string = iOPGraph.title;
        String string2 = iOPGraph.description;
        NetPanel netPanel = new NetPanel(iOPGraph, string, string2);
        Closure closure3 = iOPGraph.toolBarClosure;
        if (closure3 != null) {
            closure3.applyClosure(netPanel, iOPGraph);
        }
        if ((closure2 = iOPGraph.menuBarClosure) != null) {
            closure2.applyClosure(netPanel, iOPGraph);
        }
        if ((closure = iOPGraph.panelClosure) != null) {
            closure.applyClosure(netPanel, iOPGraph);
        }
        TabFrame tabFrame = null;
        IOPGraph iOPGraph2 = iOPGraph.getParent();
        NetPanel netPanel2 = Utils.findPanel(iOPGraph, iOPGraph2, bl);
        if (netPanel2 == null) {
            tabFrame = new TabFrame(netPanel, APPLICATION_NAME);
            tabFrame.pack();
            tabFrame.setVisible(true);
        } else {
            tabFrame = Utils.getTabFrame(netPanel2);
            int n = tabFrame.indexOfTabPanel(netPanel2);
            tabFrame.addTabPanel(n + 1, netPanel, true);
        }
        Utils.noteGraphAndPanel(iOPGraph, iOPGraph2, netPanel);
        return netPanel;
    }

    private static NetPanel findPanel(IOPGraph iOPGraph, IOPGraph iOPGraph2, boolean bl) {
        NetPanel netPanel = null;
        if (iOPGraph2 != null) {
            netPanel = name2PanelMap.get(iOPGraph2.name);
        } else if (bl) {
            for (IOPGraph iOPGraph3 : iOPGraph.getChildren()) {
                netPanel = name2PanelMap.get(iOPGraph3.name);
                if (netPanel == null) continue;
                return netPanel;
            }
            for (IOPGraph iOPGraph4 : roots) {
                netPanel = name2PanelMap.get(iOPGraph4.name);
                if (netPanel == null) continue;
                return netPanel;
            }
        }
        return netPanel;
    }

    private static void noteGraphAndPanel(IOPGraph iOPGraph, IOPGraph iOPGraph2, NetPanel netPanel) {
        String string = iOPGraph.name;
        if (string == null) {
            throw new IllegalArgumentException("launchTab: needs a non-null graph name to work like a charm.");
        }
        name2PanelMap.put(string, netPanel);
        name2GraphMap.put(string, iOPGraph);
        if (iOPGraph2 == null && !roots.contains(iOPGraph)) {
            roots.add(iOPGraph);
        }
    }

    public static void dispose(IOPGraph iOPGraph) {
        name2PanelMap.put(iOPGraph.name, null);
    }

    public static void bringToFront(IOPGraph iOPGraph) {
        NetPanel netPanel = name2PanelMap.get(iOPGraph.name);
        if (netPanel == null) {
            return;
        }
        TabFrame tabFrame = TabUtils.getTabFrame(netPanel);
        if (tabFrame == null) {
            return;
        }
        tabFrame.focusTabPanel(netPanel);
        tabFrame.toFront();
    }

    public static NetPanel getPanel(IOPGraph iOPGraph) {
        NetPanel netPanel = name2PanelMap.get(iOPGraph.name);
        return netPanel;
    }

    public static TabFrame getTabFrame(IOPGraph iOPGraph) {
        TabFrame tabFrame = null;
        NetPanel netPanel = name2PanelMap.get(iOPGraph.name);
        if (netPanel != null) {
            tabFrame = Utils.getTabFrame(netPanel);
        }
        return tabFrame;
    }

    @Override
    public void constructHierarchyMenu(HierarchyMenu hierarchyMenu) {
        for (IOPGraph iOPGraph : roots) {
            Utils.addHierarchyMenuItems(hierarchyMenu, iOPGraph, 0, new int[0]);
        }
    }

    private static void addHierarchyMenuItems(HierarchyMenu hierarchyMenu, final IOPGraph iOPGraph, int n, int[] nArray) {
        final boolean bl = name2PanelMap.get(iOPGraph.name) != null;
        String string = bl ? iOPGraph.title : iOPGraph.title + " !";
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setOpaque(true);
        if (!bl) {
            jMenuItem.setForeground(Color.red);
        }
        WindowTreeIcon windowTreeIcon = new WindowTreeIcon(jMenuItem, n, nArray);
        jMenuItem.setIcon(windowTreeIcon);
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!bl) {
                    Utils.launchTab(iOPGraph, true);
                } else {
                    Utils.bringToFront(iOPGraph);
                }
            }
        });
        hierarchyMenu.add(jMenuItem);
        IOPGraph[] iOPGraphArray = iOPGraph.getChildren();
        int n2 = iOPGraphArray.length;
        if (n2 > 0) {
            for (int i = 0; i < n2 - 1; ++i) {
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray2.length - 1] = n + 1;
                Utils.addHierarchyMenuItems(hierarchyMenu, iOPGraphArray[i], n + 1, nArray2);
            }
            Utils.addHierarchyMenuItems(hierarchyMenu, iOPGraphArray[n2 - 1], n + 1, nArray);
        }
    }

    public static void main(String[] stringArray) {
        IOPGraph iOPGraph = new IOPGraph("name", "title", "description", null, null, null, null);
        Utils.launchTab(iOPGraph);
    }

    static {
        String string;
        APPLICATION_NAME = string = System.getProperty("com.apple.mrj.application.apple.menu.about.name", "NetViewer");
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(APPLICATION_NAME));
        roots = new ArrayList();
        name2PanelMap = new HashMap();
        name2GraphMap = new HashMap();
    }
}

