/*
 * Decompiled with CFR 0.152.
 */
package g2d.netviewer;

import g2d.graph.Dot;
import g2d.graph.IOPGraph;
import g2d.graphviewer.NavPanel;
import g2d.netviewer.NetContainer;
import g2d.netviewer.NetGraphPanel;
import g2d.netviewer.SEPanel;
import g2d.netviewer.StatusBar;
import g2d.netviewer.ToolBar;
import g2d.netviewer.Utils;
import g2d.swing.ExportMenu;
import g2d.swing.GraphMenu;
import g2d.swing.HierarchyMenu;
import g2d.tabwin.TabPanel;
import g2d.tabwin.menus.FileMenu;
import g2d.tabwin.menus.ViewMenu;
import g2d.toolbar.ToolButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NetPanel
extends TabPanel
implements NetContainer,
ChangeListener {
    public IOPGraph graph;
    public final ToolBar toolBar;
    public final NetGraphPanel graphPanel;
    public final JScrollPane scrollGraph;
    public final NavPanel navPanel;
    public final SEPanel sePanel;
    public final StatusBar statusBar;
    public final JMenu fileMenu;
    public final JMenu viewMenu;
    public final JMenu exportMenu;
    public final JMenu graphMenu;
    public final JMenu hierarchyMenu;
    private static int counter = 0;
    public final int id = counter++;
    public static boolean debug = false;
    private static final String textContext = "In Context";
    private static final String ttipContext = "Layout graph according to original and show other nodes in context.";
    private static final String textDot = "DOT Layout";
    private static final String ttipDot = "Invoke dot to layout graph.";

    protected NetPanel(IOPGraph iOPGraph, String string, String string2) {
        super(string, string2);
        this.graphPanel = new NetGraphPanel(this);
        this.scrollGraph = new JScrollPane(this.graphPanel);
        this.navPanel = new NavPanel(this.graphPanel);
        this.sePanel = new SEPanel(this);
        this.statusBar = new StatusBar("Status: ");
        this.fileMenu = new FileMenu();
        this.viewMenu = new ViewMenu(this);
        this.exportMenu = new ExportMenu(this);
        this.graphMenu = new GraphMenu();
        this.hierarchyMenu = new HierarchyMenu(new Utils());
        this.toolBar = new ToolBar(this.graphPanel);
        this.setToolBar(this.toolBar);
        this.addMenus();
        this.addWestPanel();
        this.addNorthEastPanel();
        this.addSouthEastPanel();
        this.add((Component)this.statusBar, "South");
        this.setGraph(iOPGraph);
    }

    private void addMenus() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.hierarchyMenu);
        this.menuBar.add(this.exportMenu);
    }

    @Override
    public IOPGraph getGraph() {
        return this.graph;
    }

    public SEPanel getSEPanel() {
        return this.sePanel;
    }

    public NavPanel getNavPanel() {
        return this.navPanel;
    }

    @Override
    public NetGraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    @Override
    public void dispose() {
        super.dispose();
        Utils.dispose(this.graph);
    }

    @Override
    public String toString() {
        String string = "NetPanel_" + this.id;
        if (debug) {
            string = string + " : " + super.toString();
        }
        return string;
    }

    public synchronized void setStatus(String string) {
        this.statusBar.setStatus(string);
    }

    public synchronized void setStatus(String string, boolean bl) {
        this.statusBar.setStatus(string, bl);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JViewport) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            if (dimension2.width <= dimension.width && dimension2.height <= dimension.height) {
                this.navPanel.setPorthole(null);
                return;
            }
            this.navPanel.setPorthole(jViewport.getViewRect());
        } else if (object instanceof IOPGraph || object instanceof Dot) {
            this.sePanel.stateChanged(changeEvent);
        }
    }

    public void resetGraph() {
        try {
            this.graphPanel.resetGraph();
            if (this.graph != null) {
                this.navPanel.setImage(this.graph.getBufferedImage());
            } else {
                this.navPanel.setImage(null);
            }
            this.stateChanged(new ChangeEvent(this.scrollGraph.getViewport()));
            this.repaint();
        }
        catch (Exception exception) {
            System.err.println("resetGraph: " + exception);
            exception.printStackTrace();
        }
    }

    public void setGraph(IOPGraph iOPGraph) {
        this.graph = iOPGraph;
        this.graphPanel.setGraph(iOPGraph);
        this.resetGraph();
    }

    private void addWestPanel() {
        this.scrollGraph.setBackground(Color.white);
        this.scrollGraph.getViewport().setScrollMode(1);
        this.scrollGraph.getViewport().addChangeListener(this);
        this.setPanel(TabPanel.Panel.WEST, this.scrollGraph);
    }

    private void addNorthEastPanel() {
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.navPanel, new GridBagConstraints());
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                NetPanel.this.navPanel.resizeThumb(jPanel.getSize());
            }
        });
        this.setPanel(TabPanel.Panel.NORTHEAST, jPanel);
    }

    private void addSouthEastPanel() {
        this.setPanel(TabPanel.Panel.SOUTHEAST, this.sePanel);
    }

    public ToolButton createLayoutButton(IOPGraph iOPGraph) {
        final IOPGraph iOPGraph2 = iOPGraph;
        final ToolButton toolButton = new ToolButton(textContext);
        toolButton.setToolTipText(ttipContext);
        toolButton.setEnabled(iOPGraph2 != null);
        toolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetPanel.this.graphPanel.removeLastSelection();
                NetPanel.this.sePanel.clearText();
                NetPanel.this.sePanel.clearMenu();
                IOPGraph iOPGraph = NetPanel.this.graphPanel.getGraph();
                if (iOPGraph != null && iOPGraph2 != null) {
                    String string = toolButton.getText();
                    if (NetPanel.textDot.equals(string)) {
                        iOPGraph.doLayout(null);
                        toolButton.setText(NetPanel.textContext);
                        toolButton.setToolTipText(NetPanel.ttipContext);
                        NetPanel.this.setGraph(iOPGraph);
                    } else {
                        iOPGraph.doLayout(iOPGraph2);
                        toolButton.setText(NetPanel.textDot);
                        toolButton.setToolTipText(NetPanel.ttipDot);
                        NetPanel.this.setGraph(iOPGraph);
                    }
                    NetPanel.this.graphPanel.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                } else {
                    toolButton.setSelected(false);
                    toolButton.setText(NetPanel.textContext);
                    toolButton.setToolTipText(NetPanel.ttipContext);
                }
            }
        });
        return toolButton;
    }
}

