/*
 * Decompiled with CFR 0.152.
 */
package g2d.launcher;

import g2d.launcher.Launcher;
import g2d.util.Fetch;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class OnlineModel {
    public static boolean VERBOSE = false;
    protected static OnlineModel[] models;
    protected static int model_count;
    public final String name;
    public final String shortDescription;
    public final String longDescription;
    public final String guidedTour;
    public final String directory;

    static void fetchOnlineModels(Launcher launcher, String string) {
        String string2 = OnlineModel.fetchJSON(launcher, string);
        if (VERBOSE) {
            System.err.println("fetchOnlineModels: ");
            System.err.println(string2);
        }
        if (!"".equals(string2)) {
            model_count = OnlineModel.parseJSON(string2);
        } else {
            model_count = 0;
            models = new OnlineModel[0];
        }
    }

    OnlineModel(JSONObject jSONObject) {
        this.name = (String)jSONObject.get("name");
        this.directory = (String)jSONObject.get("directory");
        this.shortDescription = (String)jSONObject.get("short_description");
        this.longDescription = (String)jSONObject.get("long_description");
        this.guidedTour = (String)jSONObject.get("guided-tour");
    }

    public String toString() {
        return this.name;
    }

    public String toHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        stringBuffer.append("<h1>").append(this.name).append("</h1>");
        stringBuffer.append(this.longDescription);
        if (this.guidedTour != null) {
            stringBuffer.append("<br><br>For a Guided Tour of this model click <a href=\"http://");
            stringBuffer.append(this.guidedTour);
            stringBuffer.append("\">here.</a>");
            stringBuffer.append("</body></html>");
        }
        return stringBuffer.toString();
    }

    private static int parseJSON(String string) {
        int n = 0;
        Object object = JSONValue.parse(string);
        JSONArray jSONArray = (JSONArray)object;
        int n2 = jSONArray.size();
        models = new OnlineModel[n2];
        while (n < n2) {
            try {
                OnlineModel.models[n] = new OnlineModel((JSONObject)jSONArray.get(n));
                ++n;
            }
            catch (Exception exception) {
                System.err.println("Parsing response failed: " + exception);
            }
        }
        return n;
    }

    public static String fetchJSON(Launcher launcher, String string) {
        launcher.setMessage("Connecting to : " + string);
        String string2 = Fetch.fetchString(string);
        launcher.setMessage("Connection complete");
        return string2;
    }
}

