/*
 * Decompiled with CFR 0.152.
 */
package g2d.launcher;

import g2d.jlambda.Closure;
import g2d.launcher.Helper;
import g2d.launcher.OnlineModel;
import g2d.swing.FastListModel;
import g2d.swing.HTMLPane;
import g2d.util.Fetch;
import g2d.util.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Launcher
extends JFrame {
    public static final String VERSION = " (launcher version 0.6)";
    public static final Preferences preferences = new Preferences(Launcher.class);
    public static final String statusPrefix = "Status: ";
    public static boolean debug = false;
    public Closure launchClosure;
    public final ModelsList modelsList = new ModelsList();
    public final HTMLPane modelsInfo = new HTMLPane();
    public final JLabel status = new JLabel("Status: ");
    public final JButton launch = new JButton("Launch");
    public final Helper helper = new Helper();
    private OnlineModel selectedModel;
    private int msgCount = 0;
    private final String models_url;
    private final String intro_url;

    public Launcher(String string, String string2) {
        this(string, string2, null);
    }

    public Launcher(String string, String string2, String string3) {
        this.setTitle(string + VERSION);
        this.models_url = string2;
        this.intro_url = string3;
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.add((Component)new JScrollPane(this.modelsList), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(20, 20));
        jPanel2.add((Component)new JScrollPane(this.modelsInfo), "Center");
        JSplitPane jSplitPane = new JSplitPane(1, false, jPanel, jPanel2);
        preferences.manageJFrame(this, "Launcher_frame");
        preferences.manageJSplitPane(jSplitPane, "Launcher_split");
        this.launch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.launch();
            }
        });
        this.launch.setEnabled(false);
        JPanel jPanel3 = new JPanel(new BorderLayout(20, 20));
        jPanel3.add((Component)this.launch, "East");
        jPanel3.add((Component)this.helper, "West");
        JPanel jPanel4 = new JPanel(new BorderLayout(20, 20));
        jPanel4.add((Component)this.status, "North");
        jPanel4.add((Component)jSplitPane, "Center");
        jPanel4.add((Component)jPanel3, "South");
        JPanel jPanel5 = new JPanel(new BorderLayout(50, 50));
        jPanel5.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel5.add((Component)jPanel4, "Center");
        try {
            this.setContentPane(jPanel5);
            this.fetchOnlineModels();
            if (this.intro_url != null) {
                this.displayIntro();
            }
            this.pack();
        }
        catch (Exception exception) {
            System.err.println("Launcher threw: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    private void displayIntro() {
        try {
            String string = Fetch.fetchString(this.intro_url);
            if (string != null) {
                this.modelsInfo.displayText(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Launcher.displayIntro threw: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    private void fetchOnlineModels() {
        OnlineModel.fetchOnlineModels(this, this.models_url);
        this.modelsList.addOnlineModels();
        this.setMessage("Fetched " + OnlineModel.model_count + " models, select one to proceed.");
    }

    private void launch() {
        if (this.launchClosure != null) {
            if (this.selectedModel != null) {
                this.launchClosure.applyClosure(this);
                return;
            }
            System.err.println("No selectedModel; why?");
        }
        System.err.println("Your launch closure is null!");
    }

    private void setSelectedModel(OnlineModel onlineModel) {
        if (onlineModel != null) {
            this.launch.setEnabled(true);
            this.selectedModel = onlineModel;
            this.modelsInfo.displayText(onlineModel.toHTML());
            this.setMessage("To launch the model: " + onlineModel.name + ", press \"launch\"!");
        }
    }

    public OnlineModel getSelectedModel() {
        return this.selectedModel;
    }

    public void setMessage(String string) {
        ++this.msgCount;
        this.status.setText(statusPrefix + string);
        if (debug) {
            System.err.println("msg[" + this.msgCount + "]: " + string);
        }
    }

    class ModelsList
    extends JList<String> {
        protected final FastListModel<String> model;
        private final HashMap<String, OnlineModel> name2OnlineModel;

        public ModelsList() {
            super(new FastListModel());
            this.name2OnlineModel = new HashMap();
            this.model = (FastListModel)this.getModel();
            this.setSelectionMode(0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ModelsList.this.maybeDoubleClicked(mouseEvent);
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ModelsList.this.selected();
                    }
                }
            });
        }

        protected void addOnlineModels() {
            this.model.ensureCapacity(OnlineModel.model_count);
            this.model.setListenersEnabled(false);
            for (OnlineModel onlineModel : OnlineModel.models) {
                String string = onlineModel.name;
                this.model.addElement(string);
                this.name2OnlineModel.put(string, onlineModel);
            }
            this.model.setListenersEnabled(true);
            this.model.fireIntervalAdded(this, 0, OnlineModel.model_count);
        }

        protected void selected() {
            String string = ((String)this.getSelectedValue()).toString();
            OnlineModel onlineModel = this.name2OnlineModel.get(string);
            Launcher.this.setSelectedModel(onlineModel);
        }

        private void maybeDoubleClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2) {
                Launcher.this.launch();
            }
        }
    }
}

