/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda.code;

import g2d.jlambda.Code;
import g2d.jlambda.List;
import g2d.jlambda.code.CodeVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CFG
extends CodeVisitor {
    private final Map<String, Object> definitions = new HashMap<String, Object>();
    private final Map<String, Set<String>> calls = new HashMap<String, Set<String>>();
    private final Stack<String> dfn_stack = new Stack();
    private final Stack<Object> locals = new Stack();
    private final Set<String> defined = new HashSet<String>();
    private final Set<String> isolated = new HashSet<String>();
    private final Set<String> not_defined = new HashSet<String>();
    private static final String DEFINED = " [shape=box,style=filled,color=lightblue]";
    private static final String NOT_DEFINED = " [shape=ellipse,style=filled,color=red]";
    private static final String DEFAULT = " [shape=box,style=filled,color=lightgray]";

    private void process() {
        this.defined.addAll(this.calls.keySet());
        for (String string : this.defined) {
            Set<String> set = this.calls.get(string);
            if (set != null) {
                for (String string2 : set) {
                    if (this.defined.contains(string2)) continue;
                    this.not_defined.add(string2);
                }
                continue;
            }
            this.isolated.add(string);
        }
    }

    public String toDot(boolean bl) {
        this.process();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph G {\n");
        stringBuilder.append("\t node ").append(DEFAULT).append(";\n");
        for (String string : this.defined) {
            if (bl) {
                if (this.isolated.contains(string)) continue;
                stringBuilder.append("\t").append(string).append(DEFINED).append(";\n");
                continue;
            }
            stringBuilder.append("\t").append(string).append(DEFINED).append(";\n");
        }
        for (String string : this.not_defined) {
            stringBuilder.append("\t").append(string).append(NOT_DEFINED).append(";\n");
        }
        for (String string : this.defined) {
            Set<String> set = this.calls.get(string);
            if (set == null) continue;
            for (String string2 : set) {
                stringBuilder.append("\t").append(string).append(" -> ").append(string2).append(";\n");
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String getDefinition(String string) {
        Object object = this.definitions.get(string);
        if (object == null) {
            return "No definition found, sorry!";
        }
        if (object instanceof Code) {
            return ((Code)object).prettyPrint();
        }
        return object.toString();
    }

    @Override
    public Object visit(Object object) {
        super.visit(object);
        return null;
    }

    @Override
    protected Object visitLiteral(String string) {
        return null;
    }

    @Override
    protected Object visitDefine(String string, Code code, Object object) {
        String string2 = this.clean4dot(string);
        this.definitions.put(string2, (Code)this.getCurrentExpression());
        this.dfn_stack.push(string2);
        this.defined.add(string2);
        if (code != null) {
            this.locals.push(code);
        }
        this.visit(object);
        this.dfn_stack.pop();
        if (code != null) {
            this.locals.pop();
        }
        return null;
    }

    @Override
    protected Object visitApply(Code code) {
        String string;
        Object object = code.car();
        if (object instanceof String && !this.isLocal(string = (String)object)) {
            this.addCall(string);
        }
        this.visitList(code);
        return null;
    }

    @Override
    protected Object visitLambda(Code code, Object object) {
        this.locals.push(code);
        this.visit(object);
        this.locals.pop();
        return null;
    }

    @Override
    protected Object visitLet(Code code, Object object) {
        int n;
        int n2 = code.size();
        for (n = 0; n < n2; ++n) {
            Code code2 = (Code)code.nth(n);
            Object object2 = code2.car();
            Object object3 = code2.cadr();
            this.visit(object2);
            this.visit(object3);
            this.locals.push(object2);
        }
        this.visit(object);
        for (n = 0; n < n2; ++n) {
            this.locals.pop();
        }
        return null;
    }

    @Override
    protected Object visitCatch(String string, Object object) {
        this.locals.push(string);
        this.visit(object);
        this.locals.pop();
        return null;
    }

    @Override
    protected Object visitDo(Code code, Code code2, Code code3) {
        int n;
        int n2 = code.size();
        for (n = 0; n < n2; ++n) {
            Code code4 = (Code)code.nth(n);
            Object object = code4.car();
            List list = code4.cdr();
            this.visit(object);
            this.locals.push(object);
            this.visitList((Code)list);
        }
        this.visitList(code2);
        this.visit(code3);
        for (n = 0; n < n2; ++n) {
            this.locals.pop();
        }
        return null;
    }

    @Override
    protected Object visitIf(Object object, Object object2, Object object3) {
        this.visit(object);
        this.visit(object2);
        if (object3 != null) {
            this.visit(object3);
        }
        return null;
    }

    @Override
    protected Object visitSeq(Code code) {
        this.visitList(code);
        return null;
    }

    @Override
    protected Object visitObject(Object object) {
        if (object instanceof Code) {
            Code code = (Code)object;
            this.visitList(code);
        }
        return null;
    }

    @Override
    protected Object visitFor(String string, Object object, Object object2) {
        this.visit(object);
        this.visit(object2);
        return null;
    }

    @Override
    protected Object visitTry(Object object, Code code) {
        this.visit(object);
        this.visit(code);
        return null;
    }

    @Override
    protected Object visitOperation(String string, Code code) {
        this.visitList(code);
        return null;
    }

    @Override
    protected Object visitData(String string, String string2) {
        return null;
    }

    @Override
    protected Object visitQuote(String string) {
        return null;
    }

    private Object visitList(Code code) {
        int n = code.size();
        for (int i = 0; i < n; ++i) {
            this.visit(code.nth(i));
        }
        return null;
    }

    private String clean4dot(String string) {
        return string.replace('-', '_');
    }

    private void addCall(String string) {
        if (!this.dfn_stack.empty()) {
            Set<String> set = null;
            String string2 = this.dfn_stack.peek();
            if (string2 != null) {
                set = this.calls.get(string2);
                if (set == null) {
                    set = new HashSet<String>();
                    this.calls.put(string2, set);
                }
                set.add(this.clean4dot(string));
            }
        }
    }

    private boolean isLocal(String string) {
        for (Object e : this.locals) {
            if (e instanceof String) {
                if (!e.equals(string)) continue;
                return true;
            }
            if (e instanceof Code) {
                Code code = (Code)e;
                int n = code.size();
                for (int i = 0; i < n; ++i) {
                    Object object = code.nth(i);
                    if (!object.equals(string)) continue;
                    return true;
                }
                continue;
            }
            throw new RuntimeException("Unexpected class on locals stack: " + e.getClass());
        }
        return false;
    }
}

