/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public final class Tuple
extends AbstractCollection {
    public final int length;
    private final Object[] array;

    public Tuple(Object ... objectArray) {
        if (objectArray != null) {
            this.length = objectArray.length;
            this.array = new Object[objectArray.length];
            if (this.length > 0) {
                System.arraycopy(objectArray, 0, this.array, 0, this.length);
            }
        } else {
            throw new IllegalArgumentException("Tuple args null");
        }
    }

    public static Tuple mkTuple(int n) {
        if (n >= 0) {
            return new Tuple(new Object[n]);
        }
        throw new IllegalArgumentException("Tuple negative length not yet allowed.");
    }

    public static Tuple mkTuple(Collection collection) {
        if (collection != null) {
            return new Tuple(collection.toArray());
        }
        return new Tuple(new Object[0]);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Iterator<Object> iterator() {
        return new TupleIterator();
    }

    public Object nth(int n) {
        if (0 <= n && n < this.length) {
            return this.array[n];
        }
        throw new IllegalArgumentException(String.format("Tuple index %d out of bounds (length %d)", n, this.length));
    }

    public void setnth(int n, Object object) {
        if (0 > n || n >= this.length) {
            throw new IllegalArgumentException(String.format("Tuple index %d out of bounds (length %d)", n, this.length));
        }
        this.array[n] = object;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        stringBuilder.append('[');
        for (Object object : this.array) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private class TupleIterator
    implements Iterator<Object> {
        private int count = 0;

        @Override
        public boolean hasNext() {
            return this.count < Tuple.this.length;
        }

        @Override
        public Object next() {
            Object object = Tuple.this.array[this.count];
            ++this.count;
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

