/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Closure;
import g2d.jlambda.Continuation;
import g2d.jlambda.Environment;
import g2d.jlambda.EvaluateError;
import g2d.jlambda.List;
import g2d.jlambda.PrimitiveData;
import g2d.jlambda.State;
import g2d.jlambda.Tuple;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

class ReduceCont
extends Continuation {
    private Mode mode;
    private Iterator<?> iterator;
    private Closure closure;
    private Object closure_body;
    private Environment closure_env;
    private int closure_arity;
    private Object accumulator;
    private Object[] closure_args = new Object[2];

    public ReduceCont(List list, String string, List list2, Environment environment, Continuation continuation) {
        this.init(list, string, list2, environment, continuation);
        this.mode = Mode.INIT;
    }

    @Override
    public void cont(State state) {
        switch (this.mode) {
            case INIT: {
                state.setTag(0);
                state.setExp(this.args.nth(this.n));
                state.setEnv(this.env);
                break;
            }
            case STEP: {
                if (this.iterator.hasNext()) {
                    state.setTag(0);
                    state.setExp(this.closure_body);
                    this.closure_args[0] = this.iterator.next();
                    this.closure_args[1] = this.accumulator;
                    state.setEnv(this.closure_env.extend(this.closure_args));
                    break;
                }
                state.setTag(2);
                state.setVal(null);
                state.setK(this.k);
            }
        }
    }

    @Override
    public void handleReturn(State state) {
        ++this.n;
        switch (this.mode) {
            case INIT: {
                if (!this.receiveVal(state.getVal())) {
                    state.setK(this.k);
                    return;
                }
                if (this.n < this.args.size()) {
                    state.setTag(1);
                    break;
                }
                this.mode = Mode.STEP;
                this.n = 0;
                state.setTag(1);
                break;
            }
            case STEP: {
                this.accumulator = state.getVal();
                if (this.iterator.hasNext()) {
                    state.setTag(1);
                    break;
                }
                state.setTag(2);
                state.setVal(this.accumulator);
                state.setK(this.k);
            }
        }
    }

    protected boolean receiveVal(Object object) {
        if (this.n == 1) {
            if (object == null) {
                this.msg = this.msg + "first argument to reduce cannot be null";
                this.k.setException(new EvaluateError(this.msg, this.info()));
                return false;
            }
            if (this.notArrayOrCollectionOrIterable(object)) {
                this.msg = this.msg + "first argument is not reducable: " + object;
                this.k.setException(new EvaluateError(this.msg, this.info()));
                return false;
            }
            this.iterator = this.getIterator(object);
        } else if (this.n == 2) {
            if (!(object instanceof Closure)) {
                this.msg = this.msg + "second argument to reduce not a Closure -- " + object;
                this.k.setException(new EvaluateError(this.msg, this.info()));
                return false;
            }
            this.closure = (Closure)object;
            this.closure_arity = this.closure.arity;
            if (this.closure_arity != 2) {
                this.msg = this.msg + "second argument to reduce has arity != 2 -- actual arity = " + this.closure_arity;
                this.k.setException(new EvaluateError(this.msg, this.info()));
                return false;
            }
            this.closure_body = this.closure.body;
            this.closure_env = this.closure.env;
        } else if (this.n == 3) {
            this.accumulator = object;
        }
        this.vals[this.n - 1] = object;
        return true;
    }

    private boolean notArrayOrCollectionOrIterable(Object object) {
        return !object.getClass().isArray() && !(object instanceof Collection) && !this.isIterable(object);
    }

    private boolean isIterable(Object object) {
        PrimitiveData primitiveData;
        Object object2;
        if (object instanceof String) {
            return true;
        }
        return object instanceof PrimitiveData && (object2 = (primitiveData = (PrimitiveData)object).unwrapValue()) instanceof Integer;
    }

    private Iterator<?> getIterator(Object object) {
        if (object instanceof Tuple) {
            return ((Tuple)object).iterator();
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object.getClass().isArray()) {
            return new ArrayIterator(object);
        }
        if (object instanceof String) {
            return new StringIterator((String)object);
        }
        return new IntegerIterator((Integer)((PrimitiveData)object).unwrapValue());
    }

    private class StringIterator
    implements Iterator<Object> {
        private final char[] array;
        private final int length;

        public StringIterator(String string) {
            this.array = string.toCharArray();
            this.length = this.array.length;
        }

        @Override
        public boolean hasNext() {
            return ReduceCont.this.n < this.length;
        }

        @Override
        public Object next() {
            return PrimitiveData.wrap(Character.valueOf(this.array[ReduceCont.this.n]));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class IntegerIterator
    implements Iterator<Object> {
        int i;

        public IntegerIterator(int n) {
            this.i = n;
        }

        @Override
        public boolean hasNext() {
            return ReduceCont.this.n < this.i;
        }

        @Override
        public Object next() {
            return PrimitiveData.wrap(ReduceCont.this.n);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ArrayIterator
    implements Iterator<Object> {
        private Object array;
        private int size;
        private boolean primitive;

        public ArrayIterator(Object object) {
            this.array = object;
            this.size = Array.getLength(object);
            this.primitive = this.array.getClass().getComponentType().isPrimitive();
        }

        @Override
        public boolean hasNext() {
            return ReduceCont.this.n < this.size;
        }

        @Override
        public Object next() {
            return this.primitive ? PrimitiveData.wrap(Array.get(this.array, ReduceCont.this.n)) : Array.get(this.array, ReduceCont.this.n);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Mode {
        INIT,
        STEP;

    }
}

