/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.EvaluateError;
import g2d.jlambda.SyntaxError;
import java.io.PrintStream;

public class Debugger {
    public static boolean verbosity = false;
    public static int stackDepth = 15;

    public static void handle(Throwable throwable) {
        Debugger.reportThrowable(System.err, throwable);
    }

    public static void setStackDepth(int n) {
        stackDepth = n;
    }

    public static int getStackDepth() {
        return stackDepth;
    }

    public static void setVerbosity(boolean bl) {
        verbosity = bl;
    }

    public static boolean getVerbosity() {
        return verbosity;
    }

    public static boolean toggleVerbosity() {
        verbosity = !verbosity;
        return verbosity;
    }

    private static void reportThrowable(PrintStream printStream, Throwable throwable) {
        String string;
        printStream.println("Uncaught exception:");
        if (verbosity) {
            int n = Debugger.getStackDepth();
            int n2 = 0;
            printStream.println(throwable.getMessage());
            for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
                printStream.print("\nCause[" + n2 + "]: (" + throwable2.getClass().toString() + ")\n\t");
                String string2 = throwable2.getMessage();
                if (string2 != null && string2 != "") {
                    printStream.println(string2);
                }
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    printStream.println("\tstack[" + i + "] = " + stackTraceElementArray[i].toString());
                    if (i != n) continue;
                    printStream.println(".... " + (stackTraceElementArray.length - n) + " more (see g2d.jlambda.Debugger to increase depth)");
                    break;
                }
                ++n2;
            }
        } else if (throwable instanceof SyntaxError) {
            printStream.println(throwable.toString());
        } else {
            printStream.println(throwable.getMessage());
        }
        if (throwable instanceof EvaluateError && (string = ((EvaluateError)throwable).getBT()) != null) {
            printStream.println("JLambda backtrace:");
            printStream.println(string);
        }
    }

    protected Debugger() {
    }
}

