/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Analyse;
import g2d.jlambda.List;
import g2d.jlambda.PrettyPrinter;
import g2d.jlambda.Utils;
import java.util.Collection;

public class Code
extends List {
    protected String filename;
    protected int lineno;

    public Code() {
    }

    public Code(int n, String string) {
        this.lineno = n;
        this.filename = string;
    }

    public Code(Object object, Code code) {
        this.car = object;
        this.cdr = code;
        this.empty = false;
    }

    public Code(Object object, Code code, int n, String string) {
        this.car = object;
        this.cdr = code;
        this.lineno = n;
        this.filename = string;
        this.empty = false;
    }

    public static Code clist(Object object) {
        return new Code(object, new Code());
    }

    public static Code clist(Object object, Object object2) {
        return new Code(object, new Code(object2, new Code()));
    }

    public static Code clist(Object object, Object object2, Object object3) {
        return new Code(object, new Code(object2, new Code(object3, new Code())));
    }

    public static Code cflist(Object object, int n, String string) {
        return new Code(object, new Code(n, string), n, string);
    }

    public static Code cflist(Object object, Object object2, int n, String string) {
        return new Code(object, new Code(object2, new Code(n, string)));
    }

    public static Code cflist(Object object, Object object2, Object object3, int n, String string) {
        return new Code(object, new Code(object2, new Code(object3, new Code(n, string), n, string), n, string), n, string);
    }

    public static Code cflist(Object object, Object object2, Object object3, Object object4, int n, String string) {
        return new Code(object, new Code(object2, new Code(object3, new Code(object4, new Code(n, string), n, string), n, string), n, string), n, string);
    }

    @Override
    public Code snoc(Object object) {
        assert (this.empty);
        Code code = new Code();
        this.cdr = code;
        this.car = object;
        this.empty = false;
        return code;
    }

    public Code snoc(Object object, int n, String string) {
        Code code = this.snoc(object);
        code.lineno = n;
        code.filename = string;
        return code;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static String toString(Code code) {
        String string = null;
        string = "";
        string = string + code + "\n";
        string = string + "\tline number ";
        string = string + code.lineno;
        if (code.filename != null) {
            string = string + " of file ";
            string = string + code.filename + "\n";
        }
        return string;
    }

    public static void augmentSpine(List list, List list2) {
        while (!list.empty || !list2.empty) {
            Code.augmentCell(list, list2);
            if (!list.empty) {
                list = list.cdr;
            }
            if (list2.empty) continue;
            list2 = list2.cdr;
        }
    }

    public static void augmentSpine(int n, List list, List list2) {
        while (!(n <= 0 || list.empty && list2.empty)) {
            Code.augmentCell(list, list2);
            if (!list.empty) {
                list = list.cdr;
            }
            if (!list2.empty) {
                list2 = list2.cdr;
            }
            --n;
        }
    }

    public static void augmentCell(List list, List list2) {
        if (list instanceof Code && list2 instanceof Code) {
            Code code = (Code)list;
            Code code2 = (Code)list2;
            code2.lineno = code.lineno;
            code2.filename = code.filename;
        }
    }

    public String dump() {
        String string = "(";
        Code code = this;
        while (!code.empty) {
            string = string + "<" + code.filename + ":" + code.lineno + ">";
            string = string + (code.car() instanceof Code ? ((Code)code.car()).dump() : code.car().toString());
            code = (Code)code.cdr();
            if (code.empty) continue;
            string = string + " ";
        }
        string = string + ")";
        return string;
    }

    public String prettyPrint() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        if (this.filename != null) {
            prettyPrinter.append(";; from ").append(this.filename).append(" line ").append(this.lineno).cr();
        }
        this.pprint(prettyPrinter);
        return prettyPrinter.toString();
    }

    private void pprint(PrettyPrinter prettyPrinter) {
        this.pprint2pp(prettyPrinter, 0);
        prettyPrinter.cr();
    }

    private void pprint2pp(PrettyPrinter prettyPrinter, int n) {
        try {
            if (this.size() < 2) {
                prettyPrinter.pad(n).append(this);
            } else {
                String string = (String)this.car();
                Code code = (Code)this.cdr();
                if (Analyse.isPrimitiveForm(string)) {
                    prettyPrinter.pad(n).append(this);
                } else if (string == "quote") {
                    this.quote2pp(prettyPrinter, n, string, code);
                } else if (string == "object") {
                    this.object2pp(prettyPrinter, n, string, code);
                } else if (string == "let") {
                    this.let2pp(prettyPrinter, n, string, code);
                } else if (string == "lambda") {
                    this.lambda2pp(prettyPrinter, n, string, code);
                } else if (string == "if") {
                    this.if2pp(prettyPrinter, n, string, code);
                } else if (string == "seq") {
                    this.seq2pp(prettyPrinter, n, string, code);
                } else if (string == "define") {
                    this.define2pp(prettyPrinter, n, string, code);
                } else if (string == "do") {
                    this.do2pp(prettyPrinter, n, string, code);
                } else if (Analyse.isUnaryForm(string) || Analyse.isBinaryForm(string) || string == "-" || string == "catch" || string == "try" || string == "getattr" || string == "aset" || string == "setattr" || string == "concat" || string == "and" || string == "apply" || string == "or" || string == "mkarray" || string == "for" || string == "array" || string == "invoke" || string == "sinvoke" || string == "update" || string == "supdate") {
                    this.call2pp(prettyPrinter, n, string, code);
                } else {
                    Utils.err.println("Code.pprint2pp: ?? " + this);
                }
            }
        }
        catch (Exception exception) {
            Utils.err.println("Code.pprint2pp: " + exception);
            exception.printStackTrace(Utils.err);
        }
    }

    private static int width(Object object) {
        if (object == null) {
            return 0;
        }
        return object.toString().length();
    }

    private void let2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        Code code2 = (Code)code.car();
        int n2 = code2.size();
        Object object = code.cadr();
        prettyPrinter.pad(n).append('(');
        int n3 = prettyPrinter.offset();
        prettyPrinter.append(string);
        int n4 = prettyPrinter.offset();
        prettyPrinter.pad(1).append('(');
        int n5 = n4 + 2;
        for (int i = 0; i < n2; ++i) {
            Object object2 = code2.nth(i);
            Code code3 = (Code)object2;
            String string2 = (String)code3.car();
            Object object3 = code3.cadr();
            if (i != 0) {
                prettyPrinter.pad(n5);
            }
            prettyPrinter.append('(').append(string2).pad(1);
            if (object3 instanceof Code) {
                ((Code)object3).pprint2pp(prettyPrinter, 0);
            } else {
                prettyPrinter.append(object3);
            }
            prettyPrinter.append(')');
            if (i == n2 - 1) continue;
            prettyPrinter.cr();
        }
        prettyPrinter.append(')').cr();
        n5 = n4;
        Code.thing2pp(prettyPrinter, n5, object);
        prettyPrinter.cr().pad(n3).append(')');
    }

    private void lambda2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        boolean bl = prettyPrinter.little(Code.width(code));
        Code code2 = (Code)code.car();
        Object object = code.cadr();
        prettyPrinter.pad(n).append('(').append(string).pad(1);
        int n2 = prettyPrinter.offset();
        code2.list2pp(prettyPrinter, 0);
        if (!bl) {
            prettyPrinter.cr();
        }
        Code.thing2pp(prettyPrinter, bl ? 1 : n2, object);
        prettyPrinter.append(')');
    }

    private void define2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        String string2 = (String)code.car();
        boolean bl = prettyPrinter.little(Code.width(code));
        prettyPrinter.pad(n).append('(');
        int n2 = prettyPrinter.offset();
        int n3 = n2 + 2;
        prettyPrinter.append(string).pad(1).append(string2);
        if (code.size() == 2) {
            Object object = code.cadr();
            if (!bl) {
                prettyPrinter.cr();
                Code.thing2pp(prettyPrinter, n3, object);
                prettyPrinter.cr().pad(n2).append(')');
            } else {
                Code.thing2pp(prettyPrinter, 1, object);
                prettyPrinter.append(')');
            }
        } else {
            Code code2 = (Code)code.cadr();
            Object object = code.caddr();
            prettyPrinter.pad(1).append(code2);
            if (!bl) {
                prettyPrinter.cr();
                Code.thing2pp(prettyPrinter, n3, object);
                prettyPrinter.cr().pad(n2).append(')').cr();
            } else {
                Code.thing2pp(prettyPrinter, 1, object);
                prettyPrinter.append(')').cr();
            }
        }
    }

    private void call2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        boolean bl = prettyPrinter.little(Code.width(this));
        prettyPrinter.pad(n).append('(').append(string);
        int n2 = prettyPrinter.offset() + 1;
        boolean bl2 = true;
        int n3 = code.size();
        for (int i = 0; i < n3; ++i) {
            boolean bl3;
            Object object = code.nth(i);
            boolean bl4 = bl3 = i == n3 - 1;
            if (object instanceof Code) {
                if (bl) {
                    ((Code)object).pprint2pp(prettyPrinter, 1);
                    continue;
                }
                if (bl2) {
                    ((Code)object).pprint2pp(prettyPrinter, 1);
                    bl2 = false;
                } else {
                    ((Code)object).pprint2pp(prettyPrinter, n2);
                }
                if (bl3) continue;
                prettyPrinter.cr();
                continue;
            }
            if (bl) {
                prettyPrinter.pad(1).append(object);
                continue;
            }
            if (bl2) {
                prettyPrinter.pad(1).append(object);
                if (!bl3) {
                    prettyPrinter.cr();
                }
                bl2 = false;
                continue;
            }
            prettyPrinter.pad(n2).append(object);
            if (bl3) continue;
            prettyPrinter.cr();
        }
        prettyPrinter.append(')');
    }

    private void list2pp(PrettyPrinter prettyPrinter, int n) {
        boolean bl = true;
        int n2 = this.size();
        boolean bl2 = prettyPrinter.little(Code.width(this));
        prettyPrinter.pad(n).append('(');
        int n3 = prettyPrinter.offset();
        for (int i = 0; i < n2; ++i) {
            boolean bl3;
            Object object = this.nth(i);
            boolean bl4 = bl3 = i == n2 - 1;
            if (object instanceof Code) {
                if (bl) {
                    ((Code)object).pprint2pp(prettyPrinter, 0);
                    bl = false;
                } else {
                    ((Code)object).pprint2pp(prettyPrinter, bl2 ? 1 : n3);
                }
                if (bl2 || bl3) continue;
                prettyPrinter.cr();
                continue;
            }
            if (bl) {
                prettyPrinter.append(object);
                if (!bl2 && !bl3) {
                    prettyPrinter.cr();
                }
                bl = false;
                continue;
            }
            prettyPrinter.pad(bl2 ? 1 : n3).append(object);
            if (bl2 || bl3) continue;
            prettyPrinter.cr();
        }
        prettyPrinter.append(')');
    }

    private void if2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        boolean bl = prettyPrinter.little(Code.width(code));
        Object object = code.car();
        Object object2 = code.cadr();
        prettyPrinter.pad(n).append('(');
        int n2 = prettyPrinter.offset();
        prettyPrinter.append(string).pad(1);
        int n3 = prettyPrinter.offset();
        Code.thing2pp(prettyPrinter, 0, object);
        if (!bl) {
            prettyPrinter.cr();
        }
        int n4 = bl ? 1 : n3;
        Code.thing2pp(prettyPrinter, n4, object2);
        if (!bl) {
            prettyPrinter.cr();
        }
        if (code.size() == 3) {
            Object object3 = code.caddr();
            n4 = bl ? 1 : n3;
            Code.thing2pp(prettyPrinter, n4, object3);
            if (!bl) {
                prettyPrinter.cr();
            }
        }
        n4 = bl ? 0 : n2;
        prettyPrinter.pad(n4).append(')');
    }

    private void seq2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        int n2 = code.size();
        if (n2 == 0) {
            prettyPrinter.pad(n).append(this).cr();
        } else {
            boolean bl = true;
            boolean bl2 = prettyPrinter.little(Code.width(this));
            prettyPrinter.pad(n).append('(');
            int n3 = prettyPrinter.offset();
            prettyPrinter.append(string).pad(1);
            int n4 = prettyPrinter.offset();
            for (int i = 0; i < n2; ++i) {
                boolean bl3 = i == n2 - 1;
                Object object = code.nth(i);
                if (object instanceof Code) {
                    if (bl) {
                        ((Code)object).pprint2pp(prettyPrinter, 0);
                        bl = false;
                    } else {
                        ((Code)object).pprint2pp(prettyPrinter, bl2 ? 1 : n4);
                    }
                    if (bl3 || bl2) continue;
                    prettyPrinter.cr();
                    continue;
                }
                if (bl) {
                    prettyPrinter.pad(bl2 ? 0 : n4).append(object);
                    bl = false;
                } else {
                    prettyPrinter.pad(bl2 ? 1 : n4).append(object);
                }
                if (bl2 || bl3) continue;
                prettyPrinter.cr();
            }
            if (!bl2) {
                prettyPrinter.cr().pad(n3);
            }
            prettyPrinter.append(')');
        }
    }

    private static void thing2pp(PrettyPrinter prettyPrinter, int n, Object object) {
        if (object instanceof Code) {
            ((Code)object).pprint2pp(prettyPrinter, n);
        } else {
            prettyPrinter.pad(n).append(object);
        }
    }

    private void object2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        Object object = code.car();
        prettyPrinter.pad(n).append('(').append(string).pad(1);
        if (object instanceof Code) {
            ((Code)object).list2pp(prettyPrinter, 0);
        } else {
            prettyPrinter.append(object);
        }
        prettyPrinter.append(')');
    }

    private void quote2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        String string2 = code.car().toString();
        prettyPrinter.pad(n).append('\"');
        block4: for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\n': {
                    prettyPrinter.append('\\');
                    prettyPrinter.append('n');
                    continue block4;
                }
                case '\t': {
                    prettyPrinter.append('\\');
                    prettyPrinter.append('t');
                    continue block4;
                }
                default: {
                    prettyPrinter.append(c);
                }
            }
        }
        prettyPrinter.append('\"');
    }

    private void do2pp(PrettyPrinter prettyPrinter, int n, String string, Code code) {
        Code code2;
        prettyPrinter.pad(n).append('(');
        int n2 = prettyPrinter.offset();
        prettyPrinter.append(string).pad(1);
        int n3 = prettyPrinter.offset();
        Code code3 = (Code)code.car();
        int n4 = code3.size();
        boolean bl = true;
        boolean bl2 = false;
        prettyPrinter.append('(');
        for (int i = 0; i < n4; ++i) {
            code2 = (Code)code3.nth(i);
            boolean bl3 = bl2 = i == n4 - 1;
            if (bl) {
                code2.list2pp(prettyPrinter, 0);
                bl = false;
            } else {
                code2.list2pp(prettyPrinter, n3 + 1);
            }
            if (bl2) continue;
            prettyPrinter.cr();
        }
        prettyPrinter.append(')').cr();
        Code code4 = (Code)code.cadr();
        code4.list2pp(prettyPrinter, n3);
        code2 = (Code)code.cddr();
        int n5 = code2.size();
        prettyPrinter.cr();
        for (int i = 0; i < n5; ++i) {
            Code code5 = (Code)code2.nth(i);
            code5.pprint2pp(prettyPrinter, n3);
            prettyPrinter.cr();
        }
        prettyPrinter.pad(n2).append(')');
    }

    protected static Code _collection2Sequence(Collection<Code> collection, String string) {
        Code code;
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Code code2 = code = new Code();
        for (Code code3 : collection) {
            Code code4 = new Code();
            code2.car = code3;
            code2.filename = string;
            code2.lineno = code3.lineno;
            code2.cdr = code4;
            code2.empty = false;
            code2 = code4;
        }
        return new Code("seq", code, 0, string);
    }

    public static Code collection2Sequence(Collection<?> collection, String string) {
        Code code;
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Code code2 = code = new Code();
        for (Object obj : collection) {
            Code code3 = new Code();
            code2.car = obj;
            code2.filename = string;
            if (obj instanceof Code) {
                code2.lineno = ((Code)obj).lineno;
            }
            code2.cdr = code3;
            code2.empty = false;
            code2 = code3;
        }
        return new Code("seq", code, 0, string);
    }
}

