/*
 * Decompiled with CFR 0.152.
 */
package g2d.graphviewer;

import g2d.graph.IOPNode;
import g2d.graphviewer.AbstractBaseFrame;
import g2d.graphviewer.BaseFrame;
import g2d.graphviewer.TabFind;
import g2d.graphviewer.TabInfo;
import g2d.graphviewer.TabMenu;
import g2d.graphviewer.TabSettings;
import g2d.graphviewer.Textual;
import g2d.jlambda.Closure;
import g2d.util.TetrisStack;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SEPanel
extends JTabbedPane
implements Textual,
ChangeListener {
    private static final String INFO_TAB = "Info";
    private static final String MENU_TAB = "Context Menu";
    private TabFind tabFind;
    private TabSettings tabSettings;
    private TabInfo tabInfo;
    private TabMenu tabMenu;
    private TetrisStack lastIndices = new TetrisStack(5);

    public void setFindTabCellRendererClosure(Closure closure) {
        if (this.tabFind != null) {
            this.tabFind.setCellRendererClosure(closure);
        }
    }

    public SEPanel(AbstractBaseFrame abstractBaseFrame) {
        Font font = UIManager.getFont("Button.font").deriveFont(10.0f);
        this.tabFind = new TabFind(abstractBaseFrame, font);
        this.addTab("Find", null, this.tabFind, "Find nodes in graph");
        if (abstractBaseFrame.allowsSelections()) {
            this.tabSettings = new TabSettings();
        }
        this.tabMenu = new TabMenu(font, this);
        this.addTab(MENU_TAB, this.tabMenu);
        this.tabInfo = new TabInfo(font);
        this.addTab(INFO_TAB, this.tabInfo);
        this.disableSome();
        this.setTabPlacement(4);
        this.addChangeListener(this);
        this.lastIndices.addPuffable(this.indexOfTab(MENU_TAB));
        this.lastIndices.addPuffable(this.indexOfTab(INFO_TAB));
        this.lastIndices.push(0);
        this.setSelectedIndex(0);
    }

    private void disableSome() {
        this.setEnabledAt(this.indexOfTab(MENU_TAB), false);
        this.setEnabledAt(this.indexOfTab(INFO_TAB), false);
    }

    public TabFind getTabFind() {
        return this.tabFind;
    }

    public TabSettings getTabSettings() {
        return this.tabSettings;
    }

    public void setNodes(IOPNode[] iOPNodeArray) {
        if (iOPNodeArray == null) {
            return;
        }
        this.tabFind.setNodes(Arrays.asList(iOPNodeArray));
    }

    public void clearText() {
        int n = this.getSelectedIndex();
        if (n == this.indexOfTab(INFO_TAB)) {
            this.setSelectedIndex(this.getLastIndex(n));
        }
    }

    @Override
    public void displayText(String string, String string2) {
        this.tabInfo.displayText(string, string2);
        int n = this.indexOfTab(INFO_TAB);
        if (n != -1) {
            this.setEnabledAt(n, true);
            this.setSelectedIndex(n);
        }
    }

    public void clearMenu() {
        int n = this.getSelectedIndex();
        if (n == this.indexOfTab(MENU_TAB)) {
            this.setSelectedIndex(this.getLastIndex(n));
        }
    }

    public void displayMenu(String string, List<AbstractButton> list) {
        this.displayMenu(string, list, true);
    }

    public void displayMenu(String string, List<AbstractButton> list, boolean bl) {
        this.tabMenu.displayMenu(string, list, bl);
        int n = this.indexOfTab(MENU_TAB);
        if (n != -1) {
            this.setEnabledAt(n, true);
            this.setSelectedIndex(n);
        }
    }

    private int getLastIndex(int n) {
        int n2;
        while ((n2 = this.lastIndices.pop()) == n) {
        }
        return n2;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.disableSome();
        this.setEnabledAt(this.getSelectedIndex(), true);
        this.lastIndices.push(this.getSelectedIndex());
        if (this.getSelectedIndex() != this.indexOfTab(MENU_TAB)) {
            this.tabMenu.clearMenu();
        }
    }

    public static void main(String[] stringArray) {
        final SEPanel sEPanel = new SEPanel(new BaseFrame("hudi", null, true));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame("Testing SEPanel");
                jFrame.setDefaultCloseOperation(3);
                jFrame.setContentPane(sEPanel);
                jFrame.pack();
                jFrame.setVisible(true);
                ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
                JButton jButton = new JButton("Number One");
                arrayList.add(jButton);
                jButton.setMnemonic('E');
                jButton.setDisplayedMnemonicIndex(9);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        System.out.println("Number 1 clicked!");
                    }
                });
                jButton = new JButton("Number Two");
                arrayList.add(jButton);
                jButton.setMnemonic('T');
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        System.out.println("Number 2 clicked!");
                    }
                });
                sEPanel.displayMenu("Test 1", arrayList);
            }
        });
    }
}

