/*
 * Decompiled with CFR 0.152.
 */
package g2d.graphviewer;

import g2d.graph.Dot;
import g2d.graph.IOPGraph;
import g2d.graphviewer.GraphPanel;
import g2d.swing.ImageFilter;
import g2d.util.ActorMsg;
import g2d.util.IO;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class FileMenu
extends JMenu {
    private final JFrame bframe;
    private final GraphPanel graphPanel;
    private File lastFile;
    private JFileChooser chooser = new JFileChooser();
    private FileFilter epsFilter = new ImageFilter("Encapsulated PostScript (*.eps)", Dot.DotFormat.EPS);
    private FileFilter pngFilter = new ImageFilter("Portable Network Graphics (*.png)", Dot.DotFormat.PNG);
    private FileFilter dotFilter = new ImageFilter("Dot's native format (*.dot)", Dot.DotFormat.DOT);

    public FileMenu(JFrame jFrame, GraphPanel graphPanel) {
        super("File");
        this.bframe = jFrame;
        this.graphPanel = graphPanel;
        this.setMnemonic(70);
        this.chooser.setDialogTitle("Export Graph As Image");
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.addChoosableFileFilter(this.epsFilter);
        this.chooser.addChoosableFileFilter(this.pngFilter);
        this.chooser.addChoosableFileFilter(this.dotFilter);
        this.chooser.setFileFilter(this.epsFilter);
        JMenuItem jMenuItem = new JMenuItem("Export Image...", 69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                IOPGraph iOPGraph = FileMenu.this.graphPanel.getGraph();
                if (iOPGraph == null) {
                    return;
                }
                if (FileMenu.this.lastFile != null) {
                    FileMenu.this.chooser.setSelectedFile(FileMenu.this.lastFile);
                    FileMenu.this.chooser.setCurrentDirectory(FileMenu.this.lastFile.getParentFile());
                }
                if ((n = FileMenu.this.chooser.showDialog(FileMenu.this.bframe, "Export")) != 0) {
                    return;
                }
                File file = FileMenu.this.chooser.getSelectedFile();
                boolean bl = false;
                Dot.DotFormat dotFormat = Dot.DotFormat.DOT;
                for (FileFilter fileFilter : FileMenu.this.chooser.getChoosableFileFilters()) {
                    if (!fileFilter.accept(file)) continue;
                    dotFormat = ((ImageFilter)fileFilter).getType();
                    bl = true;
                    break;
                }
                if (!bl) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(FileMenu.this.bframe, "Cannot export to unknown file type of chosen file \"" + file.getName() + "\"", "Error", 0);
                } else {
                    String string = iOPGraph.makeDotInput();
                    if (dotFormat != Dot.DotFormat.DOT) {
                        String string2 = Dot.askDot(dotFormat, string);
                        if (dotFormat.fileType == Dot.FileType.BINARY) {
                            IO.b64String2File(string2, file);
                        } else {
                            IO.string2File(string2, file);
                        }
                    } else {
                        IO.string2File(string, file);
                    }
                    FileMenu.this.lastFile = file;
                }
            }
        });
        this.add(jMenuItem);
        this.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Close", 67);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileMenu.this.bframe.dispatchEvent(new WindowEvent(FileMenu.this.bframe, 201));
            }
        });
        this.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Quit", 81);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActorMsg.send("system", "graphics2d", "stop system");
            }
        });
        this.add(jMenuItem2);
    }
}

