/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.glyph.Glyph;
import g2d.glyph.GlyphList;
import g2d.glyph.Glyphish;
import g2d.graph.IOPEdge;
import g2d.swing.IOPConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ListIterator;

public class Spline
extends GlyphList {
    protected String style = "solid";
    protected float strokeWidth = 1.25f;
    protected Color color = IOPConstants.EDGE_COLOR;
    private boolean stale = false;

    @Override
    public void paint(Graphics2D graphics2D) {
        this.updateAll();
        super.paint(graphics2D);
    }

    public Spline(Point2D point2D, Point2D point2D2) {
        this.add(new Glyph(new Line2D.Double(point2D, point2D2)));
        this.stale = true;
    }

    public Spline(Spline spline) {
        super(spline);
        this.style = spline.style;
        this.strokeWidth = spline.strokeWidth;
        this.color = spline.color;
        this.stale = spline.stale;
    }

    public void setCoordinates(Point2D[] point2DArray) {
        if (point2DArray != null) {
            int n = point2DArray.length - 3;
            this.clear();
            for (int i = 0; i < n; i += 3) {
                CubicCurve2D.Double double_ = new CubicCurve2D.Double();
                double_.setCurve(point2DArray, i);
                this.add(new Glyph(double_));
            }
        }
        this.stale = true;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        if (string == null) {
            string = "solid";
        }
        this.style = string;
        this.stale = true;
    }

    public void setColor(Color color) {
        this.color = color;
        this.stale = true;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float f) {
        this.strokeWidth = f;
        this.stale = true;
    }

    private BasicStroke createStroke() {
        return IOPEdge.createStroke(this.style, this.strokeWidth);
    }

    private void updateAll() {
        if (this.stale) {
            BasicStroke basicStroke = this.createStroke();
            ListIterator<Glyphish> listIterator = this.getListIterator();
            while (listIterator.hasNext()) {
                Glyphish glyphish = listIterator.next();
                if (!(glyphish instanceof Glyph)) continue;
                Glyph glyph = (Glyph)glyphish;
                glyph.setStroke(basicStroke);
                glyph.setBorder(this.color);
                glyph.setFill(null);
            }
            this.stale = false;
        }
    }

    public double distanceTo(Point2D point2D) {
        this.updateAll();
        double d = Double.MAX_VALUE;
        ListIterator<Glyphish> listIterator = this.getListIterator();
        while (listIterator.hasNext()) {
            Shape shape;
            Glyphish glyphish = listIterator.next();
            if (!(glyphish instanceof Glyph) || !((shape = ((Glyph)glyphish).getShape()) instanceof CubicCurve2D)) continue;
            d = Math.min(d, this.approximateDistance(point2D, (CubicCurve2D)shape));
        }
        return d;
    }

    private double approximateDistance(Point2D point2D, CubicCurve2D cubicCurve2D) {
        double d = this.distToLine(point2D, new Line2D.Double(cubicCurve2D.getP1(), cubicCurve2D.getCtrlP1()));
        double d2 = this.distToLine(point2D, new Line2D.Double(cubicCurve2D.getCtrlP1(), cubicCurve2D.getCtrlP2()));
        double d3 = this.distToLine(point2D, new Line2D.Double(cubicCurve2D.getCtrlP2(), cubicCurve2D.getP2()));
        return Math.min(d, Math.min(d2, d3));
    }

    private double distToLine(Point2D point2D, Line2D line2D) {
        double d = line2D.ptLineDist(point2D);
        if (Double.isNaN(d)) {
            d = Double.MAX_VALUE;
        }
        double d2 = line2D.getP1().distance(point2D);
        double d3 = line2D.getP2().distance(point2D);
        return Math.min(d, Math.min(d2, d3));
    }

    public boolean __intersects(Rectangle2D rectangle2D) {
        boolean bl = true;
        return bl;
    }
}

