/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class Polygon2D
extends RectangularShape
implements Shape {
    private Path2D.Double polygon = new Path2D.Double();
    private Shape actualShape;
    private Rectangle2D actualBounds;

    public void transform(AffineTransform affineTransform) {
        this.actualShape = affineTransform.createTransformedShape(this.actualShape);
        this.actualBounds = this.actualShape.getBounds2D();
    }

    public Polygon2D() {
    }

    public Polygon2D(int[] nArray, int[] nArray2) {
        this.setPoints(nArray, nArray2);
    }

    public Polygon2D(double[] dArray, double[] dArray2) {
        this.setPoints(dArray, dArray2);
    }

    public void setPoints(double[] dArray, double[] dArray2) {
        if (this.polygon != null) {
            this.polygon.moveTo(dArray[0], dArray2[0]);
            for (int i = 1; i < dArray.length; ++i) {
                this.polygon.lineTo(dArray[i], dArray2[i]);
            }
            this.polygon.closePath();
            this.actualShape = this.polygon;
            this.actualBounds = this.actualShape.getBounds2D();
            this.polygon = null;
        }
    }

    public void setPoints(int[] nArray, int[] nArray2) {
        if (this.polygon != null) {
            this.polygon.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < nArray.length; ++i) {
                this.polygon.lineTo(nArray[i], nArray2[i]);
            }
            this.polygon.closePath();
            this.actualShape = this.polygon;
            this.actualBounds = this.actualShape.getBounds2D();
            this.polygon = null;
        }
    }

    @Override
    public double getHeight() {
        return this.actualBounds.getHeight();
    }

    @Override
    public double getWidth() {
        return this.actualBounds.getWidth();
    }

    @Override
    public double getX() {
        return this.actualBounds.getX();
    }

    @Override
    public double getY() {
        return this.actualBounds.getY();
    }

    @Override
    public boolean isEmpty() {
        return this.actualBounds.isEmpty();
    }

    @Override
    public void setFrame(double d, double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        double d9 = d - d5;
        double d10 = d2 - d6;
        double d11 = d4 / d8;
        double d12 = d3 / d7;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d12, d11);
        this.transform(affineTransform);
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(d9, d10);
        this.transform(affineTransform2);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.actualShape.getPathIterator(affineTransform);
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.actualShape.contains(d, d2);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.actualShape.contains(d, d2, d3, d4);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.actualBounds;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.actualShape.intersects(d, d2, d3, d4);
    }
}

