/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.graph.IOPNode;
import g2d.swing.IOPFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class NodeDialog
extends JDialog
implements ActionListener,
PopupMenuListener,
KeyListener,
ChangeListener {
    private final int WIDTH = 340;
    private final int HEIGHT = 180;
    private static final String APPLY = "Apply";
    private static final String CLOSE = "Close";
    private String[] shapes = new String[]{"Ellipse", "Rectangle"};
    private IOPNode node;
    private JPanel options;
    private JTextField label;
    private JComboBox<String> combo;
    private JButton closeButton;
    private JButton fillColor;
    private JButton borderColor;
    private JButton textColor;
    private JSlider wSlider;
    private JSlider hSlider;
    private JLabel wLabel;
    private JLabel hLabel;
    private IOPFrame frame;

    public NodeDialog(IOPFrame iOPFrame) {
        super(iOPFrame, "Edit Node Properties", false);
        this.frame = iOPFrame;
        this.setSize(340, 180);
        this.setContents();
    }

    public NodeDialog(IOPFrame iOPFrame, IOPNode iOPNode) {
        this(iOPFrame);
        this.setNode(iOPNode);
    }

    public void setNode(IOPNode iOPNode) {
        this.node = iOPNode;
    }

    public void setContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.options = new JPanel(gridBagLayout);
        this.combo = new JComboBox<String>(this.shapes);
        this.combo.setSelectedIndex(0);
        this.label = new JTextField(10);
        this.wLabel = new JLabel("Width: ");
        this.wSlider = new JSlider(0, 300);
        this.hLabel = new JLabel("Height: ");
        this.hSlider = new JSlider(0, 300);
        this.wSlider.addChangeListener(this);
        this.hSlider.addChangeListener(this);
        this.fillColor = new JButton();
        this.fillColor.setPreferredSize(new Dimension(20, 20));
        this.fillColor.addActionListener(this);
        this.borderColor = new JButton();
        this.borderColor.setPreferredSize(new Dimension(20, 20));
        this.borderColor.addActionListener(this);
        this.textColor = new JButton();
        this.textColor.setPreferredSize(new Dimension(20, 20));
        this.textColor.addActionListener(this);
        this.closeButton = new JButton(CLOSE);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.setSize(340, 40);
        this.closeButton.addActionListener(this);
        jPanel2.add(this.closeButton);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Node Label:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.options.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.label, gridBagConstraints);
        this.options.add(this.label);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel2 = new JLabel("Node Shape:");
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.options.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.combo, gridBagConstraints);
        this.options.add(this.combo);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.wLabel, gridBagConstraints);
        this.options.add(this.wLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.wSlider, gridBagConstraints);
        this.options.add(this.wSlider);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.hLabel, gridBagConstraints);
        this.options.add(this.hLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.hSlider, gridBagConstraints);
        this.options.add(this.hSlider);
        JLabel jLabel3 = new JLabel("Colours:");
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.options.add(jLabel3);
        JLabel jLabel4 = new JLabel("Fill:");
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        this.options.add(jLabel4);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fillColor, gridBagConstraints);
        this.options.add(this.fillColor);
        JLabel jLabel5 = new JLabel("Border:");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        this.options.add(jLabel5);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.borderColor, gridBagConstraints);
        this.options.add(this.borderColor);
        jPanel.add("Center", this.options);
        jPanel.add("South", jPanel2);
        this.setContentPane(jPanel);
        this.combo.addPopupMenuListener(this);
        this.label.addKeyListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.takeAction(APPLY);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.takeAction(APPLY);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = null;
        if (actionEvent.getSource() == this.fillColor) {
            color = JColorChooser.showDialog(this, "Select Fill Colour", this.node.getFillColor());
            if (color != null) {
                this.node.setFillColor(color);
                this.fillColor.setBackground(color);
                this.frame.repaint();
            }
        } else if (actionEvent.getSource() == this.borderColor) {
            color = JColorChooser.showDialog(this, "Select Border Colour", this.node.getFillColor());
            if (color != null) {
                this.node.setBorderColor(color);
                this.borderColor.setBackground(color);
                this.frame.repaint();
            }
        } else if (actionEvent.getSource() != this.textColor) {
            this.takeAction(actionEvent.getActionCommand());
        }
    }

    public void takeAction(String string) {
        if (string.equals(APPLY)) {
            this.node.setLabel(this.label.getText());
            this.node.setNodeShape(((String)this.combo.getSelectedItem()).toLowerCase());
            this.node.setBaseDimension(this.wSlider.getValue(), this.hSlider.getValue());
            this.wLabel.setText("Width:   " + this.wSlider.getValue());
            this.hLabel.setText("Height:  " + this.hSlider.getValue());
            this.frame.repaint();
        } else if (string.equals(CLOSE)) {
            this.setVisible(false);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.takeAction(APPLY);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            int n;
            String string = this.node.getNodeShape();
            if (string.equals("box")) {
                string = "rectangle";
            }
            for (n = 0; n < this.shapes.length; ++n) {
                if (!this.shapes[n].toLowerCase().equals(string.toLowerCase())) continue;
                this.combo.setSelectedIndex(n);
            }
            this.label.setText(this.node.getLabel());
            n = (int)Math.round(this.node.getHeight());
            int n2 = (int)Math.round(this.node.getWidth());
            this.hLabel.setText("Height:  " + n);
            this.wLabel.setText("Width:   " + n2);
            this.hSlider.setValue(n);
            this.wSlider.setValue(n2);
            this.fillColor.setBackground(this.node.getFillColor());
            this.borderColor.setBackground(this.node.getBorderColor());
        }
        super.setVisible(bl);
    }
}

