/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.glyph.GlyphList;
import g2d.glyph.Glyphish;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Manifold {
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static int THRESHOLD = 200;
    public static int CHART_W = 1000;
    public static int CHART_H = 1000;
    private static final boolean DEBUG = false;
    private int width;
    private int height;
    private int w;
    private int h;
    private int xOffset;
    private int yOffset;
    private int rows;
    private int columns;
    private Rectangle[][] atlas;
    private GlyphList[][] glyphs;
    private Rectangle base;

    public Glyphish getGlyphThing(Point2D point2D) {
        Point point = this.getSector((int)point2D.getX(), (int)point2D.getY());
        if (point == null) {
            return null;
        }
        GlyphList glyphList = this.glyphs[point.x][point.y];
        return glyphList.getGlyphThing(point);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        Rectangle rectangle2 = this.base.intersection(rectangle);
        Point[] pointArray = this.getSectors(rectangle2);
        if (pointArray == null) {
            return;
        }
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = pointArray[i];
            GlyphList glyphList = this.glyphs[point.x][point.y];
            glyphList.paint(graphics2D);
        }
    }

    public Manifold(int n, int n2, int n3, int n4) {
        this.width = n;
        this.height = n2;
        this.w = n3;
        this.h = n4;
        this.xOffset = this.computeOffset(1, n, n3);
        this.yOffset = this.computeOffset(0, n2, n4);
        this.initCharts();
    }

    public void add(Glyphish glyphish) {
        Point[] pointArray = this.getSectors(glyphish.getBounds());
        if (pointArray == null) {
            return;
        }
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = pointArray[i];
            GlyphList glyphList = this.glyphs[point.x][point.y];
            glyphList.add(glyphish);
        }
    }

    private void initCharts() {
        this.base = new Rectangle(0, 0, this.width, this.height);
        this.atlas = new Rectangle[this.rows][this.columns];
        this.glyphs = new GlyphList[this.rows][this.columns];
        int n = -this.xOffset;
        int n2 = -this.yOffset;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                Rectangle rectangle;
                this.atlas[j][i] = rectangle = new Rectangle(n, n2, this.w, this.h);
                this.glyphs[j][i] = new GlyphList();
                n2 += this.h;
            }
            n2 = -this.yOffset;
            n += this.w;
        }
    }

    private int computeOffset(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n2 / n3;
        int n6 = n2 % n3;
        if (n6 != 0) {
            int n7 = n3 - n6;
            n4 = n7 % 2 == 0 ? n7 / 2 : (n7 + 1) / 2;
            ++n5;
        }
        if (n == 0) {
            this.rows = n5;
        } else {
            this.columns = n5;
        }
        return n4;
    }

    private Point getSector(int n, int n2) {
        if (!this.base.contains(n += this.xOffset, n2 += this.yOffset)) {
            return null;
        }
        int n3 = n2 / this.h;
        int n4 = n / this.w;
        return n3 < this.rows && n4 < this.columns ? new Point(n3, n4) : null;
    }

    private Point[] getSectors(Rectangle2D rectangle2D) {
        return this.getSectors(new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight()));
    }

    private Point[] getSectors(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        Rectangle rectangle2 = this.base.intersection(rectangle);
        if (rectangle2.isEmpty()) {
            return null;
        }
        rectangle2.x += this.xOffset;
        rectangle2.y += this.yOffset;
        int n4 = rectangle2.x / this.w;
        int n5 = rectangle2.y / this.h;
        int n6 = rectangle2.x + rectangle2.width;
        int n7 = n6 / this.w;
        if (n7 > 0 && n6 % this.w == 0 && n7 > n4) {
            --n7;
        }
        if ((n3 = (n2 = rectangle2.y + rectangle2.height) / this.h) > 0 && n2 % this.h == 0 && n3 > n5) {
            --n3;
        }
        int n8 = (n = n7 - n4) < this.columns ? n + 1 : this.columns;
        int n9 = n3 - n5;
        int n10 = n9 < this.rows ? n9 + 1 : this.rows;
        try {
            Point[] pointArray = new Point[n8 * n10];
            for (int i = 0; i < n8; ++i) {
                for (int j = 0; j < n10; ++j) {
                    pointArray[j * n8 + i] = new Point(n5 + j, n4 + i);
                }
            }
            return pointArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("rows = " + this.rows + " columns = " + this.columns);
            System.err.println("xOffset = " + this.xOffset + " yOffset = " + this.yOffset);
            System.err.println("rect = " + rectangle2);
            System.err.println("row index = " + n3 + " column index = " + n7);
            System.err.println("rs = " + n10 + " cs = " + n8);
            throw arrayIndexOutOfBoundsException;
        }
    }
}

