/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.glyph.GlyphList;
import g2d.glyph.Glyphish;
import g2d.graph.IOPNode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;

public abstract class GraphItem
extends Glyphish {
    private static int idCounter = 0;
    public final Integer gid;
    public static Comparator<GraphItem> COMPARATOR = new Comparator<GraphItem>(){

        @Override
        public int compare(GraphItem graphItem, GraphItem graphItem2) {
            if (graphItem.equals(graphItem2)) {
                return 0;
            }
            if (graphItem instanceof IOPNode && graphItem2 instanceof IOPNode) {
                return IOPNode.COMPARATOR.compare((IOPNode)graphItem, (IOPNode)graphItem2);
            }
            return graphItem.gid - graphItem2.gid;
        }
    };
    protected static boolean antiAliased = true;
    public static int HIGHLIGHT_OFFSET = 2;
    public static Color HIGHLIGHT = Color.RED;
    public GlyphList glyphList = new GlyphList();
    private boolean selected = false;
    protected boolean highlighted = false;

    public GraphItem() {
        this.gid = new Integer(idCounter++);
    }

    public GraphItem(GraphItem graphItem) {
        super(graphItem);
        this.gid = graphItem.gid;
    }

    public int gid() {
        return this.gid;
    }

    public abstract double distanceTo(Point2D var1);

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void highlight() {
        this.highlighted = true;
    }

    public void dehighlight() {
        this.highlighted = false;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.glyphList.transform(affineTransform);
    }

    @Override
    public boolean inside(Point2D point2D) {
        return this.glyphList.inside(point2D);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        boolean bl = this.glyphList.intersects(rectangle2D);
        return bl;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.glyphList.getBounds();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (antiAliased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.glyphList.paint(graphics2D);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            this.glyphList.paint(graphics2D);
        }
    }
}

