/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.graph.IOPEdge;
import g2d.swing.IOPFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class EdgeDialog
extends JDialog
implements ActionListener,
PopupMenuListener,
KeyListener,
ChangeListener {
    private final int WIDTH = 300;
    private final int HEIGHT = 150;
    private static final String APPLY = "Apply";
    private static final String CLOSE = "Close";
    private String[] styles = new String[]{"Solid", "Dashed", "Dotted"};
    private IOPEdge edge;
    private JPanel options;
    private JComboBox<String> combo;
    private JButton closeButton;
    private JButton color;
    private IOPFrame frame;

    public EdgeDialog(IOPFrame iOPFrame) {
        super(iOPFrame, "Edit Node Properties", false);
        this.frame = iOPFrame;
        this.setSize(300, 150);
        this.setContents();
    }

    public EdgeDialog(IOPFrame iOPFrame, IOPEdge iOPEdge) {
        this(iOPFrame);
        this.setEdge(iOPEdge);
    }

    public void setEdge(IOPEdge iOPEdge) {
        this.edge = iOPEdge;
    }

    public void setContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.options = new JPanel(gridBagLayout);
        this.combo = new JComboBox<String>(this.styles);
        this.combo.setSelectedIndex(0);
        this.color = new JButton();
        this.color.setPreferredSize(new Dimension(20, 20));
        this.color.addActionListener(this);
        this.closeButton = new JButton(CLOSE);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.setSize(300, 40);
        this.closeButton.addActionListener(this);
        jPanel2.add(this.closeButton);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Edge Style:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.options.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.combo, gridBagConstraints);
        this.options.add(this.combo);
        JLabel jLabel2 = new JLabel("Colours:");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.options.add(jLabel2);
        JLabel jLabel3 = new JLabel("Fill:");
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.options.add(jLabel3);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.color, gridBagConstraints);
        this.options.add(this.color);
        jPanel.add("Center", this.options);
        jPanel.add("South", jPanel2);
        this.setContentPane(jPanel);
        this.combo.addPopupMenuListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.takeAction(APPLY);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.takeAction(APPLY);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = null;
        if (actionEvent.getSource() == this.color) {
            color = JColorChooser.showDialog(this, "Select Fill Colour", this.edge.getColor());
            if (color != null) {
                this.edge.setColor(color);
                this.color.setBackground(color);
                this.frame.repaint();
            }
        } else {
            this.takeAction(actionEvent.getActionCommand());
        }
    }

    public void takeAction(String string) {
        if (string.equals(APPLY)) {
            this.edge.setStyle(((String)this.combo.getSelectedItem()).toLowerCase());
            this.frame.repaint();
        } else if (string.equals(CLOSE)) {
            this.setVisible(false);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.takeAction(APPLY);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            String string = this.edge.getStyle();
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].toLowerCase().equals(string.toLowerCase())) continue;
                this.combo.setSelectedIndex(i);
            }
            this.color.setBackground(this.edge.getColor());
        }
        super.setVisible(bl);
    }
}

