/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.Main;
import g2d.graph.IOPEdge;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graph.IOPSubgraph;
import g2d.pla.PLAGraph;
import g2d.util.IO;
import g2d.util.Request;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Dot {
    public static final Version VERSION;
    public static boolean useRuleRanks;
    public static boolean dotDebug;
    public static boolean dotVerbose;
    public static int NSLIMIT;
    public static int NSLIMIT1;
    public static float MCLIMIT;
    public static final DotFormat DEFAULT_DOT_FORMAT;

    public static DotFormat int2DotFormat(int n) {
        return DotFormat.values()[n];
    }

    public static String colorToDotHSB(Color color) {
        if (color == null) {
            color = Color.white;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return "\"" + fArray[0] + " " + fArray[1] + " " + fArray[2] + "\"";
    }

    public static Color rgba2Color(String string) {
        Color color = Color.black;
        try {
            if (string != null && string.charAt(0) == '#' && string.length() >= 7) {
                int n = Integer.parseInt(string.substring(1, 3), 16);
                int n2 = Integer.parseInt(string.substring(3, 5), 16);
                int n3 = Integer.parseInt(string.substring(5, 7), 16);
                if (string.length() == 9) {
                    int n4 = Integer.parseInt(string.substring(7, 9), 16);
                    color = new Color(n, n2, n3, n4);
                } else if (string.length() == 7) {
                    color = new Color(n, n2, n3);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("rgba2Color hated " + string);
        }
        return color;
    }

    public static String makeDotInput(IOPGraph iOPGraph, Collection<IOPSubgraph> collection, Collection<IOPNode> collection2, Map<Integer, IOPEdge> map) {
        String string;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        PLAGraph pLAGraph = PLAGraph.getPLAGraph(iOPGraph);
        String string2 = useRuleRanks && pLAGraph != null ? pLAGraph.ruleRanks.toString() : "";
        stringBuffer.append("digraph temp {\n");
        stringBuffer.append("graph [xdotversion=1.2, rankdir=");
        stringBuffer.append(iOPGraph.rankdir);
        if (NSLIMIT != 0) {
            stringBuffer.append(", nslimit=");
            stringBuffer.append(NSLIMIT);
        }
        if (NSLIMIT1 != 0) {
            stringBuffer.append(", nslimit1=");
            stringBuffer.append(NSLIMIT1);
        }
        if (MCLIMIT != 0.0f) {
            stringBuffer.append(", mclimit=");
            stringBuffer.append(MCLIMIT);
        }
        if ((object = iOPGraph.getAttribute("compound")) != null && object.equals("true")) {
            stringBuffer.append(", compound=true");
        }
        stringBuffer.append("];\n");
        if (dotVerbose) {
            System.err.println("Graph Attributes: " + stringBuffer.toString());
        }
        for (IOPSubgraph object2 : collection) {
            if (!object2.topLevel) continue;
            string = object2.toDotString(iOPGraph, collection2, map);
            stringBuffer.append(string);
        }
        for (IOPNode iOPNode : collection2) {
            string = iOPNode.toDotString();
            stringBuffer.append(string);
        }
        for (Integer n : map.keySet()) {
            string = map.get(n).toDotString();
            stringBuffer.append(string);
        }
        stringBuffer.append(string2);
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public static boolean queryDot(DotFormat dotFormat, File file, File file2) {
        long l;
        block9: {
            Process process = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            l = System.nanoTime();
            arrayList.add("dot");
            if (dotVerbose) {
                arrayList.add("-v");
            }
            arrayList.add("-T" + dotFormat.extension);
            arrayList.add("-o");
            arrayList.add(file2.getPath());
            arrayList.add(file.getPath());
            try {
                if (dotDebug) {
                    IO.err.println(arrayList);
                }
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                processBuilder.redirectErrorStream(true);
                process = processBuilder.start();
                if (process != null) {
                    int n;
                    if (dotVerbose) {
                        String string;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        while ((string = bufferedReader.readLine()) != null) {
                            System.err.println(string);
                        }
                    }
                    if ((n = process.waitFor()) != 0) {
                        throw new IOException("dotProcess wait failed " + n);
                    }
                    break block9;
                }
                return false;
            }
            catch (Exception exception) {
                System.err.println(exception);
                return false;
            }
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        if (dotVerbose) {
            System.err.format("Dot.queryDot finished in %d milliseconds\n", l3 / 10000000L);
        }
        return true;
    }

    private static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block5;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String requestDot(DotFormat dotFormat, String string) {
        return "\"" + Dot.quote(Dot.askDot(dotFormat, string)) + "\"";
    }

    public static String askDot(DotFormat dotFormat, String string) {
        if (!Main.isRemote()) {
            try {
                String string2;
                File file = File.createTempFile("dotIn", "." + Dot.DEFAULT_DOT_FORMAT.extension);
                File file2 = File.createTempFile("dotOut", "." + Dot.DEFAULT_DOT_FORMAT.extension);
                if (dotDebug) {
                    System.err.println("in = " + file + "\nout = " + file2);
                    System.err.flush();
                }
                IO.string2File(string, file);
                if (!Dot.queryDot(dotFormat, file, file2)) {
                    return null;
                }
                String string3 = string2 = dotFormat.fileType == FileType.BINARY ? IO.file2B64String(file2) : IO.file2String(file2);
                if (!dotDebug) {
                    file.delete();
                    file2.delete();
                } else {
                    IO.err.println("Dot leaving dot files around!\n");
                }
                return string2;
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                return null;
            }
        }
        String string4 = "(sinvoke \"g2d.graph.Dot\" \"requestDot\" (sinvoke \"g2d.graph.Dot\" \"int2DotFormat\" (int " + dotFormat.ordinal() + ")) \"" + Dot.quote(string) + "\")";
        return new Request(string4).ask();
    }

    public static String chopQuotes(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length() - 1;
        if (string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            return string.substring(1, n);
        }
        return string;
    }

    static {
        useRuleRanks = false;
        VERSION = Version.which();
        dotDebug = false;
        dotVerbose = false;
        NSLIMIT = 8;
        NSLIMIT1 = 8;
        MCLIMIT = 0.1f;
        DEFAULT_DOT_FORMAT = DotFormat.XDOT;
    }

    public static enum DotFormat {
        DOT(FileType.TEXT, "dot"),
        PNG(FileType.BINARY, "png"),
        JPG(FileType.BINARY, "jpg"),
        GIF(FileType.BINARY, "gif"),
        PS(FileType.BINARY, "ps"),
        PS2(FileType.BINARY, "ps2"),
        EPS(FileType.BINARY, "eps"),
        XDOT(FileType.TEXT, "xdot"),
        SVG(FileType.TEXT, "svg"),
        SVGZ(FileType.TEXT, "svg");

        public final FileType fileType;
        public final String extension;

        private DotFormat(FileType fileType, String string2) {
            this.fileType = fileType;
            this.extension = string2;
        }
    }

    public static enum FileType {
        BINARY,
        TEXT;

    }

    public static class Version {
        public int version = -1;
        public int major = -1;
        public int minor = -1;
        public String raw;
        private final Matcher matcher;
        private static final String patternString = "version\\s+([\\d]*)\\.([\\d]*)\\.([\\d]*)(\\.([\\d]*))?\\s+";
        private static final Pattern pattern = Pattern.compile("version\\s+([\\d]*)\\.([\\d]*)\\.([\\d]*)(\\.([\\d]*))?\\s+");

        public Version(String string) {
            this.raw = string;
            this.matcher = pattern.matcher(string);
            if (this.matcher.find()) {
                this.version = Integer.parseInt(this.matcher.group(1));
                this.major = Integer.parseInt(this.matcher.group(2));
                this.minor = Integer.parseInt(this.matcher.group(3));
            } else {
                System.err.println("g2d.graph.Dot.Version: no match (" + this.raw + ")");
            }
        }

        public String toString() {
            return this.version > 0 ? "" + this.version + "." + this.major + "." + this.minor : "no dot version known";
        }

        public static final Version which() {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder("dot", "-V");
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string = bufferedReader.readLine();
                if (string != null) {
                    return new Version(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

