/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyphviewer;

import g2d.glyph.BufferedGlyphList;
import g2d.glyph.Glyphish;
import g2d.glyphviewer.GlyphPanel;
import g2d.glyphviewer.GlyphView;
import g2d.jlambda.Closure;
import g2d.jlambda.PrimitiveData;
import g2d.swing.IOPFileChooser;
import g2d.util.IO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TabFindGlyph
extends JPanel
implements ChangeListener {
    private static final String COMPLETE = "complete";
    private static final String FIND_SELECT = "find_and_select";
    private final GlyphView owner;
    public final Font font;
    private final Closure filter;
    private final Closure renderer;
    private final JLabel description;
    private final JTextField fieldOfGlyphs;
    private final ListModel modelOfGlyphs = new ListModel();
    private final JList<Glyphish> listOfGlyphs = new JList<Glyphish>(this.modelOfGlyphs);
    private int lastIndex;
    private boolean completionInProgress = false;
    private boolean completionRemove = false;
    private boolean completionInsert = false;

    public TabFindGlyph(GlyphView glyphView, Closure closure, Closure closure2) {
        this(glyphView, UIManager.getFont("Button.font").deriveFont(10.0f), closure, closure2);
    }

    public TabFindGlyph(GlyphView glyphView, Font font, Closure closure) {
        this(glyphView, font, null, closure);
    }

    public TabFindGlyph(GlyphView glyphView, Font font) {
        this(glyphView, font, null, null);
    }

    public TabFindGlyph(GlyphView glyphView, Font font, Closure closure, Closure closure2) {
        this.owner = glyphView;
        this.font = font;
        this.filter = closure;
        this.renderer = closure2;
        this.listOfGlyphs.setFont(font);
        this.listOfGlyphs.setCellRenderer(new ListRenderer());
        this.fieldOfGlyphs = this.makeField(this.modelOfGlyphs, this.listOfGlyphs);
        this.description = new JLabel("Find Glyph:");
        this.description.setFont(this.font);
        this.init();
        this.stateChanged();
    }

    public String renderObject(Object object) {
        String string = "";
        string = this.renderer != null && object instanceof Glyphish ? this.renderer.applyClosure(object).toString() : object.toString();
        return string;
    }

    public boolean filterObject(Object object) {
        Object object2;
        boolean bl = true;
        if (this.filter != null && object instanceof Glyphish && (object2 = this.filter.applyClosure(object)) != null) {
            bl = (object2 = PrimitiveData.unwrap(object2)) instanceof Boolean && (Boolean)object2 != false;
        }
        return bl;
    }

    public void stateChanged() {
        this.stateChanged(new ChangeEvent(this));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        BufferedGlyphList bufferedGlyphList = this.owner.glyphs;
        if (bufferedGlyphList != null) {
            Collection<Glyphish> collection = bufferedGlyphList.getGlyphishInCollection();
            if (this.filter != null) {
                ArrayList<Glyphish> arrayList = new ArrayList<Glyphish>();
                for (Glyphish glyphish : collection) {
                    if (!this.filterObject(glyphish)) continue;
                    arrayList.add(glyphish);
                }
                this.setGlyphishs((List<Glyphish>)arrayList);
            } else {
                this.setGlyphishs(collection);
            }
        }
    }

    public void setCellRendererClosure() {
        this.listOfGlyphs.setCellRenderer(new ListRenderer());
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        jPanel.add((Component)this.description, "North");
        jPanel.add((Component)this.fieldOfGlyphs, "Center");
        this.configureList(this.listOfGlyphs, this.fieldOfGlyphs);
        JScrollPane jScrollPane = new JScrollPane(this.listOfGlyphs);
        jScrollPane.setBackground(Color.white);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
        JButton jButton = new JButton(this.fieldOfGlyphs.getAction());
        jButton.setToolTipText("Find glyph (or [ENTER] in text field)");
        jButton.setOpaque(false);
        jPanel2.add(jButton);
        jButton = this.makeSaveButton();
        jPanel2.add(jButton);
        SelectingListener selectingListener = new SelectingListener(this.fieldOfGlyphs, this.modelOfGlyphs, this.listOfGlyphs);
        this.fieldOfGlyphs.getDocument().addDocumentListener(selectingListener);
        this.fieldOfGlyphs.getDocument().putProperty("SelectingListener", selectingListener);
    }

    private JButton makeSaveButton() {
        JButton jButton = new JButton(new SaveAction());
        jButton.setOpaque(false);
        jButton.setToolTipText("Save the list to a file");
        return jButton;
    }

    private JTextField makeField(ListModel listModel, JList jList) {
        final JTextField jTextField = new JTextField(25);
        jTextField.setFont(this.font);
        jTextField.setFocusable(true);
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                jTextField.setCaretPosition(0);
                jTextField.selectAll();
            }
        });
        jTextField.setAction(new FindAction(jTextField, jList));
        jTextField.setFocusTraversalKeysEnabled(false);
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), COMPLETE);
        jTextField.getActionMap().put(COMPLETE, new CompleteAction(jTextField, listModel));
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), FIND_SELECT);
        jTextField.getActionMap().put(FIND_SELECT, new FindAction(jTextField, jList));
        return jTextField;
    }

    private void configureList(JList jList, JTextField jTextField) {
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(-1);
        jList.addMouseListener(new FindListener(jList, jTextField));
    }

    public void setGlyphishs(List<Glyphish> list) {
        this.modelOfGlyphs.setData(list);
    }

    public void setGlyphishs(Collection<Glyphish> collection) {
        ArrayList<Glyphish> arrayList = new ArrayList<Glyphish>(collection);
        this.modelOfGlyphs.setData(arrayList);
    }

    private void setTFText(JTextField jTextField, String string) {
        this.completionInProgress = false;
        SelectingListener selectingListener = (SelectingListener)jTextField.getDocument().getProperty("SelectingListener");
        jTextField.getDocument().removeDocumentListener(selectingListener);
        jTextField.setText(string);
        jTextField.getDocument().addDocumentListener(selectingListener);
    }

    public void focus(boolean bl) {
        this.fieldOfGlyphs.requestFocus();
    }

    public void wait4VisibleNFocus(boolean bl) {
        Visible2Focus visible2Focus = new Visible2Focus(this.fieldOfGlyphs);
        this.addComponentListener(visible2Focus);
    }

    class ListRenderer
    extends JLabel
    implements ListCellRenderer<Glyphish> {
        public ListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setVerticalAlignment(0);
            this.setFont(TabFindGlyph.this.font);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Glyphish> jList, Glyphish glyphish, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            String string = TabFindGlyph.this.renderObject(glyphish);
            this.setText(string);
            this.revalidate();
            this.setSize(this.getPreferredSize());
            return this;
        }
    }

    class ListModel
    extends AbstractListModel<Glyphish> {
        protected List<Glyphish> data = new ArrayList<Glyphish>();

        ListModel() {
        }

        public void setData(List<? extends Glyphish> list) {
            int n = this.getSize() - 1;
            this.data.clear();
            if (n >= 0) {
                this.fireIntervalRemoved(this, 0, n);
            }
            this.data = list == null ? new ArrayList<Glyphish>() : new ArrayList<Glyphish>(list);
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        public int indexOfName(String string, boolean bl, int n) {
            int n2 = -1;
            if (n >= 0 && n <= this.data.size()) {
                ListIterator<Glyphish> listIterator = this.data.listIterator(n);
                while (listIterator.hasNext()) {
                    String string2 = TabFindGlyph.this.renderObject(listIterator.next());
                    if (!bl && string2.equalsIgnoreCase(string) || string2.equals(string)) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
            }
            return n2;
        }

        public int indexOfCompletion(String string, int n) {
            int n2 = -1;
            if (string != null && !string.equals("")) {
                ListIterator<Glyphish> listIterator = this.data.listIterator(n);
                while (listIterator.hasNext()) {
                    String string2 = TabFindGlyph.this.renderObject(listIterator.next());
                    if (string2.toLowerCase().startsWith(string.toLowerCase())) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
            }
            return n2;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Glyphish getElementAt(int n) {
            return this.data.get(n);
        }
    }

    class SelectingListener
    implements DocumentListener {
        private JTextField textField;
        private ListModel model;
        private JList list;

        public SelectingListener(JTextField jTextField, ListModel listModel, JList jList) {
            this.textField = jTextField;
            this.model = listModel;
            this.list = jList;
        }

        private void selectInList() {
            String string = this.textField.getText();
            int n = 0;
            if (TabFindGlyph.this.completionInProgress) {
                n = TabFindGlyph.this.lastIndex;
            }
            if ((n = this.model.indexOfName(string, true, n)) != -1) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                this.list.setSelectionInterval(n, n);
                this.list.ensureIndexIsVisible(n);
            } else {
                n = this.model.indexOfCompletion(string, 0);
                if (n == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectionBackground(Color.LIGHT_GRAY);
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!TabFindGlyph.this.completionInsert) {
                TabFindGlyph.this.completionInProgress = false;
            }
            TabFindGlyph.this.completionInsert = false;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.selectInList();
            if (!TabFindGlyph.this.completionRemove) {
                TabFindGlyph.this.completionInProgress = false;
            }
            TabFindGlyph.this.completionRemove = false;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class FindListener
    extends MouseAdapter {
        private JList list;
        private JTextField textField;

        public FindListener(JList jList, JTextField jTextField) {
            this.list = jList;
            this.textField = jTextField;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 0) {
                this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    this.list.setSelectionInterval(n, n);
                    this.list.ensureIndexIsVisible(n);
                    Object e = this.list.getSelectedValue();
                    String string = TabFindGlyph.this.renderObject(e);
                    TabFindGlyph.this.setTFText(this.textField, string);
                    if (mouseEvent.getClickCount() == 2) {
                        this.textField.getAction().actionPerformed(new ActionEvent(this.list, 1001, ""));
                    }
                }
            }
        }
    }

    class CompleteAction
    extends AbstractAction {
        private JTextField textField;
        private ListModel model;
        private String toBeCompleted = "";
        private int firstIndex;

        public CompleteAction(JTextField jTextField, ListModel listModel) {
            this.textField = jTextField;
            this.model = listModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (!TabFindGlyph.this.completionInProgress) {
                TabFindGlyph.this.completionInProgress = true;
                this.toBeCompleted = this.textField.getText();
                TabFindGlyph.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, 0);
                this.firstIndex = TabFindGlyph.this.lastIndex;
                if (TabFindGlyph.this.lastIndex == -1) {
                    TabFindGlyph.this.completionInProgress = false;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                string = TabFindGlyph.this.renderObject(this.model.getElementAt(TabFindGlyph.this.lastIndex));
                if (this.textField.getText().equals(string)) {
                    ++this.firstIndex;
                    this.textField.dispatchEvent(new KeyEvent(this.textField, 401, 0L, 0, 9, '\uffff'));
                    return;
                }
            } else {
                TabFindGlyph.this.lastIndex = this.model.indexOfCompletion(this.toBeCompleted, TabFindGlyph.this.lastIndex + 1);
                if (TabFindGlyph.this.lastIndex == -1) {
                    TabFindGlyph.this.lastIndex = this.firstIndex - 1;
                    string = this.toBeCompleted;
                } else {
                    string = TabFindGlyph.this.renderObject(this.model.getElementAt(TabFindGlyph.this.lastIndex));
                }
            }
            TabFindGlyph.this.completionInsert = true;
            TabFindGlyph.this.completionRemove = true;
            this.textField.setText(string);
        }
    }

    class FindAction
    extends AbstractAction {
        private JTextField textField;
        private JList list;

        public FindAction(JTextField jTextField, JList jList) {
            super("Find");
            this.textField = jTextField;
            this.list = jList;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object e = this.list.getSelectedValue();
            if (e instanceof Glyphish) {
                GlyphPanel glyphPanel;
                Glyphish glyphish = (Glyphish)e;
                String string = TabFindGlyph.this.renderObject(glyphish);
                if (string.equalsIgnoreCase(this.textField.getText())) {
                    TabFindGlyph.this.setTFText(this.textField, string);
                }
                if (TabFindGlyph.this.owner != null && (glyphPanel = ((TabFindGlyph)TabFindGlyph.this).owner.glyphPanel) != null && glyphPanel.glyphs != null) {
                    glyphPanel.centerOn(glyphish.getBounds().getBounds());
                }
                return;
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class Visible2Focus
    extends ComponentAdapter {
        JTextField textField;

        public Visible2Focus(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.textField.requestFocus();
            TabFindGlyph.this.removeComponentListener(this);
        }
    }

    class SaveAction
    extends AbstractAction {
        private final IOPFileChooser chooser;

        public SaveAction() {
            super("Save");
            this.chooser = new IOPFileChooser("raw_text_area");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.setDialogTitle("Save List to File");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.situate();
            JFrame jFrame = ((TabFindGlyph)TabFindGlyph.this).owner.glyphPanel.getFrame();
            int n = this.chooser.showDialog(jFrame, "Save");
            if (n != 0) {
                return;
            }
            File file = this.chooser.getSelectedFile();
            String[] stringArray = new String[((TabFindGlyph)TabFindGlyph.this).modelOfGlyphs.data.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = TabFindGlyph.this.renderObject(((TabFindGlyph)TabFindGlyph.this).modelOfGlyphs.data.get(i));
            }
            IO.array2File(stringArray, file);
        }
    }
}

