/*
 * Decompiled with CFR 0.152.
 */
package g2d.closure;

import g2d.jlambda.Attributable;
import g2d.jlambda.Closure;
import g2d.jlambda.PrimitiveData;
import g2d.util.IO;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ClosureIterator
extends Attributable
implements Iterator {
    private Closure hasNextClosure;
    private Closure nextClosure;
    private Closure removeClosure;
    private boolean nextCalled = false;
    private Object current = null;

    public void setHasNextClosure(Closure closure) {
        if (closure.getArity() != 1) {
            IO.err.println("ClosureIterator.setHasNextClosure: Closure arity not 1 -- " + closure);
        } else {
            this.hasNextClosure = closure;
        }
    }

    public void setNextClosure(Closure closure) {
        if (closure.getArity() != 1) {
            IO.err.println("ClosureIterator.setNextClosure: Closure arity not 1 -- " + closure);
        } else {
            this.nextClosure = closure;
        }
    }

    public void setRemoveClosure(Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("ClosureIterator.setRemoveClosure: Closure arity not 2 -- " + closure);
        } else {
            this.removeClosure = closure;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextClosure != null) {
            Object object = this.hasNextClosure.applyClosure(this);
            if ((object = PrimitiveData.unwrap(object)) instanceof Boolean) {
                return (Boolean)object;
            }
        }
        return false;
    }

    public Object next() {
        if (this.nextClosure != null) {
            Object object = this.nextClosure.applyClosure(this);
            this.nextCalled = true;
            this.current = object;
            return object;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (!this.nextCalled) {
            throw new UnsupportedOperationException();
        }
        if (this.removeClosure != null) {
            this.removeClosure.applyClosure(this, this.current);
            this.nextCalled = false;
            this.current = null;
        }
        throw new UnsupportedOperationException();
    }
}

