/*
 * Decompiled with CFR 0.152.
 */
package g2d.closure;

import g2d.jlambda.Attributable;
import g2d.jlambda.Closure;
import g2d.util.IO;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class ClosureComponentListener
extends Attributable
implements ComponentListener {
    private Closure componentResizedClosure;
    private Closure componentMovedClosure;
    private Closure componentShownClosure;
    private Closure componentHiddenClosure;

    public void setClosure(int n, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("ClosureComponentListener.setClosure: closure arity not 2 -- " + closure);
            return;
        }
        switch (n) {
            case 100: {
                this.componentMovedClosure = closure;
                return;
            }
            case 101: {
                this.componentResizedClosure = closure;
                return;
            }
            case 102: {
                this.componentShownClosure = closure;
                return;
            }
            case 103: {
                this.componentHiddenClosure = closure;
                return;
            }
        }
        IO.err.println("ClosureComponentListener.setClosure: unrecognized type -- " + n);
    }

    private void takeAction(Closure closure, ComponentEvent componentEvent) {
        if (closure != null) {
            closure.applyClosure(this, componentEvent);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.takeAction(this.componentResizedClosure, componentEvent);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.takeAction(this.componentMovedClosure, componentEvent);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.takeAction(this.componentShownClosure, componentEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.takeAction(this.componentHiddenClosure, componentEvent);
    }
}

