/*

Import menu
ortho
   file name -- csv/tab uniprot id x confidence
   paint occs with uniprot dk/lt green according to confidence
expression
   file name -- uniprot,level
    partition levels into n+1 use headmap colors

*/

;; returns arrl of arrays (line splits)
(define loadData (filename sep)
  (let ((res (object ("java.util.ArrayList")))
        (fun (lambda (line) (invoke line "split" sep)))
        )
     (sinvoke g2d.util.IO "file2Collection" res filename fun (boolean true))
    res
))

(define paintGName (gname filter cfun)
  (let ((graph (fetch gname)))
   (if (isobject graph) (apply paintGraph graph filter cfun) (object null))
  ))

(define paintGraph (graph filter cFun)
  (let ((panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (nodes (invoke graph "getNodesInArray")))
     (for node nodes 
        (let ((res (apply filter node)))
          (if (isobject res) (invoke node "setFillColor" (apply cFun res))) ))
     (invoke panel "repaint") 
))

;; an arraylist of the uniprots of any proteins appearing in the occ
;; for composite proteins -- uniprots of the subunits
;; for families -- uniprots of the members

(define occ2UniProts (occ)
  (let ((res (object ("java.util.ArrayList"))))
  (if (instanceof occ "bp2pl.ComplexOccurrence")
      (apply cocc2Uniprots occ res)
  (if (instanceof occ "bp2pl.SimpleOccurrence")
      (apply socc2Uniprots occ resw)
      res
))))

(define cocc2UniProts (occ res)
  (let ((components (lookup occ "components")))
    (for socc componenets (apply socc2UniProts socc res))
    res ))

(define isProtein (eref) (= (lookup eref "sort") bp2pl.EntityReference.PROT))

(define socc2Uniprots (occ res)
  (let ((eref (lookup occ "eref")))
    (if (apply isProtein eref) (apply protEref2UniProts eref res) res) ))

(define protEref2UniProts (eref res)
;; cases sref, gref cref
  (if (instanceof eref bp2pl.SimpleReference)
      (apply sref2UniProts eref res)
  (if (instanceof eref bp2pl.CompositeReference)
      (let ((subunits (lookup eref "subunits")))
        (for er subunits  (apply sref2UniProts er res)))
  (if (instanceof eref bp2pl.GenericReference)
      (let ((members (lookup eref "members")))
        (for er members  (apply sref2UniProts er res)))
  res ))) )

;; the uniprot tag should be looked up 
(define sref2UniProts (eref res)
  (let ((md (getAttr eref "metadata"))
        (up (if (isobject md) (invoke md "get" "spnumber") (object null)))
       )
      (if (isobject up)  (invoke res "add" up)) 
    res
))


(define uniProtFilter  (uparray occmap) 
  (lambda (node) 
    (if (= (getattr Node "type") "occ")
      (let ((clab (getAttr node "chattylabel"))
            (occ (invoke occmap "get" clab))
            (uids (apply occ2UniProts occ))
            )
         (apply intersect uparray uids)
       )
      (object null)
   )))   

(define paintUpList (graph uparray color)
)

(define paintRankdedUpList (graph uparray rank2colorfun)
)

