;; REQUIRES jutil.lsp

;; The names of all entities referenced in a simple occ and hence in any occ
;; inlcude also any members/subunits


;;; kb used vocabulary
(define exportVocabulry (kbname dir)
  (let ((kb (fetch kbname))
        (jkb (getAttr kb "jkb")) 
        (locs-used (apply usedLocs jkb)) 
        (mods-used (apply usedMods jkb)) 
        (erefs-used (apply usedErefs jkb)) ) 
     (seq
      "write json files"
       )))


(define usedErefs (jkb)
  (let ((occvals (invoke (lookup jkb "occmap") "values"))
        (erefmap (lookup jkb "erefmap") )
        (enames (object ("java.util.ArrayList"))) )
     (seq
       (for occ occvals
         (if (instanceOf occ "bp2pl.SimpleOccurrence")
           (let ((eref (lookup occ "eref"))
                 (ename (lookup eref "name")) )
            (seq
             (if (not (invoke enames "contains" ename))
                 (invoke enames "add" ename))
             (if (instanceOf eref "bp2pl.GenericReference")
                 (let ((members (lookup eref "members")))
                     (for er members 
                       (let ((en (lookup er "name")))
                         (if (not (invoke enames "contains" en))
                             (invoke enames "add" en)) )))) ;; generic
             (if (instanceOf eref "bp2pl.CompositeReference")
                  (let ((members (lookup eref "subunits")))
                     (for er members 
                       (let ((en (lookup er "name")))
                         (if (not (invoke enames "contains" en))
                             (invoke enames "add" en)) )))) ;; generic

           )))) ;; seq let if for
       (apply names2objs erefmap enames)
     )))


(define usedMods (jkb)
  (let ((occvals (invoke (lookup jkb "occmap") "values"))
        (modmap (lookup jkb "modmap") )
        (names (object ("java.util.ArrayList"))) )
     (seq
       (for occ occvals
         (if (instanceOf occ "bp2pl.SimpleOccurrence")
            (for mod (lookup occ "modifiers") 
              (let ((name (lookup mod "name")))
                (if (not (invoke names "contains" name)) (invoke names "add" name)))) ))
       (apply names2objs modmap names)
     )))

(define usedLocs (jkb)
  (let ((occvals (invoke (lookup jkb "occmap") "values"))
        (locmap (lookup jkb "locmap") )
        (names (object ("java.util.ArrayList"))) )
     (seq
       (for occ occvals
         (if (instanceOf occ "bp2pl.SimpleOccurrence")
             (let ((name (lookup (lookup occ "location") "name")))
               (if (not (invoke names "contains" name)) (invoke names "add" name)))) )
       (apply names2objs locmap names)
     )))


(define lbrace (invoke "{}" "substring" (int 0) (int 1)))
(define rbrace (invoke "{}" "substring" (int 1) (int 2)))

;;; turns an array of kb vals into a string array { "key1":jstr1,  ... "keyn":jstrn }
;;; for printing each json object on a newline
(define vals2jarr (vals o2jfun keyname)
  (let ((arrl (object ("java.util.ArrayList"))))
    (seq
      (invoke arrl "add" lbrace)
      (for val vals
	      (let ((jval (apply o2jfun val)))
	        (if  (instanceof jval "java.util.Map")
	          (let ((key (invoke jval "get" keyname))
	                (jstr  (sinvoke "org.json.simple.JSONValue" "toJSONString" jval)) )
  	          (invoke arrl "add" (concat "\"" key "\"" ":" jstr ",")) ))  
          ))
     ;;; delete final comma
      (let ((lastix (- (invoke arrl "size") (int 1)))
            (last (invoke arrl "remove" lastix)) )
         (invoke arrl "add" 
             (invoke last "substring" (int 0) (- (invoke last "length") (int 1))))
        )
      (invoke arrl "add" rbrace)
      arrl) ))

(define exportJSONvals (vals jfun keyname fname)
  (let ((jarr (apply  vals2jarr vals jfun keyname)) )
      (sinvoke "g2d.util.IO" "collection2File" 
          jarr         
          fname  ;; "XJSON/locs.json" 
          (object null)
          (boolean false) ) ))

;; single kb object to json
;; { "stype" : "loc",
;;   "name" : String,           // its name (unique in a KB)
;;   "metadata" : JObject       // definition
;;  }
;;   (update loc "name" name) 
;;   (if (instanceof metadata "java.util.Map") (setAttr loc "metadata" metadata))

;; assumes lobj is bp2pl.Location outputs json object or null
(define loc2json (obj)
  (let ((jobj (object ("java.util.HashMap")))
        (metadata (getAttr obj "metadata")) )
   (seq
     (invoke jobj "put" "stype" "loc")
     (invoke jobj "put" "name" (lookup obj "name"))
     (if (instanceof metadata "java.util.Map") (invoke jobj "put" "metadata" metadata))
     jobj ) ))


(define msort2mtype (msort)
 (if (= msort bp2pl.Modification.AAMOD ) "AAMOD"  
 (if (= msort bp2pl.Modification.ACT   ) "ACT"    
 (if (= msort bp2pl.Modification.OTHER ) "OTHER"  
 (if (= msort bp2pl.Modification.SMBIND) "SMBIND" 
 (if (= msort bp2pl.Modification.FRAG  ) "FRAG"   
     ""))))) )

;; { "stype" : "mod",
;;   "name" : String,      // constructed from op (and site if present)
;;   "shortname" : String  // for op
;;   "op" : String,  
;;   "site" : String,      // optional 
;;   "mtype" : MType, 
;;   "cvs" : JArray[CV],          //controlled vocab refs
;;   "metadata" : JObj
;; }
;; MType = {"AAMOD", "ACT", "FRAG", "SMBIND", "OTHER"}

;;   (update mod "name" name)
;;   (update mod "op" op)
;;   (update mod "sort" msort)
;;   (if (instanceof site "java.lang.String") (update mod "site" site)) 
;;   (if (instanceof shortname "java.lang.String")(setAttr mod "shortname" shortname)) 
;;   (if (apply cvSpecsP cvs) (update mod "cvs" cvs))
;;   (if (instanceof metadata "java.util.Map") (setAttr mod "metadata" metadata))

(define mod2json (obj)
  (let ((jobj (object ("java.util.HashMap")))
        (site (lookup obj "site"))
        (sort (lookup obj "sort"))
        (mtype (apply msort2mtype sort))
        (cvs (lookup obj "cvs"))
        (shortname (getAttr obj "shortname"))
        (metadata (getAttr obj "metadata"))
        ) 
   (seq
     (invoke jobj "put" "stype" "mod")
     (invoke jobj "put" "name" (lookup obj "name"))
     (invoke jobj "put"  "op" (lookup obj "op")) 
     (if (instanceof site "java.lang.String") (invoke jobj "put"  "site" site) )
     (invoke jobj "put"  "mtype" mtype)
     (if (instanceof shortname "java.lang.String") 
          (invoke jobj "put"  "shortname" shortname) )
     (if (instanceof cvs "java.util.ArrayList") (invoke jobj "put"  "cvs" cvs))
     (if (instanceof metadata "java.util.Map") (invoke jobj "put" "metadata" metadata))
     jobj ) ))


;;;; entities

(define esort2etype (esort)
 (if (= esort bp2pl.EntityReference.PROT) "Protein" 
 (if (= esort bp2pl.EntityReference.CHEM) "Chemical"
 (if (= esort bp2pl.EntityReference.DNA ) "Gene"    
 (if (= esort bp2pl.EntityReference.RNA ) "RNA"     
       "")))) )

;; { "stype" : "sref",
;;   "name" : String,  
;;   "etype" : Etype,   
;;   "xref" : Xref,              // standard refs or null
;;   "metadata" : JObj,
;; }
;; Etype = {"Protein", "Chemical", "DNA", "RNA"}

;; (update sref "name" name)
;; (update sref "sort" (if (= (object null) esort) (int -1) esort))
;; (if (apply isXref xref) (update sref "xref" xref))
;; (if (instanceof synonyms "java.util.ArrayList") (update sref "synonyms" synonyms))
;; (if (instanceof metadata "java.util.Map") (setAttr sref "metadata" metadata)) 

(define sref2json (obj)
  (let ((jobj (object ("java.util.HashMap")))
        (sort (lookup obj "sort"))
        (etype (apply esort2etype sort))
        (xref (lookup obj "xref"))
        (metadata (getAttr obj "metadata"))
        )
   (seq
     (invoke jobj "put" "stype" "sref")
     (invoke jobj "put" "name" (lookup obj "name"))
     (invoke jobj "put"  "etype" etype)
     (if (instanceof xref "java.util.Map") (invoke jobj "put"  "xref" xref))
     (if (instanceof metadata "java.util.Map") (invoke jobj "put" "metadata" metadata))
     jobj ) ))

;; { "stype" : "gref",
;;   "name" : String, 
;;   "etype" : "Protein",
;;   "members" : JArray[String], 
;;   "metadata" : JObject  }

;;  (update gref "name" name)
;;  (update gref "sort" (if (isnull esort) (int -1) esort))
;;    (update gref "members" membererefs)
;;  (if (instanceof synonyms "java.util.ArrayList") (update gref "synonyms" synonyms))
;;  (if (instanceof members "java.util.ArrayList")  (setAttr gref "members" members)) 
;;  (if (instanceof metadata "java.util.Map")  (setAttr gref "metadata" metadata)) 

(define gref2json (obj)
  (let ((jobj (object ("java.util.HashMap")))
        (members (apply objs2vals (lookup obj "members") "name"))
        (metadata (getAttr obj "metadata"))
        )
   (seq
     (invoke jobj "put" "stype" "gref")
     (invoke jobj "put" "name" (lookup obj "name"))
     (invoke jobj "put"  "etype" "Protein")
     (if (instanceof members "java.util.ArrayList") 
         (invoke jobj "put"  "members" members))
     (if (instanceof metadata "java.util.Map") (invoke jobj "put" "metadata" metadata))
     jobj ) ))

(define cref2json (obj)
  (let ((jobj (object ("java.util.HashMap")))
        (subunits (apply objs2vals (lookup obj "subunits") "name"))
        (metadata (getAttr obj "metadata"))
        )
   (seq
     (invoke jobj "put" "stype" "gref")
     (invoke jobj "put" "name" (lookup obj "name"))
     (invoke jobj "put"  "etype" "Protein")
     (if (instanceof subunits "java.util.ArrayList") 
         (invoke jobj "put"  "subunits" subunits))
     (if (instanceof metadata "java.util.Map") (invoke jobj "put" "metadata" metadata))
     jobj ) ))


(define omods2json (mods)
  (let ((jmods (object ("java.util.ArrayList"))))
    (seq
      (for mod mods (invoke jmods "add" (apply omod2json mod)))
      jmods )))

(define omod2json (mod)
  (let ((name (lookup mod "name"))
        (site (lookup mod "site")))
   (if (or (not (instanceof site "java.lang.String")) (= site ""))
     name
     (let ((jmod (object ("java.util.HashMap"))))
       (seq
        (invoke jmod "put" "stype" "sitemod")
        (invoke jmod "put" "name" (lookup mod "name"))
        (invoke jmod "put" "op" (lookup mod "op"))
        (invoke jmod "put" "site" (lookup mod "site"))
        jmod
       )) )))

;;;; soccs
;; { "stype":"socc",
;;   "name":"String",          //computed from ename,mods,loc
;;   "shortname":"String",     // computed from ename,mods,loc
;;   "ename":String,           // the entity name
;;   "mods":JArray[String],    // modification names
;;   "loc":String              // the location name
;; }
;; "mods" : [{"stype":"sitemod", "name":"phos!S473", "op":"phos", "site":"S473"}] 
;;   (update occ "uname"  (concat (apply jkbNext jkb) ""))
;;   (update occ "name" name)
;;   (update occ "shortname" (invoke jobj "get" "shortname"))
;;   (update occ "eref" eref)
;;   (update occ "modifiers" omods)
;;   (update occ "location" loc)

(define socc2json (obj)
  (let ((jobj (object ("java.util.HashMap")))
        (ename (lookup (lookup obj "eref") "name"))
        (mods (lookup obj "modifiers"))
        (loc (lookup (lookup obj "location") "name"))
        )
   (seq
     (invoke jobj "put" "stype" "socc")
     (invoke jobj "put" "name" (lookup obj "name"))
     (invoke jobj "put" "nid" (lookup obj "uname"))
     (invoke jobj "put" "shortname" (lookup obj "shortname"))
     (invoke jobj "put"  "ename" ename)
     (if (instanceof mods "java.util.ArrayList") 
         (invoke jobj "put" "mods" (apply omods2json mods)))
     (invoke jobj "put" "loc" loc)
     jobj ) ))


;;;; coccs
;; { "stype" :"cocc",
;;   "name" : "String",          //computed from component specs
;;   "shortname" : String,       //computed from component specs
;;   "components" : Components,
;;   "loc" : String                         
;; }
;;   (invoke occs "put" name occ)
;;   (update occ "uname"  (concat (apply jkbNext jkb) ""))
;;   (update occ "name" name)
;;   (update occ "shortname" (invoke jobj "get" "shortname"))
;;   (update occ "components" componentobjs)
;;   (update occ "location" loc)

(define cocc2json (obj)
  (let ((jobj (object ("java.util.HashMap")))
        (components (lookup obj "components"))
        (loc (lookup (lookup obj "location") "name"))
        )
   (seq
     (invoke jobj "put" "stype" "cocc")
     (invoke jobj "put" "name" (lookup obj "name"))
     (invoke jobj "put" "nid" (lookup obj "uname"))
     (invoke jobj "put" "shortname" (lookup obj "shortname"))
     (if (instanceof components "java.util.ArrayList") 
      (invoke jobj "put" "components" (apply occs2jmap components)))
     (invoke jobj "put" "loc" loc)
     jobj )))


(define occs2jmap (components)
  (let ((jmap (object ("java.util.HashMap"))))
    (seq
      (for obj components
        (if (instanceof obj "bp2pl.SimpleOccurrence")  
          (invoke jmap "put" (lookup obj "name") (apply socc2json obj)) 
        (if (instanceof obj "bp2pl.ComplexOccurrence")
          (invoke jmap "put" (lookup obj "name") (apply cocc2json obj)) 
        )))
       jmap
     )))

;;;; rules

;; A rule specification (RuleSpec) is an object with the following fields
;;  "stype" : "rule",
;;  "name" : String,  
;;  "shortname" : String,
;;  "consumed" : Participants,
;;  "produced" : Participants,
;;  "controls" : Participants,
;;  "description" : String,
;;  "evidence" : EvidenceSpec
;;  }
;;    (update rule "uname"  (concat (apply jkbNext jkb) ""))
;;    (update rule "name" name)
;;    (update rule "shortname" (invoke jobj "get" "shortname"))
;;    (update rule "consumed" consumed)
;;    (update rule "produced" produced)
;;    (update rule "controls" controls)
;;    (setAttr rule "evidence" (invoke jobj "get" "evidence"))
;;    (setAttr rule "description" (invoke jobj "get" "description"))

;; ofun is (lambda (objs) (apply objs2vals objs "name")) 
;;   for participants as arraylists of occnames
;; ofun is occs2jmap for participants as occspec map
(define rule2json (obj ofun)
  (let ((jobj (object ("java.util.HashMap")))
        (consumed (apply ofun (lookup obj "consumed")))
        (produced (apply ofun (lookup obj "produced")))
        (controls (apply ofun (lookup obj "controls")))
        (evidence (getAttr obj "evidence"))               
        (description (getAttr obj "description"))
        )
   (seq
     (invoke jobj "put" "stype" "rule")
     (invoke jobj "put" "name" (lookup obj "name"))
     (invoke jobj "put" "nid" (lookup obj "uname"))
     (invoke jobj "put" "shortname" (lookup obj "shortname"))
     (invoke jobj "put"  "consumed" consumed)
     (invoke jobj "put"  "produced" produced)
     (invoke jobj "put"  "controls" controls)
     (if (instanceof evidence "java.util.Map") 
         (invoke jobj "put"  "evidence" evidence))
     (if (instanceof description "java.lang.String") 
         (invoke jobj "put" "description" description))
     jobj ) ))

(define test ()
(seq
;; assume json loaded

(apply loc2json (invoke locmap "get" "CLo"))
(apply mod2json (invoke modmap "get" "Yphos"))
(apply mod2json (invoke modmap "get" "phos!T507"))

(apply sref2json (invoke erefmap "get" "Egf"))
(apply sref2json (invoke erefmap "get" "2DOG"))
(apply gref2json (invoke erefmap "get" "Erks"))
(apply cref2json (invoke erefmap "get" "Pi3k"))

(sinvoke "org.json.simple.JSONValue" "toJSONString" (apply loc2json (invoke locmap "get" "CLo")))

(sinvoke "org.json.simple.JSONValue" "toJSONString" (apply sref2json (invoke erefmap "get" "Egf")))

;; export locs


(define locjarr (apply vals2jarr (invoke locmap "values") loc2json "name"))

(sinvoke "g2d.util.IO" "collection2File" locjarr "XJSON/locs.json" (object null)          (boolean false) )

(apply socc2json (invoke occmap "get" "Egf@XOut"))
(apply socc2json (invoke occmap "get" "Akt1-phos!S473@CLc"))
(apply cocc2json (invoke occmap "get" "Cd40:Cd40lg@Cd40C"))


;; ofun is (lambda (objs) (apply objs2vals objs "name")) 
;;   for participants as arraylists of occnames
;; ofun is occs2jmap for participants as occspec map
(apply rule2json (invoke rulemap "get" "001.EgfR.irt.Egf") occs2jmap)
(apply rule2json (invoke rulemap "get" "001.EgfR.irt.Egf") (lambda (objs) (apply objs2vals objs "name")) )


(define ulocs (apply usedLocs jkb))
(define umods (apply usedMods jkb))
(define uents (apply usedErefs jkb))

))
