
(define getSTMSimpleInfoFun (eref)
  (if (instanceof eref "bp2pl.SimpleReference")
    (let ((esort (lookup eref "sort")) ) 
      (if (= esort bp2pl.EntityReference.PROT ) mkProteinInfo
      (if (= esort bp2pl.EntityReference.CHEM ) mkChemicalInfo 
      (if (= esort bp2pl.EntityReference.DNA) mkGeneInfo 
      (if (= esort bp2pl.EntityReference.RNA ) mkRNAInfo 
      (if (= esort bp2pl.EntityReference.SIGNATURE ) mkSignatureInfo 
      (if (= esort bp2pl.EntityReference.CELL ) mkCellInfo 
          (object null) )))))) )
   (if (instanceof eref "bp2pl.GenericReference") mkGenericInfo 
   (if (instanceof eref "bp2pl.CompositeReference") mkCompositeInfo
       (object null)))
  ))


(define mkProteinInfo  (eref name mods strb)
  (let ((xref (lookup eref "xref"))
        (id (if (instanceof xref "java.util.Map")
                (invoke xref "get" "id") 
                (object null)))
        (synonyms (lookup eref "synonyms"))
        (metadata (getAttr eref "metadata"))
        (hugosym (if (instanceof metadata "java.util.Map") 
                     (invoke metadata "get" "hugosym") 
                      (object null)))
        )
    (seq
 ;;    (invoke strb "append" "<ul>")
     (invoke strb "append" (concat "Name: " name))
     (if (not (isnull id))
       (invoke strb "append" (concat "<p>Uniprot: " (apply mkUniprotLink id) "</p>")))
     (if (not (isnull hugosym))
       (invoke strb "append" (concat "<p>HUGO: " (apply mkHUGOLink hugosym) "</p>")))
     (if (instanceof synonyms "java.util.ArrayList")
        (if (> (invoke synonyms "size") (int 0))
          (apply addItems "Synonyms" synonyms strb) ))
     (if (instanceof mods "java.util.ArrayList")
        (apply addItems "Modifications" mods strb) )
;;     (invoke strb "append" "</ul>")  
   ) ))

(define mkUniprotLink (id)
  (concat "<a href=\"http://www.uniprot.org/uniprot/" id "\">"  id "</a>"))

(define mkHUGOLink (hugosym)
  (concat "<a href=\"http://www.genecards.org/cgi-bin/carddisp.pl?gene=" hugosym "\"> "  hugosym " </a>"))

(define mkChemicalInfo  (eref name mods strb)
  (invoke strb "append" (concat "Chemical: " name ))
)

(define mkGeneInfo  (eref name mods strb)
  (invoke strb "append" (concat "Gene: " name ))
)

(define mkRNAInfo  (eref name mods strb)
  (invoke strb "append" (concat "RNA: " name ))
)

(define mkSignatureInfo  (eref name mods strb)
  (invoke strb "append" (concat "Signature: " name ))
)

(define mkCellInfo  (eref name mods strb)
  (invoke strb "append" (concat "Cell: " name ))
)


(define mkGenericInfo  (eref name mods strb)
  (let ((members (lookup eref "members"))
        (names (if (instanceof members "java.util.ArrayList")
                  (if (> (invoke members "size") (int 0))
                    (apply objs2vals members "name")
                    (object null)) (object null))) )      
   (apply mkMultiInfo eref name "Members" members mods strb)
))

(define mkCompositeInfo  (eref name mods strb)
  (let ((subunits (lookup eref "subunits"))
        (names (if (instanceof subunits "java.util.ArrayList")
                  (if (> (invoke subunits "size") (int 0))
                    (apply objs2vals subunits "name")
                    (object null)) (object null))) )      
   (apply mkMultiInfo eref name "Subunits" subunits mods strb)
))


(define mkMultiInfo  (eref name tag names mods strb)
  (seq
;;     (invoke strb "append" "<ul>")
     (invoke strb "append" (concat "<p>Name: " name "</p>"))
     (if (instanceof names "java.util.ArrayList")
        (apply addItems tag names strb) )
     (if (instanceof mods "java.util.ArrayList")
        (apply addItems "Modifications" mods strb) )
;;     (invoke strb "append" "</ul>")  
   ) ))

;;  {"stype" : "evspec", "evtype" : "datum", 
;; "val" : "/Egf-Evidence/EgfR.irt.Egf.001.html" }
;; evtype in  {"datum","pubmed","other"}
