;;;;;;;;;; /Users/iam/Repositories/IOP++/PLA4/Package/PLALib/g2dlib.lsp autogenerated on  Mon Feb 25 09:37:47 2019 ;;;;;;;;;;
(define logDev (msg) 
  (if g2d.pla.PLA.developmental
      (invoke java.lang.System.err "println" msg))
  )

(supdate "g2d.pla.PLA" "developmental" (boolean true))

(supdate "g2d.pla.PLA" "subgraphs" (boolean true))


;;;;;;;;;; ../Tools/makeg2dlib loaded ../JLibraries/graphviz.lsp ;;;;;;;;;;
;;new in November 2013 (for use in NPA and CTA too)
;;please keep this file in synch with the one in IOP
;;enforce a reasonably recent dot

(define dot_required_version (int 2))
(define dot_required_major (int 30))
(define dot_required_minor (int 0))

(define showDotPopup ()
  (let (
        (url "http://light.csl.sri.com/plaonline/graphviz.html")
        (preferred (object ("java.awt.Dimension" (int 500) (int 300))))
        (popup (object ("g2d.swing.HTMLPopup" "Graphviz Needed"  url preferred)))
        )
    (invoke popup "display")
    )
  )

(define checkGraphviz  ()
  (let (
        (version  g2d.graph.Dot.VERSION)
        )
    (if (isnull version)
        (seq 
         (invoke java.lang.System.err "println" (concat "\n\nChecking dot: NO VERSION FOUND\n\n"))
         (apply showDotPopup)
         (throw (object ("java.lang.RuntimeException" "You need to install graphviz")))
         )
      (invoke java.lang.System.err "println" (concat "\n\nChecking dot: found version " version "\n\n"))
      )

    (let (
          (version_no  (lookup version "version"))
          (version_major  (lookup version "major"))
          (version_minor  (lookup version "minor"))
          )
      (if (or (< version_no dot_required_version)
              (and (= version_no dot_required_version) 
                   (< version_major dot_required_major))
              (and (= version_no dot_required_version) 
                   (= version_major dot_required_major)
                   (< version_minor dot_required_minor)))
          (seq 
           (apply showDotPopup)
           (throw (object ("java.lang.RuntimeException" (concat "Your dot version: " version " is too old"))))
           )
        )
      )
    )
  )


        


(if  (and (not (sinvoke "g2d.Main" "isRemote")) (not (sinvoke "g2d.Main" "isGadget")))
    (apply checkGraphviz))




;;;;;;;;;; ../Tools/makeg2dlib loaded ../JLibraries/console.lsp ;;;;;;;;;;
;; ilk is the name of the parent application, it is used for the preferences
(define makeConsoleMenu  (ilk)
  (let (
        (menu (object ("javax.swing.JMenu" "Help")))
        (console (object ("javax.swing.JMenuItem" "JLambda Console")))
	(cwd (invoke (object ("java.io.File" "")) "getAbsoluteFile"))
        (closure (lambda (self e) (sinvoke "g2d.console.Console" "launch" "Console" ilk cwd)))
        (listener (object ("g2d.closure.ClosureActionListener" closure)))
        )
    (invoke console "addActionListener" listener)
    (invoke menu "add" console)
    menu
    )
  )

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/util.lsp ;;;;;;;;;;
;; nothing to see here. delete whenever


;; 3/6/17 called selectArrl in jl-util
;; collection (array, list, ...) to list of selected elements
;;(define select (col selectorC)
;;  (let ((list (object ("java.util.ArrayList"))))
;;   (seq
;;    (for elt col (if (apply selectorC elt) (invoke list "add" elt) ))
;;    list
;;   ))
;;)


;;(define lsubset (list0 list1 size ix)
;;  (if (> size ix)
;;    (if (invoke list1 "contains" (invoke list0 "get" ix))
;;     (apply lsubset list0 list1 size (+ ix (int 1)))   
;;     (boolean false))
;;   (boolean true)
;;  )
;;)

;;(define ljoin (list1 list0 size ix)
;;  (if (> size ix)
;;    (seq
;;      (if (invoke list1 "contains" (invoke list0 "get" ix))
;;        (boolean false)
;;        (invoke list1 "add" (invoke list0 "get" ix))
;;      )
;;     (apply ljoin list1 list0 size (+ ix (int 1)))   
;;     ) ; seq
;;   list1
;;   ) ; if
;;)

;;(define ldiff (list1 list0 size ix)
;; (if (> size ix)
;;    (seq
;;       (invoke list1 "remove" (invoke list0 "get" ix))
;;       (apply ldiff list1 list0 size (+ ix (int 1)))   
;;     )
;;  list1) 
;;)

;; return the accumulation
;;(define map (col mfun accum) (seq (for elt col (apply mfun elt accum)) accum))


;; delete without side effect
;;(define ldelete (list obj)
;;  (let ((l (invoke list "clone"))) (seq  (invoke l "remove" obj) l))
;;)

; itemPrinter is a printer for the collection item type
;  (apply itemPrinter elt strbuffer) should append print string to passed buffer
;;(define printCol (col itemPrinter)
;;  (let ((strb (object ("java.lang.StringBuffer"))) )
;;    (seq
;;      (for item col (apply itemPrinter item strb))
;;       (invoke strb "toString")
;;     )
;;  )
;;)

;;(define printArr (arr)(apply printCol arr 
;;    (lambda (elt strb) (invoke strb "append" (concat elt " ")))))


;;(define listOccs (gname fname chatty?)
;;  (let ((graph (fetch gname))
;;        (onodes (apply select (invoke graph "getNodesInArray") 
;;                       (lambda (node) (= (getAttr node "type") "occ"))))
;;        (pfun (lambda (node) 
;;                (getAttr node (if chatty?  "chattylabel" "label")))) 
;;    )
;;  (sinvoke "g2d.util.IO" "collection2File" onodes fname pfun (boolean false) )
;; )
;;)



;; iam: util.lsp looks pretty small compared to jl-util.lsp
;;(apply logDev "\nFIXME: check that jl-util.lsp and util are nice to each other, or one replaces.\n")
;;;;;;;;;; ../Tools/makeg2dlib loaded ../../imaude/jlib/jl-util.lsp ;;;;;;;;;;
;; jl-util.lsp


(define print2err (str) (invoke java.lang.System.err "println" str))

;; [iam 3/7/2017: migrated from util.lsp] return the accumulation
(define map (col mfun accum) (seq (for elt col (apply mfun elt accum)) accum))


;; [iam 3/7/2017: migrated from util.lsp] delete without side effect
(define ldelete (list obj)
  (let ((l (invoke list "clone"))) (seq  (invoke l "remove" obj) l))
)

;; [iam 3/7/2017: migrated from util.lsp] itemPrinter is a printer for the collection item type
;;  (apply itemPrinter elt strbuffer) should append print string to passed buffer
(define printCol (col itemPrinter)
  (let ((strb (object ("java.lang.StringBuffer"))) )
    (seq
      (for item col (apply itemPrinter item strb))
       (invoke strb "toString")
     )
  )
)

;;[iam 3/7/2017: migrated from util.lsp]
(define printArr (arr)(apply printCol arr 
    (lambda (elt strb) (invoke strb "append" (concat elt " ")))))



(define canonical_path (str)
  (let ((str0 (sinvoke "g2d.util.IO" "interpretTilde" str))
	(file0 (object ("java.io.File" str0)))
	(str1 (invoke file0 "getCanonicalPath")))
    str1
    )
  )
  
;;;(invoke br "readLine")
(define getBufferedReader (fname)
 (let ((fnameX (sinvoke "g2d.util.IO" "interpretTilde" fname))
       (file (object ("java.io.File" fnameX)))
      )
   (if (invoke file "exists")
     (object ("java.io.BufferedReader" 
		            (object ("java.io.FileReader" file)) ))
     (object null))
	 ))

(define readTilEnd (br fun) 
  (let ((line (invoke br "readLine"))) 
    (if (isobject line) 
      (seq (apply fun line) (apply readTilEnd br fun)) 
      (boolean true)) ))
     

(define getPrintWriter (fname append?)
 (let ((fnameX (sinvoke "g2d.util.IO" "interpretTilde" fname))
       (fwriter (object ("java.io.FileWriter" fnameX append?)))
      )
    (object ("java.io.PrintWriter" fwriter (boolean true)))
	 ))

(define fileExists (fname)
  (let ((fnameX (sinvoke "g2d.util.IO" "interpretTilde" fname))
        (file (object ("java.io.File" fnameX))) )
    (invoke file "exists")
  ))

;; returns false if dname exists and is not a directory
;; returns true if is already directory or directory is created
(define assureDir (dname)
  (let ((dnameX (sinvoke "g2d.util.IO" "interpretTilde" dname))
        (file (object ("java.io.File" dnameX))) )
   (if (invoke file "exists")
	    (invoke file "isDirectory")
			(invoke file "mkdirs")
  )))

;;;;;;;;;;;  json I/)
;;; reading json
;; returns json java object parsed from fname
;; returns null if file does not exist
(define readJSonF (fname)
  (let ((fnameX (sinvoke "g2d.util.IO" "interpretTilde" fname))
        (file (object ("java.io.File" fnameX)))
        (reader (if (invoke file "exists")
                    (object ("java.io.FileReader" fnameX))
                    (object null)))
        )
   (if (isnull reader)
       (seq (invoke java.lang.System.err "println"  "no reader") (object null) )
       (sinvoke "org.json.simple.JSONValue" "parseWithException" reader)
  )))


;;;; saving as json -- pretty
(define initGsonPretty ()
 (let ((ioplib (sinvoke "g2d.util.IO" "interpretTilde"
                       "~/Repositories/IOP++/lib"))
      (dummy (load (concat ioplib "/gson.jar")))
      (gsonbuilder (invoke (object ("com.google.gson.GsonBuilder")) 
			                     "setPrettyPrinting"))
     )     													 
   (invoke gsonbuilder "create")))

(define prettyJson2File (gson jthing fname)
  (let ((pretty (invoke gson "toJson" jthing)))
   (sinvoke "g2d.util.IO" "string2File" pretty fname)
 ))


(define prArr (arr) (sinvoke "java.util.Arrays" "toString" arr))


(define removeLast (str n)
 (invoke str "substring" (int 0) (- (invoke str "length") n))  
)
;; len 5 n 1 substr 0,4 chars upto but not including 4

;; replace by delete method
(define removeSBLast (strb n) (apply removeLast (invoke strb "toString") n))


(define ensureList (elt)
  (if (instanceof elt "java.util.List") elt (apply mkMt)))

(define ensureString (elt)
  (if (instanceof elt "java.lang.String") elt ""))

(define mkMtSet () (object ("java.util.HashSet")))
(define mkMtMap () (object ("java.util.HashMap")))
(define mkMt () (object ("java.util.ArrayList")))

;;; safe dget
(define dgetS (obj tag default)
  (if (instanceof obj "java.util.Map")
	  (let ((val (invoke obj "get" tag)))
		  (if (isobject val) val default) )
    default	))

(define dget (obj tag default)
  (let ((val (invoke obj "get" tag)))
    (if (isobject val) val default)  ))

(define mkSingle (x)
  (let ((res (object ("java.util.ArrayList"))))
    (invoke res "add" x)
    res ))

(define mkPair (x y)
  (let ((res (object ("java.util.ArrayList"))))
    (invoke res "add" x)
    (invoke res "add" y)
    res ))

(define mkTriple (x y z)
  (let ((res (object ("java.util.ArrayList"))))
    (invoke res "add" x)
    (invoke res "add" y)
    (invoke res "add" z)
    res ))

(define mkQuad (x y z w)
  (let ((res (object ("java.util.ArrayList"))))
    (invoke res "add" x)
    (invoke res "add" y)
    (invoke res "add" z)
    (invoke res "add" w)
    res ))

(define mkFive (x0 x1 x2 x3 x4)
 (let ((res (apply mkMt)))
   (invoke res "add" x0)	
   (invoke res "add" x1)	
   (invoke res "add" x2)	
   (invoke res "add" x3)	
   (invoke res "add" x4)	
	res
	))

(define mkSix (x0 x1 x2 x3 x4 x5)
 (let ((res (apply mkMt)))
   (invoke res "add" x0)	
   (invoke res "add" x1)	
   (invoke res "add" x2)	
   (invoke res "add" x3)	
   (invoke res "add" x4)	
   (invoke res "add" x5)	
	res
	))

(define mkMap1 (key val)
  (let ((res (apply mkMtMap)))
	  (invoke res "put" key val)
		res	))

(define mkMap2 (key0 val0 key1 val1)
  (let ((res (apply mkMap1 key0 val0)))
	  (invoke res "put" key1 val1)
		res	))

;; a list of numerals from start to (not including) end
(define enum (start end) (let ((res (apply mkMt))) (apply enumX res start end)))

(define enumX (res cur end)
 (if (>= cur end) 
   res 
   (seq 
    (invoke res "add" (concat cur "")) 
    (apply enumX res (+ cur (int 1)) end)) 
  ))


;; objs is a collection of maps  
(define getByName (objs str)
  (apply getByNameX objs str (invoke objs "size") (int 0)))    

(define getByNameX (objs str len cur)
  (if (>= cur len)
    (object null)
    (let ((obj (invoke objs "get" cur)))
      (if (= (invoke obj  "get" "name") str)
      obj
      (apply getByNameX objs str len (+ cur (int 1)))
      ))
))


;;; 1 if nstr0 > nstr1  (as integers)
;;; -1 if nstr0 < nstr1  (as integers)
;;; 0 if nstr0 = nstr1 
(define numeralCompare (nstr0 nstr1)
 (if (= nstr0 nstr1) 
   (int 0)
  (if (> (sinvoke "java.lang.Integer" "parseInt" nstr0)
         (sinvoke "java.lang.Integer" "parseInt" nstr1))
	  (int 1)
	  (int -1)
	 ))
  )
	

;; test for array -- instanceof doesn't work for arrays
(define isArray (obj) (invoke (invoke obj "getClass") "isArray"))

(define isInt (str) 
  (try 
    (sinvoke "java.lang.Integer" "parseInt" str) 
    (boolean true) 
  (catch x (boolean false)) ))

(define isDouble (str) 
  (try 
    (sinvoke "java.lang.Double" "parseDouble" str) 
    (boolean true) 
  (catch x (boolean false)) ))

(define tryDouble (str fail) 
  (try 
    (sinvoke "java.lang.Double" "parseDouble" str) 
  (catch x fail) ))

(define tryInt (str fail) 
  (try 
    (sinvoke "java.lang.Integer" "parseInt" str) 
  (catch x fail) ))


(let ((patternstring "-??\\d+")
      (pattern (sinvoke "java.util.regex.Pattern" "compile" patternstring)))
  (define isint (query)
    (let ((matcher (invoke pattern "matcher" query)))
    (if (invoke matcher "matches")
	(boolean true)
      (boolean false)))))

(define subarrl (arrl start end) 
  (let ((res (apply mkMt)))
    (for ix end (if (>= ix start)
    (invoke res "add" (invoke arrl "get" ix)))) res ))


(define subarray (arrl ixs)
  (let ((sarrl (object ("java.util.ArrayList"))))
   (for ix ixs (invoke sarrl "add" (invoke arrl "get" ix)))
   sarrl
))

;; works for any collection with a toArray method
(define sortArrl (arrl)
  (let ((arr (invoke arrl "toArray")))
    (sinvoke "java.util.Arrays" "sort" arr)
    (apply toArrl arr)
  ))

;; restrict hmap to keys
(define mapRestrict (map keys)
  (let ((hm (object ("java.util.HashMap"))))
   (for key keys 
     (let ((val (invoke map "get" key)))
       (if (isobject val) (invoke hm "put" key val))
       ))
  hm
  ))

;;; restrict range of map to scope
(define restrictmapi (map scope) 
(let ((res (apply mkMtMap)))
  (for key (invoke map "keySet")
	   (let ((vals (apply intersect (invoke map "get" key) scope)))
		   (if (> (invoke vals "size") (int 0)) (invoke res "put" key vals)) ))
  res ))


(define mapRng (map dom)
 (let ((res (apply mkMt)))
   (for elt dom (apply arrlUnion res (apply dget map elt (apply mkMt))))
 ))

;; assuming map partitions union of range lists,
;; this inverts the map
(define mapLInv (map) 
  (let ((imap (apply mkMtMap))) 
	  (for key (invoke map "keySet") 
		  (let ((vals (invoke map "get" key))) 
			  (for val vals (invoke imap "put" val key)) )) 
 	imap))

;; result is inverse image of each elememt in range
(define mapInvIm (map)
  (let ((imap (apply mkMtMap))) 
	  (for key (invoke map "keySet") 
		  (apply mapAdd imap (invoke map "get" key) key))
 	imap))

 (define mapInvImX (map keys)
   (let ((imap (apply mkMtMap))) 
 	  (for key keys
      (let ((val (invoke map "get" key)))
        (if (isobject val) (apply mapAdd imap val key))))
  	imap))


;; add elt to list associated to key
;; init with empty list if no association exists
(define mapAdd (map key elt)
  (let ((val0 (invoke map "get" key))
        (val (if (isobject val0) 
               val0
               (let ((val1 (object ("java.util.ArrayList"))))
                  (invoke map "put" key val1)
                  val1)))
        )
    (invoke val "add" elt)
))

;; add elt to list associated to key
;; init with empty list if no association exists
(define mapSetAdd (map key elt)
  (let ((val0 (invoke map "get" key))
        (val (if (isobject val0) 
               val0
               (let ((val1 (object ("java.util.ArrayList"))))
                  (invoke map "put" key val1)
                  val1)))
        )
    (apply setAdd val elt)
))

;; arg is map key -> <count>
;; result is [mxcount, keys]  keys have mxcount
(define maxCount (countMap)
  (let ((keys (invoke countMap "keySet"))
        (mx (array int (int 0)))    
        (elts (array java.lang.Object (apply mkMt)))    
        )
    (for key keys
      (let ((cnt (aget (invoke countMap "get" key) (int 0))))
        (if (= cnt (aget mx (int 0))) 
          (invoke (aget elts (int 0)) "add" key)
          (if (> cnt (aget mx (int 0)))
            (seq (aset mx (int 0) cnt) 
                 (aset elts (int 0) (apply mkSingle key)) )
       )) ))  
  (apply mkPair (concat (aget mx (int 0)) "") (aget elts (int 0)))
  ))

;; increments count of elt in map
(define mapIncCount (map elt) 
  (let ((cnt0 (invoke map "get" elt)) 
        (cnt (if (isnull cnt0) (array int (int 0)) cnt0)) ) 
    (if (isnull cnt0) (invoke map "put" elt cnt))
    (aset cnt (int 0) (+ (aget cnt (int 0)) (int 1)))  ))

;; assume maps from symbols to arrlists
;; map0 will be updated
(define mapJoin (map0 map1)
 (for key (invoke map1 "keySet")
   (let ((vals (invoke map1 "get" key))) 
	   (if (> (invoke vals "size") (int 0))(apply mapJoinX map0 key vals))
	 )))

(define mapJoinX (map key newvals)
  (let ((val0 (invoke map "get" key))
        (val (if (isobject val0) 
               val0
               (let ((val1 (object ("java.util.ArrayList"))))
                  (invoke map "put" key val1)
                  val1)))
        )
    (apply arrlUnion val newvals)
		(boolean true)
))
	

(define mapget (map key default)
  (let ((v0 (invoke map "get" key)))
   (if (isobject v0)
	   v0
     (seq (invoke map "put" key default) default)
		 )
	))



;; print to std err elements selected by pfun using ofun
(define printlnArrP (arrl pfun ofun)
  (for elt arrl
     (if (apply pfun elt) 
        (invoke java.lang.System.err "println" (apply ofun elt)))
 ))

(define toArrl (col)
  (let ((arrl (object ("java.util.ArrayList"))))
    (for elt col (invoke arrl "add" elt))
    arrl
))

;; an arraylist of strings to a string array
(define arrlStr2arr (arrl) 
  (let ((len (invoke arrl "size"))
	      (arr (mkarray java.lang.String len)))
    (for ix len (aset arr ix (invoke arrl "get" ix)))				
    arr ))

(define intArr2arrl (arr)(apply mapArrl arr (lambda (elt) (concat elt ""))))

(define selectArrl (arrl pfun)
  (let ((sarrl (object ("java.util.ArrayList"))))
    (for elt arrl (if (apply pfun elt) (invoke sarrl "add" elt)))
    sarrl
 ))

;;; list of keys st fun(map[key]) is true
(define mapSelect (map fun)
 (let ((res (apply mkMt)))
   (for key (invoke map "keySet")
	   (if (apply fun (invoke map "get" key)) (invoke res "add" key)))
	 res ))


(define andArrl (arrl pfun) 
  (try (for elt arrl 
    (if (not (apply pfun elt)) 
      (throw (object ("java.lang.Throwable"))) )) 
    (boolean true)
    (catch x (boolean false)) ))

(define orArrl (arrl pfun) 
  (try (for elt arrl 
    (if (apply pfun elt)
      (throw (object ("java.lang.Throwable"))) )) 
    (boolean false)
    (catch x (boolean true)) ))

(define mapArrl (arrl mfun)
  (let ((marrl (object ("java.util.ArrayList"))))
    (for elt arrl (invoke marrl "add" (apply mfun elt)))
    marrl
 ))

(define mapArrlSet (arrl mfun)
  (let ((marrl (object ("java.util.HashSet"))))
    (for elt arrl
      (let ((res (apply mfun elt)))
        (if (isobject res) (invoke marrl "add" res))))
    (apply toArrl marrl)
 ))

(define mapArrlSetS (arrl mfun)(let ((marrl (object ("java.util.HashSet"))))   (for elt arrl (let ((res (apply mfun elt)))(if (isobject res) (invoke marrl "addAll" res)))) marrl))

	;; form set union of map(sym) for sym in syms
	(define mapRngUnion (syms map)   
	  (let ((res (apply mkMtSet)))
	    (for sym syms 
			  (let ((vals (invoke map "get" sym)))
				  (if (isobject vals) (invoke res "addAll" vals))) )
	   (apply toArrl res)
		))

(define mapMap (map fun) 
  (let ((res (apply mkMtMap)))
   (for key (invoke map "keySet") 
    (invoke res "put" key (apply fun (invoke map "get" key))) ) res))

;; elements of col0 that are not in col1
(define diff (col0 col1)
 (let ((res (apply mkMt)))
   (for elt col0 
     (if (not (invoke col1 "contains" elt)) (invoke res "add" elt) ))
   res
 ))


(define intersect (a0 a1) (apply diff a0 (apply diff a0 a1)))

(define intersectArr (arr arrl) 
  (let ((res (apply mkMt))) 
	  (for elt arr 
		 (if (invoke arrl "contains" elt) (invoke res "add" elt))) 
  	res ))

(define intersects (a0 a1) (apply intersectsX a0 a1 (invoke a0 "size")(int 0)))
(define intersectsX (a0 a1 len cur)
  (if (>= cur len) 
    (boolean false)
    (if (invoke a1 "contains" (invoke a0 "get" cur))
      (boolean true)
      (apply intersectsX a0 a1 len (+ cur (int 1)))
    ) ))

;; does arrl1 contain every element of arrl0?
(define containsAll (arrl0 arrl1)
  (invoke arrl0 "containsAll" arrl1)
;; (apply containsAllX arrl0 arrl1 (invoke arrl0 "size") (int 0))
)

(define sameArrl (arrl0 arrl1)
  (and (invoke arrl0 "containsAll" arrl1)
       (invoke arrl1 "containsAll" arrl0)) )
			
(define containsAllX (arrl0 arrl1 len cur)
 (if (>= cur len)
   (boolean true)
   (if (invoke arrl1 "contains" (invoke arrl0 "get" cur))
	   (apply containsAllX arrl0 arrl1 len (+ cur (int 1)))
	   (boolean false)
	 )))

;; add elements of arrl1 to arrl0 if not there already
;; modifies arrl0
;; same result as arrUnion
(define uniAdd (arrl0 arrl1 len cur)
  (if (>= cur len)
      arrl0
      (let ((elt (invoke arrl1 "get" cur)))
        (if (not (invoke arrl0 "contains" elt)) (invoke arrl0 "add" elt))
        (apply uniAdd arrl0 arrl1 len (+ cur (int 1)))
      )
  ))
  
;; as uniAdd but not modifying arrl0	
  (define arrlSetAdd (arrl0 arrl1)
    (let ((arrl (object ("java.util.ArrayList"))))
      (invoke arrl "addAll" arrl0)
      (for elt arrl1 
           (if (not (invoke arrl0 "contains" elt)) (invoke arrl "add" elt)))
      arrl
  ))

(define setAdd (arrl elt)
  (if (not (invoke arrl "contains" elt)) (invoke arrl "add" elt))
  arrl
)

;; table is collecting values for key
(define add2tab (tab key val)
  (let ((v0 (invoke tab "get" key))
	      (v (if (isobject v0) 
				     v0 
      			 (let ((v1 (apply mkMt)))(invoke tab "put" key v1) v1)))
       	)
        (apply setAdd v  val)
	))
	
;; same fn as uniAdd
(define arrlUnion (arrl elts)
  (for elt elts (apply setAdd arrl elt))
  arrl
)
;; ptwise equality of arrays (not arraylists)
(define arrEq (arr0 arr1)
  (let ((len0 (lookup arr0 "length"))
        (len1 (lookup arr1 "length")))
  (if (= len0 len1)				
    (apply arrEqX arr0 arr1 len0 (int 0))
		(boolean false)
		)))
		
(define arrEqX (arr0 arr1 len cur)
  (if (>= cur len)
	  (boolean true)
		(if (= (aget arr0 cur) (aget arr1 cur))
		  (apply arrEqX arr0 arr1 len (+ cur (int 1)))
			(boolean false)
		)) )		


(define str2arrl (str) (apply mkSingle str))

(define split2arrl (elt chr) (apply toArrl (invoke elt "split" chr)))

(define slash2arrl (singleton) 
  (if (instanceof singleton "java.util.List")
   (if (> (invoke singleton "size") (int 0))
       (apply split2arrl (invoke singleton "get" (int 0) "/"))
       (object ("java.util.ArrayList"))
   )))
    
(define arrl2str (arrl sep)
 (if (isnull arrl) ""
  (let ((len (invoke arrl "size"))
        (strb (object ("java.lang.StringBuffer"))) )
   (if (= len (int 0)) ""
     (seq
       (invoke strb "append" (concat (invoke arrl "get" (int 0)) ""))
       (do ((cur (int 1) (+ cur (int 1))))
           ((>= cur len) (invoke strb "toString"))
           (invoke strb "append" (concat sep (invoke arrl "get" cur)))          
        ) ;;od
      ) ) 
  )))
  
(define titleCase (str)
  (let ((tail (invoke str "substring" (int 1) (invoke str "length")) )
        (head (invoke str "substring" (int 0) (int 1)))
       )
   (concat (invoke head "toUpperCase") 
           (invoke tail "toLowerCase")) 
  ))
  

(define lbrace "{")(define rbrace "}")
(define lbracket "[")(define rbracket "]")
(define lparen "(")(define rparen ")")
(define lp "(")(define rp ")")
(define lcurly "{") (define rcurly "}")
(define lsq "[") (define rsq "]")

;;;;;;;;;; reading/writing arrls/tables/rows ....

(define saveArrl (arrl fname)(sinvoke "g2d.util.IO" "collection2File" arrl fname (object null) (boolean false)))

(define loadArrl (fname) (let ((arrl (object ("java.util.ArrayList")))) (sinvoke "g2d.util.IO" "file2Collection" arrl fname (object null)(boolean true)) arrl))



(define unsplit (row sep)
  (if (apply isArray row) 
    (apply unsplitArr row sep)
    (apply unsplitArrl row sep)
 ))

(define unsplitArr (row sep)
 (let ((strb (object ("java.lang.StringBuffer")))
       (len (lookup row "length")) )
  (invoke strb "append" (aget row (int 0)))
	(for ix len 
    (if (> ix (int 0))
	    (invoke strb "append" (concat sep (aget row ix)) ) ))
	(invoke strb "toString")
 ))

(define unsplitArrl (row sep)
 (let ((strb (object ("java.lang.StringBuffer")))
       (len (invoke row "size")) )
  (invoke strb "append" (invoke row "get" (int 0)))
	(for ix len (if (> ix (int 0))
	  (invoke strb "append" (concat sep  (invoke row "get" ix))	)))
	(invoke strb "toString")
 ))
 
(define saveAsCSV (rows fname)(sinvoke "g2d.util.IO" "collection2File" rows fname (lambda (row) (apply unsplit row ","))   (boolean false)))

(define saveAs (rows fname sep)(sinvoke "g2d.util.IO" "collection2File" rows fname (lambda (row) (apply unsplit row sep))   (boolean false)))


(define loadFile (fname fun)
  (let ((arrl (object ("java.util.ArrayList"))))
   (sinvoke "g2d.util.IO" "file2Collection"
	            arrl fname fun (boolean true))
    arrl
))

(define loadCSV (fname)
 (apply loadFile fname
    (lambda (str) (apply toArrl (invoke str "split" ",")))))
		
(define loadTab (fname)
 (apply loadFile fname
    (lambda (str) (apply toArrl (invoke str "split" "\\t")))))

;; load chr separated table into [... (rowarr ...)  ...]
(define loadTable (fname chr) 
  (let ((arrl (object ("java.util.ArrayList"))))
   (sinvoke "g2d.util.IO" "file2Collection" arrl fname 
      (lambda (line) (invoke line "split" chr)) (boolean true))
    arrl
))

;;; reading writing maps  
;;; -> rows key,val
;; (apply hmap2tab fname hm ",")
(define saveMap (hm fname)
  (let ((arrl (apply mkMt)))
    (for key (invoke hm "keySet") 
      (invoke arrl "add" (apply mkPair key (invoke hm "get" key))))
      
    (sinvoke "g2d.util.IO" "collection2File" arrl fname
        (lambda (row) (concat (invoke row "get" (int 0)) "," 
                              (invoke row "get" (int 1)) ))
        (boolean false))
    ))    

;; hmap to tab file
(define hmap2tab (fname hmap sep)
  (let ((arrl (object ("java.util.ArrayList")))
        (keys (invoke hmap "keySet")) )
    (for key keys 
       (invoke arrl "add" (concat key sep (invoke hmap "get" key))))
    (sinvoke "g2d.util.IO" "collection2File" arrl fname 
        (object null)(boolean false))
 ))

;; hmap to tab file
(define hmap2tabSorted (fname hmap sep)
  (let ((arrl (object ("java.util.ArrayList")))
        (keys (apply sortArrl (invoke hmap "keySet")) ))
    (for key keys 
       (invoke arrl "add" (concat key sep (invoke hmap "get" key))))
    (sinvoke "g2d.util.IO" "collection2File" arrl fname 
        (object null)(boolean false))
 ))

;;; assume table key,val
(define loadMap (fname)
  (let ((arrl (apply loadCSV fname))
        (hm (apply mkMtMap))
       )
   (for row arrl
     (invoke hm "put" (invoke row "get" (int 0))(invoke row "get" (int 1)))
   )        
  hm
  ))    

;;; assume table key,val -- or key,
(define loadMapD (fname default)
  (let ((arrl (apply loadCSV fname))
        (hm (apply mkMtMap))
       )
   (for row arrl
	   (let ((key (invoke row "get" (int 0)))
		       (val (if (> (invoke row "size") (int 1))
					        (invoke row "get" (int 1))
								  default))
					 )
     (invoke hm "put" key val)
		 ))        
  hm
  ))    

;;; assume table key,val  or key,
;;; full inverse val -> keylist
(define loadMapInvD (fname)
  (let ((arrl (apply loadCSV fname))
        (hm (apply mkMtMap)) )
   (for row arrl
	   (let ((key (invoke row "get" (int 0)))
		       (val (if (> (invoke row "size") (int 1))
					        (invoke row "get" (int 1))
								  key)) )
		 (apply add2tab hm val key)
   ))    
   hm
  ))

;;; val -> some key
(define loadMapInvDX (fname)
  (let ((arrl (apply loadCSV fname))
        (hm (apply mkMtMap)) )
   (for row arrl
	   (let ((key (invoke row "get" (int 0)))
		       (val (if (> (invoke row "size") (int 1))
					        (invoke row "get" (int 1))
								  key)) )
     (invoke hm "put"  val key)
   ))    
   hm
  ))


(define loadMapT (fname)
  (let ((arrl (apply loadTab fname))
        (hm (apply mkMtMap))
       )
   (for row arrl (if (> (invoke row "size") (int 1))
     (invoke hm "put" (invoke row "get" (int 0))(invoke row "get" (int 1)))
   ))        
  hm
  ))    

(define loadMapInvT (fname)
  (let ((arrl (apply loadTab fname))
        (hm (apply mkMtMap))
       )
   (for row arrl (if (> (invoke row "size") (int 1))
     (invoke hm "put" (invoke row "get" (int 1))(invoke row "get" (int 0)))
   ))        
  hm
  ))    

;;; assume table key,val
(define loadMapInv (fname)
  (let ((arrl (apply loadCSV fname))
        (hm (apply mkMtMap))
       )
   (for row arrl
     (invoke hm "put" (invoke row "get" (int 1))(invoke row "get" (int 0)))
   )        
  hm
  ))    


;; convert table to map from col i to col j
(define tarrl2map (tarrl i j)
  (let ((hm (object ("java.util.HashMap")))
        (len (sinvoke "java.lang.Math" "max" i j))
        )
    (for ta tarrl (if (> (lookup ta "length") len)
                    (invoke hm "put" (aget ta i) (aget ta j))))
   hm))

;; write map of keys to string arrl 
;; key sep elt0 ... sep eltn-1
(define saveMap2Arrl (fname hmap sep)
  (apply saveMap2ArrlX fname hmap sep (boolean false)))

(define saveMap2ArrlX (fname hmap sep append?)
  (let ((arrl (apply mkMt))
        (keys (invoke hmap "keySet")) )
    (for key keys 
       (let ((strb (object ("java.lang.StringBuffer")))
             (vals (invoke hmap "get" key))
            )
         (invoke strb "append" key)
         (for val vals (invoke strb "append" (concat sep val)))
         (invoke arrl "add" (invoke strb "toString"))
         ))
    (sinvoke "g2d.util.IO" "collection2File" arrl fname 
        (object null) append?)
 ))

;; write map of keys to string arrl 
;; key sep elt0 ... sep eltn-1
(define saveMap2ArrlSorted (fname hmap sep)
  (apply saveMap2ArrlSortedX fname hmap sep (boolean false)))

(define saveMap2ArrlSortedX (fname hmap sep append?)
  (let ((arrl (apply mkMt))
        (keys (apply sortArrl (invoke hmap "keySet"))) )
      (for key keys 
       (let ((strb (object ("java.lang.StringBuffer")))
             (vals (invoke hmap "get" key))
            )
         (invoke strb "append" key)
         (for val vals (invoke strb "append" (concat sep val)))
         (invoke arrl "add" (invoke strb "toString"))
         ))
    (sinvoke "g2d.util.IO" "collection2File" arrl fname 
        (object null) append?)
 ))
 
 

 ;; write map of keys to string arrl using cnv map if not null and sorting rng
 ;; key sep elt0 ... sep eltn-1
 (define saveMap2ArrlSortedC (fname hmap sep cnv append?)
   (let ((pr (apply getPrintWriter fname append?))
         (keys (apply sortArrl (invoke hmap "keySet"))) )
      (for key keys 
        (let ((strb (object ("java.lang.StringBuffer")))
              (vals0 (invoke hmap "get" key))
              (vals1 (if (isnull cnv) vals0 (apply mapArrl vals0 cnv)))
              (vals (apply sortArrl vals1))
             )
          (invoke strb "append" key)
          (for val vals
               (seq (invoke strb "append" sep) (invoke strb "append" val)))
          (invoke pr "println" (invoke strb "toString"))
          (invoke pr "println" "")
          ))
    (invoke pr "close")  ))

;; loads file written by saveMap2Arrl
(define loadMap2Arrl (fname sep)
  (let ((arrl (apply mkMt))
        (hmap (object ("java.util.HashMap")))
        (fun (lambda (line) 
               (let ((parts (invoke line "split" sep))
                     (key (aget parts (int 0)))
                     (len (lookup parts "length"))
                     (val (apply mkMt))
                    )
                 (for ix len (if (> ix (int 0))
                    (invoke val "add" (aget parts ix))) )
                 (invoke hmap "put" key val)
                 key
                )))
          )
   (sinvoke "g2d.util.IO" "file2Collection" arrl fname fun (boolean true))
   hmap
 ))

;; assume row of strings
(define rowProject (row ixarr len)
 (let ((strb (object ("java.lang.StringBuffer"))))
   (invoke strb "append" (invoke row "get" (aget ixarr (int 0))))
	 (for ix len 
	   (if (> ix (int 0))
      (seq
   	    (invoke strb "append" "\t")
   	    (invoke strb "append" (invoke row "get" (aget ixarr ix)))
   	  ) 
    )) ))

 
(define saveTabTab (fname rows ixarr)
  (let ((len (lookup ixarr "length")))
   (sinvoke "g2d.util.IO" "collection2File" rows fname 
	 (lambda (row) (apply rowProject row ixarr len)) (boolean false))))


;; get values of elements in harr according to hm
(define hs2us (hm harr) 
  (let ((uarrl (object ("java.util.ArrayList"))))
   (for hid harr (invoke uarrl "add" (invoke hm "get" hid)))
   uarrl))

(define one-one (hm)
 (let ((vals (invoke hm "values"))
       (vset (object ("java.util.HashSet" vals)))
        )
    (= (invoke vals "size") (invoke vset "size"))
))

(define findDuplicates (arrl)
  (let ((seen (apply mkMt))
	      (dups (apply mkMt))
       	)
   (for elt arrl 
	   (if (invoke seen "contains" elt)
	     (invoke dups "add" elt)
   	   (invoke seen "add" elt)
	  ))
		dups				
	))
		
;; extract name conversion map from table tab with cols mix cix
(define tabNameCnv (tab mix cix)
 (let ((map (apply mkMtMap)))
   (for row (invoke tab "subList" (int 1) (invoke tab "size"))
	   (let ((mname (invoke row "get" mix)))
		  (if (isnull (invoke map "get" mname))
			  (invoke map "put" mname (invoke row "get" cix)) )
		 ))
   map
 ))

;; map col i to col j
(define tab2map (fname header? sep i j) 
  (let ((br (apply getBufferedReader fname)) 
        (res (apply mkMtMap)) 
        (fun (lambda (line) 
               (let ((parts (invoke line "split" sep))
                     (len (lookup parts "length")) ) 
        (if (and (< j len)(< i len)) 
         (apply mapAdd res  (aget parts i) (aget parts j))
       ) )))   ) 
      (if header? (invoke br "readLine")) 
      (apply readTilEnd br fun) res ))
		

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/pla.lsp ;;;;;;;;;;
;;; *********** DEBUG settings *********


 ;;make sure we do only the new stuff ...
 (supdate "g2d.pla.PLA" "version" (int 4)) 

; define verbosity
; (supdate "g2d.util.ActorMsg" "VERBOSE" (boolean true))
(supdate "g2d.runtime.ExceptionHandler" "SHUTDOWN_AFTER_ERROR" (boolean false))
(sinvoke "g2d.jlambda.Debugger" "setVerbosity" (boolean true))

;; set the verbosity in the PLAGraph object construction (requestargs etc)
(supdate "g2d.pla.PLAGraph" "VERBOSE" (boolean false))


;; for extracting runtime settings from PLA
(define getPLAParameter (name default)
  (let ((config g2d.pla.PLA.config))
    (if (isobject config)
	(let ((value (lookup config name)))
	  (if (isobject value)
	      value
	    )
	  )
      default)
    )
  )

;;09july19
;; g2d.runtime vs pla

; if true prints lola retcode and path to GUI output
; and leaves the lola files in /tmp
(define lolaDebug (boolean false))

;;; *********** exception handling *********

; define exception handler
;;(sinvoke "g2d.jlambda.Debugger" "setHandler" (object ("g2d.runtime.ExceptionHandler")))

; add shutdown hook to send shutdown command to IOP
(invoke (sinvoke "java.lang.Runtime" "getRuntime") 
	"addShutdownHook" 
	(object ("g2d.runtime.ShutdownHook" "shutdown_hook")))

;;; *********** colors *********

;lavendar
(define noneFillColor (object ("java.awt.Color" (int 210) (int 202) (int 255))))
;dklavendar
(define initFillColor (object ("java.awt.Color" (int 150) (int 150) (int 255))))
;ltgreen
(define goalFillColor (object ("java.awt.Color" (int 100) (int 255) (int 90))))
;red
(define ngoalFillColor (object ("java.awt.Color" (int 255) (int 0) (int 0))))
;orangeish
(define avoidFillColor (object ("java.awt.Color" (int 255) (int 136) (int 102))))
;lighter ltgreen
(define usesFillColor (object ("java.awt.Color" (int 180) (int 255) (int 160))))
;bluegreen
(define foundFillColor (object ("java.awt.Color" (int 0) (int 255) (int 255))))
;black
(define nodeBorderColor java.awt.Color.black)
;grey
;(define cxtBorderColor (object ("java.awt.Color" (int 204) (int 204) (int 204))))
(define cxtBorderColor java.awt.Color.gray)
;ltgrey
;(define cxtFillColor (object ("java.awt.Color" (int 204) (int 204) (int 255))))
(define cxtFillColor java.awt.Color.white)
;ltyellow
;(define ruleFillColor (object ("java.awt.Color" (int 251) (int 255) (int 145))))
(define ruleFillColor java.awt.Color.lightGray)
;darker dklavendar
(define bidirEdgeColor (object ("java.awt.Color" (int 50) (int 25) (int 255))))
;black
(define unidirEdgeColor java.awt.Color.black)
;subgraph selection
(define subgraphFillColor java.awt.Color.red)
;pair selection rmp magenta
(define pairFillColor (object ("java.awt.Color" (int 255) (int 0) (int 255))))



; tell Java about the colors
(supdate "g2d.graph.IOPGraph" "cxtBorderColor" cxtBorderColor)

; (supdate "g2d.graph.IOPGraph" "noneFillColor" noneFillColor)
; (supdate "g2d.graph.IOPGraph" "initFillColor" initFillColor)
; (supdate "g2d.graph.IOPGraph" "goalFillColor" goalFillColor)
; (supdate "g2d.graph.IOPGraph" "ngoalFillColor" ngoalFillColor)
; (supdate "g2d.graph.IOPGraph" "avoidFillColor" avoidFillColor)
; (supdate "g2d.graph.IOPGraph" "usesFillColor" usesFillColor)
; (supdate "g2d.graph.IOPGraph" "foundFillColor" foundFillColor)
; (supdate "g2d.graph.IOPGraph" "nodeBorderColor" nodeBorderColor)
; (supdate "g2d.graph.IOPGraph" "cxtFillColor" cxtFillColor)
; (supdate "g2d.graph.IOPGraph" "ruleFillColor" ruleFillColor)
; (supdate "g2d.graph.IOPGraph" "bidirEdgeColor" bidirEdgeColor)
; (supdate "g2d.graph.IOPGraph" "unidirEdgeColor" unidirEdgeColor)

;; remove if nothing breaks
; called whenever node attribute changes to recalculate fill color:
 (define XXXcalcNodeFillColor (nodename)
  (let ((node (fetch nodename)))
    (seq
     (if (= node (object null)) noneFillColor ; unknown node
     (if (= "rule" (getAttr node "type")) 
         (if (= "avoid" (getAttr node "status"))
             avoidFillColor
             ruleFillColor) ; "type" = "rule": look whether "avoid"
     (if (= "true" (getAttr node "context")) cxtFillColor
     (if (= "none" (getAttr node "status"))
         (if (= "true" (getAttr node "init")) 
             initFillColor
             noneFillColor) ; "status" = "none": look at "init"
         (if (= "goal" (getAttr node "status")) ; "status" != "none" 
             goalFillColor
             (if (= "avoid" (getAttr node "status")) avoidFillColor))
     )))) ; 4x if
  )) ; seq;let
) ;calcNodeFillColor	  



;;; *********** interfaces *********

; from ii.maude -----------

; echos messages sent by g2d to GUI output window
(define sendMessage (to from msg)
  (sinvoke "g2d.util.ActorMsg" "send" to from msg)
) ;sendMessage

;(apply displayMessage2G %gname %title %message)
(define displayMessage2G (gname title msg)
  (let (
        (graph (fetch gname))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (sep (invoke panel "getSEPanel"))
        )
    (invoke sep "displayText" title msg)
    ) ;let
) ;displayMessage2G




;(apply displayMessage %title %message)
(define displayMessage (title msg)
  (seq
   ; show message in warning dialog:
   (sinvoke "javax.swing.JOptionPane" "showMessageDialog" 
	    (object null)
	    msg
	    title
	    javax.swing.JOptionPane.WARNING_MESSAGE)
   )
)

;(apply displayInfoMessage %title %message)
(define displayInfoMessage (title msg)
  (let ((popup (object ("g2d.swing.IOPInfoPopup"  title msg))))
     (invoke popup "display")
 ))



; from dg2g2d.maude -----------
;;; --- adding nodes and edges to graph:

(define maxLabLen (int 20))
(define useChattyLabels (boolean false))


;;; *********** begin explorer code *********

;;; 06oct09 clt code for exploring 

(define colorXGraph (graph)
  (let ((nodes (invoke graph "getNodesInArray")))
     (for node nodes
       (if (= (getAttr node "type" "") "rule")
         (invoke node "setFillColor" java.awt.Color.lightGray)
         (let ((xstatus (getAttr node "xstatus" ""))
               (color 
                 (if (= xstatus "seen")
                     java.awt.Color.lightGray
                 (if (= xstatus "oup") initFillColor
                 (if (= xstatus "odn") java.awt.Color.green
                 (if (= xstatus "oboth") java.awt.Color.cyan 
                  java.awt.Color.white)
                 ))))  ; color
             )
          (seq 
            (invoke node "setFillColor" color)
          )
         ) ;let
       ) ;if
     ) ;for
  ) ;let
)

(define redisplay (graph)
  (let ((panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph)))
    (seq
      (invoke graph "resetDotLayout")
      (if (invoke graph "isDotLayout") (invoke graph "doLayout" (object null)))
      (invoke panel "setGraph" graph)
      )
    )
)

; (apply addXOccNode graph %occLab %occLoc %occChattyLab %nodeId %occXInit %occXStatus)
(define addXOccNode (graph lab loc clab nid xinit xstatus)
  (let ((node (apply addOccNodeX graph lab loc clab nid xinit "none" "true"))
	)
    (seq
     (setAttr node "init" "false") ; override setting of "xinit" used for coloring
     (setAttr node "xinit" xinit)
     (setAttr node "xstatus" xstatus)
     node))
) ;addXOccNode


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/lola.lsp ;;;;;;;;;;
;(apply lolaRequest %net %task %id %requestor)
;; CLT split in to local request and remote request server

;;; IAM: 12/1/2016  Time to ditch all mention of lola in favor of the lola2. Yes?

(define lolaRequest (net task reqId requestor)
  (let ((res (apply doLolaReq net task reqId)))
    (apply sendMessage requestor "graphics2d"
           (concat (aget res (int 0)) " " (aget res (int 1))))
    )
  )

;; json file is new, hence optional
(define lolaDebugFiles (netFile taskFile pathFile jsonFile)
  (if lolaDebug
      (seq
       (invoke java.lang.System.err "println" (concat "lolaNetFile: " netFile))
       (invoke java.lang.System.err "println" (concat "lolaTaskFile: " taskFile))
       (invoke java.lang.System.err "println" (concat "lolaPathFile: " pathFile))
       (if (isobject jsonFile) 
           (invoke java.lang.System.err "println" (concat "lolaJsonFile: " jsonFile)))
       )
    )
  )

;; json file is new, hence optional
(define lolaDeleteFiles  (netFile taskFile pathFile jsonFile)
  (if (not lolaDebug)
      (seq
       (sinvoke "g2d.util.IO" "deleteFile" netFile)
       (sinvoke "g2d.util.IO" "deleteFile" taskFile)
       (sinvoke "g2d.util.IO" "deleteFile" pathFile)
       (if (isobject jsonFile) 
           (sinvoke "g2d.util.IO" "deleteFile" jsonFile)
         )
       )
    )
  )


(define doLolaReq (net task reqId)
  (let ((lolaPrefix (concat "lola" reqId "_"))
        (lolaNetFile (invoke (sinvoke "java.io.File" "createTempFile" 
				      lolaPrefix ".net")
			     "getAbsolutePath")) 
	(lolaTaskFile (invoke (sinvoke "java.io.File" "createTempFile" 
				       lolaPrefix ".task")
			     "getAbsolutePath")) 
	(lolaPathFile (invoke (sinvoke "java.io.File" "createTempFile" 
				       lolaPrefix ".path")
			     "getAbsolutePath")) 
	(command (concat "lola " lolaNetFile 
			 " -a" lolaTaskFile
			 " -p" lolaPathFile))
	(res (mkarray java.lang.String (int 2)))
	)
    (seq
     (sinvoke "g2d.util.IO" "string2File" net lolaNetFile)
     (sinvoke "g2d.util.IO" "string2File" task lolaTaskFile)
; run lola       
; retcode == 0 => SATISFIED
; retcode == 1 => NOT-SAT
; retcode =/= 0 => UNDECIDED
     (try 
      (let ((lolaProc (invoke (sinvoke "java.lang.Runtime" "getRuntime")
			      "exec" command))
	    (dummy
	     (if lolaDebug
		 (invoke java.lang.System.err "println" "lolaProc started")))
	    (retcode (invoke lolaProc "waitFor"))
	    (resPath
	     (if (= retcode (int 0))
		 (sinvoke "g2d.util.IO" "file2String" lolaPathFile)
	       ""))
	    )
	(seq 
         (apply lolaDebugFiles lolaNetFile lolaTaskFile lolaPathFile (object null))
	 (if lolaDebug
	     (seq
	      (invoke java.lang.System.err "println" (concat "retcode: " retcode))
	      (invoke java.lang.System.err "println" (concat "resPath: " resPath))
	      ))  ; if
	 (aset res (int 0) (concat "" retcode))
	 (aset res (int 1) resPath)
	 )) ; seq;let
    (catch var 
      (seq (apply displayMessage "error" "run lola failed")
	     (aset res (int 0) (concat "" (- (int 1))))
	     (aset res (int 1) "")) 
	  ) ; catch
    ) ;try
     
     (apply lolaDeleteFiles lolaNetFile lolaTaskFile lolaPathFile (object null))
     res
     ))  ;seq;let
  ) ; doLolaReq


(define lola2Request (net task reqId requestor)
  (let ((res (apply doLola2Req net task reqId))
	(rval (aget res (int 1)))
	(res1 (if (isobject rval) rval "0"))
	(msg (concat (aget res (int 0)) " " res1)))
    (if lolaDebug
	(seq 
	 (invoke java.lang.System.err "println" (concat "net: " net))
	 (invoke java.lang.System.err "println" (concat "task: " task))
	 (invoke java.lang.System.err "println" (concat "lola response to " requestor ": " msg))))
    (apply sendMessage requestor "graphics2d" msg)
    )
  )

(define runLola2 (command)
  (try 
   (let ((lolaProc (invoke (sinvoke "java.lang.Runtime" "getRuntime") "exec" command))
         (retcode (invoke lolaProc "waitFor")))
     (if lolaDebug (invoke java.lang.System.err "println"  (concat "retcode: " retcode)))
     retcode
     ) ; let
   (catch error 
     (invoke java.lang.System.err "println" (concat "runLola2 failed: " error))
     (int 1))
   ) 
  )

(define getLola2Result (jsonObj)
  (if (isobject jsonObj)
      (let ((analysis (invoke jsonObj "get" "analysis"))
            (result (if (isobject analysis) (invoke analysis "get" "result") (object null))))
        (if (isobject result)
            (invoke result "booleanValue")
          (boolean false)))))


(define doLola2Req (net task reqId)
  (let ((lolaPrefix (concat "lola" reqId "_"))
        (lolaNetFile (invoke (sinvoke "java.io.File" "createTempFile" lolaPrefix ".net")
			     "getAbsolutePath")) 
	(lolaTaskFile (invoke (sinvoke "java.io.File" "createTempFile" lolaPrefix ".formula")
                              "getAbsolutePath")) 
	(lolaJsonFile (invoke (sinvoke "java.io.File" "createTempFile" lolaPrefix ".json")
			     "getAbsolutePath")) 
	(lolaPathFile (invoke (sinvoke "java.io.File" "createTempFile" lolaPrefix ".path")
                              "getAbsolutePath")) 
        (command (concat "lola-2" " --formula=" lolaTaskFile " " lolaNetFile " --path=" lolaPathFile " --json=" lolaJsonFile))
	(res (mkarray java.lang.String (int 2)))
	)
    (seq
     (if lolaDebug (invoke java.lang.System.err "println" command))
     (apply lolaDebugFiles lolaNetFile lolaTaskFile lolaPathFile lolaJsonFile)
     (sinvoke "g2d.util.IO" "string2File" net lolaNetFile)
     (sinvoke "g2d.util.IO" "string2File" task lolaTaskFile)
     ;; run lola2       
     ;; retcode == 0 => NO ERROR
     ;; retcode == 1 => ERROR
     (let ((retcode (apply runLola2 command)))
       (if (= retcode (int 0))
           (let ((jsonObj (apply readJSonF lolaJsonFile))
                 (answer (apply getLola2Result jsonObj)))      
             (if answer 
                 (seq 
                  (aset res (int 0) "0")
                  (aset res (int 1) (sinvoke "g2d.util.IO" "file2String" lolaPathFile))
                  )
               (aset res (int 0) "1")
               )
             )
         (seq
          (aset res (int 0) "1")
          (aset res (int 1) "")
          )
         )
       )
     (apply lolaDeleteFiles lolaNetFile lolaTaskFile lolaPathFile lolaJsonFile)
     res
     )
    )
  )

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/dot.lsp ;;;;;;;;;;
;; a convenience flag for ian.
(define paint_testing (boolean false))

;; flip on to see the dot files, both input and output
(supdate "g2d.graph.Dot" "dotDebug" (boolean false))

;; passes the verbose flag to the dot process so you can see
;; why dot is taking such a long time.
(supdate "g2d.graph.Dot" "dotVerbose" paint_testing)

;; for debugging the paint routines
(supdate "g2d.glyph.GlyphList" "verbose" (boolean false))

;; processing large graphs with dot can take a long time.
;; this function tweaks some knobs to speed up that process.
;; note that the layout deteriorates when set to true.
;; so don't use large graph settings on small graphs if you can help it.
(define dot_large_graph_settings (bval)
  (if (not bval)
	  (seq
	   ;; these are the default settings of yore */
	   (supdate "g2d.graph.Dot" "NSLIMIT" (int 15))
	   (supdate "g2d.graph.Dot" "NSLIMIT1" (int 0))
	   (supdate "g2d.graph.Dot" "MCLIMIT" (float 0.0))
	   )
	(seq
	 ;; these are the settings for Merrill's humungous graphs  */
	 (supdate "g2d.graph.Dot" "NSLIMIT" (int 5))
	 (supdate "g2d.graph.Dot" "NSLIMIT1" (int 5))
	 (supdate "g2d.graph.Dot" "MCLIMIT" (float 0.3))
	 )
	)
  )

;; usually we are debugging when the graphs are large
(apply dot_large_graph_settings paint_testing)

;; thumbnail stuff happens in buffered glyphlist.
(supdate "g2d.glyph.BufferedGlyphList" "paintDebug" paint_testing)


;; a very vague guesstimate of what constitutes a large graph.
;; STM is to STM7  what STM7 is to SmallKB.
;;
(if paint_testing
	(seq
	 ;; just enough to make Egf dish in STM "small"
	 (supdate "g2d.glyph.BufferedGlyphList" "NODE_THRESHOLD" (int 2000))
	 (supdate "g2d.glyph.BufferedGlyphList" "EDGE_THRESHOLD" (int 8000))
	 )
  (seq
   ;; just enough to make Egf dish in STM7 "small"
   (supdate "g2d.glyph.BufferedGlyphList" "NODE_THRESHOLD" (int 500))
   (supdate "g2d.glyph.BufferedGlyphList" "EDGE_THRESHOLD" (int 1500))
   )
  )


(apply logDev  "dot.lsp loaded")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/exploreSelect.lsp ;;;;;;;;;;
(seq
; (apply exploreSelectRules %title %gname %rids %replyto %replyfor)
;                             graphname array[String]
(define exploreSelectRules (title parent ruleids replyto replyfor)
  (let (
        (parentobj (fetch parent))
        (frame (if (instanceof parentobj "g2d.graph.IOPGraph") (sinvoke "g2d.pla.PLAUtils" "getTabFrame" parentobj) (getAttr (fetch "KBManager") "kbframe")))
        (sdialog (object ("g2d.subset.SDialog" frame (boolean true))) )
        (order g2d.util.Orderings.INTEGRAL_PREFIX)
        )
    (seq
     ;this one results in the combobox being ordered correctly
     (sinvoke "java.util.Arrays" "sort" ruleids order)
     (invoke sdialog "setUniverse" ruleids)
     ;this one results in the STree being ordered correctly
     (invoke sdialog "addTab" "Lexical" order)
     (invoke sdialog "setTitle" title)
     (invoke sdialog "setVisible" (boolean true))
     (invoke sdialog "toFront")
     (let ((selected (invoke sdialog "getStrings" (int 1)))
           (ans (if (= selected (object null)) 
                    ""
                  (apply sarray2string  selected 
                         (lookup selected "length") (int 0) "")
                  ))
           )
       (sinvoke "g2d.util.ActorMsg" "send" replyto replyfor ans)
       )      
     ))  ; seq ; let
) ; end exploreSelectRules

(define sarray2string (selected len cur ans)
  (if (>= cur len)
   ans
   (apply sarray2string  selected len (+ cur (int 1))
          (concat ans " " (aget selected cur))      
   ))
)

; (apply sarray2string (array java.lang.String "a" "b" "c") (int 3) (int 0) "")

; (apply exploreSelectOccs %title %gname %occids %replyto %replyfor)
(define exploreSelectOccs (title parent occids replyto replyfor)
  (let (
        (parentobj (fetch parent))
        (frame (if (instanceof parentobj "g2d.graph.IOPGraph") (sinvoke "g2d.pla.PLAUtils" "getTabFrame" parentobj) (getAttr (fetch "KBManager") "kbframe")))
        (sdialog (object ("g2d.subset.SDialog" frame (boolean true))) )
      	;this is new, and is used below
      	(order g2d.util.Orderings.LEXICAL_CASE_INSENSITIVE)
        (four (object ("g2d.subset.StateSpace" )))
        (names (array java.lang.String 
                      "         " 
                      " (both)  "
                      " (up)    "
                      " (dn)    "))
       	;this is new, if we sort them here, they appear nicely in the combobox drop down....
        (dummy (seq (sinvoke "java.util.Arrays" "sort" occids order)
		    (invoke four "setValency" (int 4))
                    (invoke four "setNames" names)))
        (universe (object ("g2d.subset.Universe" occids four)))
       )
    (seq
      (invoke sdialog "setUniverse" universe)
      (invoke sdialog "addTab" "Lexical")
      (invoke sdialog "setTitle" title)
      (invoke sdialog "setVisible" (boolean true))
      (invoke sdialog "toFront")
      (let ((both (invoke sdialog "getStrings" (int 1)))
            (up (invoke sdialog "getStrings" (int 2)))
            (dn (invoke sdialog "getStrings" (int 3)))
            (ansb (if (= both (object null)) 
                   ""
                  (apply occChattySelect2string  both "b" 
                               (lookup both "length") (int 0) "")))
            (ansu (if (= up (object null)) 
                   ansb
                  (apply occChattySelect2string  up "u" 
                               (lookup up "length") (int 0) (concat ansb " "))))
            (ansd (if (= dn (object null)) 
                   ansu
                  (apply occChattySelect2string  dn "d" 
                               (lookup dn "length") (int 0) (concat ansu " "))))
              )
        (sinvoke "g2d.util.ActorMsg" "send" replyto replyfor ansd)
       )      
     ))  ; seq ; let
) ; end exploreSelectRules


(define occChattySelect2string (selected tag len cur ans)
  (if (>= cur len)
   ans
   (apply occChattySelect2string  selected tag len (+ cur (int 1))
          (concat ans  (aget selected cur) " " tag " " )      
   ))
)




(define test (what)
  (let ((parent (object ("g2d.jlambda.Attributable")))
        (frame (object ("g2d.swing.IOPFrame" "test")))
        (ids (array java.lang.String
                         "102.def"  "hello" "Src-act-CLi" 
                           "1433-CLc" "213.xyz#a"))
        )
    (seq
      (setuid parent "parent") 
      (setAttr parent "frame" frame)
      (if (= what "rules")
        (apply exploreSelectRules "foo" "parent" ids "maude" "maudereq3")
        (apply exploreSelectOccs "foo" "parent" ids "maude" "maudereq3")
      )
    ) ; seq
  ) ; let
)
; (apply test "rules")
; (apply test "occs")
)

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/query.lsp ;;;;;;;;;;
(define mkStatusString (graph)
  (let ((nodes (invoke graph "getNodesInArray")))
    (apply nodes2status nodes (int 0) (lookup nodes "length") "")
  ) 
)

(define nodes2status (nodes cur len str)
  (if (>= cur len)
   str
   (let ((node (aget nodes cur))
         (nid (getAttr node "nid" ""))
         (status (getAttr node "status" "none")))
    (apply nodes2status nodes (+ cur (int 1)) len 
         (if (or (= status "none") (= nid ""))
          str 
          (concat str " " nid " " status) 
      ) ) ) ; if app let 
  )  
) ; nodes2status


(define subnetRequest (graph)
   (sinvoke "g2d.util.ActorMsg" "send" 
      "maude"
       (getuid graph)
       (concat "displaySubnet1" " " (apply mkStatusString graph))
    )
 )

;; iam: eliminated 3/18/2015  need to eliminate displayPath1 too.
;;(define pathRequest (graph)
;;   (sinvoke "g2d.util.ActorMsg" "send" 
;;      "maude"
;;       (getuid graph)
;;       (concat "displayPath1" " " (apply mkStatusString graph))
;;       )
;;   )

(define pathRequest (graph)
   (sinvoke "g2d.util.ActorMsg" "send" 
      "maude"
       (getuid graph)
       (concat "displayPath2" " " (apply mkStatusString graph))
       )
   )
 

(define nodeById (nodes id cur len)
  (if (>= cur len)
   (object null)
   (let ((node (aget nodes cur))
         (nid (getAttr node "nid" ""))
        )
     (if (= nid id)
      node
      (apply nodeById nodes id (+ cur (int 1)) len) 
      ) ) ) ; if let if
) ; nodeById

(apply logDev  "query.lsp loaded")


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/mongolib.lsp ;;;;;;;;;;
;; mongo support


(define mongoMachine (apply getPLAParameter "mongo" "stella.csl.sri.com"))
(invoke java.lang.System.err "println" (concat "the mongoMachine: " mongoMachine))
  
(define authenticate  ()
  (apply authenticateUser2Machine "plaGuest" "admin" "pathway2heaven@sri" mongoMachine)
  )


(define authenticateUser2Machine (name database password machine)
  (try (apply nauthenticateUser2Machine name database password machine)
       (catch e
	 (try (apply _authenticateUser2Machine name database password machine) (catch e (boolean false))))
       )
  )


;;old way mongo-driver < 3.0.0
(define _authenticateUser2Machine (name database password machine)
  (let ((dbc (object ("com.mongodb.MongoClient" machine (int 7777))))
        (db (invoke dbc "getDB" database))
        (pwd (invoke password "toCharArray"))
        (auth (invoke db "authenticate" name pwd)))
    (invoke java.lang.System.err "println" auth)
    (invoke java.lang.System.err "println" name)
    (invoke java.lang.System.err "println" machine)
    (if auth
        dbc
      (seq 
       (invoke java.lang.System.err "println" "authentication failed")
       (object null)
       )
      )
    )
  )


;;new way mongo-driver >= 3.0.0
(define nauthenticateUser2Machine (name database password machine)
  (let ((serveraddr  (object ("com.mongodb.ServerAddress" machine (int 7777))))
	(seeds (object ("java.util.ArrayList")))
	(password password)
        (pwd (invoke password "toCharArray"))
	(cred (sinvoke "com.mongodb.MongoCredential" "createMongoCRCredential" name database pwd))
	(credlist (object ("java.util.ArrayList"))))
    (invoke seeds "add" serveraddr)
    (invoke credlist "add" cred)
    (object ("com.mongodb.MongoClient" seeds credlist))
    )
  )

(define nauthenticateUser (name database password)
  (apply nauthenticateUser2Machine name database password "iandev.sri.com")
  )

(define _authenticateUser (name database password)
  (apply _authenticateUser2Machine name database password "iandev.sri.com")
  )


(define fetchByKeyValue (db key value collection)
  (let ((query (let ((q (object ("com.mongodb.BasicDBObject")))) (seq (invoke q "put" key value) q)))
        (cursor (invoke collection "find" query)))
    (if (invoke cursor "hasNext")
        (invoke cursor "next")
      (object null))))

(define findNets (mname db)
  (let ((result (object ("java.util.HashSet")))
        (uniprot (invoke db "getCollection" "uniprot"))
        (basicOps (invoke db "getCollection" "basicOps")))
    (if (isobject uniprot)
        (apply findNetsAux mname db uniprot basicOps result)
      (object null))))



(define findNetsAux (mname db uniprot basicOps result)  
  (let ((uq (apply fetchByKeyValue db "mname" mname uniprot)))
    (if (isobject uq)
        (seq (invoke result "addAll" (invoke uq "get" "nets"))
             result)
      (let ((bop (apply fetchByKeyValue db "name" mname basicOps)))
        (if (isobject bop)
            (let ((metadata (invoke bop "get" "metadata"))
                  (sort (invoke metadata "get" "sort"))
                  (category (invoke metadata "get" "category")))
              (if (= sort "Peptide")
                  (seq ;(invoke java.lang.System.err "println" "Peptide")
                       (apply findNetsAux (invoke metadata "get" "partof") db uniprot basicOps result)
                       )
                (if (= sort "Composite")
                    (seq ;(invoke java.lang.System.err "println"  "Composite")
                         (for member (invoke metadata "get" "subunits")  
                              (apply findNetsAux member db uniprot basicOps result)
                              )          
                         )
                  (if (= category "Family")
                      (seq ;(invoke java.lang.System.err "println"  "Family")
                           (for member (invoke metadata "get" "members")  
                                (apply findNetsAux member db uniprot basicOps result)
                                )
                           )
                    (seq ;(invoke java.lang.System.err "println"  sort)
                         ;(invoke java.lang.System.err "println"  category)
                         result)
                    )
                  )
                )
              )
          result)
        )
      )
    )
  )

(define findRules (mname db)
  (let ((result (object ("java.util.HashSet")))
        (uniprot (invoke db "getCollection" "uniprot"))
        (basicOps (invoke db "getCollection" "basicOps")))
    (if (isobject uniprot)
        (apply findRulesAux mname db uniprot basicOps result)
      (object null))))



(define findRulesAux (mname db uniprot basicOps result)  
  (let ((uq (apply fetchByKeyValue db "mname" mname uniprot)))
    (if (isobject uq)
        (seq (invoke result "addAll" (invoke uq "get" "rules"))
             result)
      (let ((bop (apply fetchByKeyValue db "name" mname basicOps)))
        (if (isobject bop)
            (let ((metadata (invoke bop "get" "metadata"))
                  (sort (invoke metadata "get" "sort"))
                  (category (invoke metadata "get" "category")))
              (if (= sort "Peptide")
                  (seq ;(invoke java.lang.System.err "println" "Peptide")
                       (apply findRulesAux (invoke metadata "get" "partof") db uniprot basicOps result)
                       )
                (if (= sort "Composite")
                    (seq ;(invoke java.lang.System.err "println"  "Composite")
                         (for member (invoke metadata "get" "subunits")  
                              (apply findRulesAux member db uniprot basicOps result)
                              )          
                         )
                  (if (= category "Family")
                      (seq ;(invoke java.lang.System.err "println"  "Family")
                           (for member (invoke metadata "get" "members")  
                                (apply findRulesAux member db uniprot basicOps result)
                                )
                           )
                    (seq ;(invoke java.lang.System.err "println"  sort)
                         ;(invoke java.lang.System.err "println"  category)
                         result)
                    )
                  )
                )
              )
          result)
        )
      )
    )
  )

;;;;   generic versions 

(define findNetsGeneric (mname db)
  (let ((result (object ("java.util.HashSet")))
        (basicOps (invoke db "getCollection" "basicOps")))
    (if (isobject basicOps)
        (apply findNetsGenericAux mname db basicOps result)
      (object null))))



(define findNetsGenericAux (mname db basicOps result)  
  (let ((bop (apply fetchByKeyValue db "name" mname basicOps)))
    (if (isobject bop)
        (seq (invoke result "addAll" (invoke bop "get" "nets"))
             (let ((metadata (invoke bop "get" "metadata"))
                   (sort (invoke metadata "get" "sort"))
                   (category (invoke metadata "get" "category")))
               (if (= sort "Peptide")
                   (seq ;(invoke java.lang.System.err "println" "Peptide")
                    (apply findNetsGenericAux (invoke metadata "get" "partof") db basicOps result)
                    )
                 (if (= sort "Composite")
                     (seq ;(invoke java.lang.System.err "println"  "Composite")
                      (for member (invoke metadata "get" "subunits")  
                           (apply findNetsGenericAux member db basicOps result)
                           )          
                      )
                   (if (= category "Family")
                       (seq ;(invoke java.lang.System.err "println"  "Family")
                        (for member (invoke metadata "get" "members")  
                             (apply findNetsGenericAux member db basicOps result)
                             )
                        )
                     (seq ;(invoke java.lang.System.err "println"  sort)
                                        ;(invoke java.lang.System.err "println"  category)
                      result)
                     )
                   )
                 )
               )
             )
      )
    result
    )
  )


(define findRulesGeneric (mname db)
  (let ((result (object ("java.util.HashSet")))
        (basicOps (invoke db "getCollection" "basicOps")))
    (if (isobject basicOps)
        (apply findRulesGenericAux mname db basicOps result)
      (object null))))



(define findRulesGenericAux (mname db basicOps result)  
  (let ((bop (apply fetchByKeyValue db "name" mname basicOps)))
    (if (isobject bop)
        (seq (invoke result "addAll" (invoke bop "get" "rules"))
             (let ((metadata (invoke bop "get" "metadata"))
                   (sort (invoke metadata "get" "sort"))
                   (category (invoke metadata "get" "category")))
               (if (= sort "Peptide")
                   (seq ;(invoke java.lang.System.err "println" "Peptide")
                    (apply findRulesGenericAux (invoke metadata "get" "partof") db basicOps result)
                    )
                 (if (= sort "Composite")
                     (seq ;(invoke java.lang.System.err "println"  "Composite")
                      (for member (invoke metadata "get" "subunits")  
                           (apply findRulesGenericAux member db basicOps result)
                           )          
                      )
                   (if (= category "Family")
                       (seq ;(invoke java.lang.System.err "println"  "Family")
                        (for member (invoke metadata "get" "members")  
                             (apply findRulesGenericAux member db basicOps result)
                             )
                        )
                     (seq ;(invoke java.lang.System.err "println"  sort)
                                        ;(invoke java.lang.System.err "println"  category)
                      result)
                     )
                   )
                 )
               )
             )
      )
    result
    )
  )

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/kbbrowser.lsp ;;;;;;;;;;
;;new (May 2014) kb browser using mongo

(define launchKBBrowser (kbm pd)
  (let ((dbc (apply authenticate)))
    (if (isobject dbc)
        (seq 
         ;;(invoke java.lang.System.err "println" kbm)
         ;;(invoke kbm "showAttributes" java.lang.System.err)
         ;;(invoke java.lang.System.err "println" dbc)
         (let (
               (kbnames (getAttr kbm "kbnames"))
               (kbname (invoke kbnames "elementAt" (int 0))) 
               (plamodel (apply getModelName kbname))
               (mongodb (invoke plamodel "toLowerCase"))
               (model (invoke dbc "getDB" mongodb))
               (bo (invoke model "getCollection" "basicOps"))
               (completionCollection bo)
               (completionKey "name")
               ;;(completionClosure (apply  makeCompletionClosure completionKey completionCollection))
               ;;(rulesClosure (apply makeRulesClosure model))
               ;;(netsClosure (apply makeNetsClosure model))
               (completionClosure (apply  makeCompletionClosureGeneric completionKey completionCollection))
               (rulesClosure (apply makeRulesClosureGeneric model))
               (netsClosure (apply makeNetsClosureGeneric model))
               (launchClosure (apply makeLaunchClosure kbm kbname pd))
               (explorer (object ("g2d.pla.explorer.Explorer"))))

           ;;(invoke java.lang.System.err "println" kbnames)
           ;;(invoke java.lang.System.err "println" (invoke kbnames "getClass"))
           (invoke java.lang.System.err "println" kbname)
           (invoke java.lang.System.err "println" plamodel)
           (invoke java.lang.System.err "println" mongodb)

           (invoke g2d.tabwin.TabPreferences.g2d_preferences "manageJFrame" explorer "pla-kbbrowser")

           (update explorer "completionClosure" completionClosure)
           (update explorer "rulesClosure" rulesClosure)
           (update explorer "netsClosure" netsClosure)
           (update explorer "launchClosure" launchClosure)
           (update explorer "saveClosure" saveClosure)
           (invoke explorer "setVisible" (boolean true))
           )
         )
      (invoke java.lang.System.err "println" "No mongo support by the looks of it!")
      )
    )
  )

(define saveClosure (explorer results)
  (let ((chooser (object ("g2d.swing.IOPFileChooser" 
                          g2d.tabwin.TabPreferences.FC_RAW_TEXT_AREA 
                          g2d.tabwin.TabPreferences.FC_RAW_TEXT_FORMAT 
                          g2d.tabwin.TabPreferences.FC_RAW_TEXT_FILE)))
        (retval (invoke chooser "showSaveDialog" explorer))
        )
    (if (= retval javax.swing.JFileChooser.APPROVE_OPTION)
        (let ((selectedFile (invoke chooser "getSelectedFile"))
              (fileName (invoke selectedFile "getAbsolutePath"))
              (collection (sinvoke "java.util.Arrays" "asList" results))
              )
          (sinvoke "g2d.util.IO" "collection2File" collection fileName (object null) (boolean false))
          )
      )
    )
  )

(define makeCompletionClosure (completionKey completionCollection)
  (lambda (explorer text)
    (try 
     (let ((pattern (sinvoke "java.util.regex.Pattern" "compile" text java.util.regex.Pattern.CASE_INSENSITIVE))
	   (query0 (object ("com.mongodb.BasicDBObject" completionKey pattern)))
	   (query1 (object ("com.mongodb.BasicDBObject" "modname" "PROTEINOPS")))
	   (qlist (object ("java.util.ArrayList")))
	   (dummy (seq (invoke qlist "add" query0) (invoke qlist "add" query1) "dummy"))
	   (query (object ("com.mongodb.BasicDBObject" "$and" qlist)))
	   (cursor (invoke completionCollection "find" query))
	   (rawArray (invoke cursor "toArray"))
	   (resultSet (object ("java.util.HashSet")))
	   (results (object ("java.util.ArrayList"))))
       (for obj rawArray (invoke resultSet "add" (invoke obj "get" completionKey)))
       (invoke results "addAll" resultSet)
       ;;(invoke java.lang.System.err "println" results)
       results)
     (catch e (invoke java.lang.System.err "println" "Burp (can't compile pattern)!") (object ("java.util.ArrayList"))))
    )
  )

(define makeCompletionClosureGeneric (completionKey completionCollection)
  (lambda (explorer text)
    (try 
     (let ((pattern (sinvoke "java.util.regex.Pattern" "compile" text java.util.regex.Pattern.CASE_INSENSITIVE))
	   (query (object ("com.mongodb.BasicDBObject" completionKey pattern)))
	   (cursor (invoke completionCollection "find" query))
	   (rawArray (invoke cursor "toArray"))
	   (resultSet (object ("java.util.HashSet")))
	   (results (object ("java.util.ArrayList"))))
       (for obj rawArray (invoke resultSet "add" (invoke obj "get" completionKey)))
       (invoke results "addAll" resultSet)
       ;;(invoke java.lang.System.err "println" results)
       results)
     (catch e (invoke java.lang.System.err "println" "Burp (can't compile pattern)!") (object ("java.util.ArrayList"))))
    )
  )


(define makeRulesClosure (model)
  (lambda (explorer text)
    ;; needs to return an an AbstractCollection of the rules
    (let ((answers (apply findRules text model)))
      ;;(invoke java.lang.System.err "println" answers)
      answers
      )
    )
  )

(define makeNetsClosure (model)
  (lambda (explorer text)
    ;; needs to return an an AbstractCollection of the nets
    (let ((answers (apply findNets text model)))
      ;;(invoke java.lang.System.err "println" answers)
      (if (isobject answers)
          (invoke answers "remove" "allDish")
        )
      answers
      )
    )
  )

(define makeRulesClosureGeneric (model)
  (lambda (explorer text)
    ;; needs to return an an AbstractCollection of the rules
    (let ((answers (apply findRulesGeneric text model)))
      ;;(invoke java.lang.System.err "println" answers)
      answers
      )
    )
  )

(define makeNetsClosureGeneric (model)
  (lambda (explorer text)
    ;; needs to return an an AbstractCollection of the nets
    (let ((answers (apply findNetsGeneric text model)))
      ;;(invoke java.lang.System.err "println" answers)
      (if (isobject answers)
          (invoke answers "remove" "allDish")
        )
      answers
      )
    )
  )



(define browseRules (kbm kbname text pd)
  (seq
   ;;(invoke java.lang.System.err "println" text)
   (sinvoke "g2d.util.ActorMsg" "send" "maude" kbname (concat "exploreRule " text))
   )
  )

(define browseNets (kbm kbname text pd)
  (seq
   ;;(invoke java.lang.System.err "println" text)
   (sinvoke "g2d.util.ActorMsg" "send" "maude" kbname (concat "displayPetri " text)) 
   (apply showProgressDialog pd "Creating dishnet")
   )
  )



 
(define makeLaunchClosure  (kbm kbname pd)
  (lambda (explorer text)
    ;; the type will be either g2d.pla.explorer.Explorer$Find.rules or g2d.pla.explorer.Explorer$Find.nets
    ;; the text will then be the name of the rule or net respectively
    (let ((type (lookup explorer "current")))
      ;;(invoke java.lang.System.err "println" type)
      (if (== type g2d.pla.explorer.Explorer$Find.rules)
          (apply browseRules kbm kbname text pd)
        (if (== type g2d.pla.explorer.Explorer$Find.nets)
            (apply browseNets kbm kbname text pd)
          (invoke java.lang.System.err "println" "Unexpected type in launchClosure!")
          )
        )
      )
    )
  )



;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/kbmanager.lsp ;;;;;;;;;;
(define mkKBAction (label tip list cmd)
  (let ((closure
         (lambda (self event)
           (let ((selection (invoke list "getSelectedValue")))
             (if (= selection (object null))
                 (invoke java.lang.System.err "println" 
                         (concat "KBManager no kb selected for " cmd)) 
               (sinvoke "g2d.util.ActorMsg" 
                        "send" "maude" selection cmd)))))
        )
    (object ("g2d.closure.ClosureAbstractAction"
             label
             (object null) ; icon
             tip
             (object null) ; accelerator
             (object null) ; mnemonic
             closure     ; action closure
            ))
   )) ;mkKBAction

(define mkKBBrowserAction (label tip kbm pd)
  (let ((closure  
         (lambda (self event)
           (apply launchKBBrowser kbm pd))))
    (object ("g2d.closure.ClosureAbstractAction"
             label
             (object null) ; icon
             tip
             (object null) ; accelerator
             (object null) ; mnemonic
             closure     ; action closure
             )
            )
    )
  )
  

;                      dish name string array
(define initKBwdo (title kbm dishes)
  (let (
        (frame (object ("g2d.tabwin.AppFrame" title)))
        (isRemote (sinvoke "g2d.Main" "isRemote"))
        (model (object ("javax.swing.DefaultListModel")))
        (list (object ("javax.swing.JList" model) ))
;;;clt 09may23
        (pd (apply makeProgressDialog2 frame (boolean true)))
        (toolbar (object ("javax.swing.JToolBar"  
                          javax.swing.JToolBar.VERTICAL)))
;;; added
        (dishbutton (object ("g2d.swing.IOPDropdownButton" "Select Dish")))
        (editDishClosure
           (lambda (self event)
              (let ((selection (invoke list "getSelectedValue")))
                  (sinvoke "g2d.util.ActorMsg" 
                               "send" "maude" selection "newDish"))))
        (predefClosure (lambda (dname) (lambda (s e )
                (let ((kbname  (invoke list "getSelectedValue")))
                  (seq
                    (sinvoke "g2d.util.ActorMsg" 
                    "send" "maude" kbname (concat "displayPetri " dname)) 
;;;clt 09may23
                    (apply showProgressDialog pd "Creating dishnet"))
                    )
                ))
               )
        (exploreOccsAction 
           (apply mkKBAction "Explore(Occs)" 
                           "Explore the selected knowledge base from occurrences" 
                             list "exploreInit occ"))
        (exploreRulesAction 
           (apply mkKBAction "Explore(Rules)" 
                           "Explore the selected knowledge base from rules" 
                             list "exploreInit rule"))
;;19feb22clt  hiding mongo browser
;;        (browseKBAction (apply mkKBBrowserAction "Browse KB" "Browse the rules and nets associated with proteins" kbm pd))
        )
    (seq
     

     ;;add the jlambda console
     (if g2d.pla.PLA.developmental
         (try
          (let ((menubar (object ("javax.swing.JMenuBar"))))
            (invoke menubar "add" (apply makeConsoleMenu "pla"))
            (invoke frame "setJMenuBar" menubar)
	    ;;august 2015; also make the kbframe immune to the dreaded "barber pole"
	    (invoke frame "setModalExclusionType" java.awt.Dialog$ModalExclusionType.APPLICATION_EXCLUDE)
            )      
	  (catch exception (boolean true)))
       )
     (invoke frame "setSize" (int 200) (int 350))
     (invoke list "setFixedCellHeight" (int 20))
     (invoke toolbar "addSeparator")
     (invoke dishbutton "addMenuItem" "Edit" editDishClosure)
     (if (> (lookup dishes "length") (int 0))
	 (invoke dishbutton "addMenu" "PreDefined" dishes predefClosure))
     (invoke toolbar "add" dishbutton (int -1))
;;;
     (invoke toolbar "addSeparator")
     (invoke toolbar "add" exploreOccsAction)
     (invoke toolbar "addSeparator")
     (invoke toolbar "add" exploreRulesAction)
     ;; add the mongo browser if we are iam or clt.
     ;;(if g2d.pla.PLA.developmental
     ;;    (seq
;;19feb22clt hiding mongo browser
;;     (invoke toolbar "addSeparator")
;;     (invoke toolbar "add" browseKBAction)
     ;;     )
     ;;  )
     (invoke toolbar "setFloatable" (boolean false))
     (invoke frame  "add" toolbar java.awt.BorderLayout.EAST)
     (invoke frame  "add" list java.awt.BorderLayout.CENTER)
;;; clt 09july26
     (setAttr kbm "kbnames" model)
     (setAttr kbm "kblist" list)
     (setAttr kbm "kbframe" frame)
;;;clt 09may23
     (invoke pd "setLocation" (int 20) (int 175))
     (setAttr kbm "progressd" pd)
     ;; redundant
     ;;      (setAttr kbm "kbfname" (getuid (invoke frame "getID")))
     ;;      (invoke frame "setVisible" (boolean true))
;;;09dec08 clt freezing kbm until the KB is ready
    (if isRemote 
	(sinvoke "g2d.util.ActorMsg" "send" "maude" "iop_remote_actor" "OK") 
      (sinvoke "g2d.util.ActorMsg" "send" "maude" "graphics2d" "OK") 
      )
    (apply showProgressDialog  pd "initializing KB")      
    ) ) ) ; seq ; let ; initKBwdo

(define defKBManager ()
  (let ((name  "KBManager")
        (kbm0 (fetch name))
        (kbm (if (= kbm0 (object null))  ; **** don't create if exists
                 (object ("g2d.jlambda.Attributable"))
                 kbm0))
        (dishes (array java.lang.String ))
     )
    (seq
      (if (= kbm0 (object null)) (setuid kbm name))
      (apply initKBwdo "PLA KB Manager" kbm dishes) ;; set kbnames,kbframe attrs.
    )
))

(define defKBManagerD (dishes)
  (let ((name  "KBManager")
        (kbm0 (fetch name))
        (kbm (if (= kbm0 (object null))  ; **** don't create if exists
                 (object ("g2d.jlambda.Attributable"))
                 kbm0)))
    (seq
      (if (= kbm0 (object null)) (setuid kbm name))
      (apply initKBwdo "PLA KB Manager" kbm dishes) ;; set kbnames,kbframe attrs.
    )
))

(define defKBGraph 
  (kbname occ-labs occ-ids occ-aexps occ-locs rule-labs rule-ids)
  (let ((kbg0 (fetch kbname))
        (kbg (if (= kbg0 (object null))  ; **** don't create if exists
                 (object ("g2d.jlambda.Attributable"))
                 kbg0))
        (kbm (fetch "KBManager"))
        (kbnames (if (= kbm (object null)) 
                     (object null)
                     (getAttr kbm "kbnames" (object null))))
        (kbframe (if (= kbm (object null)) 
                     (object null)
                     (getAttr kbm "kbframe" (object null))))
        (kblist (if (= kbm (object null)) 
                     (object null)
                     (getAttr kbm "kblist" (object null))))
         )
    (seq
      (invoke kbnames "addElement" kbname)  ; add element to list
      (if (= kbg0 (object null)) (setuid kbg kbname))
      (setAttr kbg "frame" (object ("g2d.swing.IOPFrame" "test")))
      (setAttr kbg "occ-labs" occ-labs)
      (setAttr kbg "occ-ids" occ-ids)
      (setAttr kbg "occ-aexps" occ-aexps)
      (setAttr kbg "occ-locs" occ-locs)
      (setAttr kbg "rule-labs" rule-labs)
;;clt 13jan01
;;      (sinvoke "g2d.util.IO" "string2File"
;;        (apply printArr (getAttr (fetch kbname) "rule-labs")) "12octrlabs.txt")   
      (setAttr kbg "rule-ids" rule-ids)
;;      (sinvoke "g2d.util.IO" "string2File"
;;        (apply printArr (getAttr (fetch kbname) "rule-ids")) "120octrids.txt")   
      (setAttr kbg "occ-bases"   (apply computeBasis occ-aexps))      
      (if (invoke kblist "isSelectionEmpty")
          (invoke kblist "setSelectedIndex" (int 0)))
      (invoke kbframe "setVisible" (boolean true))          
;;; 09dec08 clt unfreeze kbm          
      (apply hideProgressDialog (getAttr kbm "progressd"))
    )
  ))

;; <cr> or red button closes wdo, answer is what ever is in the box, maybe ""
(define askUser (frame title msg)
   (let ((asker (object ("g2d.swing.IOPAskUser" frame title msg (boolean true)))))
      (seq 
        (invoke asker "setVisible" (boolean true))
        (invoke asker "getAnswer")
      )
     )
  )

; (apply initDishEditor %kbname %dishnames)
(define initDishEditor (kbname dishnames)
  (let ((kb0 (fetch kbname))
        (kb (if (instanceof kb0 "g2d.jlambda.Attributable") 
             kb0
             (object ("g2d.jlambda.Attributable")) ))
        (entries (getAttr kb "occ-labs" (array java.lang.String) ))
        (bases   (getAttr kb "occ-bases" (array java.util.ArrayList) ))
        (locations (getAttr kb "occ-locs" (array java.lang.String) ))
;        (frame (object ("javax.swing.JFrame" "DDialog Test")))
        (frame (getAttr kb "kbframe"))
;                                                         modal?
        (ddialog (object ("g2d.subset.DDialog" frame (boolean false))))
        (button (object ("g2d.swing.IOPDropdownButton" "Dish")))
      ; the two closures for the drop down button:
        (open (lambda (s e) 
	        (let ((dish (invoke ddialog "getEntriesFromFile"))
            	  (result (invoke ddialog "add2Dish" dish))
            	  ) 
            (if (instanceof result "java.lang.String") 
                (apply displayMessage "Bad dish component" result)	  
            	  result)
            )))
       (save (lambda (s e) (invoke ddialog "saveEntriesToFile")))
       (askmaude 
        (lambda (dname) 
          (lambda (s e )
;;;; 09july19
            (seq 
             ; (invoke ddialog "setVisible" (boolean false))
             (sinvoke "g2d.util.ActorMsg" 
                      "send" "maude" kbname (concat "getDish " dname)) )) )
        )
       (ask4all
        (lambda (s e )
          (sinvoke "g2d.util.ActorMsg" 
                   "send" "maude" kbname "getAllDish")))
       (okClosure 
         (lambda (s e)
           (let ((selected (invoke ddialog "getSelected"))
                 (udname (apply askUser frame "AskUser" "Type in a dish name"))
                 (ans (apply sarray2string selected 
                             (lookup selected "length") (int 0) "")))
             (if (= udname "")
               (apply displayMessage "Alert" "No Dish Name")
             (if (= (lookup selected "length") (int 0))
               (apply displayMessage "Alert" "Empty Dish")
               (sinvoke "g2d.util.ActorMsg" "send" "maude" kbname 
                              (concat "displayNewDish " udname " " ans))
              )) ; if if
           )))   ; let lambda okClosure
       (merge 
        (lambda (s e)
          (apply dishMerge frame kbname dishnames)
          )
        )
       )
 (seq 

   (invoke ddialog "add2DishToolbar" button)

   (invoke button  "addMenuItem" "Open" open)
   (invoke button  "addMenuItem" "Save" save)
   (invoke button  "addMenu" "Choose One" dishnames askmaude)
   (invoke button  "addMenuItem" "Choose Many" merge)
   (invoke button  "addMenuItem" "Choose All" ask4all)

   (invoke ddialog "setScope" entries bases)

   ;make a  real tab via the agreed API
   (invoke ddialog "classify" "Spatial" entries  locations)
   (invoke ddialog "addTab" "Spatial")

   ;now actually build the trees 
;   (invoke ddialog "fireUpdate")
   (setAttr kb "dishEditor" ddialog)
   (invoke ddialog "setOKClosure" okClosure)

   (invoke g2d.tabwin.TabPreferences.g2d_preferences "manageJDialog" ddialog "ddialog")
   (invoke ddialog "setVisible" (boolean true))
   ))
) ;initDishEditor

(define dishMerge (frame kbname dishnames)
  (let (
        (length (lookup dishnames "length"))
        (selections (mkarray boolean length))
        (dishesSelect (object ("g2d.swing.IOPMultiSelect" 
                               frame 
                               "Dish Merge" 
                               "Select the dishes you want to include"
                               dishnames
                               selections)))
        (choices (object ("java.util.ArrayList")))
        (buffer (object ("java.lang.StringBuffer")))
        )
    
    (invoke g2d.tabwin.TabPreferences.g2d_preferences "manageJDialog" dishesSelect "dishesSelect")

    (invoke dishesSelect "show")
    
    (do 
     
     ((i (int 0) (+ i (int 1))))
     
     ((= i length) (object null))
     
     (if  (aget selections i)
         (seq
          (invoke buffer "append" (aget dishnames i))
          (invoke buffer "append" " ")
          )
       )
     )
    
    ;;(invoke java.lang.System.err "println" (invoke buffer "toString"))

    (sinvoke "g2d.util.ActorMsg" "send" "maude" kbname (concat "getDishes " buffer))
    )
  )


; maude kbname displayNewDish user-dname toks

; want to give disheditor closure to call upon exit

; (apply getDishReply %kbname %dishoccs)
;                      string String[]
(define getDishReply (kbname dishoccs)
  (let ((kb (fetch kbname))
        (editor (if (instanceof kb "g2d.jlambda.Attributable")
                    (getAttr kb "dishEditor" )
                    (object null)))
       )                
    (if (instanceof editor "g2d.subset.DDialog")
        (let ((result (invoke editor "add2Dish" dishoccs)))
;;;;09july19  editor crash
          (seq
;            (invoke editor "setVisible" (boolean true))
          (if (instanceof result "java.lang.String") 
              (apply displayMessage "Bad Maude dish component" result)	  
          	  result)
          )
        ))
  ) ;let
)



; (apply defKBManager)
; (apply defKBGraph "KB0" (array java.lang.String "occ0") (array java.lang.String "0") (array java.lang.String "Out") (array java.lang.String "1.occ.act") (array java.lang.String "1") )

; (define kbl6 (getAttr (fetch "KBManager") "kblist"))

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/info.lsp ;;;;;;;;;;
(seq
 
; *** create a string from an array of strings recursively
;     each string in array is prepended with given prefix, then the given 
;     closure <makeString> is applied (use "ident" if no change desired), 
;     and then given postfix (e.g., a newline character) is appended
; arr: Array of strings
; cur: current index in recursion
; msg: containing string assembled so far
(define printArray (arr prefix makeString postfix cur msg)
  (if (>= cur (lookup arr "length"))
      msg
      (apply printArray arr prefix makeString postfix (+ cur (int 1)) 
	     (concat msg 
		     prefix 
		     (apply makeString (aget arr cur))
		     postfix))
  )
)

; use this for "makeString" if strings in array don't need alteration
(define ident (str) str) ; identity function

;;; ------ requests from Maude -----

(define displayProteinInfo (gname hugosym spnum synonymsArray)
  (let ((message 
           (concat "Hugo: " hugosym "\n" 
                   "SwissProt ID: " spnum "\n"
                   "Synonyms: \n")))
    (apply displayMessage2G gname "ProteinInfo" 
      (apply printArray synonymsArray "    " ident "\n" (int 0) message))
   )
)

(define displayChemicalInfo (gname keggcpd synonymsArray)
  (let ((message 
           (concat "KeggCpd: " keggcpd "\n" 
                   "Synonyms: \n")))
    (apply displayMessage2G gname "ChemicalInfo" 
      (apply printArray synonymsArray "    " ident "\n" (int 0) message))
   )
)

(define displayOtherInfo (gname sort opstr)
  (let ((message 
           (concat "Sort: " sort "\n" 
                   "Occ:  " opstr "\n")))
    (apply displayMessage2G gname "OtherInfo" message)
   )
)

(define ruleEvidence (gname clab refArray)
  (apply displayMessage2G gname 
	 (concat "Evidence for Rule \"" clab "\"")
	 (if (> (lookup refArray "length") (int 0))
	     (concat "<html><br>"
       (if (= evidencePath "")
	     (apply printArray refArray "PubMed ID " makePMIDLink "<br>" (int 0)  " ")
	     (apply printArray refArray "Evidence File " makeEvidenceLink "<br>" (int 0)  " "))
		     "</html>")
	     "\n(none)"))
)
(define makePMIDLink (pmid)
  (concat "<a href=\"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids="
	  pmid
	  "&dopt=Abstract\">"
	  pmid
	  "</a>")
)

(define makeEvidenceLink (link)
  (concat "<a href=\""
    evidencePath
	  link
	  "\">"
	  link
	  "</a>")
)


)
;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/infox.lsp ;;;;;;;;;;
(seq
(define displayComponentInfo (gname clab infoArray)
  (apply displayMessage2G gname 
     (concat "About " clab )
     (let ((strb (object ("java.lang.StringBuffer"))))
      (seq 
        (invoke strb "append" "<html><br> ")
        (for item infoArray (apply makeInfoItem item strb ))
        (invoke strb "append" " </html>")
        (invoke strb "toString")
      ) ) ; seq let
  ) ; apply
)


(define makeInfoItem (item strb)
 (if (> (lookup item "length") (int 2))
  (let ((type (aget item (int 0)))
        (tag (aget item (int 1))) )
   (if (= type "val")
     (invoke strb "append" (concat tag  ": "  (aget item (int 2)) " <br><p>"))  
     (if (> (lookup item "length") (int 3))
       (if (= type "link") 
         (invoke strb "append" (concat tag  ": <a href=\""  
                                       (aget item (int 3)) "\">"
                                       (aget item (int 2)) "</a><br><p>" )) 
         (if (= type "list")
           (seq 
             (invoke strb "append" (concat tag  ": <br><ul>"))
             (apply makeListItem (aget item (int 2)) (aget item (int 3)) strb)
             (invoke strb "append" "</ul>")
            ) ; 
           "" ) ; if list
         ) ; if link
      "") ; 3x if len > 3
     ) ; if val
   ) ; let
  ) ; if len > 2
)

(define makeListItem (fun items strb)
  (for item items (invoke strb "append" (concat " <li> " item)))
)


(define displayHistory (gname hstring)
    (apply displayMessage2G gname "Exploration History" hstring)
)


(define saveHistory (gname hstring)
; ask user for filename
; output
  (let ((graph (fetch gname))
        (frame (sinvoke "g2d.pla.PLAUtils" "getTabFrame" graph))
        (chooser (object ("g2d.swing.IOPFileChooser" 
                          g2d.tabwin.TabPreferences.FC_RAW_TEXT_AREA 
                          g2d.tabwin.TabPreferences.FC_RAW_TEXT_FORMAT 
                          g2d.tabwin.TabPreferences.FC_RAW_TEXT_FILE)))
        (retval (invoke chooser "showSaveDialog" frame))
  )
  (if (= retval javax.swing.JFileChooser.APPROVE_OPTION)
     (let ((selectedFile (invoke chooser "getSelectedFile"))
           (fileName (invoke selectedFile "getName") )
       )
       (sinvoke "g2d.util.IO" "string2File" hstring fileName)
     )
   ) ;if
 )
)

) ;top seq

(seq
 (define a1 (array java.lang.String "val" "Name"  "foo"))
 (define a2 (array java.lang.String "link" "KEGG" "C00042"
                 "http://www.genome.jp/dbget-bin/www_bget?compound+C00042"))
 (define a3  (array java.lang.Object "list" "Synonyms"  ident 
              (array java.lang.String  "synonym1" "synonym2" )))
 (define iarr (array java.lang.Object a1 a2 a3))
 (define s1 "Name: foo <br><p>")
 (define s2 (concat "KEGG: "
  "<a href=\"http://www.genome.jp/dbget-bin/www_bget?compound+C00042\">"
	  "C00042 </a>" "<br><p>"
	))
 (define s3 "Synonyms: <br> <ul> <li> s1 <li> s2 </ul><br>")
 (define msg (concat "<html><br> " s1 s2 s3 " </html>"))
)
; (apply displayComponentInfo "graph4" "something" iarr)




;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/nodeColoring.lsp ;;;;;;;;;;
(define defaultFillColor java.awt.Color.white)

;; 19jan15 clt coloring no evidence rules
(define noEvRuleFillColor java.awt.Color.yellow)
(define xselectedRuleFillColor java.awt.Color.yellow)
;; (define ruleFillColor java.awt.Color.lightGray)
;; ltyellow
(define noEvRuleFillColor (object ("java.awt.Color" (int 251) (int 255) (int 145))))

(define isNoEvLab (clab)
  (let ((parts (invoke clab "split" "\\."))
        (rnum (if (> (lookup parts "length") (int 0))
                (aget parts (int 0)) ""))
        )
    (invoke rnum "endsWith" "n")
))

(define colorPnetNode (node)
  (let ((type (getAttr node "type" ""))
        (context? (getAttr node "context" ""))
       )
    (if (= context? "true") cxtFillColor
    (if (= type "occ")    (apply colorPnetOccNode node)
    (if (= type "rule")    (apply colorPnetRuleNode node)
     java.awt.Color.white
    )))
  )
)


(define colorPnetOccNode (node)
  (let ((init (getAttr node "init" ""))
        (status (getAttr node "status" "none"))
        )
    (if (= status "subgraph") subgraphFillColor
      (if (= status "goal")     goalFillColor
	(if (= status "avoid")    avoidFillColor
	  (if (= status "pair")   pairFillColor
	    (if (= init "true")       initFillColor
	      noneFillColor
	      )))))  ; ifs
    ) ; let
  )
; trying coloring init with status
;    if (= status "none")  noneFillColor

;; 19jan15 coloring no evidence rules
(define colorPnetRuleNode (node)
  (let ((status (getAttr node "status" "none")))
    (if (= status "subgraph") subgraphFillColor
      (if (= status "none")
        (if (apply isNoEvLab (getAttr node "chattylabel" "."))
        noEvRuleFillColor
        ruleFillColor)
	(if (= status "pair")   pairFillColor
	  (if (= status "avoid")    avoidFillColor
      (if (apply isNoEvLab (getAttr node "chattylabel" "."))
      noEvRuleFillColor
      ruleFillColor)

	    ))))  ;  ifs
      ) ; let
    )


(define _colorPnetRuleNode (node)
  (let ((status (getAttr node "status" "none")))
    (if (= status "subgraph") subgraphFillColor
      (if (= status "none")     ruleFillColor
	(if (= status "pair")   pairFillColor
	  (if (= status "avoid")    avoidFillColor
	    ruleFillColor
	    ))))  ;  ifs
      ) ; let
    )

(define colorXnetNode (node)
   (let ((type (getAttr node "type" ""))
         (context? (getAttr node "context" ""))
         )
    (if (= context? "true") cxtFillColor
    (if (= type "occ")    (apply colorXnetOccNode node)
    (if (= type "rule")    (apply colorXnetRuleNode node)
     java.awt.Color.white
    )))
  )
)


;; 19jan15 coloring no evidence rules
(define colorXnetRuleNode (node)
  (if (=  (getAttr node "xselect" "none") "none")
    (if (apply isNoEvLab (getAttr node "chattylabel" "."))
      noEvRuleFillColor
      ruleFillColor)
    xselectedRuleFillColor )
)

(define _colorXnetRuleNode (node)
  (if (=  (getAttr node "xselect" "none") "none")
     ruleFillColor
     java.awt.Color.yellow )
)

(define colorXnetOccNode (node)
   (if (not (= (getAttr node "xselect" "none") "none"))
    ;; dispatch on selection mode
     java.awt.Color.yellow
   ;; dispatch on xstatus
    (let ((xstatus (getAttr node "xstatus" "none")))
     (if (= xstatus "seen") java.awt.Color.lightGray
     (if (= xstatus "oup") initFillColor
     (if (= xstatus "odn") java.awt.Color.green
     (if (= xstatus "oboth") java.awt.Color.cyan
      java.awt.Color.white
      )))) ; 4x if xstatus
     ) ;let
   )  ; if selected
)


(define colorCnetNode (node)
  (let ((compare (getAttr node "compare" "both"))
         (context? (getAttr node "context" ""))
         )
    (if (= context? "true") cxtFillColor
    (if (= compare "left")  initFillColor  ; parent
    (if (= compare "right")
      (object ("java.awt.Color" (int 0) (int 255) (int 255)))
;;      java.awt.Color.white
      java.awt.Color.pink
     )) )
    ) ; let
)


(apply logDev  "nodeColoring.lsp loaded")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/askrmp.lsp ;;;;;;;;;;
/*
import rmp.Model;
import rmp.ParserJSON;
import rmp.PathList;
import rmp.PathListOperations;
import rmp.RMPHelper;
import rmp.HideEdges;

(define home (sinvoke "java.lang.System" "getProperty" "user.home"))
(define devpath (concat home "/Repositories/DevIOP/JLIbraries/" ))
(load (concat devpath "jl-util.lsp"))
(load (concat devpath "json-util.lsp"))

(define hnet (apply readJSonF  "hras-subnet.json"))
(define hnet2 (apply readJSonF  "hras-subnet2.json"))
(define hrules (apply readJSonF "rules.json"))

(define hmodel2 (sinvoke "rmp.ParserJSON" "parse" hrules hnet2))
(define hpaths2 (sinvoke "rmp.RMPHelper" "compute" hmodel2 (object null) (boolean true) (boolean true) (boolean true) ))

(sinvoke "rmp.PathListOperations" "essentialTransitions" hmodel2 hpaths2)
(sinvoke "rmp.PathListOperations" "usedPlaces" hmodel2 hpaths2)
(sinvoke "rmp.PathListOperations" "knockouts" hmodel2 hpaths2)
(sinvoke "rmp.PathListOperations" "pathsUsingPlace" hmodel2 hpaths2 "Grb2@CLc")
(sinvoke "rmp.PathListOperations" "pathsUsingPlace" hmodel2 hpaths2 "PIP2@CLm" )

*/

                                        ;(define debugRMP (boolean true))
(define debugRMP (boolean false))


;;2/15/2017 added graph arg so we could use the requestArgsObj field of the
;;PLAGraph attribute.
(define parseArgs (query graph)
  (let ((plaobj (sinvoke "g2d.pla.PLAGraph" "getPLAGraph" graph (object null)))
        (requestArgsObj (lookup plaobj "requestArgsObj")))
    ;;(invoke java.lang.System.err "println" requestArgsObj)
    (if (instanceof requestArgsObj "g2d.pla.requestargs.NetRequestArgs")
        (apply mkTriple
               (lookup requestArgsObj "goals")
               (lookup requestArgsObj "avoids")
               (lookup requestArgsObj "hides"))
      (apply mkTriple (apply mkMt)(apply mkMt)(apply mkMt))
      )
    )
  )

;;;old version: delete when so inclined.
(define _parseArgs (query)
  (let (
        (patternstring "goals\\s(.*)\\s*avoids\\s(.*)\\s*hides\\s(.*)\\s*")
        (pattern (sinvoke "java.util.regex.Pattern" "compile" patternstring))
        (matcher (invoke pattern "matcher" query))
        )
    (if (invoke matcher "matches")
        (let (
              (goalss (invoke (invoke matcher "group" (int 1)) "trim"))
              (avoidss (invoke (invoke matcher "group" (int 2)) "trim"))
              (hidess (invoke (invoke matcher "group" (int 3)) "trim"))
              (goals (if (= goalss "") (apply mkMt) (apply toArrl (invoke goalss "split" "[ ]+"))))
              (avoids (if (= avoidss "") (apply mkMt) (apply toArrl (invoke avoidss "split" "[ ]+"))))
              (hides (if (= hidess "") (apply mkMt) (apply toArrl (invoke hidess "split" "[ ]+"))))
              )
          (apply mkTriple goals avoids hides)
          )
      (apply mkTriple (apply mkMt)(apply mkMt)(apply mkMt))
      )
    )
  )


/*

{"stype" : "jnet",
"name" : "hras-subnet2",
"type" : "pnet",
"kbname" : "RKB",
"parent" : "pnet9",
"rids" : ["1.EgfR.act", "1.EgfR.act#1", "5.Grb2.reloc", "5.Grb2.reloc#1", "13.Sos1.reloc", "12.Sos1.reinit", "12.Sos1.reinit#1", "4.Gab1.Yphosed", "4.Gab1.Yphosed#1", "8.Pi3k.act", "9.PIP3.from.PIP2.by.Pi3k", "6.Hras.act.1"],
"init" : ["Egf@XOut", "EgfR@CLm", "Sos1@CLc", "Gab1@CLc", "Grb2@CLc", "Pi3k@CLc", "Tgfa@XOut", "PIP2@CLm", "Hras-GDP@CLi"],
"op" : "subnet",
"args" : {"goals": ["Hras-GTP@CLi"],"avoids": [],"hides": [],}

(requestor (getAttr graph "requestor"))
(requestop (getAttr graph "requestop"))
(requestargs (getAttr graph "requestargs")))
goals occ1 ... occn avoids occ1 ...occm hides rid1 ... ridl

(= requestop "subnet")
(gname1 requestor)
*/

;; for subnet graphs only
(define ensureSubnet (graph)
  (let ((snet0 (getAttr graph "jnet"))
	(snet (if (isobject snet0) snet0 (apply addJSubnet graph)))
	)
    snet
    ))

(define getInitNames (graph)
  (let ((nodes (invoke graph "getNodesInArray"))
	(res (apply mkMt))
	)
    (for nd nodes
	 (if (and (= (getAttr nd "type" "") "occ")
		  (= (getAttr nd "init" "") "true"))
	     (invoke res "add" (getAttr nd "chattylabel" "")) ))
    res
    ))

(define getRuleNames (graph)
  (let ((nodes (invoke graph "getNodesInArray"))
	(res (apply mkMt))
	)
    (for nd nodes
	 (if (= (getAttr nd "type" "") "rule")
	     (invoke res "add" (getAttr nd "chattylabel" "")) ))
    res
    ))


(define addJSubnet (graph)
  (let ((jnet (object ("java.util.HashMap")))
        (args (object ("java.util.HashMap")))
        (requestor (getAttr graph "requestor"))
        (requestop (getAttr graph "requestop"))
        (requestargs (getAttr graph "requestargs"))
	(arglists (apply parseArgs requestargs graph))
	(init (apply getInitNames graph))
	(rids (apply getRuleNames graph)))

    (invoke args "put" "goals" (invoke arglists "get" (int 0)))
    (invoke args "put" "avoids" (invoke arglists "get" (int 1)))
    (invoke args "put" "hides" (invoke arglists "get" (int 2)))
    (invoke jnet "put" "stype" "jnet")
    (invoke jnet "put" "name" (getUID graph))
    (invoke jnet "put" "kbname" (getAttr graph "kbname"))
    (invoke jnet "put" "parent" requestor)
    (invoke jnet "put" "rids" rids)
    (invoke jnet "put" "init" init)
    (invoke jnet "put" "op" requestop)
    (invoke jnet "put" "args" args)
    (setAttr graph "jnet" jnet)
    jnet
    )
  )


(define ensureRMPModel (graph)
  (let ((rmpModel0 (getAttr graph "rmpModel"))
        (rmpModel (if (isobject rmpModel0)
                      rmpModel0
                    (apply generateRMPModel graph)))
        )
    rmpModel
    ))

;; ArrayList<Path>
;; is there some reason to override the ArrayList methods
;; contains, get, size,
;; Path (transitions :: bitmask, cardinalities :: ArrayList<Tuple>
;; Tuple (transID :: int, card :: int)
(define ensureAllPaths (graph)
  (let ((rmpAllPaths0 (getAttr graph "rmpAllPaths"))
        (rmpAllPaths (if (isobject rmpAllPaths0)
                         rmpAllPaths0
                       (apply generateRMPAllPaths graph)))
        )
    rmpAllPaths
    ))


(define getJrules (graph)
  (let ((kbname (getAttr graph "kbname" ""))
	(kb (fetch kbname))
	(jkb (if (isobject kb)
		 (getAttr kb "jkb")
	       (object null)))
	(jrules (if (isobject jkb)
		    (getAttr jkb "jrules" (apply mkMtMap))
		  (apply mkMtMap) ))
	)
    jrules
    ))

(define generateRMPModel (graph)
  (let ((jnet (apply ensureSubnet graph))
        (rules (apply getJrules graph))
        (model (sinvoke "rmp.ParserJSON" "parse" rules jnet))
        )
    (setAttr graph "rmpModel" model)
    model
    ))

;;compute(Model model, String algorithm,
;;   boolean approximateMinimality,
;;      boolean hideEdges, boolean debug)
;; algorithm is one of null, "stub", "stub_alt", "dep"

(define generateRMPAllPathsAlgorithm "dep")

;; 15aug15 clt dep >> stub -- dep has bug
(define generateRMPAllPaths (graph)
  (let ((model (apply ensureRMPModel graph))
        (paths (sinvoke "rmp.RMPHelper" "compute" model generateRMPAllPathsAlgorithm
                        (boolean true) (boolean true) debugRMP))
        )
    (setAttr graph "rmpAllPaths" paths)
    paths
    ))

(define rmpQueries
  (apply toArrl
	 (array java.lang.String
		"essentialTransitions"      ;; ArrayList<String> rulenames
		"essentialTransitionPairs"  ;; ArrayList<TransitionPair>
		"usedPlaces"                ;; ArrayList<String>  used occnames
		"knockouts"                 ;; ArrayList<String>  essential occnames
		"doubleKnockouts"           ;; ArrayList<PlacePair>  occnames
		)))


;; pairs  lookup t1,t2

(define askAllPaths (graph query)
  (let ((model (apply ensureRMPModel graph))
        (paths (apply ensureAllPaths graph)))
    (if (isobject paths)
	(if (= query "count")
	    (seq
	     ;;(invoke java.lang.System.err "println" (concat "paths: " (invoke paths "toString" model)))
	     (invoke paths "size")
	     )
	  (sinvoke "rmp.PathListOperations" query model paths)
	  )
      )
    )
  )

;; pathsUsingPlace rmp.PathList
(define askAllPaths2 (graph query arg)
  (let ((model (apply ensureRMPModel graph))
        (paths (apply ensureAllPaths graph))
        (res (sinvoke "rmp.PathListOperations" query model paths arg))
        )
    res
    ))



/*
(sinvoke "rmp.PathListOperations" "essentialTransitions" hmodel2 hpaths2)
(sinvoke "rmp.PathListOperations" "usedPlaces" hmodel2 hpaths2)
(sinvoke "rmp.PathListOperations" "knockouts" hmodel2 hpaths2)
(sinvoke "rmp.PathListOperations" "pathsUsingPlace" hmodel2 hpaths2 "Grb2@CLc")
*/
;; hideedges arraylist [transid, ctl] -- edge to hide

;;      ArrayList<HideEdgeTuple> lookup "transitionID", "placeID"
;; (sinvoke "rmp.HideEdges" "computeHideableEdges" model)
/*
(load "/Users/clt/Repositories/DevIOP/JLibraries/jl-util.lsp")
(load "../../PLALib/G2D/rmptest.lsp")
(define g4 (fetch "graph4"))
g4
(define rm4 (apply ensureRMPModel g4))
(define paths4 (apply ensureAllPaths g4))

(define res0 (apply askAllPaths g4 (invoke rmpQueries "get" (int 0))))
(define res1 (apply askAllPaths g4 (invoke rmpQueries "get" (int 1))))
res1
(define res2 (apply askAllPaths g4 (invoke rmpQueries "get" (int 2))))
res2
(define res3 (apply askAllPaths g4 (invoke rmpQueries "get" (int 3))))
res3
(define res4 (apply askAllPaths g4 (invoke rmpQueries "get" (int 4))))
res4
(define res5 (apply askAllPaths2 g4 (invoke rmpQueries "get" (int 5)) "Grb2@CLc"))
res5

*/

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/rmp.lsp ;;;;;;;;;;

(define mkRmpMenuItem (string closure)
  (let ((item (object ("javax.swing.JMenuItem"  string)))
        (cacl (if g2d.pla.PLA.developmental
                  (object ("g2d.closure.SpawningClosureActionListener" closure))
                (object ("g2d.closure.ClosureActionListener" closure))))
        )
    (seq
     (invoke item "addActionListener" cacl)
     item
     )
    )
  )

(define RMPTabName "RMP")
(define PathTabName "Paths")
(define PairTabName "Pairs")

(define rmpDescriptions
  (array java.lang.String
         "The number of paths"
         "Essential Transitions"
         "Essential Transition Pairs"
         "Used Occurences"
         "Single Knockouts"
         "Double Knockouts"
         (object null)))

(define printRMPResult (panel label result)
  (let ((sepanel (invoke panel "getSEPanel"))
        (sb (object ("java.lang.StringBuffer"))))
    (for item result
         (invoke sb "append" item)
         (invoke sb "append" "\n"))
    (invoke sepanel "displayText"  label (invoke sb "toString"))))

(define nodeList2RMPTab (result graph panel title)
  (let ((sepanel (invoke panel "getSEPanel"))
        (rmptab (invoke sepanel "getTab" RMPTabName))
        (nodelist (apply path2nodeList result graph)))
    (invoke rmptab "setRange" nodelist)
    (invoke rmptab "setDescription" title)
    (invoke sepanel "selectTab" RMPTabName)
    )
  )

(define path2nodeList (path graph)
  (let ((nodelist (object ("java.util.ArrayList"))))
    (for longname path
         (let ((iopnode (invoke graph "getIOPNode" longname)))
           (if (isobject iopnode) (invoke nodelist "add" iopnode))))
    nodelist
    )
  )

(define toDisplayString (graph pathlist)
  (let ((model (apply ensureRMPModel graph))
        (paths (invoke pathlist "getPaths" model))
        (sb (object ("java.lang.StringBuffer"))))
    (for index (invoke paths "size")
         (invoke sb "append" (concat "\nPath " index ":\n"))
         (for transition (invoke paths "get" index)
              (invoke sb "append" transition)
              (invoke sb "append" "\n")))
    (invoke sb "toString"))
  )

(define result2PathTab (result graph sepanel name)
  (let ((description (concat "Paths using " name))
        (model (apply ensureRMPModel graph))
        (paths (invoke result "getPaths" model))
        (pathtab (invoke sepanel "getTab" PathTabName)))
    (invoke pathtab "setPaths" description paths)
    (invoke sepanel "selectTab" PathTabName)
    )
  )

(define result2PairTab (result graph sepanel title index)
  (let ((list (object ("java.util.ArrayList")))
        (pairtab (invoke sepanel "getTab" PairTabName)))
    (for pair result
         (invoke list "add" (lookup pair "t1"))
         (invoke list "add" (lookup pair "t2"))
         )
    (invoke pairtab "setPairs" title list)
    (invoke sepanel "selectTab" PairTabName)
    )
  )



(define handleRMPResult (result graph panel query name index)
  (if (not (isnull result))
      (let ((sepanel (invoke panel "getSEPanel"))
            (title (aget rmpDescriptions index)))
        (if (= index (int 0))
            (let ((title (aget rmpDescriptions index))
                  (answer (concat "There are " result " paths.")))
              (invoke sepanel "displayText"  title answer)
              )
          (if (or (= index (int 1))  (= index (int 3)) (= index (int 4)))
              (apply nodeList2RMPTab result graph panel title)
            (if (or (= index (int 2)) (= index (int 5)))
                (apply result2PairTab result graph sepanel title index)
              (if (= index (int 6))
                  (apply result2PathTab result graph sepanel name)
                (invoke java.lang.System.err "println" (concat "Oooops: handleRMPResult got a mysterious index: " index))
                )
              )
            )
          )
        )
    )
  )


(define choices2PathTab (graph panel choice)
  ;;(invoke java.lang.System.err "println" choice)
  (let ((model (apply ensureRMPModel graph))
        (allpaths (apply ensureAllPaths graph))
        (pathlist (sinvoke "rmp.PathListOperations" "pathsUsingPlaces" model allpaths choice))
        (paths (invoke pathlist "getPaths" model))
        (description (concat "Paths using " choice))
        (sepanel (invoke panel "getSEPanel"))
        (pathtab (invoke sepanel "getTab" PathTabName)))
    (invoke pathtab "setPaths" description paths)
    (invoke sepanel "selectTab" PathTabName)
    )
  )

(define rmpPathChooser  (graph panel)
  (let (
        (frame (sinvoke "g2d.pla.PLAUtils" "getTabFrame" graph))
        (occs (apply getOccsFromGraph graph (boolean true)))
        (count (invoke occs "size"))
        (labels (let ((labels (mkarray java.lang.String count)))
                  (for i count (aset labels i (lookup (invoke occs "get" i) "longName")))
                  labels))
        (selections (mkarray boolean (lookup labels "length")))
        (choice (object ("java.util.ArrayList")))
        (title "Paths Chooser")
        (label "Choose paths that use ...")
        (list (object ("g2d.swing.IOPMultiSelect" frame title label labels selections))))
    (seq
     (invoke list "show")
     (for i count
          (if (aget selections i)
              (invoke choice "add" (aget labels i))))
     (apply choices2PathTab graph panel choice)
     )
    )
  )





(define mkRmpMenuItemClosure (graph panel query index)
  (lambda (self event)
    (if (invoke graph "isDotLayout")
        (if (or (= query "knockouts") (= query "inhibits"))
            (let ((kos (apply askAllPaths graph "knockouts"))
                  (jnet (apply ensureSubnet graph))
                  (inits (invoke jnet "get" "init"))
                  (args (invoke jnet "get" "args"))
                  (goals (if (isobject "args") (invoke args "get" "goals") (apply mkMt))))
              (if (= query "knockouts")
                  (let ((result (apply intersect kos inits)))
                    (apply handleRMPResult result graph panel "knockouts" (object null) index)
                    )
                (let ((result (apply diff (apply diff kos inits) goals)))
                  (apply handleRMPResult result graph panel "knockouts" (object null) index)
                  )
                )
              )
          (if (= index (int 7))
              (apply rmpPathChooser graph panel)
            (let ((result (apply askAllPaths graph query)))
              (apply handleRMPResult result graph panel query (object null) index)
              )
            )
          )
      (apply displayMessage "Alert" "Cannot do path analysis when displaying in context!")
      )
    )
  )


(define mkRmpMenuItem6Closure (graph panel query name)
  (lambda (self event)
    (if (invoke graph "isDotLayout")
        (let ((result (apply askAllPaths2 graph query name)))
          (apply handleRMPResult result graph panel query name (int 6))
          )
      (apply displayMessage "Alert" "Cannot do path analysis when displaying in context!")
      )
    )
  )


(define rmpFeatures (graph panel)
  (let ((requestop (getAttr graph "requestop"))
        (requestargs (getAttr graph "requestargs"))
        (parsedargs (apply parseArgs requestargs graph))
        (goals (invoke parsedargs "get" (int 0))))
    (if (and (= requestop "subnet") (> (invoke goals "size") (int 0)))
        (let ((sepanel (invoke panel "getSEPanel"))
              (rmptab (object ("g2d.pla.SearchTabita" RMPTabName panel)))
              (pathtab (object ("g2d.pla.PathTab" graph)))
              (pairtab (object ("g2d.pla.PairTab" graph)))
              (menuBar (lookup panel "menuBar"))
              (rmpMenu (object ("javax.swing.JMenu" "Path Analysis")))
              (menuItem0C (apply mkRmpMenuItemClosure graph panel  "count" (int 0)))
              (menuItem0 (apply mkRmpMenuItem "Number of Paths" menuItem0C))
              (menuItem1C (apply mkRmpMenuItemClosure graph panel  "essentialTransitions" (int 1)))
              (menuItem1 (apply mkRmpMenuItem "Essential Transitions" menuItem1C))
              (menuItem2C (apply mkRmpMenuItemClosure graph panel  "essentialTransitionPairs" (int 2)))
              (menuItem2 (apply mkRmpMenuItem "Essential Transitions Pairs" menuItem2C))
              (menuItem3C (apply mkRmpMenuItemClosure graph panel  "usedPlaces" (int 3)))
              (menuItem3 (apply mkRmpMenuItem "Used Occurrences" menuItem3C))
              (menuItem4Cb (apply mkRmpMenuItemClosure graph panel  "knockouts" (int 4)))
              (menuItem4b (apply mkRmpMenuItem "Single Bio-Knockouts" menuItem4Cb))
              (menuItem4Ci (apply mkRmpMenuItemClosure graph panel  "inhibits" (int 4)))
              (menuItem4i (apply mkRmpMenuItem "Single Inhibition-Targets" menuItem4Ci))
              (menuItem5C (apply mkRmpMenuItemClosure graph panel  "doubleKnockouts" (int 5)))
              (menuItem5 (apply mkRmpMenuItem "Double Knockouts" menuItem5C))
              (menu6 (object ("javax.swing.JMenu" "Paths using occurrence")))
              (menuItem7C (apply mkRmpMenuItemClosure graph panel  "doubleKnockouts" (int 7)))
              (menuItem7 (apply mkRmpMenuItem "Custom Path Chooser" menuItem7C))
              )
          (apply populateMenu6 menu6 graph panel )
          (invoke rmpMenu "add" menuItem0)
          (invoke rmpMenu "add" menuItem1)
          (invoke rmpMenu "add" menuItem2)
          (invoke rmpMenu "add" menuItem3)
          (invoke rmpMenu "add" menuItem4b)
          (invoke rmpMenu "add" menuItem4i)
          (invoke rmpMenu "add" menuItem5)
          (invoke rmpMenu "add" menu6)
          (invoke rmpMenu "add" menuItem7)
          (invoke menuBar "add" rmpMenu)
          (invoke sepanel "addTab" RMPTabName rmptab)
          (invoke sepanel "addTab" PathTabName pathtab)
          (invoke sepanel "addTab" PairTabName pairtab)
          )
      )
    )
  )

(define getOccsFromGraph (graph sort)
  (let ((occs (object ("java.util.ArrayList")))
        (nodes (invoke graph "getNodesInArray")))

    (for node nodes
         (if (= (lookup node "type") g2d.graph.IOPNode$NodeType.OCC)
             (invoke occs "add" node)))

    (if sort
        (sinvoke "java.util.Collections" "sort"  occs  g2d.graph.IOPNode.OCC_COMPARATOR)
      )

    occs)
  )


(define populateMenu6 (menu6 graph panel )
  (let ((occs (apply getOccsFromGraph graph (boolean true))))
    (for occ occs
         (let ((name (lookup occ "longName"))
               (mic (apply mkRmpMenuItem6Closure graph panel  "pathsUsingPlace" name))
               (mi (apply mkRmpMenuItem name mic)))
           (invoke menu6 "add" mi)
           )
         )
    )
  )

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/defineGraph.lsp ;;;;;;;;;;
;; functions to define / update graphs
;; needs nodeColoring.lsp

(define setAttrsAVX (obj tags vals)
  (let ((tlen (lookup tags "length"))
        (vlen (lookup vals "length"))
        (len (if (> tlen vlen) vlen tlen))
      )
  (apply setAttrsAV obj tags vals len (int 0))
  )
)

(define setAttrsAV (obj tags vals len cur)
  (if (>= cur len)
   obj
   (seq
    (setAttr obj (aget tags cur) (aget vals cur))
    (apply setAttrsAV obj tags vals len (+ cur (int 1)))))
)

;; deprecated
(define extendSEMenu (graph  clist)
  (let (
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (sep (invoke panel "getSEPanel"))
        )
    (seq
;    (invoke java.lang.System.err "println"  "extendingSEMenu")
     (invoke sep "displayMenu" "" clist (object null) (boolean false))
  )
))


;;!!! can be eliminated
(define mkXOccCheckClosure (panel node cb clist mode)
  (lambda (self e)
     (let ((checked? (invoke cb "isSelected"))
           (xstatus (getAttr node "xstatus" "none"))
           (bordercolor (if checked? java.awt.Color.red nodeBorderColor))
          )
      (seq
        (setAttr node "xselect" (if checked? mode "none"))
        (if checked?
           ; disable others
           (for cb1 clist 
             (if (not (= cb1 cb)) (invoke cb1 "setEnabled" (boolean false))) )
           ; enable all
           (for cb1 clist (invoke cb1 "setEnabled" (boolean true) ))
         )
        (invoke node "setFillColor" (apply colorXnetNode node)) 
        (invoke node "setBorderColor" bordercolor) 
        (invoke panel "repaint")
     )))  ; seq let lambda
)

;;used in the subgraph tab; name is hard coded so change it and break it.
(define subgraph2Node (graph type lab)
  (let ((colorFun (getattr graph "colorFun"))
	(mouseClickedClosure (lookup graph "mouseClickedClosure"))
	(mtarray (array java.lang.Object))
	(node (if (= type "occ")
		  (apply newOccNode graph mouseClickedClosure (object null) lab lab mtarray mtarray colorFun)
		(apply newRuleNode graph mouseClickedClosure (object null) lab lab mtarray mtarray colorFun))))
    (setattr node "graph" graph)
    node
    )
  )

(define newNode (graph type mouseClickedClosure nid lab clab tags vals colorFun)
  (if (= type "occ")
    (apply newOccNode graph mouseClickedClosure nid lab clab tags vals colorFun)
    (if (= type "rule")
      (apply newRuleNode graph mouseClickedClosure 
                         nid lab clab tags vals colorFun)
      (object null)
    )) ; 2x if
)

;;; clt added for shape hack 15aug06
(define getSort (graph clab)
  (let ((kbname0 (getAttr graph "kbname"))
	(kbname (if (isnull kbname0) "RKB" kbname0))
	(jkb (getAttr (fetch kbname) "jkb"))
        (occmap (lookup jkb "occmap"))				
        (occ (invoke occmap "get" clab))
	)
    (if (isobject occ)
	(if (instanceof occ "bp2pl.ComplexOccurrence")
	    "Complex"
	  (let ((entity (lookup occ "eref"))
		(metadata (getAttr entity "metadata"))
		(sort (invoke metadata "get" "sort"))
      		)
	    (if (isobject sort) sort "Protein")))
      "Protein"
      )
    )
  )

(define setPreferences (kbname fname)
  (let ((kb (fetch kbname))
        (prefs (apply readJSonF fname))
      	)
   (if (instanceof prefs "java.util.Map")
	    (setAttr kb "preferences" prefs)
 	 )))


;;; clt added shape hack 15auag06
(define newOccNode (graph mouseClickedClosure nid lab clab tags vals colorFun)
  (let ((label (if useChattyLabels
                   clab
		 (if (> (invoke lab "length") maxLabLen)
		     (invoke lab "substring" (int 0) maxLabLen) 
		   lab)
		 ))
        (kbname (getAttr graph "kbname"))
	(kb (if (isnull kbname) (object null) (fetch kbname)))
	(prefs (if (isobject kb) 
		   (getAttr kb "preferences" (apply mkMtMap)) 
		 (apply mkMtMap)))
        (sort  (apply getSort graph clab))
        (sprefs (apply dget prefs sort (apply mkMtMap)))
	(shape (apply dget sprefs "shape" "ellipse"))
	(perimstr (apply dget sprefs "perims" "1"))
	(perims (sinvoke "java.lang.Integer" "parseInt" perimstr))
        (nattrs (object ("g2d.graph.DotNodeAttributes" label shape  nodeBorderColor defaultFillColor perims)))
        (node (sinvoke "g2d.graph.IOPNode" "makeOcc" nid lab clab nattrs))
        ) 
    (seq 
     (setAttr node "type" "occ")
     (setAttr node "nid" nid)
     (setAttr node "chattylabel" clab)
     (setAttr node "label" lab)
     ;(invoke node "setBaseDimension" (double 10) (double 10))
     (apply setAttrsAVX node tags vals)
     (invoke node "setFillColor" (apply colorFun node))

     (invoke node "setLabel" (if useChattyLabels clab lab))

     (if (instanceof mouseClickedClosure "g2d.jlambda.Closure")
          (invoke node "setMouseAction"
                  java.awt.event.MouseEvent.MOUSE_CLICKED mouseClickedClosure)
      )
     (invoke graph "addNode" node)
     node))
) ;newOccNode


; add a rule node to given graph
(define newRuleNode (graph mouseClickedClosure nid lab clab tags vals colorFun)
  (let (
        (nattrs (object ("g2d.graph.DotNodeAttributes" lab "box"  nodeBorderColor defaultFillColor (int 1))))
        (node (sinvoke "g2d.graph.IOPNode" "makeRule" nid lab clab nattrs))
        )
    (seq 
     (setAttr node "type" "rule")
     (setAttr node "nid" nid)
     (setAttr node "chattylabel" clab)
     (setAttr node "label" lab)
     ;(invoke node "setBaseDimension" (double 10) (double 10))
     ;(invoke node "setLabel" lab)
     ;
     ;<fun zone>
;     (invoke nattrs "setDotAttribute" g2d.graph.DotAttributes.SHAPE  "triangle") 
;     (invoke nattrs "setDotAttribute" g2d.graph.DotAttributes.ORIENTATION  (double 180.0)) 
;     (invoke nattrs "setDotAttribute" g2d.graph.DotAttributes.SIDES  (int 3)) 
;     (invoke nattrs "setDotAttribute" g2d.graph.DotAttributes.FONTSIZE  (int 3)) 
     ;</fun zone>
    
     (apply setAttrsAVX node tags vals)

     (invoke node "setFillColor" (apply colorFun node))

     (if (instanceof mouseClickedClosure "g2d.jlambda.Closure")
         (invoke node "setMouseAction"
                 java.awt.event.MouseEvent.MOUSE_CLICKED mouseClickedClosure))
     (invoke graph "addNode" node) 
     node))
  ) ;newRuleNode

; add a node to given explore graph
(define newXNode (graph type mouseClickedClosure nid lab clab tags vals colorFun)
  (if (invoke graph "isDotLayout")
    (apply newNode graph type mouseClickedClosure 
                   nid lab clab tags vals colorFun)
    (let ((node (invoke graph "getIOPNode" clab)))
      (if (instanceof node "g2d.graph.IOPNode")
        (seq 
          (apply setAttrsAVX node tags vals)
          (setAttr node "context" (object null))
          (invoke node "setFillColor" (apply colorFun node))
          (invoke node "setBorderColor" nodeBorderColor)
          (if (instanceof mouseClickedClosure "g2d.jlambda.Closure")
              (invoke node "setMouseAction"
                  java.awt.event.MouseEvent.MOUSE_CLICKED mouseClickedClosure))
          node
         )
        ;; shouldn't happen
          (apply newNode 
                 graph type mouseClickedClosure nid lab clab tags vals colorFun)
      ) ; if IOPNode 
     ) ;let
  ) ; if isDot
)

(define updateXNode (graph nid xstatus colorFun)
  (let ((node (invoke graph "getNode" nid)))
  (seq
    (setAttr node "xselect" "none")
    (setAttr node "xstatus" xstatus)
    (invoke node "setFillColor" (apply colorFun node))
 ))
)        

(define newEdge (graph srcid tgtid bidir?)
  (let ((src (invoke graph "getNode" srcid))
        (tgt  (invoke graph "getNode" tgtid))
        (color (if (= bidir? "true") bidirEdgeColor  unidirEdgeColor))
        (e (object ("g2d.graph.IOPEdge" src tgt color))) )
    (seq 
      ; can replace "dashed" by "dotted"
     (if (= bidir? "true")  (invoke e "setStyle" "dashed"))
     (invoke e "setDoubleEnded" (boolean false)) 
     (setAttr e "bidir" bidir?)
     (invoke graph "addEdge" e)
     e))
) ;newEdge

(define newXEdge (graph srcid tgtid bidir?)
  (if (invoke graph "isDotLayout")
    (apply newEdge graph srcid tgtid bidir?)
    (let ((edge (invoke graph "getEdge"
                    (invoke graph "getNode" srcid)
                    (invoke graph "getNode" tgtid))
                 )
          )
      (if (instanceof edge "g2d.graph.IOPEdge")
          (seq (setAttr edge "context" (object null)) 
               (invoke edge "setColor" 
                      (if (= bidir? "true") bidirEdgeColor  unidirEdgeColor))
               edge)
          ;; shouldn't happen
          (apply newEdge graph srcid tgtid bidir?)
     ) ; if edge
   ) ; let
  ) ; if Dot
)

; remove a node from a given explore graph
(define delXNode (graph  nid)
  (let ((node  (invoke graph "getNode" nid)))
    (if (instanceof node "g2d.graph.IOPNode")
      (if (invoke graph "isDotLayout")
          (invoke graph "rmNode" node)
          (seq (setAttr node "context" "true")
               (setAttr node "xselect" "none")
               (invoke node "setFillColor" cxtFillColor)
               (invoke node "setBorderColor" cxtBorderColor)
               (invoke node "unsetMouseAction" 
                              java.awt.event.MouseEvent.MOUSE_CLICKED )
          )
      ) ; if isDot
    ) ; if IOPNode 
  ) ;let
)

; remove a node from a given explore graph
(define delXEdge (graph  srcid tgtid)
  (let ((edge (invoke graph "getEdge"
                     (invoke graph "getNode" srcid)
                     (invoke graph "getNode" tgtid)) )
        )
    (if (instanceof edge "g2d.graph.IOPEdge")
      (if (invoke graph "isDotLayout")
          (invoke graph "rmEdge" edge)
          (seq (setAttr edge "context" "true")
               (invoke edge "setColor" cxtBorderColor))          
      ) ; if isDot
    ) ; if IOPEdge
  ) ;let
)


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/showGraph.lsp ;;;;;;;;;;
;;op is dishnet pathnet subnet compare explore
;;

(define makeGraphTitle (gname graph)
  (let (
	(contention ":")
	(requestor (getAttr graph "requestor"))
	(requestop (getAttr graph "requestop"))
	(requestargs (getAttr graph "requestargs")))
    (if (= requestop "dishnet")
	(concat gname contention requestargs)
      (if (= requestop "subnet")
	  (concat gname contention "S(" requestor ")")
        (if (= requestop "pathnet")
            (concat gname contention "P(" requestor ")")
          (if (= requestop "explore")
              (concat gname contention "E(" requestor ")")
	    (if (= requestop "compare")
		(concat gname contention "C(" requestor "," requestargs ")")
	      "Mystery")))))
    )
  )

(define getGraphParent (graph)
  (let ((kb (getAttr graph "kbname"))
	(requestor (getAttr graph "requestor")))
    (seq
     ;;(invoke java.lang.System.err "println" requestor)
     ;;(invoke java.lang.System.err "println" kb)
     ;;(invoke java.lang.System.err "println" (fetch requestor))
     (if (= kb requestor) (object null) (fetch requestor))
     )
    )
  )

;;

(define formatquery (query padding)
  (seq
   ;;    (invoke java.lang.System.err "println"  query)
   ;;    (invoke java.lang.System.err "println"  padding)
   (let
       (
	(patternstring "goals\\s(.*)\\s*avoids\\s(.*)\\s*hides\\s(.*)\\s*")
	;;buggy         (patternstring "goals\\s(\\S*)\\s*avoids\\s(\\S*)\\s*hides\\s(\\S*)\\s*")
	(pattern (sinvoke "java.util.regex.Pattern" "compile" patternstring))
	(matcher (invoke pattern "matcher" query))
	)
     (if (invoke matcher "matches")
	 (let (
	       (goals  (invoke (invoke matcher "group" (int 1)) "trim"))
	       (avoids (invoke (invoke matcher "group" (int 2)) "trim"))
	       (hides (invoke (invoke matcher "group" (int 3)) "trim"))
	       (sb (object ("java.lang.StringBuffer")))
	       )
	   (seq
	    (if (not (invoke "" "equals" goals)) (invoke sb "append" (concat padding  "Goals:  " goals "\n")))
	    (if (not (invoke "" "equals" avoids)) (invoke sb "append" (concat padding "Avoids: " avoids "\n")))
	    (if (not (invoke "" "equals" hides)) (invoke sb "append" (concat padding  "Hides:  " hides "\n")))
	    (invoke sb "toString")
	    )
	   )
       (concat "Matching failed! query = \"" query "\"")
       )
     )
   )
  )


(define indentation (gname description indent)
  (let ((strings (invoke description "split" "\\n"))
	(sb (object ("java.lang.StringBuffer"))))
    (seq
     ;;      (invoke java.lang.System.err "println" (lookup strings "length"))
     (for line strings
	  (seq (invoke sb "append" indent)
	       (invoke sb "append" line)
	       (invoke sb "append" "\n")))
     (invoke sb "toString"))))

(define makeGraphDescription (gname graph)
  (let (
	(padding " ")
	(spadding "    ")
	(ppadding "    ")
	(contention ": ")

	;;(ginfo (invoke graph "getGraphInfo"))
    (ginfo "")
	;;(kb (getAttr graph "kbname"))
	(requestor (getAttr graph "requestor"))
	(requestop (getAttr graph "requestop"))
	(requestargs (getAttr graph "requestargs")))
    (if (= requestop "dishnet")
	(concat gname contention "DishNet(" requestor ", " requestargs "): " ginfo)
      (if (= requestop "subnet")
	  (let ((gname1 requestor)
		(descriptor1 (lookup (fetch gname1) "description" ))
		(child1 (apply indentation gname1 descriptor1 padding))
		(query (apply formatquery requestargs spadding)))
	    (concat gname contention "SubNet(" gname1 "): " ginfo "\n with " query "\n" child1)
	    )
	(if (= requestop "pathnet")
	    (let ((gname1 requestor)
		  (descriptor1 (lookup (fetch gname1) "description" ))
		  (child1 (apply indentation gname1 descriptor1 padding))
		  (query (apply formatquery requestargs ppadding)))
	      (concat gname contention "PathNet(" gname1 "): " ginfo "\n with " query "\n" child1 "\n"))
	  (if (= requestop "explore")
	      (concat gname contention "[" requestor "].E(" requestargs "): " ginfo "\n")
	    (if (= requestop "compare")
		(let ((gname1 requestor)
		      (gname2 requestargs)
		      (descriptor1 (lookup (fetch requestor) "description" ))
		      (descriptor2 (lookup (fetch requestargs) "description" ))
		      (child1 (apply indentation gname1 descriptor1 padding))
		      (child2 (apply indentation gname2 descriptor2 padding))
		      )
		  (concat gname contention "Compare(" gname1 ", " gname2 "): " ginfo "\n\n"  child1 "\n" child2 "\n"))
	      "Mystery")))))
    )
  )

;; new in October 2013 (panelClosure for, amongst other things, Garuda)

(define garudaInit ()
  (seq
   (invoke java.lang.System.err "println" "\n\n\tgarudaInit\n\n")
   (define garudaBackend com.sri.plagadget.Garuda.BACKEND)
   (define garudaGUI com.sri.plagadget.Garuda.GUI)
   (invoke garudaBackend "requestForLoadableGadgets" "genelist" "txt")
   )
  )


(if (sinvoke "g2d.Main" "isGadget")
    (apply garudaInit)
  )



(define sendSelectedToGadget  (gadgets)
  (lambda (garudatab event)
    (let (
          (list (lookup garudatab "list"))
          (hugos (invoke list "getSelectedValues"))
          (comboBox (lookup garudatab "comboBox"))
          (gadgetIndex (invoke comboBox "getSelectedIndex"))
          (gadget (invoke gadgets "get" gadgetIndex))
          (file (sinvoke "java.io.File" "createTempFile" "plaGeneList" ".txt"))
          (success (sinvoke "g2d.util.IO" "collection2File" (sinvoke "java.util.Arrays" "asList" hugos) (invoke file "getAbsolutePath") (object null) (boolean false)))
          )
      (if success
          (seq
           ;;(invoke java.lang.System.err "println" file)
           (invoke garudaBackend "sentFileToGadget" gadget file)
           )
        )
      )
    )
  )

(define plaPanelClosure (panel graph)
  (if (sinvoke "g2d.Main" "isGadget")
      (let (
            (gname (lookup graph "name"))
            (gadgets (invoke garudaBackend "getCompatibleGadgetList"))
            (garudatab (object ("g2d.netviewer.TabList" panel)))
            (model (lookup garudatab "model"))
            (list (lookup garudatab "list"))
            (comboBox (lookup garudatab "comboBox"))
            (button  (lookup garudatab "button"))
            (sepanel (invoke panel "getSEPanel"))
            (hugolist (apply graph2Xs gname "bprot2hugo"))
            )
        (seq
         (invoke button "setText" "Send selected to Gadget")
         (invoke list "setSelectionMode" javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION)
         (invoke model "setCollection" hugolist)
         (update garudatab "buttonClosure" (apply sendSelectedToGadget gadgets))
         (if (isobject gadgets)
             (for gadget gadgets (invoke comboBox "addItem" (invoke gadget "getName"))))
         (invoke sepanel "insertTab" "Garuda" (object null) garudatab "Garuda Messaging" (int 0))
         (invoke sepanel "setSelectedIndex" (int 0))
         )
        )
    )
  )

;; common graph showing code
;;iam 2012 version
;;N.B. Large amount of redundancy in arguments...

;;(apply anyShowGraph gname (fetch gname) (object null) (object null) title subtitle selections toolBarFun menuBarFunBase)


;; 13aug03 clt Is it an Immune system model
(define isIM () (try isImmuneModel (catch var (boolean false))))

(define anyShowGraph (gname graph pname _pgraph title subtitle selections toolBarFun menuBarFun)

  ;; this block needs to migrate out of here to newGraph ...
  (update graph "name" gname)
  ;;note that parent is now private (must use getters and setters)
  ;;done this way because a graph now knows (and hence "setParent" maintains) its children
  (let ((requestorGraph (apply getGraphParent graph)))
    (invoke graph "setParent" requestorGraph)
    (update graph "title"  (apply makeGraphTitle gname graph))
    (update graph "description" (apply makeGraphDescription gname graph))

    (let ((displayable  (invoke graph "getDisplayable")))
      (seq
       ;; ORDER IMPORTANT
       (apply  setGraphImagePath graph)
       ;; 13jun19 clt fancy nodes
       ;;    (invoke java.lang.System.err "println" (concat "calling setDotAttrs: " gname))
       (apply setDotAttrs graph)
       ;;(invoke java.lang.System.err "println" (lookup graph "images"))
       (invoke graph "setStrokeWidth" (float 1.0))

       ;;<experimental>
       ;;  2/6/2017
       ;;  -- precompute the hidden edges
       ;;  -- compute the rule ranks
       ;;  -- parse the requestargs
       ;;
       (let ((plaobj (sinvoke "g2d.pla.PLAGraph" "getPLAGraph" graph requestorGraph)))
         (setattr graph g2d.pla.PLAGraph.graphAttribute plaobj)
	 ;;</experimental>

	 (if displayable
	     (seq
	      ;;
	      ;; indicate that the edges should be hidden (this is here so we can test this on small graphs if ...)
	      ;; (apply hide_the_edges graph)
	      ;;
	      ;; do layout with dot by default
	      (invoke graph "doLayout" (object null))
	      )
	   )
	 ;;<workzone>

	 ;;</work zone>
	 (update graph "colorClosure" (getAttr graph "colorFun" (object null)))
	 (update graph "toolBarClosure"
		 (lambda (panel graph)
		   (apply toolBarFun (lookup panel "toolBar") gname graph panel requestorGraph displayable)))
	 (update graph "menuBarClosure"
		 (lambda (panel graph) (apply menuBarFun gname graph panel)))
	 (update graph "panelClosure" (lambda (panel graph) (apply plaPanelClosure panel graph)))

	 ;; launch graph in new panel, next to parent graph, or new frame if parent is null
	 (let ((panel (sinvoke "g2d.pla.PLAUtils" "launchTab"  graph selections displayable)))
	   (if (and displayable (isobject plaobj))
	       ;; if the graph is an explore graph we can center on the (last) focal node
	       (let ((requestargs  (lookup plaobj "requestArgsObj"))
		     (node (invoke requestargs "focalPoint" graph)))
		 (if (isobject node)
		     (invoke panel "centerOn" node)
		   )
		 )
	     (invoke panel "repaint")
	     )
	   )
	 ;; get progressbar attr from KBM, if not null, setvisible false
	 (apply closeProgressd)
	 graph
         )
       )
      )
    )
  ) ;; anyShowGraph


;; showing updated Xnet graph
(define showUXGraph (gname)
  (let ((graph (if (instanceof gname "java.lang.String")
		   (fetch gname)
		 (object null)))

        )
    (if (instanceof graph "g2d.graph.IOPGraph")
	;;        (apply redisplay graph)
        (let ((plaobj (getattr graph g2d.pla.PLAGraph.graphAttribute (object null)))
	      (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph)))
          (seq
	   (if (isobject plaobj)
	       (invoke plaobj "update"))
	   (invoke graph "resetDotLayout")
	   (if (invoke graph "isDotLayout")
               (invoke graph "doLayout" (object null)))
	   (invoke panel "setGraph" graph)
	   ;;            (invoke frame "repaint") ;; redundant setGraph repaints
	   ) ;; seq
	  ) ;;let
      ) ;;if
    ) ;; let
  ) ;; showUXGraph


;; (apply showNewGraph %gname %parent %selections %title %subtitle  %toolBarFun )
;;                      str  str or null bool                 id
;;iam 2012 version (still needs work: toolbar and menu stuff pushed into anyShowGraph missing)
;;iam 2012  gname vs graph & pname vs parent  WANTS TO be cleaned up


					;   (apply showNewGraph "graph15" (object null) (boolean true) "Subnet of rafUbe213Dish" " "  toolBarFunPnet )
(define showNewGraph (gname pname selections title subtitle toolBarFun)
  (let ((parent (if (instanceof pname "java.lang.String")
		    (fetch pname)
                  (object null)))
        (graph (fetch gname))
	(args (array java.lang.Object gname graph pname parent title subtitle selections toolBarFun menuBarFunBase))
	)
    (seq
     (setattr graph "anyShowGraphArgs" args)  ;; we remember the arguments in case we have to render the non-displayable  graph
     (invoke graph "setDisplayable") ;; calculate if the graph is displayable
     (apply anyShowGraph gname graph pname parent title subtitle selections toolBarFun menuBarFunBase)
     ))
  )


;;; experimental
(define renderGraph (graph)
  (let ((args (getattr graph "anyShowGraphArgs"))
	(panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
	(frame (sinvoke "g2d.pla.PLAUtils" "getTabFrame" graph))
	(dot_verbosity g2d.graph.Dot.dotVerbose)
	(glyphlist_verbosity g2d.glyph.GlyphList.verbose)
	(paint_debug g2d.glyph.BufferedGlyphList.paintDebug)
	)
    (if (and (isobject panel) (isobject  frame) (isobject args))
	(let ((gname (aget args (int 0)))
	      (graph (aget args (int 1)))
	      (pname (aget args (int 2)))
	      (parent (aget args (int 3)))
	      (title (aget args (int 4)))
	      (subtitle (aget args (int 5)))
	      (selections (aget args (int 6)))
	      (toolBarFun (aget args (int 7)))
	      (menuBarFunBase(aget args (int 8)))
	      )
	  ;;first remove the current panel
	  ;;
	  (invoke frame "removeTabPanel" panel) ;; this may not yet do enough, need to remove the associations too.
	  (invoke java.lang.System.err "println" "renderGraph: panel removed")
	  ;;
	  ;;override the displayable flag
	  ;;
	  (invoke graph "setDisplayable" (boolean true))
          ;;
          ;; hide the edges
          (apply hide_the_edges graph)
          ;;
	  ;;
	  ;; turn on some verbosity
	  (supdate "g2d.graph.Dot" "dotVerbose" (boolean true))
	  (supdate "g2d.glyph.GlyphList" "verbose" (boolean true))
	  ;; tweak the dot settings
	  (apply dot_large_graph_settings  (boolean true))

	  ;;
	  ;; now launch the puppy
	  ;;
	  (apply anyShowGraph gname graph pname parent title subtitle selections toolBarFun menuBarFunBase)
	  ;;
	  ;; restore the verbosity and dot tweakage
	  (supdate "g2d.graph.Dot" "dotVerbose" dot_verbosity)
	  (supdate "g2d.glyph.GlyphList" "verbose" glyphlist_verbosity)
	  (supdate "g2d.glyph.BufferedGlyphList" "paintDebug" paint_debug)

	  (apply dot_large_graph_settings  (boolean false))
	  )
      (invoke java.lang.System.err "println" "renderGraph: something went wrong!")
      )
    )

  )

(define getKBMFrame ()
  (let ((kbm (fetch "KBManager")))
    (if (instanceof kbm "g2d.jlambda.Attributable")
	(getAttr kbm "kbframe")
      (object null)
      ))
  )



(define menuBarFunBase (gname graph panel)
  (let ((displayable (invoke graph "getDisplayable")))
    ;; can actually save files from the server to the client now (even in online mode).
    ;;(if (not (sinvoke "g2d.Main" "isRemote"))
    (apply menuBarFunBaseX gname graph panel)
    ;;)
    (if displayable
	;; add compareMenu
	(invoke (lookup panel "menuBar") "add" (lookup panel "compareMenu"))
      )
    (apply addExportUniprot gname graph panel)
    (apply addGraphMenuAux gname graph panel)  ;; in graphMenu.lsp
    (if displayable
	(apply rmpFeatures graph panel)
      )
    )
  )


(define addExportUniprot (gname graph panel)
  (let ((exportMenu (lookup panel "exportMenu"))
        (menuItem (object ("javax.swing.JMenuItem"
			   "Export UniProtIds..." java.awt.event.KeyEvent.VK_U)))
        (toolkit  (sinvoke "java.awt.Toolkit" "getDefaultToolkit"))
        (keystrokeU (sinvoke "javax.swing.KeyStroke" "getKeyStroke"
                             java.awt.event.KeyEvent.VK_U
                             (invoke toolkit "getMenuShortcutKeyMask") ))
        (clac
	 (lambda (self event)
	   (let ((frame (sinvoke "g2d.pla.PLAUtils" "getTabFrame" panel))
		 (chooser (object ("g2d.swing.IOPFileChooser"
				   g2d.tabwin.TabPreferences.FC_RAW_TEXT_AREA
				   g2d.tabwin.TabPreferences.FC_RAW_TEXT_FORMAT
				   g2d.tabwin.TabPreferences.FC_RAW_TEXT_FILE)))
		 (txtFilter (object ("g2d.swing.FileFilter"
				     "UniProt *.txt" "txt")))
		 )
	     (seq
	      (invoke chooser "setDialogTitle" "Export Graph UniProt Ids To File")
	      (invoke chooser "setAcceptAllFileFilterUsed" (boolean false))
	      (invoke chooser "setMultiSelectionEnabled" (boolean false))
	      ;;last filter set is the default
	      (invoke chooser "addChoosableFileFilter" txtFilter)
	      ;;this will do the preferences magic
	      (invoke chooser "situate")
	      (if (= (invoke chooser "showDialog" frame "Export")
		     g2d.swing.IOPFileChooser.APPROVE_OPTION)
		  (let ((selectedFile (invoke chooser "getSelectedFile"))
			(fileName (invoke selectedFile "getCanonicalPath") )
			)
		    (apply  exportUniprot gname fileName)
		    ) ;; let
		) ;;if
	      ) ;;seq
	     )) ;;lambda
         ) ;;clac
        (cla (object ("g2d.closure.ClosureActionListener"  clac )))
        )
    ;; (exportGraph graph2 graphics2d foo sbml)
    (seq
     (invoke menuItem "addActionListener" cla)
     (invoke menuItem "setAccelerator" keystrokeU)
     (invoke exportMenu "add" menuItem )
     )
    )
  )

(define menuBarFunBaseX (gname graph panel)
  (let ((exportMenu (lookup panel "exportMenu"))
        (menuItem (object ("javax.swing.JMenuItem"
			   "Export graph..." java.awt.event.KeyEvent.VK_G)))
        (toolkit  (sinvoke "java.awt.Toolkit" "getDefaultToolkit"))
        (keystrokeG (sinvoke "javax.swing.KeyStroke" "getKeyStroke"
                             java.awt.event.KeyEvent.VK_G
                             (invoke toolkit "getMenuShortcutKeyMask") ))
        (clac
	 (lambda (self event)
	   (let ((frame (sinvoke "g2d.pla.PLAUtils" "getTabFrame" panel))
		 (chooser (object ("g2d.swing.IOPFileChooser"
				   g2d.tabwin.TabPreferences.FC_RAW_TEXT_AREA
				   g2d.tabwin.TabPreferences.FC_RAW_TEXT_FORMAT
				   g2d.tabwin.TabPreferences.FC_RAW_TEXT_FILE)))
		 (lspFilter (object ("g2d.swing.FileFilter"
				     "JLambda *.lsp" "lsp")))
		 (pnFilter (object ("g2d.swing.FileFilter"
				    "Petri net *.pn" "pn")))
		 (sbmlFilter (object ("g2d.swing.FileFilter"
				      "Systems Biology Markup Language *.sbml" "sbml")))
		 )
	     (seq
	      (invoke chooser "setDialogTitle" "Export Graph To File")
	      (invoke chooser "setAcceptAllFileFilterUsed" (boolean false))
	      (invoke chooser "setMultiSelectionEnabled" (boolean false))
	      (invoke chooser "addChoosableFileFilter" pnFilter)
	      (invoke chooser "addChoosableFileFilter" sbmlFilter)
	      ;;last filter set is the default
	      (invoke chooser "addChoosableFileFilter" lspFilter)
	      ;;this will do the preferences magic
	      (invoke chooser "situate")
	      (if (= (invoke chooser "showDialog" frame "Export")
		     g2d.swing.IOPFileChooser.APPROVE_OPTION)
		  (let ((selectedFile (invoke chooser "getSelectedFile"))
			(fileName (invoke selectedFile "getCanonicalPath") )
			)
		    (seq
		     (sinvoke "g2d.util.ActorMsg" "send"
			      "maude" gname (concat "exportGraph" " "
						    " "
						    (apply fileNameExt fileName))  )
		     )) ;; seq let
		) ;;if
	      ) ;;seq
	     )) ;;lambda
         ) ;;clac
        (cla (object ("g2d.closure.ClosureActionListener"  clac )))
        )
    ;; (exportGraph graph2 graphics2d foo sbml)
    (seq
     (invoke menuItem "addActionListener" cla)
     (invoke menuItem "setAccelerator" keystrokeG)
     (invoke exportMenu "add" menuItem )
     )
    )
  )


(define fileNameExt (str)
  (let ((ix (invoke str "lastIndexOf" "."))
        (base  (if (< ix (int 0))
		   str
		 (invoke str "substring" (int 0 ) ix )) )
        (ext  (if (< ix (int 0))
		  "lsp"
                (invoke str "substring" (+ ix (int 1)))) )
	)
    (concat base " " ext)
    )
  )

(define toolBarFunBase (toolbar gname graph panel pgraph displayable)
  (seq
   ;; incontext button if pgraph non null and is displayable
   (if (and displayable (not (= pgraph (object null))))
       (seq
	(invoke toolbar "prepend"
		(sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
	(invoke toolbar "prepend" (invoke panel "createLayoutButton" pgraph))
	))
   ;; add the render button
   (if (not displayable)
       (let
	   ((renderMeButton (object ("g2d.toolbar.ToolButton" "Render")))
	    (renderMeAction (object ("g2d.closure.ClosureAbstractAction"
				     "Render" "Render this graph in a new tab"
				     (lambda (self event)
				       (invoke java.lang.System.err "println" "rendering")
				       (invoke renderMeButton "setEnabled" (boolean false))
				       (invoke renderMeButton "setEnabled" (boolean true))
				       (apply renderGraph graph)
				       (invoke java.lang.System.err "println" "rendered")
				       )))))
	 (invoke toolbar "prepend"
		 (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
	 (invoke renderMeButton "setAction" renderMeAction)
	 (invoke toolbar "prepend" renderMeButton)
	 )
     ) ;;if
   ;; add 2kb button
   ;;(invoke toolbar "prepend"
   ;;		   (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
   ;;     (apply addTreeMgrButton toolbar)
   (invoke toolbar "prepend"
	   (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
   (invoke toolbar "prepend"
	   (object ("g2d.toolbar.ToolButton"
		    (object ("g2d.closure.ClosureAbstractAction"
			     "ToKB" "Save underlying net as a KB"
			     (lambda (self event)
			       (let ((frame (sinvoke "g2d.pla.PLAUtils" "getTabFrame" panel))
				     (ukbname (apply askUser  ;; in kbmanager.lsp
						     frame "AskUser" "Type in a KB name")))
				 (sinvoke "g2d.util.ActorMsg" "send"
					  "maude" gname (concat "net2KB" " " ukbname)))))
			    ))))

   ;; button for toggling the experimental ruleRanks.
   (if (invoke graph "getAttributeAsBoolean" g2d.pla.RuleRanks.hasRanks (boolean false))
       (seq
	(invoke toolbar "prepend"
		(sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
	(let ((urrb (object ("g2d.toolbar.ToolButton" "Use Ranks")))
	      (urrbTip "Use rule rank to layout the graph.")
	      (urrbClosure (lambda (self event)
			     (if (invoke graph "getAttributeAsBoolean" g2d.pla.RuleRanks.usingRanks (boolean false))
				 (seq
				  (invoke graph "setAttribute" g2d.pla.RuleRanks.usingRanks java.lang.Boolean.FALSE)
				  (invoke urrb "setText" "Use Ranks")
				  (supdate "g2d.graph.Dot" "useRuleRanks" (boolean false))
				  )
			       (seq
				(invoke graph "setAttribute" g2d.pla.RuleRanks.usingRanks java.lang.Boolean.TRUE)
				(invoke urrb "setText" "Ignore Ranks")
				(supdate "g2d.graph.Dot" "useRuleRanks" (boolean true))
				)
			       )
			     (invoke graph "doLayout" (object null))
			     (supdate "g2d.graph.Dot" "useRuleRanks" (boolean false))
			     )
			   )
	      )

	  (invoke urrb "setAction" (apply mkAction "Use Ranks" urrbTip urrbClosure))

	  (invoke toolbar "prepend" urrb)
	  )
	)
     )
   )
  )


(apply logDev "showGraph.lsp loaded")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/showGraphFuns.lsp ;;;;;;;;;;
(define mtGraphAlert ()
  (seq
   (apply closeProgressd)
   (apply displayMessage "Alert" "Empty Graph")
   ))

(define closeProgressd ()
  (let ((kbm (fetch "KBManager"))
        (pd (if (instanceof kbm "g2d.jlambda.Attributable")
		(getAttr  kbm "progressd")
	      (object null)
	      )) )
    (if (instanceof pd "javax.swing.JDialog")
	(invoke pd "setVisible" (boolean false))) )
  )


(define mkAction (label tip closure)
  (object ("g2d.closure.ClosureAbstractAction"
	   label
	   (object null) ; icon
	   tip
	   (object null) ; accelerator
	   (object null) ; mnemonic
	   closure     ; action closure
	   ) ) )

(define pnetColorKey ()
  (let (
	(colorkey (object ("g2d.swing.IOPColorKey")))
	(colors (array java.awt.Color
		       initFillColor
		       noneFillColor
		       ruleFillColor
		       goalFillColor
		       avoidFillColor
		       cxtFillColor
		       ))
	(keys (array java.lang.String
		     "Initial occurrence"
		     "Occurrence no status"
		     "Rule no status"
		     "Goal status"
		     "Avoid/hide status"
		     "Context node"
		     ))
	)
    (seq
     (invoke colorkey "add" colors keys)
     colorkey
     )
    )
  )

(define toolBarFunPnet (toolbar gname graph panel pgraph displayable)
  (seq
   (apply toolBarFunBase toolbar gname graph panel pgraph displayable)
   (if displayable
	   (seq
		;; prepend buttons and things in tool bar
		(invoke toolbar "add" (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
		(invoke toolbar "add" (apply pnetColorKey))
		(apply addHideEdgesButton toolbar gname graph)
		)
	 )
   (invoke toolbar "prepend" (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))

   ;; 3/18/2015 lola 2 is now the default, and the only lola (maude code needs a cleanup too)
   (if displayable
	   (invoke toolbar "prepend"
			   (object ("g2d.toolbar.ToolButton"
						(apply mkAction "FindPath" "find a path to goals (lola)"
							   (lambda (self event) (apply pathRequest graph))) ) ) )
	 )
   (let ((subnetButton (object ("g2d.toolbar.ToolButton" "Subnet")))
		 (subnetAction (apply mkAction "Subnet" "display relevant subnet"
							  (lambda (self event)
								;; these do not work because we are involved with asyncronous message passing here.
								;;(invoke subnetButton "setEnabled" (boolean false))
								(apply subnetRequest graph)
								;;(invoke subnetButton "setEnabled" (boolean true))
								))))
	 (invoke subnetButton "setAction" subnetAction)
	 (invoke toolbar "prepend" subnetButton)
	 )
   (invoke toolbar "prepend"
		   (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
   ;; explore dropdown button
   (apply addPnetExploreButton toolbar gname)
   )
  )


(define mkPnetExploreClosure (gname mode)
  (lambda (self event)
    (sinvoke "g2d.util.ActorMsg" "send"
	     "maude" gname (concat "exploreInit " mode)))
  )


(define addPnetExploreButton (toolbar gname)
  (let ((button (object ("g2d.swing.IOPDropdownButton" "Explore")))
        (occsC (apply mkPnetExploreClosure gname "occ"))
        (rulesC (apply mkPnetExploreClosure gname  "rule"))
        (ht g2d.toolbar.ToolBar.TOOL_BTN_HEIGHT)
	)
    (seq
     (invoke button "addMenuItem" "Occs" occsC)
     (invoke button "addMenuItem" "Rules" rulesC)
     (invoke button "setHeight" ht)
     (invoke toolbar "prepend"  button )
     ))
  ) ; addPnetExploreButton


(define cnetColorKey ()
  (let (
	(colorkey (object ("g2d.swing.IOPColorKey")))
	(colors (array java.awt.Color
		       initFillColor
		       (object ("java.awt.Color" (int 0) (int 255) (int 255)))
		       java.awt.Color.pink
		       cxtFillColor
		       ))
	(keys (array java.lang.String
		     "Requesting graph"
		     "CompareTo graph"
		     "Both graphs"
		     "context"
		     ))
	)
    (seq
     (invoke colorkey "add" colors keys)
     colorkey
     )
    )
  )

(define toolBarFunCnet (toolbar gname graph panel pgraph displayable)
  (seq
   (apply toolBarFunBase toolbar gname graph panel pgraph displayable)
   ;; prepend buttons and things in tool bar
   (if displayable
	   (seq
		(invoke toolbar "add" (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
		(invoke toolbar "add" (apply cnetColorKey))
		(apply addHideEdgesButton toolbar gname graph)
		)
	 )
   )
  )

(define xnetColorKey ()
  (let (
	(colorkey (object ("g2d.swing.IOPColorKey")))
	(colors (array java.awt.Color
		       java.awt.Color.lightGray
		       initFillColor
		       java.awt.Color.green
		       java.awt.Color.cyan
		       java.awt.Color.yellow
		       cxtFillColor
		       ))
	(keys (array java.lang.String
		     "Occ node seen"
		     "Occ node up OK"
		     "Occ node down OK"
		     "Occ node up and down OK"
		     "selected"
		     "context"
		     ))
	)
    (seq
     (invoke colorkey "add" colors keys)
     colorkey
     )
    )
  )

(define mkTTF ()
  (let ((tf (object ("javax.swing.JFormattedTextField"
		     (object ("java.lang.Integer" (int 1))) )) ))
    (seq
     (invoke tf "setMaximumSize"
	     (object ("java.awt.Dimension" (int 32) (int 32))))
     tf) ))



(define toolBarFunXnet (toolbar gname graph panel pgraph displayable)
  (let ((cb (object ("g2d.toolbar.ToolCheckBox" "New Tab")))
					;        (tf (object ("g2d.toolbar.ToolTextField")))
        (tf (apply mkTTF))
        (gname (getuid graph))
        (dnClosure
	 (lambda (self event)
	   (let ((new (invoke cb "isSelected"))
		 (steps (invoke (invoke tf "getValue") "intValue"))
		 )
	     (seq (sinvoke "g2d.util.ActorMsg" "send" "maude" gname
			   (concat "explore " new " dn " steps))
					;  (invoke cb "setSelected" (boolean false))
		  ) ))) ; dnClosure
        (downTip "Explore down given steps")
        (upClosure
	 (lambda (self event)
	   (let ((new (invoke cb "isSelected"))
		 (steps (invoke (invoke tf "getValue") "intValue")))
             (sinvoke "g2d.util.ActorMsg" "send" "maude" gname
                      (concat "explore " new " up " steps)))
	   )) ; upClosure
        (upTip "Explore up given steps")
	) ; letbindings
					; prepend buttons and things in tool bar
    (seq
     (if (try explorerCheckBoxDefault (catch x (boolean false)))
	 (invoke cb "setSelected" (boolean true)))
     (apply toolBarFunBase toolbar gname graph panel pgraph displayable)
     (invoke toolbar "add" (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
     (invoke toolbar "add" (apply xnetColorKey))
     (invoke toolbar "prepend"
             (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
					; check box for new or reuse tabs
     (invoke cb "setToolTipText"
	     "Open graph resulting from next explore operation in new tab")
     (invoke toolbar "prepend" cb)

     (invoke toolbar "prepend"
             (sinvoke "g2d.toolbar.SeparatorFactory" "makeSmallSep"))
					; text field for number of steps
     (invoke tf "setToolTipText"
	     "Specify number of steps to be taken when exploring up or down")
     (invoke toolbar "prepend" tf)
     (invoke toolbar "prepend"
	     (sinvoke "g2d.toolbar.SeparatorFactory" "makeSmallSep"))
					; up and down buttons
     (invoke toolbar "prepend"
	     (object ("g2d.toolbar.ToolButton"
		      (apply mkAction "Down" downTip dnClosure))))
     (invoke toolbar "prepend"
	     (object ("g2d.toolbar.ToolButton" (apply mkAction "Up" upTip upClosure))))
     (invoke toolbar "prepend"
	     (object ("g2d.toolbar.ToolButton"
		      (apply mkAction "Explore Selected" "explore with xselect attributes"
			     (lambda (self event) (apply exploreSelectedRequest graph gname cb)))
		      ) ) )
					; explore dropdown button
     (apply addExploreButton toolbar gname cb)
     ) ;seq
    ) ; let
  ) ; toolBarFunXnet


(define addExploreButton (toolbar gname cb)
  (let ((button (object ("g2d.swing.IOPDropdownButton" "Explore")))
        (fpsC (apply mkExploreClosure gname cb "fps"))
        (addRC (apply mkExploreClosure gname cb "addR"))
        (hideRC (apply mkExploreClosure gname cb "hideR"))
        (unhideRC (apply mkExploreClosure gname cb "unhideR"))
        (ht g2d.toolbar.ToolBar.TOOL_BTN_HEIGHT)
	)
    (seq
     (invoke button "addMenuItem" "occs" fpsC)
     (invoke button "addMenuItem" "add Rules" addRC)
     (invoke button "addMenuItem" "hide Rules" hideRC)
     (invoke button "addMenuItem" "unhide Rules" unhideRC)
     (invoke button "setHeight" ht)
     (invoke toolbar "add"  button (int 0))
     ))
  ) ; addExploreButton


(define mkExploreClosure (gname cb cmd)
  (lambda (self event)
    (let ((new (invoke cb "isSelected")))
      (seq (sinvoke "g2d.util.ActorMsg" "send" "maude" gname
		    (concat "explore " new " " cmd))
					;  (invoke cb "setSelected" (boolean false))
	   )
      )
    ) ; exploreClosure
  )


(define exploreSelectedRequest (graph gname cb)
  (let ((new (invoke cb "isSelected")))
    (seq (sinvoke "g2d.util.ActorMsg" "send" "maude" gname
		  (concat "explore " new " " "selected" " "
			  (apply mkXStatusString graph) ))
					; (invoke cb "setSelected" (boolean false))
	 ))
  )

(define mkXStatusString (graph)
  (let ((nodes (invoke graph "getNodesInArray")))
    (apply nodes2xselect nodes (int 0) (lookup nodes "length") "")
    )
  )

(define nodes2xselect (nodes cur len str)
  (if (>= cur len)
      str
    (let ((node (aget nodes cur))
	  (chatty (getAttr node "chattylabel" ""))
	  (xselect (getAttr node "xselect" "none")))
      (apply nodes2xselect nodes (+ cur (int 1)) len
	     (if (or (= xselect "none") (= chatty ""))
		 str
	       (concat str " " chatty " " xselect)
	       ) ) ) ; if app let
    )
  ) ; nodes2xselect

(apply logDev "showGraphFuns.lsp loaded")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/labels.lsp ;;;;;;;;;;
(define refreshThumbnail (panel graph)
   (let ((navPanel (invoke panel "getNavPanel"))
         (image (invoke graph "getBufferedImage"))
        )
       (invoke navPanel "setImage" image)
   )
)

;;;!!! fixed viewport bug 13jan23
(define setNodeLabels (gname type tag)
  (let ((graph (fetch gname))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (nodes (invoke graph "getNodesInArray")))
    (seq
      (for node nodes 
         (if (= type (getAttr node "type"))
           (seq
            (invoke node "setBaseDimension" (double 10) (double 10))
            (invoke node "setLabel" (getAttr node tag ""))
            ))  )
      (invoke graph "doLayout")
      (invoke panel "setGraph" graph) 
;;      (apply refreshThumbnail panel graph)
;;      (invoke panel "repaint")
   )) ; seq let
)

(define setOccLabels (gname chatty?)
  (let ((graph (fetch gname))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        )
    (apply setDotAttrsX graph chatty?)
    (invoke graph "doLayout")
    (invoke panel "setGraph" graph) 
))

(define suppressRuleLabels (gname)
  (let ((graph (fetch gname))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (nodes (invoke graph "getNodesInArray")))
    (seq
      (for node nodes 
         (if (= "rule" (getAttr node "type"))
          (seq
           (invoke node "setLabel" "")
           (invoke node "setBaseDimension" (double 10) (double 10))
          )))
      (invoke graph "doLayout")
      (invoke panel "repaint")
   )) ; seq let
)

(apply logDev "labels.lsp loaded")



;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/graphMenu.lsp ;;;;;;;;;;
(define addGraphMenu (gname)
  (let ((graph (fetch gname))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (graphMenu  (apply mkGraphMenu gname graph panel))
       )
   (seq
     (invoke (lookup panel "menuBar") "add" graphMenu)
     (invoke panel "validate")
  )
))

(define addGraphMenuAux (gname graph panel)
  (invoke (lookup panel "menuBar") "add" (apply mkGraphMenu gname graph panel))
)

;(g2dexe graphics2d (apply setNodeLabels "graph2" "occ" "label"))
;(g2dexe graphics2d (apply setNodeLabels "graph2" "occ" "chattylabel"))
;(g2dexe graphics2d (apply setNodeLabels "graph2" "rule" "label"))
;(g2dexe graphics2d (apply setNodeLabels "graph2" "rule" "chattylabel"))
;(g2dexe graphics2d (apply suppressRuleLabels "graph2"))
;(maude graph displayUnused)

(define mkOccLabelItem (gname)
  (let ((occLabelItem (object ("javax.swing.JMenuItem"                 
                                  "Short Occ Labels" )))
        (occLabelC
;;clt 13aug16
;;          (lambda (self event) (apply setNodeLabels gname "occ" "label"))
          (lambda (self event) (apply setOccLabels gname (boolean false))
           ) ;lambda
         ) ; suppressC
        (occLabelCA
           (object ("g2d.closure.ClosureActionListener"  occLabelC )))
       )
     (seq
       (invoke occLabelItem "addActionListener" occLabelCA)
       occLabelItem
    )
))

(define mkOccChattyLabelItem (gname)
  (let ((occChattyLabelItem (object ("javax.swing.JMenuItem"                 
                                  "Chatty Occ Labels" )))
        (occChattyLabelC
;;clt 13aug16
;;          (lambda (self event) (apply setNodeLabels gname "occ" "chattylabel"))
          (lambda (self event) (apply setOccLabels gname (boolean true))
           ) ;lambda
         ) ; suppressC
        (occChattyLabelCA
           (object ("g2d.closure.ClosureActionListener"  occChattyLabelC )))
       )
     (seq
       (invoke occChattyLabelItem "addActionListener" occChattyLabelCA)
       occChattyLabelItem
    )
))

(define mkRuleLabelItem (gname)
  (let ((ruleLabelItem (object ("javax.swing.JMenuItem"                 
                                  "Short Rule Labels" )))
        (ruleLabelC
          (lambda (self event) (apply setNodeLabels gname "rule" "label")
           ) ;lambda
         ) ; suppressC
        (ruleLabelCA
           (object ("g2d.closure.ClosureActionListener"  ruleLabelC )))
       )
     (seq
       (invoke ruleLabelItem "addActionListener" ruleLabelCA)
       ruleLabelItem
    )
))
(define mkRuleChattyLabelItem (gname)
  (let ((ruleChattyLabelItem (object ("javax.swing.JMenuItem"                 
                                  "Chatty Rule Labels" )))
        (ruleChattyLabelC
          (lambda (self event) (apply setNodeLabels gname "rule" "chattylabel")
           ) ;lambda
         ) ; suppressC
        (ruleChattyLabelCA
           (object ("g2d.closure.ClosureActionListener"  ruleChattyLabelC )))
       )
     (seq
       (invoke ruleChattyLabelItem "addActionListener" ruleChattyLabelCA)
       ruleChattyLabelItem
    )
))


(define mkSuppressRuleLabelItem (gname)
  (let ((suppressRuleLabelItem (object ("javax.swing.JMenuItem"                 
                                  "Suppress Rule Labels" )))
        (suppressRuleLabelC
          (lambda (self event) (apply suppressRuleLabels gname)
           ) ;lambda
         ) ; suppressC
        (suppressRuleLabelCA
           (object ("g2d.closure.ClosureActionListener"  suppressRuleLabelC )))
       )
     (seq
       (invoke suppressRuleLabelItem "addActionListener" suppressRuleLabelCA)
       suppressRuleLabelItem
    )
))


(define mkShowUnusedItem (gname)
  (let ((showUnusedItem (object ("javax.swing.JMenuItem"                 
                                  "Show Unused" )))
        (showUnusedC
          (lambda (self event) 
            (sinvoke "g2d.util.ActorMsg" "send" "maude" gname "displayUnused")
           ) ;lambda
         ) ; suppressC
        (showUnusedCA
           (object ("g2d.closure.ClosureActionListener"  showUnusedC )))
       )
     (seq
       (invoke showUnusedItem "addActionListener" showUnusedCA)
       showUnusedItem
    )
))


(define mkShowGoalsAvoidsItem (gname)
  (let ((showGoalsAvoidsItem (object ("javax.swing.JMenuItem"                 
                                  "Show Goals & Avoids" )))
        (showGoalsAvoidsC
          (lambda (self event) 
            (apply showGoalsAvoids gname)
           ) ; lambda
         ) ; showGAC
        (showGoalsAvoidsCA
           (object ("g2d.closure.ClosureActionListener"  showGoalsAvoidsC )))
       )
     (seq
       (invoke showGoalsAvoidsItem "addActionListener" showGoalsAvoidsCA)
       showGoalsAvoidsItem
    )
))

(define showGoalsAvoids (gname)
  (let ((graph (fetch gname))
        (gastring (if (= gname (object null)) "" (getAttr graph "subtitle")))
  )
   (apply displayMessage2G gname "Goals&Avoids" gastring)
  )
)


(define mkKOItem (gname)
  (let ((koItem (object ("javax.swing.JMenuItem"           
                                  "Display KnockOuts" )))
        (koC
          (lambda (self event) (apply displayKOs gname)
           ) ;lambda
         ) ; koC
        (koCA
           (object ("g2d.closure.ClosureActionListener"  koC )))
       )
     (seq
       (invoke koItem "addActionListener" koCA)
       koItem
    )
))

(define mkHistoryItem (gname label fun)
  (let ((dhItem (object ("javax.swing.JMenuItem" label)))
        (dhC
          (lambda (self event) 
              (sinvoke "g2d.util.ActorMsg" "send" "maude" gname 
                     (concat "printHistory " fun ))
           ) ;lambda
         ) ; dhC
        (dhCA
           (object ("g2d.closure.ClosureActionListener"  dhC )))
       )
     (seq
       (invoke dhItem "addActionListener" dhCA)
       dhItem
    )
))

(define mkResetAllItem (gname)
  (let ((resetAllItem (object ("javax.swing.JMenuItem"                 
                                  "Reset All Selections" 
                                  java.awt.event.KeyEvent.VK_R)))
        (toolkit  (sinvoke "java.awt.Toolkit" "getDefaultToolkit"))
        (keystrokeR (sinvoke "javax.swing.KeyStroke" "getKeyStroke"
                             java.awt.event.KeyEvent.VK_R 
                             (invoke toolkit "getMenuShortcutKeyMask") ))
                                  
        (raC
          (lambda (self event) 
            (let ((graph (fetch gname))
                  (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
                  )
              (seq 
               (invoke panel "resetAllSelections")
               )
              ))
          ) ; raC
        (raCA
         (object ("g2d.closure.ClosureActionListener"  raC )))
        )
    (seq
     (invoke resetAllItem "addActionListener" raCA)
     (invoke resetAllItem "setAccelerator" keystrokeR)
     resetAllItem
     )
    )
  )


;; the graph items should be relevant to graph type
(define mkGraphMenu (gname graph panel)
  (let ((graphMenu (lookup panel "graphMenu"))
		(displayable (invoke graph "getDisplayable")))
    (seq
	 (if (invoke panel "allowsSelections")
		 (seq
          (invoke graphMenu "add" (apply mkShowUnusedItem gname))
          (invoke graphMenu "addSeparator" )
		  ;;only subnet/path
          (invoke graphMenu "add" (apply mkShowGoalsAvoidsItem gname))
          (invoke graphMenu "addSeparator" )
		  ;;only pnet 
		  ;;          (invoke graphMenu "add" (apply mkKOItem gname))
		  ;;          (invoke graphMenu "addSeparator" )
          (invoke graphMenu "add" (apply mkResetAllItem gname))
          (invoke graphMenu "addSeparator" )
          )
	   ;; only xnets
	   (seq 
		(invoke graphMenu "add" 
				(apply mkHistoryItem gname "Display History" "displayHistory"))
		;;          (invoke graphMenu "addSeparator" )        
		(invoke graphMenu "add" 
				(apply mkHistoryItem gname "Save History" "saveHistory"))
		(invoke graphMenu "addSeparator" )        
        )
	   )
	 (if displayable
		 (seq 
		  (invoke graphMenu "add" (apply mkOccLabelItem gname))
		  (invoke graphMenu "add" (apply mkOccChattyLabelItem gname))
		  (invoke graphMenu "add" (apply mkRuleLabelItem gname))
		  (invoke graphMenu "add" (apply mkRuleChattyLabelItem gname))
		  (invoke graphMenu "add" (apply mkSuppressRuleLabelItem gname))
		  (invoke graphMenu "addSeparator" )
		  )
	   )
	 (invoke graphMenu "add" (apply mkShowGraphInfoItem gname graph panel))
	 graphMenu
	 )
	)
  )



(define mkShowGraphInfoItem (gname graph panel)
  (let ((menuItemItem (object ("javax.swing.JMenuItem"  "Graph Details" )))
        (menuItemC
          (lambda (self event) 
             (invoke (invoke panel "getGraphPanel") "displayContextMGraph")
            ) ;lambda
          ) ; suppressC
        (menuItemCA
         (object ("g2d.closure.ClosureActionListener"  menuItemC )))
        )
    (seq
     (invoke menuItemItem "addActionListener" menuItemCA)
     menuItemItem
     )
    ))


(apply logDev "graphMenu.lsp loaded")


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/lola-str.lsp ;;;;;;;;;;
;; Lola net
;; PLACES p0, p1, p2, p3, p4, p5;

;; MARKING p0 : 1, p1 : 0, p4 : 1;

;; TRANSITION t64
;; CONSUME p80 : 1, p30 : 1, p68 : 1, p84 : 1, p1 : 1;
;; PRODUCE p80 : 1, p30 : 1, p68 : 1, p84 : 1, p81 : 1;

(seq

;  op appendLolaPlaces : NodeList StringBuffer -> * .
(define appendLolaPlaces (occNodes strb)
  (seq
    (for node occNodes
      (seq
        (invoke strb "append" "p")
        (invoke strb "append" (getAttr node "nid" ""))
        (invoke strb "append" ", ")
      ))
   ; delete trailing ", "
    (invoke strb "setLength" (- (invoke strb "length") (int 2))) 
  )
)

;  op appendLolaMarking : NodeList StringBuffer -> * .
(define appendLolaMarking (initNodes strb)
  (seq
    (for node initNodes
      (seq
        (invoke strb "append" "p")
        (invoke strb "append" (getAttr node "nid" ""))
        (invoke strb "append" " : 1")
        (invoke strb "append" ", ")
      ))
   ; delete trailing ", "
    (invoke strb "setLength" (- (invoke strb "length") (int 2))) 
  )
)

;  op appendLolaTrans      : NodeList StringBuffer -> * .
;  op mkLolaTrans1         : Node Stringbuffer -> * .
;  op mkLolaPrePost        : Nats -> String .
(define appendLolaTrans (rnodes strb)
  (for node rnodes
   (apply appendLolaTrans1 node strb)
  )
)

(define appendLolaTrans1 (node strb)
  (let ((nid (getAttr node "nid" ""))
        (preids (invoke (getAttr node "pre") "split" "\\s+"))
        (postids (invoke (getAttr node "post") "split" "\\s+"))
        )
    (seq
      (invoke strb "append" "\n")
      (invoke strb "append" "TRANSITION t")
      (invoke strb "append" nid)
      (invoke strb "append" "\n")
      (invoke strb "append" "CONSUME ")
      (apply appendLolaPrePost preids strb)
      (invoke strb "append" ";\n")
      (invoke strb "append" "PRODUCE ")
      (apply appendLolaPrePost postids strb)
      (invoke strb "append" ";\n")
    ) ; concat
  )
)

;; op appendLolaPrePost : NidList StringBuffer -> *
(define appendLolaPrePost (nids strb)
  (seq
    (for nid nids
      (seq
        (invoke strb "append" "p")
        (invoke strb "append" nid)
        (invoke strb "append" " : 1, ")
     ))
     ; delete trailing ", "
    (invoke strb "setLength" (- (invoke strb "length") (int 2))) 
  )
)

;  op mkLolaNetStr : NodeList NodeList NodeList  -> String .

(define mkLolaNetStr (occNodes ruleNodes initNodes)
  (let ((strb (object ("java.lang.StringBuffer"))))
    (seq 
      (invoke strb "append" "PLACE ")
      (apply appendLolaPlaces occNodes strb)
      (invoke strb "append" ";\n\nMARKING ")
      (apply appendLolaMarking initNodes strb)
      (invoke strb "append" ";\n")
      (apply appendLolaTrans ruleNodes strb)
      (invoke strb "toString")
  ))
)


;; FORMULA ( (p72 = 1) AND  (p73 = 1) )

;;  op mkLolaTaskString : NodeList -> String .
;; op appendLolaGoals : NodeList StringBuffer -> * .
  
(define mkLolaTaskStr  (goalNodes) 
  (let ((strb (object ("java.lang.StringBuffer"))))
    (seq 
      (invoke strb "append" "FORMULA ( ")
      (apply appendLolaGoals goalNodes strb)
      (invoke strb "append" " )\n" )
      (invoke strb "toString")
    )
  )
)

(define appendLolaGoals (gnodes strb)
  (for node gnodes
    (seq
      (invoke strb "append" "( p")
      (invoke strb "append" (getAttr node "nid" "") )
      (invoke strb "append" " = 1 )")
    ))
)



) ; top seq

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/ko.lsp ;;;;;;;;;;
;; Lola net
;; PLACES p0, p1, p2, p3, p4, p5;

;; MARKING p0 : 1, p1 : 0, p4 : 1;

;; TRANSITION t64
;; CONSUME p80 : 1, p30 : 1, p68 : 1, p84 : 1, p1 : 1;
;; PRODUCE p80 : 1, p30 : 1, p68 : 1, p84 : 1, p81 : 1;
; requires lola-str.lsp and pla.lsp (doLolaRequest)

(define KO-DEBUG (boolean false))
;; candidates are initial occ nodes that appear in the premiss of a rule
;; in pathstr
(define lolaPath2Candidates (pathstr graph)
  (let ((patharr (invoke (aget (invoke pathstr "split" "\\s+" (int 2)) 
                               (int 1)) ;; the cdr of the token string
                         "split" "\\s+"))
        (list (object ("java.util.ArrayList")))
       )
  (seq
    (for elt patharr
      (let ((nid (invoke elt "substring" (int 1) (invoke elt "length"))))
        (apply trans2cand graph nid list)))
    list))
)

;; adds init pre nodes of node to list
(define trans2cand (graph nid list)
  (let ((node (invoke graph "getNode" nid) )
        (pre (invoke (getAttr node "pre" "") "split" "\\s+"))
        )
      (for pnid pre
        (let ((pnode (invoke graph "getNode" pnid)))
          (if (= (getAttr pnode "init" "") "true") 
            (if (not (invoke list "contains" pnode))                    
              (invoke list "add" pnode)
          )))) ; if if let for
    )
)

;; returns true if lolas result code is not 0, means no path ie a ko
;; need to extract lolaRes from lolaRequest 
;; 
(define LolaCheckKO (occNodes ruleNodes initNodes goalNodes occ)
  (let ((netStr (apply mkLolaNetStr occNodes ruleNodes 
                                   (apply ldelete initNodes occ)))
        (taskStr (apply mkLolaTaskStr goalNodes))
        (res (apply doLolaReq netStr taskStr "0"))
        )
   (seq         
    (if KO-DEBUG
      (invoke java.lang.System.err "println" 
       (concat "LolaCheckKO\n" occ "\n" (aget res (int 0)))))
     (not  (= (aget res (int 0)) "0"))
   )
  )
)

;; candidates is a list of nodes
(define searchKOs (occNodes ruleNodes initNodes goalNodes candidates)
  (let ((kos (object ("java.util.ArrayList")))) 
    (seq
      (for occ candidates 
        (if (apply LolaCheckKO occNodes ruleNodes initNodes goalNodes occ)
         (invoke kos "add" occ) ))
      (if KO-DEBUG
        (invoke java.lang.System.err "println" (concat "searchKOs\n" kos)))
     kos)
  )
)

; true if some nid in arr is the id of a node in ndl
(define findArrNdl (ndl graph arr len cur)
  (if (>= cur len) 
   (boolean false)
   (if (invoke ndl "contains" (invoke graph "getNode" (aget arr cur)))
    (boolean true)
    (apply findArrNdl ndl graph arr len (+ cur (int 1)))
   ))
)

; true if (the nid of) no node in avoidNodes appears in the pre or post
; of rnode
;                  rnode nodelist 
(define notHidden (rnode avoidNodes graph)
  (let ((pre (invoke (getAttr rnode "pre" "") "split" "\\s+"))
        (prelen  (lookup pre "length"))
        (post (invoke (getAttr rnode "post" "") "split" "\\s+"))
        (postlen  (lookup post "length"))
        )
    (if (apply findArrNdl avoidNodes graph pre prelen (int 0))
     (boolean false)
     (not (apply findArrNdl avoidNodes graph post postlen (int 0)))
     )    
  )
)

;;                     occs    rules    init
;;  op mkLolaNetStr : NodeList NodeList NodeList  -> String .
;;                          goals
;;  op mkLolaTaskString : NodeList -> String .

;; assume graph has one or more goals
;; may have unprocesses occ or rule avoids
(define displayKOs (gname)
  (let ((graph (fetch gname))
        (nodes (invoke graph "getNodesInArray"))
        (occNodes (apply selectArrl nodes 
            (lambda (node) (if (= (getAttr node "type" "") "occ")
                            (not (= (getAttr node "status" "") "avoid"))
                            (boolean false) ))))
; (docc (invoke java.lang.System.err "println" 
;                                  (concat "displayKOs occNodes\n" occNodes)))
        (avoidNodes (apply selectArrl nodes 
            (lambda (node) (if (= (getAttr node "type" "") "occ")
                            (= (getAttr node "status" "") "avoid")
                            (boolean false) ))))
; (davoid (invoke java.lang.System.err "println" 
;                              (concat "displayKOs avoidNodes\n" avoidNodes)))
        (initNodes (apply selectArrl occNodes
                        (lambda (node) (= (getAttr node "init" "") "true"))))
; (dinit (invoke java.lang.System.err "println" 
;                                (concat "displayKOs initNodes\n" initNodes)))
        (goalNodes (apply selectArrl occNodes
                        (lambda (node) (= (getAttr node "status" "") "goal"))))
; (dgoal (invoke java.lang.System.err "println" 
;                                 (concat "displayKOs goalNodes\n" goalNodes)))
        (ruleNodes (apply selectArrl nodes 
            (lambda (node) (if (= (getAttr node "type" "") "rule")
                             (if  (= (getAttr node "status") "avoid")
                               (boolean false)
                               (apply notHidden node avoidNodes graph))
                             (boolean false) ))))
; (drule (invoke java.lang.System.err "println" 
;                               (concat "displayKOs ruleNodes\n" ruleNodes)))
        (netStr (apply mkLolaNetStr occNodes ruleNodes initNodes))
        (taskStr (apply mkLolaTaskStr goalNodes))
      )
   (if (= (invoke goalNodes "size") (int 0))
     (apply displayMessage "KOs" "\nNo Goals\n")
     (let ((res (apply doLolaReq netStr taskStr "0"))
        )
   ; res is an array [code, path] where path begins with PATH followed by tids
       (if (not (= (aget res (int 0)) "0"))
        (apply displayMessage "KOs" "\nNo Path to Goals\n")
    ; candidates is a list of initial nodes that appear in a rule premis
        (let (
              (d4a (if KO-DEBUG
                      (invoke java.lang.System.err "println" 
                        (concat "displayKOs lolapath\n" (aget res (int 1)))))
                )
              (candidates (apply lolaPath2Candidates (aget res (int 1)) graph)) 
              (d4 (if KO-DEBUG
                    (invoke java.lang.System.err "println" 
                       (concat "displayKOs candidates\n" candidates)))
                )
              (kos (apply searchKOs occNodes ruleNodes initNodes goalNodes
                          candidates))
             )
          (apply displayMessage2G
              gname
             "KOs"
              (apply printCol kos
                 (lambda (node strb) 
                     (invoke strb "append"  (concat node "" "\n"))))
           )    
      ) )) ) ; let if let if
   ) ; outer let
)

(apply logDev "ko.lsp loaded")


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/hideEdges.lsp ;;;;;;;;;;
;;; Button UI

(define hideEdgesWidgetState  (hidden? cb rmp hb)
  (if hidden?
      (seq
       (invoke hb "setText" "HideEdges")
       (invoke cb "setEnabled" (boolean true))
       (invoke rmp "setEnabled" (boolean true))
       )
    (seq
     (invoke hb "setText" "UnhideEdges")
     (invoke cb "setEnabled" (boolean false))
     (invoke rmp "setEnabled" (boolean false))
     )
    )
  )

(define mkHideEdgesClosure (gname graph _hidden? cb rmp hb)  ;;remove _hidden? once debugged
  (lambda (self event)
    (let ((dot? (invoke cb "isSelected"))
          (hidden? (invoke graph "getAttributeAsBoolean" "edgesAreHidden" (boolean false)))
          (rmp? (invoke rmp "isSelected"))
          )
      (if hidden?
          (seq
           ;; unhiding hidden edges
           (invoke graph "setAttribute" "edgesAreHidden" java.lang.Boolean.FALSE)
           (apply hideEdgesWidgetState hidden? cb rmp hb)
           (apply unHideEdges gname dot? rmp?)
           )
        (seq
         ;; hiding edges
         (invoke graph "setAttribute" "edgesAreHidden" java.lang.Boolean.TRUE)
         (apply hideEdgesWidgetState hidden? cb rmp hb)
         (apply hideEdges gname dot? rmp?)
         )
        )
      )
    )
  )

(define addHideEdgesButton (toolbar gname graph)
  (let ((hidden? (invoke graph "getAttributeAsBoolean" "edgesAreHidden" (boolean false)))
        (cb (object ("g2d.toolbar.ToolCheckBox" "Redraw?")))
        (rmp (object ("g2d.toolbar.ToolCheckBox" "RMP?")))
        (hb (object ("g2d.toolbar.ToolButton" "HideEdges")))
        (hideTip  (concat "Hides redundant edges."
                          "\nRemoves and redraws if box checked."
                          "\nMakes them invisible otherwise."))
        (hstate  (object ("g2d.util.Variable") ))
        (hideClosure  (apply mkHideEdgesClosure gname graph hidden? cb rmp hb))
        )
    (seq

     (invoke toolbar "prepend" (sinvoke "g2d.toolbar.SeparatorFactory" "makeLargeSep"))
     (invoke toolbar "prepend" rmp)
     (invoke toolbar "prepend" cb)
     (invoke toolbar "prepend" hb)
     (update hstate "booleanValue" (boolean false))

     (invoke hb "setAction" (apply mkAction "HideEdges" hideTip hideClosure))

     ;; if the edges are hidden, then we are probably being called because someone
     ;; pressed the "render" button, so we have to pay attention to that else things
     ;; will be forever out of kilter.
     (if hidden?
         (seq
          (apply hideEdgesWidgetState (boolean false) cb rmp hb)
          (invoke cb "setSelected" (boolean true))
          )
       )
     hb
     )  )
  )

;; iam: 1/25/17
(define hide_the_edges (graph)
  (for e (apply getHiddenEdges graph (boolean false))
       (seq
        ;;(invoke java.lang.System.err "println" (concat "hiding " e))
        (invoke graph "rmEdge" e)
        )
       )
  (invoke graph "setAttribute" "edgesAreHidden" java.lang.Boolean.TRUE)
  )




;; graph operations to support the above UI

;;(invoke edge "setStyle" g2d.graph.IOPEdge.INVIS)
;;(invoke edge "setStyle" g2d.graph.IOPEdge.DASHED))


;; "occsOut" maps occ node ids to list of outgoing edges
;;  similarly for "rulesOut"  where bidir edges are not considered outgoing
(define initEdgeTraversal (graph)
  (let ((edges (invoke graph "getEdgesInArray"))
        (nodes (invoke graph "getNodesInArray"))
        (onodes (apply selectArrl nodes
                       (lambda (node) (= (getAttr node "type") "occ"))))
        (rnodes (apply selectArrl nodes
                       (lambda (node) (= (getAttr node "type") "rule"))))
        (occsOut (object ("java.util.HashMap")))
        (rulesOut (object ("java.util.HashMap")))

        )
    (seq
     (for onode onodes
          (invoke occsOut "put" (getAttr onode "nid")
                  (apply selectArrl edges
                         (lambda (edge) (= (invoke edge "getSource") onode)) )))
     (for rnode rnodes
          (invoke rulesOut "put" (getAttr rnode "nid")
                  (apply selectArrl edges
                         (lambda (edge)  (= (invoke edge "getSource") rnode)) )
                  )) ;; invoke for
     (setAttr graph "occsOut" occsOut)
     (setAttr graph "rulesOut" rulesOut)
     ) ; seq
    ) ; let
  ) ; define



;; returns a list of rules reachable from rule
;; by following out edges (not bidir edges)
(define eReach (occsOut rulesOut rule)
  (apply eReach1 occsOut rulesOut
         (object ("java.util.ArrayList" ))
         rule
         (object ("java.util.ArrayList"))
         )
  )

(define eReach1 (occsOut rulesOut done rule new)
  (let ((olist (apply map
                      (invoke rulesOut "get" (getAttr rule "nid"))
                      (lambda (edge accum)
                        (invoke accum "add" (invoke edge "getSink") ) )
                      (object ("java.util.ArrayList"))   ) ; apply
               ) ; olist -- the rule output occs
        )
    (seq
     (invoke done "add" rule)
     (for occ olist
          (for edge (invoke occsOut "get" (getAttr occ "nid"))
               (let ((sink (invoke edge "getSink")))
                 (if (not (or (invoke done "contains" sink)
                              (invoke new "contains" sink)))
                     (invoke new "add" sink))
                 ) ; let
               ) ) ; for for
     (if (= (invoke new "size" ) (int 0))
         done
       (apply eReach1 occsOut rulesOut done (invoke new "removeFirst") new)
       )
     ) ) ; seq let
  )

(define addRedundantEdges (occsOut rulesOut cand tohide)
  ;; first associate each edge with reachable rules
  ;; rch is a list of rule lists, one for each edge in cand
  ;; then use that to find the non-minimal edges and add them to tohide
  (let ((rch (apply findReach occsOut rulesOut cand)))
    ;; now partition cand into min and non-min (hidable)
    ;;(invoke java.lang.System.err "println" (concat "lsp cand: " cand))
    ;;(invoke java.lang.System.err "println" (concat "lsp rch: " rch))

    (apply findHides cand rch tohide)
    )
  )


(define findHides (cand rch tohide)
  (let ((len (invoke rch "size"))
        (keep (object ("java.util.ArrayList")))
        (hide? (object ("java.util.ArrayList")))
        )
    (seq
     ;; put index of edges whose target not reachable from another edge in keep
     ;; put index of other edges in hide?
     (apply targetSplit rch keep hide? len (int 0))
     ;; for h in hide? if rch[h][0] in rch/keep add cand[h] to tohide
     (apply checkHide cand rch keep hide? tohide len (int 0))
     )
    )
  )

;; rch a list of non-empty rule lists, keep/hide? lists of indices into rch
;; len the size of rch and cur the current rlist
;; modifies keep and hide? returns true
(define targetSplit (rch keep hide? len cur)
  (if (>= cur len)
      (boolean true)
    (let ((rls (invoke rch "get" cur))
          (rl (invoke rls "get" (int 0)))
          )
      (seq
       (if (apply findRule rch rl len cur (int 0))
           (invoke hide? "add" (object ("java.lang.Integer" cur)))
         (invoke keep "add" (object ("java.lang.Integer" cur)))
         )
       (apply targetSplit rch keep hide? len (+ cur (int 1)))
       ) ; seq
      ))  ; let if
  )

(define findRule (rch rl len omit cur)
  (if (>= cur len)
      (boolean false)
    (if (= cur omit)
        (apply findRule  rch rl len omit (+ cur (int 1)))
      (if (invoke (invoke rch "get" cur) "contains" rl)
          (boolean true)
        (apply findRule  rch rl len omit (+ cur (int 1)))
        ))) ; if x 3
  )

(define findList (krch rl len  cur)
  (if (>= cur len)
      (boolean false)
    (if (invoke (invoke krch "get" cur) "contains" rl)
        (boolean true)
      (apply findList krch rl len (+ cur (int 1)))
      )) ; if x 2
  )

;; for Integer(h) in hide? if rch[h][0] in rch/keep add cand[h] to tohide
(define checkHide (cand rch keep hide? tohide len cur)
  (let ((krch
         (apply map keep
                (lambda (ix accum)
                  (invoke accum "add" (invoke rch "get" (invoke ix "intValue"))))
                (object ("java.util.ArrayList"))))    ; rch/keep
        (klen (invoke krch "size"))
        )
    (for ixb hide?
         (let ((ix (invoke ixb "intValue")))
           (if (apply findList krch
                      (invoke (invoke rch "get" ix) "get" (int 0))
                      klen
                      (int 0))
               (invoke tohide "add" (invoke cand "get" ix))
             )) ; if let
         ) ; for
    )
  )

(define findReach (occsOut rulesOut cand)
  ;; returns a list of rule lists, one for each edge in cand
  (apply map cand
         (lambda (edge accum)
           (invoke accum "add"
                   (apply eReach occsOut rulesOut (invoke edge "getSink")) ) )
         (object ("java.util.ArrayList"))
         )
  )

(define findCandidates (occsOut onodes)
  (apply map onodes
         (lambda (onode accum)
           (let ((edges (invoke occsOut "get" (getAttr onode "nid")))
                 (bedges (apply selectArrl edges
                                (lambda (edge)(= (getAttr edge "bidir") "true"))))
                 )
             (if (>= (invoke bedges "size") (int 2))
                 (seq
                                        ; (invoke bedges "addFirst" onode) ; onode is src of each
                  (invoke accum "add" bedges)
                  )
               ) ;if
             )) ; let lambda
         (object ("java.util.ArrayList"))
         )
  ) ; candidates

;; returns list of edges to hide and caches them under "hiddenEdges"
;; a candidate a list of double ended edges with the same source,
;; potentially some are hideable.
(define setHiddenEdges (graph)
  (let ((nodes (invoke graph "getNodesInArray"))
        (onodes (apply selectArrl nodes
                       (lambda (node) (= (getAttr node "type") "occ"))))
        (occsOut  (getAttr graph "occsOut"))
        (rulesOut  (getAttr graph "rulesOut") )
        ;; [[e1 .. ek]*]
        (candidates (apply findCandidates occsOut onodes))
        (tohide
         (apply map
                candidates
                (lambda (cand accum)
                  (apply addRedundantEdges occsOut rulesOut cand accum))
                (object ("java.util.ArrayList"))))
        ) ; let list
	(seq
     ;;(invoke java.lang.System.err "println" (concat "lsp candidates: " candidates))
	 (apply logDev (concat "tohide.size() = " (invoke tohide "size") "\nhiddenEdges: " tohide))
     (setAttr graph "hiddenEdges" tohide)
     tohide
     ) ;seq
    ) ; let
  ) ; find

;;; if graph is not a subnet parseArgs should return [] [] []
;;; and all will be well
(define setHiddenEdgesRmp (graph)
  (let ((jnet (apply ensureSubnet graph))
      	(model (apply ensureRMPModel graph))
        (hes (sinvoke "rmp.HideEdges" "computeHideableEdges" model))
        (tohide (apply hideableEdges2edges graph hes))
        )
    ;;(apply logDev (concat "hes_rmp.size() = " (invoke hes "size") ", hes_rmp = " hes))
    (setAttr graph "hiddenEdgesRmp" tohide)
    tohide
    ))

(define  hideableEdges2edges (graph hets)
  (let ((tohide (object ("java.util.ArrayList"))))
    (for het hets
         (let ((tgt (lookup het "transitionID"))
               (src (lookup het "placeID"))
               (edge (invoke graph "getEdge"
                             (invoke graph "getIOPNode" src)
                             (invoke graph "getIOPNode" tgt)))
               )
           (invoke tohide "add" edge)
           ))
    tohide) )


(define getHiddenEdges (graph ?rmp)
  (let ((edges (if ?rmp
                   (getAttr graph "hiddenEdgesRmp")
                 (getAttr graph "hiddenEdges"))))
    (if (instanceof edges "java.util.List")
        edges
      (object ("java.util.List"))
      ))
  )

;; (invoke edge "setStyle" g2d.graph.IOPEdge.INVIS)
;; (invoke edge "setStyle" g2d.graph.IOPEdge.DASHED))
(define mkEdgesInvis (graph ?rmp)
  (let ((panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph)))
    (seq
     (for e (apply getHiddenEdges graph ?rmp)
          (invoke e "setStyle" g2d.graph.IOPEdge.INVIS))
     (invoke graph "fireChange")
     ;;     (invoke panel "repaint")
     )
    )
  )

(define mkEdgesDashed (graph ?rmp)
  (let ((panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph)))
    (seq
     (for e (apply getHiddenEdges graph ?rmp)
          (invoke e "setStyle" g2d.graph.IOPEdge.DASHED))
     (invoke graph "fireChange")
     ;;(invoke panel "repaint")
     )
    )
  )

;; assume "isDotLayout" see defineGraph.lsp delXEdge
(define removeEdges (graph ?rmp)
  (seq
   (for e (apply getHiddenEdges graph ?rmp) (invoke graph "rmEdge" e))
   (apply redisplay graph)
   )
  )

(define restoreEdges (graph ?rmp)
  (seq
   (for e (apply getHiddenEdges graph ?rmp) (invoke graph "addEdge" e))
   (apply redisplay graph)
   )
  )

;;; TOP LEVEL  only for pnets, maybe comparison, not editable nets
;;; unhideEdges only available if hidden and hidding remembers the mode
;;;
;; if ?dot remove the edges and redisplay, ow just make them invisible
(define hideEdges (gname ?dot ?rmp)
  (let ((graph (fetch gname))
        (start (sinvoke "java.lang.System" "nanoTime"))
		(isLarge (invoke graph "isLarge")))
    (if (invoke graph "isDotLayout")
        (seq
         (if ?rmp
             ;; use robin's code
             ;; used cached edgelist if available
             (if (isnull (getAttr graph "hiddenEdgesRmp"))
                 (apply setHiddenEdgesRmp graph))
           ;;use who ever wrote this code's code.
		   (seq
			;; switch to flick to go back to the lisp route
			(if (boolean true)
				;;                                 parent (hide edges will look for it)
                (let ((plaobj (sinvoke "g2d.pla.PLAGraph" "getPLAGraph" graph (object null))))
                  (setattr graph g2d.pla.PLAGraph.graphAttribute plaobj)
                  )
              ;; only initialize if necessary
			  (seq
			   (if (or (isnull (getAttr graph "occsOut")) (isnull (getAttr graph "rulesOut")))
				   (apply initEdgeTraversal graph))
			   ;; used cached edgelist if available
			   (if (isnull (getAttr graph "hiddenEdges"))
				   (apply setHiddenEdges graph))
			   )
			  )
			)
		   )
         (let ((hTime (sinvoke "java.lang.System" "nanoTime")))
           (if isLarge
			   (apply logDev (concat "hideEdges took "  (/ (- hTime start) (int 1000000)) " milliseconds")))
           (if ?dot
			   (seq
				(if isLarge (apply logDev "now doing dot layout ..."))
				(apply removeEdges graph ?rmp))
			 (apply mkEdgesInvis graph ?rmp))
           (if isLarge
			   (apply logDev (concat "... dot layout after hideEdges took "  (/ (- (sinvoke "java.lang.System" "nanoTime") hTime) (int 1000000)) " milliseconds"))
			 )
           )
         )
      ;;complain
      (apply displayMessage "hideEdges" "Hiding edges not allowed in Context")
      )
    )
  )

;; if ?dot restore the removed edges and redisplay, ow just make them visible
(define unHideEdges (gname ?dot ?rmp)
  (let ((graph (fetch gname)))
    (if ?dot (apply restoreEdges graph ?rmp) (apply mkEdgesDashed graph ?rmp))
    ) ; let
  )


(define test (gname)
  (seq
   (define g (fetch gname))
   (apply initEdgeTraversal g)
   (define onodes (apply selectArrl (invoke g "getNodesInArray") (lambda (node) (= (getAttr node "type") "occ"))))
   (define oOut (getAttr g "occsOut"))
   (define rOut (getAttr g "rulesOut"))
   (define cands (apply findCandidates oOut onodes))
   (define cand0 (invoke cands "get" (int 0)))
   (define cand1 (invoke cands "get" (int 1)))
   (define rch0 (apply findReach oOut rOut cand0) )
   (define rch1 (apply findReach oOut rOut cand1) )
   (define len0 (invoke rch0 "size"))
   (define len1 (invoke rch1 "size"))
   (define keep0 (object ("java.util.ArrayList")))
   (define keep1 (object ("java.util.ArrayList")))
   (define hide0 (object ("java.util.ArrayList")))
   (define hide1 (object ("java.util.ArrayList")))
   (define tohide0 (object ("java.util.ArrayList")))
   (define tohide1 (object ("java.util.ArrayList")))
   )
  )

(apply logDev "hideEdges.lsp loaded")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/occs.lsp ;;;;;;;;;;
; needs util.lsp
;; things as aexps
; base case (array java.lang.Object "base" "Src" "Protein")

; modified (array java.lang.Object "modified" <base> <mod1> ... <modn>)
; mod  is string 
;  or sited  (array java.lang.Object "mod" "phos" "Y"  "395") 
;  or  (array java.lang.Object  "mod" "num"  "2") 

; complex (array java.lang.Object "complex" <o1> ... <on>)
;   (setAttr kbg "occ-aexps" occ-aexps)


(define thing2baselist (thing) 
  (let ((list (object ("java.util.ArrayList"))))  
   (seq
     (if (apply isArray thing) 
       (if (> (lookup thing "length") (int 1)) 
         (apply thing2baselistX thing list)))
     list
  ))
)

;  thing is array of len at least 2
(define thing2baselistX (thing list)
  (let ((tag (aget thing (int 0 ))))
    (if (= tag "base")
      (apply setAdd list (aget thing (int 1)))
      (if (= tag "modified")
        (apply setAdd list  (aget (aget thing (int 1)) (int 1)))
        (if (= tag "complex")
         (apply thing2baselistCX  thing list (int 1) (lookup thing "length"))
      ))) ; if x 3
   ) ;let
)

; thing is complex, cur is
(define thing2baselistCX (thing list cur len)
  (if (> len cur) 
    (seq
     (apply thing2baselistX (aget thing cur) list)
     (apply thing2baselistCX  thing list (+ cur (int 1)) len)
    ))
)    

;; input array of aexps
;; output corresponding array of bases
(define computeBasis (aexp-arr)
  (let (
        (len (lookup aexp-arr "length"))
        (basis-arr (mkArray java.util.ArrayList len))
        )
      (apply computeBasisX aexp-arr basis-arr len (int 0))        
  )
) ; computeBasis

(define computeBasisX (aexp-arr basis-arr len cur)
  (if (> len cur)
   (seq
     (aset basis-arr cur (apply thing2baselist (aget aexp-arr cur)))
     (apply computeBasisX aexp-arr basis-arr len (+ cur (int 1)))        
   )
   basis-arr
  )
)

(define test ()
(seq
(define thing-src  (array java.lang.Object "base" "Src" "Protein"))
(define thing-ras  (array java.lang.Object "base" "Ras" "Protein"))
(define thing2  (array java.lang.Object "modified" thing-src "act"))
(define thing3  (array java.lang.Object "modified" thing-ras 
                     "act" (array java.lang.Object "phos" "Y"  "395") ))
(define thing4  (array java.lang.Object "complex" thing-src thing3)) 
(define thing5  (array java.lang.Object "complex" thing-ras thing2)) 
   
; (apply thing2baselist thing-src)
(define labs (array java.lang.String "Src" "Ras" "Src-act" "Ras-Yphos" 
"Src:Ras" "Src-act:Ras"))
(define aexps (array java.lang.Object thing-src thing-ras thing2 thing3 thing4 thing5))

(define barr (apply computeBasis aexps))
(define frame (getAttr (fetch "KBManager") "kbframe"))
(define ddialog (object ("g2d.subset.DDialog" frame (boolean false))))
(invoke ddialog "setScope" labs barr)
(invoke ddialog "setVisible" (boolean true))
)
)  ; test

(apply logDev "occs.lsp loaded")

; (load "~/Maude/Lib/M2.2/PLA1/G2dLib/occs.lsp")
; (apply printArr labs)
; (apply printArr aexps)
; (apply printArr barr)


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/color-loc.lsp ;;;;;;;;;;
;; eventually add to graphMenu

(define colorLoc (gname loc)
  (let ((graph (fetch gname))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (frame (sinvoke "g2d.pla.PLAUtils" "getTabFrame" panel))
        (chooser (object ("javax.swing.JColorChooser")))
        (color (invoke chooser "showDialog" frame "Color Chooser" 
                       java.awt.Color.white))
        (nodes (apply getLocNodes graph loc))
        )
    (seq
     (for node nodes (invoke node "setFillColor" color))
     (invoke panel "repaint") 
     )
    )
  )

(define getLocNodes (graph loc)
  (let ((nodes (invoke graph "getNodesInArray"))
        (list (object ("java.util.ArrayList")))
        )

    (seq
     (for node nodes (if (apply hasLoc node loc) (invoke list "add" node)))
     list
     )
    )    
  )

(define hasLoc (node loc)
  (invoke (getAttr node "chattylabel") "endsWith" loc )
  )

(define restoreColor (gname)
  (let ((graph (fetch gname))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (colorFun (getAttr graph "colorFun"))
        (nodes (invoke graph "getNodesInArray"))
        )
    (seq
     (for node nodes (invoke node "setFillColor" (apply colorFun node)))
     (invoke panel "repaint") 
     )
    )
  )


(define test ()
  (seq
   (define g2 (fetch "graph2"))
   (define nout (invoke g2 "getNode" "6"))   ;  "6" "Egf-Out"
   (define nclm (invoke g2 "getNode" "7"))    ; "7" "EgfR" "EgfR-CLm" 
   (define ncli (invoke g2 "getNode" "24"))   ; "24" "Pak1-act" "Pak1-act-CLi"
   ))

(apply logDev "color-loc.lsp loaded")




;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/progress.lsp ;;;;;;;;;;
(seq

  (define makeProgressDialog2 (frame modal) 
    (let ((retval (object  ("javax.swing.JDialog" frame modal)))
	  (cpane (invoke retval "getContentPane"))
	  (layout (object ("java.awt.BorderLayout")))
	  (panel (object ("javax.swing.JPanel" layout)))
	  (dim (object ("java.awt.Dimension" (int 250) (int 25))))
	  (bar (object ("javax.swing.JProgressBar")))
	  )
      (seq 
       (invoke retval "setDefaultCloseOperation"
           javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE)
       (invoke panel "setPreferredSize"  dim)
       (invoke bar "setStringPainted" (boolean false))
       (invoke bar "setIndeterminate" (boolean true))
       (invoke panel "add" bar java.awt.BorderLayout.CENTER)
       (invoke cpane "add" panel java.awt.BorderLayout.CENTER)
       (invoke retval "setLocationRelativeTo" frame)
       (invoke retval "pack")
       retval
       )
      )
    )

  (define showProgressDialog (pdialog title) 
    (seq (invoke pdialog "setTitle" title)
	 (invoke pdialog "setVisible" (boolean true))
	 )
    )

  (define hideProgressDialog (pdialog) 
    (invoke pdialog "setVisible" (boolean false))
    )

  (define testMe () 
    (let ((frame (object ("g2d.swing.IOPFrame" "test")))
	  (pd (apply makeProgressDialog2 frame (boolean false))))
      (seq 
       (invoke frame "setVisible" (boolean true))
       (apply showProgressDialog pd "This will not go away"))
      )
    )
  )


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/imlab.lsp ;;;;;;;;;;

(define isSMod (mod) (invoke mod "startsWith" "s"))
(define isXMod (mod) (invoke mod "startsWith" "x"))
(define isPMod (mod) 
 (if (invoke mod "startsWith" "x") (boolean false)
 (if (invoke mod "startsWith" "s")  (boolean false)
 (boolean true)
 )))

;; chattylabel -> [marble pmods smods xmods loc] -- hashmap
(define imlab2parts (lab)
  (let ((imparts (object ("java.util.HashMap")))
        (thloc (invoke lab "split" "@")))
   (if (not (= (lookup thloc "length") (int 2))) ;; better be length 2
    (invoke java.lang.System.err "println" "missing @")
    (let ((ths (invoke (aget thloc (int 0)) "split" ":"))
          (loc (aget thloc (int 1)))
          (things (object ("java.util.ArrayList")))
         )
      (seq 
        (for thlab ths (invoke things "add" (apply thlab2parts thlab)))
        (invoke imparts "put" "things" things)
        (invoke imparts "put" "loc" loc)
        imparts
      )))))

(define thlab2parts (thlab)
   (let ((thmods (invoke thlab "split" "-"))
         (marble (aget thmods (int 0)))
         (len (lookup thmods "length"))
         (thparts (object ("java.util.HashMap"))) )
    (seq
     (invoke thparts "put" "marble" marble)
     (invoke thparts "put" "pmods"  
       (apply getIMods isPMod thmods len (int 1) (object ("java.util.ArrayList"))))
     (invoke thparts "put" "smods" 
       (apply getIMods isSMod thmods len (int 1) (object ("java.util.ArrayList"))))
      (invoke thparts "put" "xmods"
       (apply getIMods isXMod thmods len (int 1) (object ("java.util.ArrayList"))))
       thparts
     )))

;; [marble m1 ... mk]
(define getIMods (mtest thmods len cur mods)
  (if (>= cur len) 
   mods
   (seq
     (if (apply mtest (aget thmods cur)) (invoke mods "add" (aget thmods cur)))
     (apply getIMods mtest thmods len (+ cur (int 1)) mods)
   )))

(define shortImLab (imparts)
   (concat 
      (apply shortThLab (invoke imparts "get" "things"))
      "@"
      (invoke imparts "get" "loc") )
  )

(define shortThLab (things)
  (let ((sbuf (object ("java.lang.StringBuffer"))))
    (seq 
      (for thparts things 
         (seq
           (invoke sbuf  "append" ":")
           (invoke sbuf "append"
               (concat 
                 (invoke thparts "get" "marble")
                 (apply modSuffix (invoke thparts "get" "pmods") )
               ))
       ))
     (invoke sbuf "deleteCharAt" (int 0))
     (invoke sbuf "toString")
)))
   

(define modSuffix (mods)
  (let ((sbuf (object ("java.lang.StringBuffer"))))
    (seq
     (for mod mods (invoke sbuf "append" (concat "-" mod)))
     (invoke sbuf "toString") 
    )) )


(define fixImNodeLab (node)
  (let ((clab (getAttr node "chattylabel"))
         (imparts (apply imlab2parts clab))
         (slab (apply shortImLab imparts))
        )
     (seq
       (setAttr node "imparts" imparts)
       (setAttr node "imlab" slab)
    )))

(define fixImLabs (gname) (apply fixImLabsX (fetch gname)))

(define fixImLabsX (graph)
 (let ((nodes (invoke graph "getNodesInArray")))
  (seq  
   (for node nodes
     (if (= (getAttr node "type") "occ")
       (let ((clab (getAttr node "chattylabel"))
             (imparts (apply imlab2parts clab))
             (slab (apply shortImLab imparts))
            )
         (seq
            (setAttr node "imparts" imparts)
            (setAttr node "imlab" slab)
            (setAttr node "label" slab)   ;; really short label
            (invoke node "setLabel" slab)  ;; initially short
          ))))
    )))

(define shrinkImLabs (gname)
  (seq
    (apply fixImLabs gname)
    (apply setNodeLabels gname "occ" "imlab")
))


;;    (apply fixImLabs "graph2")
;;    (apply setNodeLabels "graph2" "occ" "imlab")
;; (invoke g2 "getNode" nid) 

(define test-imlab ()
(seq
(define l3 "DC1-mature-sCcl18-xB7-xCcR7-xMhcI*-xMhcII*:TC8-naive-xCd28-xCd8-xIL4R.Io-xTcR*:TH1-effective-xCd28-xCd4-Fas-xFasL-xIL2Ra.Io-xIL4R.Io-xSIpR-xVLA4@LN")

(define dcpsx "DC2-mature-sCcL18-xB7-xCcR7-xMhcI*-xMhcII*@LN")
(define dcps "DC2-mature-sCcL18@LN")
(define dcs "DC2-sCcL18@LN")
(define dcpx "DC2-licensed-xCcR7@LN")
(define dcp "DC2-licensed@LN")
(define dcx "DC2-xCcR7@LN")
(define ant "Ant*@LN")
(define dc "DC2@PTS" )
))

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/jutil.lsp ;;;;;;;;;;

;;; reading json

;; java.lang.Object	parse(java.io.Reader in) 
;; ArrayList<String> file2ArrayList(String filename, boolean skipblanks)
;; String file2String(String filename, char comment)

(define fileExists (fname)
  (let ((fnameX (sinvoke "g2d.util.IO" "interpretTilde" fname))
        (file (object ("java.io.File" fnameX))) )
    (invoke file "exists")
  ))

;; returns json java object parsed from fname
;; returns null if file does not exist
;; presumes it is not remote
(define _readJSonF (fname)
  (let ((fnameX (sinvoke "g2d.util.IO" "interpretTilde" fname))
        (file (object ("java.io.File" fnameX)))
        (reader (if (invoke file "exists")
                    (object ("java.io.FileReader" fnameX))
                    (object null)))
        )
   (if (isnull reader)
       (object null) 
       (sinvoke "org.json.simple.JSONValue" "parse" reader)
  )))

;; returns json java object parsed from fname
;; returns null if file does not exist
;; presumes it might be remote
(define readJSonF (fname)
  ;;(invoke java.lang.System.err "println" (concat "readJSonF: " fname))
  (if (not (sinvoke "g2d.Main" "isRemote"))
      (apply _readJSonF fname)
    (let ((jsonstr (sinvoke "g2d.pla.FileSystem" "ask4Contents" fname)))
      (if (= jsonstr "")
          (object null)
        (sinvoke "org.json.simple.JSONValue" "parse" jsonstr)
        )
      )
    )
  )


;; returns json java object parsed from fname
;; presumes it is not remote
(define readJSonS (fname)
  (let ((jstr (sinvoke "g2d.util.IO" "file2String" fname) ))
    (sinvoke "org.json.simple.JSONValue" "parse" jstr) ))


(define jsonTest (jstr)
  (let ((jobj (sinvoke "org.json.simple.JSONValue" "parse" jstr)))
    (invoke java.lang.System.err "println" (concat "jval: " jobj))
))

(define jsonNetTest (jstr)
  (let ((jobj (sinvoke "org.json.simple.JSONValue" "parse" jstr)))
    (invoke java.lang.System.err "println" (concat "jval: " jobj))
))

(define loadJNet (fname)
  (let ((jobj (apply readJSonF fname)))
   (if (instanceof jobj "java.util.Map") (apply addJNet jobj) )
))

;; assume jobj instanceof Map
(define addJNet (jobj)
  (let ((name (invoke jobj "get" "name"))
        (kbname (invoke jobj "get" "kbname"))
        (jkb (if (instanceof kbname "java.lang.String") 
                (getAttr (fetch kbname) "jkb") (object null)))
       (netmap0 (if (isobject jkb) (getAttr jkb "netmap") (object null)))
       (netmap (if (isobject netmap0) 
                 netmap0
               ;;  if jkb exists initialize the netmap
                 (if (isnull jkb)  
                  (object null)
                  (let ((nm (object ("java.util.HashMap"))))
                     (setAttr jkb "netmap" nm) nm)
                )))
      )
   (if (isobject netmap) (invoke netmap "put" name jobj))
))

(define lookupd (map tag default)
  (let ((val (invoke map "get" tag))) (if (isnull val) default val)
))

(define itPred (it pred)
  (if (invoke it "hasNext")
    (if (apply pred (invoke it "next")) 
       (apply itPred it pred)
       (boolean false) )
    (boolean true) ))

;; the index of elt in arr, -1 if not found
(define getIndex  (arr len elt cur)
  (if (>= cur len)  
    (int -1)
    (if (= (aget arr cur) elt) cur (apply getIndex arr len elt (+ cur (int 1))))
    ))

(define names2objs (map names)
  (let ((objs (object ("java.util.ArrayList"))))
    (seq
      (for name names 
         (let ((obj (invoke map "get" name)))
            (if (not (isnull obj)) (invoke objs "add" obj)) ))
      objs )))

;; non or empty arrl to null, none empty arrl to name arrl
(define objs2namesX (objs)
   (if (instanceof objs "java.util.ArrayList")
     (if (> (invoke objs "size") (int 0))
        (apply objs2vals objs "name")
        (object null))
    (object null)) )

;; non- or empty arrl -> []
(define objs2names (objs)
  (let ((names (object ("java.util.ArrayList"))))
    (seq
      (if (instanceof objs "java.util.ArrayList")
        (for obj objs (invoke names "add" (lookup obj "name"))))
      names
      )))

;; utilities
(define objs2vals (objs tag)
  (let ((names (object ("java.util.ArrayList"))))
    (seq
      (for obj objs (invoke names "add" (lookup obj tag)))
      names )))

(define objs2attrs (objs tag)
  (let ((names (object ("java.util.ArrayList"))))
    (seq
      (for obj objs (invoke names "add" (getAttr obj tag)))
      names )))

;; Sorting out bp2pl sorts vs Maude types
;; 
;; Maude OPS  and Types
;; 
;; LOCATIONOPS LocName
;; MODIFICATIONOPS  Modification
;;   constants,  op(arg) : Modification  arg could be Site, Gcode, Protein ....
;; 
;; PROTEINOPS   Protein  --- BProtein, Peptide, SpliceVariant
;; CHEMICALOPS  Chemical --- Chemical, Lipid, 
;; GENEOPS      Gene
;; SIGNATUREOPS Signature
;; CELLOPS      Cell      < Marble  probably < SimpleThing is good enough
;; STRESSOPS    Stress
;; PATHOGENOPS  Pathogen --- bug or bugbit ...
;; GLYCANOPS    Glycan   --- Gcode
;; 
;; 
;; SimpleOccurrence sorts = EntityReference sorts
;; 
;; 	PROT = 0;
;; 	CHEM = 1;
;; 	DNA = 2;
;; 	RNA = 3; 
;; 	SIGNATURE = 4; 
;; 	CELL = 5; 
;; 	STRESS = 6;
;; 	PATHOGEN = 7;
;; 	GLYCAN = 8;

 
(define simpleOps 
  (let ((so (object ("java.util.ArrayList"))))
    (seq
      (invoke so "add" "PROTEINOPS")
      (invoke so "add" "CHEMICALOPS")
      (invoke so "add" "GENEOPS")
      (invoke so "add" "RNAOPS")
      (invoke so "add" "SIGNATUREOPS")
      (invoke so "add" "CELLOPS")
      (invoke so "add" "STRESSOPS")
      (invoke so "add" "PATHOGENOPS")
      (invoke so "add" "GLYCANOPS")
      so
    )))

(define simpleTypes
  (let ((so (object ("java.util.ArrayList"))))
    (seq
      (invoke so "add" "Protein")
      (invoke so "add" "Chemical")
      (invoke so "add" "Gene")
      (invoke so "add" "RNA")
      (invoke so "add" "Signature")
      (invoke so "add" "Cell")
      (invoke so "add" "Stress")
      (invoke so "add" "Pathogen")      
      (invoke so "add" "Glycan")  ;; Gcode???
      so
    )))

(define plOps2Sort (ops) (invoke simpleOps "indexOf" ops))
(define plOps2Type (ops) 
  (let ((sort (invoke simpleOps "indexOf" ops)))
     (if (and (>= sort (int 0)) (< sort (invoke simpleTypes "size")))
         (invoke simpleTypes "get" sort) "")))
(define bpSort2Ops (sort) 
     (if (and (>= sort (int 0)) (< sort (invoke simpleOps "size")))
         (invoke simpleOps "get" sort) ""))
(define bpSort2Type (sort)
     (if (and (>= sort (int 0)) (< sort (invoke simpleTypes "size")))
         (invoke simpleTypes "get" sort) "")) 
(define plType2Sort (type) (invoke simpleTypes "indexOf" type))
(define plType2Ops (type) 
  (let ((sort (invoke simpleTypes "indexOf" type)))
     (if (and (>= sort (int 0)) (< sort (invoke simpleOps "size")))
         (invoke simpleOps "get" sort))))

;; sOp2Etype >> plOps2Type
;; esort2osort 
;; ekind2esort(type) >> plType2Sort

 (apply logDev "jutil.lsp loaded")
;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/jinfo.lsp ;;;;;;;;;;
;; requires jutil.lsp 
;;  replace displayComponentInfo call to Maude with (apply displayOccInfo graph clab)

(define displayJNodeInfo (graph node clab)
  (let ((gname (getuid graph))
        (strb (object ("java.lang.StringBuffer")))
        (title (concat "About node " clab))
	)
    (seq
     (apply addNodeInfo node strb)
     (apply displayMessage2G gname title (invoke strb "toString"))
     )))

(define addNodeInfo (node strb) 
  (let ((keyarr (invoke node "getKeys")))
    (for key keyarr 
	 (seq 
          (invoke strb "append" key)
          (invoke strb "append" ": ")
          (invoke strb "append" (getAttr node key))
          (invoke strb "append" "\n")
	  ))
    ))


(define displayJComponentInfo (graph clab)
  (try
   (let ((kbname (if (instanceof graph "g2d.jlambda.Attributable")
		     (getAttr graph "kbname" "")
		   "")) 
	 (gname (getuid graph))
	 (kb (fetch kbname))
	 (jkb (if (instanceof kb "g2d.jlambda.Attributable") 
		  (getAttr kb "jkb")
                (object null)))
	 (title (concat "About Occurrence " clab)) )
     (if (isnull jkb)
	 (apply displayMessage2G gname title "No KB")
       (let ((occmap (lookup jkb "occmap"))
	     (occ (invoke occmap  "get" clab))
	     (strb (object ("java.lang.StringBuffer")))
	     ) 
         (seq 
	  (apply addOccInfo occ strb)
	  (apply displayMessage2G gname title (invoke strb "toString"))
	  ))) )
   (catch e (invoke java.lang.System.err "println" (invoke e "getMessage")))
   ))

(define addOccInfo (occ strb)
  (seq
   (invoke strb "append" "<html><br> ")
   (if (instanceof occ "bp2pl.SimpleOccurrence")
       (apply mkSimpleOccInfo occ strb)
     (if (instanceof occ "bp2pl.ComplexOccurrence")
	 (apply mkComplexOccInfo occ strb)
       (invoke strb "append"  "Unknown occurrence class") ) )
   ;;buggy: (invoke strb "append" "<p>")
   (let ((loc (lookup occ "location") )
	 (lname (lookup loc "name"))
	 (md (getAttr loc "metadata")) 
	 (desc (if (instanceof md "java.util.Map")
		   (invoke md "get" "definition") 
		 ""))
	 )
     (invoke strb "append" (concat "<p><b>Location</b>: " lname " " 
				   (if (isnull desc) "</p>" (concat desc "</p>"))))
     )
   (invoke strb "append" "</html>")
   ))

(define mkSimpleOccInfo (occ strb)
  (let ((eref (lookup occ "eref"))
        (mods (lookup occ "modifiers"))
        (name (lookup eref "name")) 
        )
    (let ((sfun (apply getSimpleInfoFun eref)))
      (seq
       (if (isnull sfun)  
           ;; 13nov09 clt
           (apply mkEntityInfo eref name strb)   ;;unknown eref class
         ;;         (invoke strb "append" (concat "Entity: " name))  
         (apply sfun eref name strb))
       (if (and (instanceof mods "java.util.ArrayList") 
                (> (invoke mods "size") (int 0)) )
           (apply addModItems mods strb)
         )
       )) ))

(define mkEntityInfo (eref name strb)
  (let ((md (getAttr eref "metadata"))
	(sort (if (isobject md) 
                  (let ((sort0 (invoke md "get" "sort")))
                    (if (isobject sort0) sort0 ""))
		""))
	)
    (invoke strb "append" (concat "<p>" name " : " sort "</p>"))
    ))

;; add cases for
;;  (= esort bp2pl.EntityReference.SIGNATURE ) 
;;  (= esort bp2pl.EntityReference.CELL ) 


(define mkComplexOccInfo (occ strb)
  (let ((components (lookup occ "components")))
    (seq 
     (invoke strb "append" (concat "<b>Name</b>: " (lookup occ "name") " <em> of sort</em> Complex"))

     (invoke strb "append" (concat "<p><b>Components</b>: <ul>"))
     (for socc components 
	  (seq 
           (invoke strb "append" " <li>")
           (apply mkSimpleOccInfo socc strb)
           (invoke strb "append" " </li>")
	   ))
     (invoke strb "append" " </ul>")
     (invoke strb "append" " </p>")
     )))   

;; For BaseProtein
;; entity: <ename>
;; uniprot: <ulink>
;; hugosym: <hugolink>
;; synonyms: <slist>

;; items is a non empty arraylist of strings
(define addItems (tag items strb)
  (seq
   (invoke strb "append" (concat "<b>" tag "</b>: "))
   (if (not (instanceof items "java.util.List") )
       (invoke strb "append" (concat "" items))
     (if (= (invoke items "size") (int 1))
	 (invoke strb "append"  (invoke items "get" (int 0)) )
       (seq 
	(invoke strb "append"  "<ul>" )
	(for item items (invoke strb "append" (concat "<li>" item "</li>")) )
	(invoke strb "append"  "</ul>" )
	))) ))


(define displayJRuleEvidence (graph rlab )
  (let ((kbname (getAttr graph "kbname" ""))
	(kb (fetch kbname))
	(gname (lookup graph "name"))
	(jkb (if (instanceof kb "g2d.jlambda.Attributable") 
		 (getAttr kb "jkb")
	       (object null)))
	(title (concat "Evidence for Rule: " rlab)) 
	(strb (object ("java.lang.StringBuffer"))) )
    (if (isnull jkb)
	(apply displayMessage2G gname title "No KB")
      (seq
       (apply addRuleEvidence  
	      (invoke (lookup jkb "rulemap") "get" rlab) 
	      (getAttr kb "evidencePath" evidencePath ) strb)
       (apply displayMessage2G gname title (invoke strb "toString"))
       )) ))

;; "evidence":
;; {"stype":"evspec","evtype":"datum","val":"/Egf-Evidence/Gab1.irt.Egf.116.html"}
;;;; 19feb07 clt  fixing rule evidence display
;; added getRuleEvidenceTypeVal, edited addRuleEvidence
;; if the rule has an "evidence" attribute, it should be
;; a map with evtype and val keys
;; see if there is a metadata attribute 
;; if so use the pmid key if any
(define getRuleEvidenceTypeVal (rule)
  (let ((ev (getAttr rule "evidence")))
    (if (instanceof ev "java.util.Map") 
;;19feb20 evidence >> ev
      (apply mkPair (invoke ev "get" "evtype") 
                    (invoke ev "get" "val") )
     (let ((md (getAttr rule "metadata")))
        (if (instanceof md "java.util.Map") 
         (let ((pmids (invoke md "get" "pmid"))
               (parr (if (isnull pmids) 
                       (apply mkMt)
                       (apply toArrl (invoke pmids "split" "\\|"))
                    ) ) )
            (apply mkPair "pubmed" parr))
         (apply mkPair "NoEvidence" (object null)) ) 
       ))))
       


(define addRuleEvidence (rule evidencePath strb)
  (let ((evTypeVal (apply getRuleEvidenceTypeVal rule))
        (evtype (invoke evTypeVal "get" (int 0) ))
        (val (invoke evTypeVal "get" (int 1) ))
       )
  /*
   ((evidence (getAttr rule "evidence"))
        (evtype (if (instanceof evidence "java.util.Map") 
		    (invoke evidence "get" "evtype") 
		  (object null)))
        (val  (if (instanceof evidence "java.util.Map") 
		  (invoke evidence "get" "val") 
                (object null)))  )
  */                 
    (seq 
     (invoke strb "append" "<html><br> ")
     (if (not (instanceof evtype "java.lang.String"))
	 (invoke strb "append" "No evidence provided")
       (if (= evtype "datum")
	   (if (not (instanceof val "java.lang.String"))
	       (invoke strb "append" "No datum link") 
	     (invoke strb "append" (concat
				    "Datum file: "  (apply makeEvidenceLink val evidencePath ))) )                
	 (if (= evtype "pubmed")
	     (if (not (instanceof val "java.util.ArrayList"))
		 (invoke strb "append" "No pubmed ids") 
	       (apply addPubmedLinks val strb) )
	   (if (= evtype "other")
	       (if (not (instanceof val "java.lang.String"))
		   (invoke strb "append" "No evidence value") 
		 (invoke strp "append" val strb) )
	     ))))
     (invoke strb "append" "<p>")
     (invoke strb "append" " </html>")
     ) ))

(define addPubmedLinks (pmids strb)
  (seq
   (invoke strb "append" "<ul>")
   (for pmid pmids  
	(invoke strb "append" (concat "<li>" (apply makePMIDLink pmid) "</li>")))
   (invoke strb "append" "</ul>")
   ))

(define makePMIDLink (pmid)
  (concat "<a href=\"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids="
          pmid
          "&dopt=Abstract\">"
          pmid
          "</a>")
  )

(define makeEvidenceLink (link evidencePath)  
  (concat "<a href=\""
	  evidencePath
          link
          "\">"
          link
          "</a>")
  )


;;; clt 15aug07
(define displayJRuleInfo (graph clab)
  (let ((kbname (if (instanceof graph "g2d.jlambda.Attributable")
                    (getAttr graph "kbname" "")
		  "")) 
        (gname (getuid graph))
        (kb (fetch kbname))
        (jkb (if (instanceof kb "g2d.jlambda.Attributable") 
		 (getAttr kb "jkb")
	       (object null)))
        (jspec (if (isnull jkb) (object null)
		 (getAttr jkb "componentInfoSpec" (apply mkMtMap))))
        (title (concat "About Rule " clab)) )
    (if (isnull jkb)
	(apply displayMessage2G gname title "No KB")
      (let ((rulemap (lookup jkb "rulemap"))
            (rule (invoke rulemap  "get" clab))
            (strb (object ("java.lang.StringBuffer")))
	    ) 
	(seq 
	 (apply addRuleInfo rule strb jspec)
	 (apply displayMessage2G gname title (invoke strb "toString"))
	 ))) ))


(define addRuleInfoX (rule strb)
  (let ((consumed (apply objs2vals (lookup rule "consumed") "name"))
        (produced (apply objs2vals (lookup rule "produced") "name"))
        (controls (apply objs2vals (lookup rule "controls") "name"))
	)
    (seq
     (invoke strb "append" "<html><br> ")
     (apply addItems "Substrates" consumed strb)  ;;Consumed
     (invoke strb "append" "<p>")
     (apply addItems "Products" produced strb)  ;; Produced
     (invoke strb "append" "<p>")
     (apply addItems "Enzymes" controls strb)  ;; Controls
     (invoke strb "append" "</html>")
     )))

(define addElts (arrl elts cur len)
  (if (>= cur len) arrl
    (seq (invoke arrl "add" (invoke elts "get" cur))
	 (apply addElts arrl elts (+ cur (int 1)) len)
	 )))

;; ((tag1 ...) (tagn ...))

(define listGet (list tag)
  (if (instanceof list "java.util.List") 
      (apply listGetX list tag (invoke list "size") (int 0))
    (object null)
    ) )

(define listGetX (list tag len cur)
  (if (>= cur len) 
      (object null)
    (let ((elt (invoke list "get" cur)))
      (if (and (instanceof elt "java.util.List")
	       (> (invoke elt "size") (int 0)) 
	       (= tag (invoke elt "get" (int 0))) )
          (apply map (invoke elt "subList" (int 1) (invoke elt "size"))
		 (lambda (e l) (invoke l "add" e))
		 (object ("java.util.ArrayList")))
	(apply listGetX list tag len (+ cur (int 1)))
	))
    ))

;; list is java.util.List of size > 0
;; (define map (col mfun accum) (seq (for elt col (apply mfun elt accum)) accum))


;;; clt 15aug07
(define addRuleInfo (rule strb jspec)
  (let ((consumed (apply objs2vals (lookup rule "consumed") "name"))
        (produced (apply objs2vals (lookup rule "produced") "name"))
        (controls (apply objs2vals (lookup rule "controls") "name"))
        (metadata (getAttr rule "metadata"))
	(spec (apply dget jspec "Rule" (apply mkMtMap) ))
        (hidden (if (instanceof metadata "java.util.Map") 
                    (invoke metadata "get" "hidden") (object null)))
        (pre (if (instanceof hidden "java.util.List") 
                 (apply listGet hidden "pre") (object null)))
        (post (if (instanceof hidden "java.util.List") 
		  (apply listGet hidden "post") (object null)))
	;; 13sep02 glycan hack
	;;        (keggrxnid (if (instanceof metadata "java.util.Map") 
	;;                (invoke metadata "get" "KeggRxnID") (object null)))
	;;        (displayname (if (instanceof metadata "java.util.Map") 
	;;                 (invoke metadata "get" "displayname") (object null)))

	) 
    (seq
     (invoke strb "append" "<html><br> ")
     (apply addItems "Substrates" consumed strb)
     (if (and (instanceof pre "java.util.List") 
	      (> (invoke pre "size") (int 0)) )
	 (seq (invoke strb "append" "<p>")
	      (apply addItems "Hidden Substrates" pre strb))
       )

     (invoke strb "append" "<p>")
     (apply addItems "Products" produced strb)
     (if (and (instanceof post "java.util.List") 
	      (> (invoke post "size") (int 0)) )
	 (seq (invoke strb "append" "<p>")
	      (apply addItems "Hidden Products" post strb))
       )
     (invoke strb "append" "<p>")
     (apply addItems "Enzymes" controls strb)
     (invoke strb "append" "<p>")
     (let ((items (invoke spec "get" "items")))
       (if (or (isnull items) (isnull metadata)) 
	   (object null)
	 (for item items
	      (let ((ispec (invoke spec "get" item)))
		(if (isobject ispec) (apply addItemInfo strb ispec metadata))
		)) ) )
     (invoke strb "append" "</html>")
     ) ))

(define addRuleInfoOld (rule strb)
  (let ((consumed (apply objs2vals (lookup rule "consumed") "name"))
        (produced (apply objs2vals (lookup rule "produced") "name"))
        (controls (apply objs2vals (lookup rule "controls") "name"))
        (metadata (getAttr rule "metadata"))
        (hidden (if (instanceof metadata "java.util.Map") 
                    (invoke metadata "get" "hidden") (object null)))
        (pre (if (instanceof hidden "java.util.List") 
                 (apply listGet hidden "pre") (object null)))
        (post (if (instanceof hidden "java.util.List") 
		  (apply listGet hidden "post") (object null)))
	;;        (consumedpre (if (isnull pre) consumed
	;;               (apply addElts consumed pre (int 1) (invoke pre "size"))))
	;;      (producedpost (if (isnull post) produced
	;;                 (apply addElts produced post (int 1) (invoke post "size"))))
	;; 13sep02 glycan hack
        (keggrxnid (if (instanceof metadata "java.util.Map") 
		       (invoke metadata "get" "KeggRxnID") (object null)))
        (displayname (if (instanceof metadata "java.util.Map") 
			 (invoke metadata "get" "displayname") (object null)))
        (catctl (if (instanceof metadata "java.util.Map") 
                    (invoke metadata "get" "CatalysisControlType") 
		  (object null)))
        (evidence (if (instanceof metadata "java.util.Map") 
		      (invoke metadata "get" "evidence") (object null)))
	)
    (seq
     (invoke strb "append" "<html><br> ")
     (apply addItems "Substrates" consumed strb)
     (if (and (instanceof pre "java.util.List") 
	      (> (invoke pre "size") (int 0)) )
	 (seq (invoke strb "append" "<p>")
	      (apply addItems "Hidden Substrates" pre strb))
       )

     (invoke strb "append" "<p>")
     (apply addItems "Products" produced strb)
     (if (and (instanceof post "java.util.List") 
	      (> (invoke post "size") (int 0)) )
	 (seq (invoke strb "append" "<p>")
	      (apply addItems "Hidden Products" post strb))
       )
     (invoke strb "append" "<p>")
     (apply addItems "Enzymes" controls strb)
     (if (isobject keggrxnid) 
	 (apply addLinkItem strb "KeggRxn"
		keggrxnid "http://www.kegg.jp/dbget-bin/www_bget?rn:%arg"))
     (if (isobject displayname)
	 (seq
	  (invoke strb "append" "<p>")
	  (invoke strb "append" (concat "Description: " displayname))
	  (if (isobject catctl)
	      (invoke strb "append" 
		      (concat "<br>CatalysisControlType: " catctl)))
	  (if (isobject evidence)
	      (invoke strb "append" (concat "<br>Evidence:" 
					    (apply reactomeEvidence evidence))))
	  )
       )
     (invoke strb "append" "</html>")
     )))

;; string or list of pmids
(define reactomeEvidence (evidence)
  (if (instanceof evidence "java.util.List")
      (let ((strbe (object ("java.lang.StringBuffer"))))
	(for ev evidence 
	     (if (instanceof ev "java.lang.String")
		 (invoke strbe "append" (concat " " ev))) ) 
	(invoke strbe "toString")
	)
    (invoke evidence "toString")
    ))


(apply logDev "jinfo.lsp loaded")

;; 
;; (seq(define ostrb (object ("java.lang.StringBuffer")))(apply addOccInfo (invoke occmap "get" "Egf@XOut") ostrb)  (sinvoke "g2d.util.IO" "string2File" (invoke ostrb "toString") "~/Desktop/info.html"))

;; (seq(define ostrb (object ("java.lang.StringBuffer")))(apply addOccInfo (invoke occmap "get" "Lps@TLR4C")  ostrb) (sinvoke "g2d.util.IO" "string2File" (invoke ostrb "toString") "~/Desktop/info.html"))

;; (seq(define ostrb (object ("java.lang.StringBuffer")))(apply addOccInfo (invoke occmap "get" "Egf:EgfR-Yphos@EgfRC") ostrb) (sinvoke "g2d.util.IO" "string2File" (invoke ostrb "toString") "~/Desktop/info.html"))

;; (seq(define ostrb (object ("java.lang.StringBuffer")))(apply addOccInfo (invoke occmap "get" "Cd14:Lbp:Lps:Md2:TLR4@TLR4C") ostrb)  (sinvoke "g2d.util.IO" "string2File" (invoke ostrb "toString") "~/Desktop/info.html"))

;; (seq (define rstrb (object ("java.lang.StringBuffer")))(apply addRuleEvidence (invoke rulemap "get" "001.EgfR.irt.Egf") rstrb)  (sinvoke "g2d.util.IO" "string2File" (invoke rstrb "toString") "~/Desktop/info.html"))


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/jbasicinfo.lsp ;;;;;;;;;;
;; add to loadbasicjkb load componentJInfoSpec.json
;; and store in the jkb
;; mouseclicked rule action independent of json mode
;; mouseclicked occ action -- only displayJComponentInfo graph clab is affected
;;   xnet and pnet
;; displayJComponentInfo calls addOccInfo which calls
;;  mkSimpleOccInfo occ strb calls getSimpleInfoFun on occs eref
;; and apply's result to  eref name mods strb)
;; loadjkb / loadbasicjkb should define getSimpleInfoFun

(define mkBasicSimpleInfoFun (jspec)
  (let (
        (protSpec (invoke jspec "get" "Protein"))
        (chemSpec (invoke jspec "get" "Chemical"))
        (geneSpec (invoke jspec "get" "Gene"))
        (sigSpec  (invoke jspec "get" "Signature"))
        (cellSpec (invoke jspec "get" "Cell"))
        (stressSpec (invoke jspec "get" "Stress"))
        (glycanSpec (invoke jspec "get" "Glycan"))
        (protInfoFun (if (instanceof protSpec "java.util.Map")
                         (apply mkBasicInfo "Protein" protSpec)
		       (object null)))
        (genericInfoFun (if (instanceof protSpec "java.util.Map")
			    (apply mkGenericInfo protSpec)
			  (object null)))
        (compositeInfoFun (if (instanceof protSpec "java.util.Map")
			      (apply mkCompositeInfo protSpec)
			    (object null)))
        (chemInfoFun (if (instanceof chemSpec "java.util.Map")
                         (apply mkBasicInfo "Chemical" chemSpec)
		       (object null)))
        (geneInfoFun (if (instanceof geneSpec "java.util.Map")
                         (apply mkBasicInfo "Gene" geneSpec)
		       (object null)))
        (sigInfoFun (if (instanceof sigSpec "java.util.Map")
			(apply mkBasicInfo "Signature" sigSpec)
		      (object null)))
        (cellInfoFun (if (instanceof cellSpec "java.util.Map")
                         (apply mkBasicInfo "Cell" cellSpec)
		       (object null)))
        (stressInfoFun (if (instanceof stressSpec "java.util.Map")
			   (apply mkBasicInfo "Stress" stressSpec)
                         (object null)))
        (glycanInfoFun (if (instanceof glycanSpec "java.util.Map")
			   (apply mkBasicInfo "Glycan" glycanSpec)
                         (object null)))
	) 
    (lambda (eref)
      (let ((esort (lookup eref "sort")))
	(if (= esort bp2pl.EntityReference.PROT ) 
	    (if (instanceof eref "bp2pl.SimpleReference") protInfoFun
	      (if (instanceof eref "bp2pl.GenericReference") genericInfoFun
		(if (instanceof eref "bp2pl.CompositeReference") compositeInfoFun
		  (object null) )))          
	  (if (= esort bp2pl.EntityReference.CHEM ) chemInfoFun
	    (if (= esort bp2pl.EntityReference.DNA) geneInfoFun 
	      (if (= esort bp2pl.EntityReference.RNA ) (object null)
		(if (= esort bp2pl.EntityReference.SIGNATURE ) sigInfoFun
		  (if (= esort bp2pl.EntityReference.CELL ) cellInfoFun
		    (if (= esort bp2pl.EntityReference.STRESS ) stressInfoFun
		      (if (= esort bp2pl.EntityReference.GLYCAN ) glycanInfoFun
			(object null) )))))))))
      )
    ))  

(define mkGenericInfo (spec) 
  (lambda (eref name strb)
    (let ((members (lookup eref "members")))
      (seq
       (invoke strb "append" (concat "<p><b>Name</b>: " name " <em> of type</em> Family</p>"))
       (invoke strb "append" (concat "<p><b>Members</b>:"))
       (invoke strb "append"  "<ul>" )
       (for er members
	    (seq (invoke strb "append" "<li>") 
		 (apply addPInfo spec er strb)
		 (invoke strb "append" "</li>")) )
       (invoke strb "append"  "</ul></p>" )
       ;;     (if (and (instanceof mods "java.util.ArrayList") 
       ;;              (> (invoke mods "size") (int 0)) )
       ;;        (apply addModItems mods strb) )
       ))))

(define mkCompositeInfo (spec) 
  (lambda (eref name strb)
    (let ((subunits (lookup eref "subunits")))
      (seq
       (invoke strb "append" (concat "<p><b>Name</b>: " name " <em>of sort</em> Composite</p>"))
       (invoke strb "append" (concat "<p><b>Subunits</b>: "))
       (invoke strb "append"  "<ul>" )
       (for eref subunits
	    (seq 
	     (invoke strb "append" "<li>") 
	     (let ((sfun (apply getSimpleInfoFun eref))
		   (name (lookup eref "name")) )
	       (if (isnull sfun) 
		   (invoke strb "append" (concat "Unknown Entity: " name)) 
		 (apply sfun eref name strb))
	       )
	     (invoke strb "append" "</li>") ))
       (invoke strb "append"  "</ul></p>" )
       ))))

;;            (apply addPInfo spec er strb)

(define addPInfo (spec eref strb) 
  (let ((items (invoke spec "get" "items"))
	(name (lookup eref "name"))
	(md (getAttr eref "metadata"))
	)
    (seq
     (invoke strb "append" (concat "<p><b>Name</b>: " name " <em>of sort</em> Protein </p>"))
     (if (or (isnull items) (isnull md)) 
	 (object null)
       (for item items
	    (let ((ispec (invoke spec "get" item)))
	      (if (isobject ispec) (apply addItemInfo strb ispec md))
	      )) )
     )))

(define XmkBasicInfo (sort spec) 
  (lambda (eref name strb) 
    (let ((items (invoke spec "get" "items"))
          (md (getAttr eref "metadata"))
          )
      (seq
       (invoke strb "append" (concat "<p>" name " : " sort "</p>"))
       (if (or (isnull items) (isnull md)) 
	   (object null)
	 (for item items
	      (let ((ispec (invoke spec "get" item)))
		(if (isobject ispec) (apply addItemInfo strb ispec md))
		)) )
       ;;        (if (and (instanceof mods "java.util.ArrayList") 
       ;;                 (> (invoke mods "size") (int 0)) )
       ;;            (apply addModItems mods strb) )
       ))) )

(define mkBasicInfo (type spec)  ;; use type if no meta data or no sort info
  (lambda (eref name strb) 
    (let ((items (invoke spec "get" "items"))
          (md (getAttr eref "metadata"))
          (sort (if (isobject md) 
		    (let ((sort0 (invoke md "get" "sort")))
		      (if (isobject sort0) sort0 type))
		  type))
          )
      (seq
       (invoke strb "append" (concat "<p><b>Name</b>: " name " <em>of sort</em> " sort "</p>"))
       (if (or (isnull items) (isnull md)) 
	   (object null)
	 (for item items
	      (let ((ispec (invoke spec "get" item)))
		(if (isobject ispec) (apply addItemInfo strb ispec md))
		)) )
       ))) )

(define addModItems (mods strb)
  (seq
   (invoke strb "append" "<p>")
   (invoke strb "append" "<b>Modifications</b>: ")
   (if (= (invoke mods "size") (int 1))
       (apply addModItem (invoke mods "get" (int 0)) strb )
     (seq 
      (invoke strb "append"  "<ul>" )
      (for mod mods 
           (seq (invoke strb "append" "<li>") 
                (apply addModItem mod strb)
                (invoke strb "append" "</li>")) )
      (invoke strb "append"  "</ul>" )
      )
     )
   (invoke strb "append" "</p>")
   ))

(define addModItem (mod strb)
  (let ((eref (getAttr mod "eref"))
        (emap (getAttr mod "epitopeMap")) )
    (invoke strb "append" (lookup mod "name"))
    (if (instanceof eref "bp2pl.EntityReference")
        (let ((sfun (apply getSimpleInfoFun eref)))
          (if (isobject sfun)  
              (seq 
               (invoke strb "append" "<p>" )
               (apply sfun eref (lookup eref "name")  strb)
               (invoke strb "append" "</p>") 
               )) ))
    (if (instanceof emap "java.util.Map")
        (seq
         ;;(invoke strb "append" "<p>" )
         (invoke strb "append" " (Epitopes: " )
         (for key (invoke emap "keySet") 
              (seq 
               (invoke strb "append" key)
               (invoke strb "append" "~")
               (invoke strb "append" (invoke emap "get" key))
               (invoke strb "append" "  ") ))
	 (invoke strb "append" ")")  
         ;;(invoke strb "append" "</p>")  
         )         
      )))

(define addItemInfo (strb ispec md)
  (let ((mdtag (invoke ispec "get" "mdtag"))
        (type  (invoke ispec "get" "type"))
        (tag   (invoke ispec "get" "tag")) )
    (if (not (and (instanceof  mdtag "java.lang.String")
		  (instanceof  type "java.lang.String")
		  (instanceof  tag "java.lang.String")))
        (object null)
      (let ((mdval (invoke md "get" mdtag)))
	(if (isnull mdval) (object null)
	  (if (= type "val") (apply addValItem strb tag mdval)
	    (if (= type "link") 
		(apply addLinkItem strb tag mdval (invoke ispec "get" "link"))
	      (if (= type "list") (apply addListItem strb tag mdval)
		(apply addUnknownItem strb tag mdval)
		))) )) )
    ))

(define addValItem (strb tag mdval)
  (invoke strb "append" (concat "<p> <b>" tag "</b>: " mdval " </p>"))
  )

(define mkHref (link val)
  (concat "<a href=\"" (invoke link "replace" "%arg" val)  "\">"  val "</a>")
  )
;; "http://www.expasy.ch/cgi-bin/niceprot.pl?%arg"

(define isUniProtAc (val)  (= (invoke val "length") (int 6)))

(define addLinkItem (strb tag mdval link)
  (if (and (isobject mdval) (isobject link))
      ;; Hack to deal with "none"
      (if (and (= tag "UniProt") (not (apply isUniProtAc mdval)))
          (invoke strb "append" (concat "<p><b>" tag "</b>: " mdval " </p>")) 
        (invoke strb "append" 
                (concat "<p><b>"  tag "</b>: " (apply mkHref link mdval) "</p>" )) ))
  )


(define addListItem (strb tag mdval)
  ;;  (invoke strb "append" (concat "<p> " tag ": " mdval " </p>"))
  (invoke strb "append" "<p>")
  (apply addItems tag mdval strb)
  (invoke strb "append" "</p>")
  )

(define addUnknownItem (strb tag mdval)
  (invoke strb "append" (concat "<p><b>" tag "</b>: " mdval " </p>"))
  )

(apply logDev"jbasicinfo.lsp loaded")


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/jmouseClicked.lsp ;;;;;;;;;;
;;;;;;;; PNET PLA3D


;;;;;;;; PNET PLA3D

(define mkPnetMouseClickedClosure (graph)
  (lambda (self e)
    (seq 
      (if (instanceof self "g2d.graph.IOPNode")
        (let ((type (getAttr self "type")))
          (seq
          (if (= type "rule") 
            (apply doPnetMouseClickedRuleAction graph self e)             
          (if (= type "occ")
            (apply doPnetMouseClickedOccAction graph self e)
            (object null))) ; not a known node type
          ))
     (object null)  ; not a node
   ) ; if
  ) ;seq
 ))

(define  doPnetMouseClickedRuleAction (graph node e)  
  (let ((clist (object  ("java.util.ArrayList")))
        (cbclist (object  ("java.util.ArrayList")))
        (clab (getAttr node "chattylabel"))
        (cbmap (object  ("java.util.HashMap")))
        (cf (lookup graph "colorClosure"))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (sep (invoke panel "getSEPanel"))
        (tabmenu (invoke sep "getTabMenu"))
        (gname (getuid graph))
        (ruleInfoClosure 
           (lambda (self e) (apply displayJRuleInfo graph clab)))
        (ruleInfo 
          (object ("g2d.swing.IOPButton" "About Rule" ruleInfoClosure )))
        (nodeInfoClosure 
           (lambda (self e) (apply displayJNodeInfo graph node clab)))
        (nodeInfo 
            (object ("g2d.swing.IOPButton" "About Node" nodeInfoClosure)))
        (ruleEvidenceClosure 
           (lambda (self e) (apply displayJRuleEvidence graph clab)))
        (ruleEvidence
            (object ("g2d.swing.IOPButton" "Rule Evidence" ruleEvidenceClosure)))
  ;;; selections
        (cbHide (object ("javax.swing.JCheckBox" "Hide rule")))
        (acHide (apply mkNodeCheckClosure 
                    graph panel node cbHide cbclist "avoid" "status" cf))
        (exRuleClosure 
          (lambda (self e)
            (sinvoke "g2d.util.ActorMsg" 
                    "send" "maude" gname (concat "exploreRule " clab)) 
           ))
        (exRule
            (object ("g2d.swing.IOPButton" "Explore Rule" exRuleClosure )))
        (changeClosure 
         (lambda (self e) (apply handleCBChange node cbclist cbmap "status")))
        (status (getAttr node "status" "none"))
      )
     (seq
       (invoke cbHide "setAction"
         (object ("g2d.closure.ClosureAbstractAction" "Hide rule" acHide)))
      (if (= status "avoid") (invoke cbHide "setSelected" (boolean true)) )
      (invoke clist "add" nodeInfo)
      (invoke clist "add" ruleInfo)
      (invoke clist "add" ruleEvidence)
      (invoke clist "add" exRule)
      (invoke clist "add" cbHide)
      (invoke cbclist "add" cbHide)
      (invoke cbmap "put" "avoid" cbHide)
      (update tabmenu "stateChangedClosure" changeClosure)
      (apply extendSEMenu graph clist)
      ) ))

;; add nodeInfo Button, showEvidence Button, hide rule checkBox
;; (apply displayJRuleEvidence gname clab)

(define  doPnetMouseClickedOccAction (graph node e)  
 (let ((clist (object  ("java.util.ArrayList")))
       (cbclist (object  ("java.util.ArrayList")))
       (cbmap (object  ("java.util.HashMap")))
       (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
       (sep (invoke panel "getSEPanel"))
       (tabmenu (invoke sep "getTabMenu"))
       (clab (getAttr node "chattylabel"))
       (gname (getuid graph))
       (cf (lookup graph "colorClosure"))
       (occInfoClosure 
           (lambda (self e) (apply displayJComponentInfo graph clab)))
       (occInfo 
          (object ("g2d.swing.IOPButton" "About Occurrence" occInfoClosure )))
       (nodeInfoClosure 
          (lambda (self e) (apply displayJNodeInfo graph node clab)))
       (nodeInfo 
            (object ("g2d.swing.IOPButton" "About Node" nodeInfoClosure)))
;; 13aug24 clt amk request
        (exOccClosure 
          (lambda (self e)
            (sinvoke "g2d.util.ActorMsg" 
                    "send" "maude" gname (concat "exploreOcc " clab " b")) 
           ))
        (exOcc
            (object ("g2d.swing.IOPButton" "Explore Occurrence" exOccClosure )))
  ;;; selections
       (cbGoal (object ("javax.swing.JCheckBox" "Set goal")))
       (acGoal (apply mkNodeCheckClosure 
                    graph panel node cbGoal cbclist "goal" "status" cf))
       (cbAvoid (object ("javax.swing.JCheckBox" "Set avoid")))
       (acAvoid (apply mkNodeCheckClosure 
                   graph panel node cbAvoid cbclist "avoid" "status" cf))
       (status (getAttr node "status" "none"))
       (changeClosure 
         (lambda (self e) (apply handleCBChange node cbclist cbmap "status")) )
      )
     (seq
      (invoke cbGoal "setAction"
         (object ("g2d.closure.ClosureAbstractAction" 
                 "Make occ a goal" acGoal)))
      (invoke cbAvoid "setAction"
         (object ("g2d.closure.ClosureAbstractAction" "Avoid occ" acAvoid)))
      (if (= status "goal")
          (seq (invoke cbGoal "setSelected" (boolean true)) 
               (invoke cbAvoid "setEnabled" (boolean false)) ))
      (if (= status "avoid") 
         (seq (invoke cbAvoid "setSelected" (boolean true)) 
              (invoke cbGoal  "setEnabled" (boolean false)) ))
;;!!! make this conditional -- developer mode
      (invoke clist "add" nodeInfo)
      (invoke clist "add" occInfo)
;; 13aug24 clt explore occ for amk
      (invoke clist "add" exOcc)
      (invoke clist "add" cbGoal)
      (invoke clist "add" cbAvoid)
      (invoke cbclist "add" cbGoal)
      (invoke cbclist "add" cbAvoid)
      (invoke cbmap "put" "goal" cbGoal)
      (invoke cbmap "put" "avoid" cbAvoid)
      (update tabmenu "stateChangedClosure" changeClosure)
      (apply extendSEMenu graph clist)
      ) ))

;;;; figure out change listener -- look at status, redo checks
(define mkNodeCheckClosure (graph panel node cb clist mode tag colorfun)
  (lambda (self e)
     (let ((checked? (invoke cb "isSelected"))
           (bordercolor (if checked? java.awt.Color.red nodeBorderColor))
          )
      (seq
        (setAttr node tag (if checked? mode "none"))
        (if checked?
           ; disable others
           (for cb1 clist 
             (if (not (= cb1 cb)) (invoke cb1 "setEnabled" (boolean false))) )
           ; enable all---assumes at most one checked, action unchecked it
           (for cb1 clist (invoke cb1 "setEnabled" (boolean true) ))
         )
        (invoke node "setFillColor" (apply colorfun node)) 
        (invoke node "setBorderColor" bordercolor) 
        (invoke graph "fireChange" node)
        (invoke panel "repaint")
     )))  ; seq let lambda
)

(define handleCBChange (node cblist cbmap tag)
  (let ((val (getAttr node tag "none"))
        (cb (invoke cbmap "get" val))
       )
    (if (isnull cb)   
     ;; none selected make sure cbs enables and unselected
      (for cb1 cblist 
         (seq (invoke cb1 "setSelected" (boolean false))
              (invoke cb1 "setEnabled" (boolean true) )))
     ;; cb selected make sure enabled and checked, uncheck and disable others
      (seq (invoke cb "setSelected" (boolean true))
           (invoke cb "setEnabled" (boolean true)) 
           (for cb1 cblist  ;; cb should be selected others disabled
              (if (!= cb cb1) 
                  (seq (invoke cb1 "setSelected" (boolean false))
                       (invoke cb1 "setEnabled" (boolean false)) )))
      ) )) )



;;;;;;;;  XNET PLA3D

; for explore graph add checkBoxes to context menu tab
(define mkXnetMouseClickedClosure (graph)
  (lambda (self e)
    (seq 
      (if (instanceof self "g2d.graph.IOPNode")
        (let ((type (getAttr self "type")))
          (seq
          (if (= type "rule") 
            (apply doXnetMouseClickedRuleAction graph self e)             
          (if (= type "occ")
            (apply doXnetMouseClickedOccAction graph self e)
            (object null))) ; not a known node type
          ))
     (object null)  ; not a node
   ) ; if
  ) ;seq
 )
)

;; xselect is t if rule is selected for hiding, "none" owise
(define  doXnetMouseClickedRuleAction (graph node e)  
  (let ((clist (object  ("java.util.ArrayList")))
       (cbclist (object  ("java.util.ArrayList")))
       (clab (getAttr node "chattylabel"))
       (cbmap (object  ("java.util.HashMap")))
       (cf (lookup graph "colorClosure"))
       (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
       (sep (invoke panel "getSEPanel"))
       (tabmenu (invoke sep "getTabMenu"))
       (ruleInfoClosure 
           (lambda (self e) (apply displayJRuleInfo graph clab)))
       (ruleInfo 
          (object ("g2d.swing.IOPButton" "About Rule" ruleInfoClosure )))
       (nodeInfoClosure 
           (lambda (self e) (apply displayJNodeInfo graph node clab)))
       (nodeInfo 
           (object ("g2d.swing.IOPButton" "About Node" nodeInfoClosure)))
        (ruleEvidenceClosure 
           (lambda (self e) (apply displayJRuleEvidence graph clab)))
        (ruleEvidence
            (object ("g2d.swing.IOPButton" "Rule Evidence" ruleEvidenceClosure)))
       (cbHideRule (object ("javax.swing.JCheckBox" "hideRule")))
       (acHideRule (apply mkNodeCheckClosure
              graph panel node cbHideRule cbclist "t" "xselect" cf))
       (changeClosure 
         (lambda (self e)
             (apply handleCBChange node cbclist cbmap "xselect")))
       (selection (getAttr node "xselect" "none"))
      )
     (seq
      (invoke cbHideRule "setAction"
         (object ("g2d.closure.ClosureAbstractAction"
                  "hideRule" acHideRule)))
      (if (= selection "t")
          (invoke cbHideRule "setSelected" (boolean true))
       )
      (invoke clist "add" nodeInfo)
      (invoke clist "add" ruleInfo)
      (invoke clist "add" ruleEvidence)
      (invoke clist "add" cbHideRule)
      (invoke cbclist "add" cbHideRule)
      (invoke cbmap "put" "t" cbHideRule)
      (update tabmenu "stateChangedClosure" changeClosure)
      (apply extendSEMenu graph clist)
     )   ))

;;!!! can be eliminated
(define mkXRuleCheckClosure (panel node cb  mode)
  (lambda (self e)
     (let ((checked? (invoke cb "isSelected"))
;          (color (apply colorXRuleNode  checked?))
           (bordercolor (if checked? java.awt.Color.red nodeBorderColor))
          )
      (seq
        (setAttr node "xselect" (if checked? mode "none"))
;; should lookup color function in graph
        (invoke node "setFillColor" (apply colorXnetNode node)) 
        (invoke node "setBorderColor" bordercolor) 
        (invoke graph "fireChange" node)
        (invoke panel "repaint")
     )))  ; seq let lambda
)


; oup  explore up
; odn  explore dn
; oboth explore up dn up/dn
; seen  no options
; xstatus -- what are the options
; xselect --- which button is selected --- u d b
(define  doXnetMouseClickedOccAction (graph node e)  
  (let ((clist (object ("java.util.ArrayList")))
       (cbclist (object  ("java.util.ArrayList")))
       (cbmap (object  ("java.util.HashMap")))
       (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
       (sep (invoke panel "getSEPanel"))
       (tabmenu (invoke sep "getTabMenu"))
       (clab (getAttr node "chattylabel"))
       (cf (lookup graph "colorClosure"))
       (occInfoClosure 
           (lambda (self e) (apply displayJComponentInfo graph clab)))
       (occInfo 
         (object ("g2d.swing.IOPButton" "About Occurrence" occInfoClosure )))
       (nodeInfoClosure 
          (lambda (self e) (apply displayJNodeInfo graph node clab)))
       (nodeInfo 
            (object ("g2d.swing.IOPButton" "About Node" nodeInfoClosure)))
       (cbBoth (object ("javax.swing.JCheckBox" "explore Up+Down")))
       (acBoth (apply mkNodeCheckClosure 
                    graph panel node cbBoth cbclist "b" "xselect" cf))
       (cbUp (object ("javax.swing.JCheckBox" "explore Up")))
       (acUp (apply mkNodeCheckClosure 
                    graph panel node cbUp cbclist "u" "xselect" cf))
       (cbDown (object ("javax.swing.JCheckBox" "explore Down")))
       (acDown (apply mkNodeCheckClosure 
                    graph panel node cbDown cbclist "d" "xselect" cf))
       (selection (getAttr node "xselect" "none"))
       (xstatus (getAttr node "xstatus" "none"))
       (changeClosure 
        (lambda (self e)(apply handleCBChange node cbclist cbmap "xselect")))
      )
     (seq
      (invoke cbBoth "setAction"
         (object ("g2d.closure.ClosureAbstractAction"
                  "explore Up&Down" acBoth)))
      (invoke cbUp "setAction"
         (object ("g2d.closure.ClosureAbstractAction"
                  "explore up stream" acUp)))
      (invoke cbDown "setAction"
         (object ("g2d.closure.ClosureAbstractAction"
                  "explore down stream" acDown)))
      (if (not (= selection "none"))
          (if (= selection "u")
              (invoke cbUp "setSelected" (boolean true))
          (if (= selection "d")
              (invoke cbDown "setSelected" (boolean true))
          (if (= selection "b")
              (invoke cbBoth "setSelected" (boolean true))
          ))) )
      (invoke clist "add" nodeInfo)
      (invoke clist "add" occInfo)
      (if (= xstatus "oboth") 
          (seq (invoke clist "add" cbBoth)
               (invoke cbclist "add" cbBoth)
               (invoke cbmap "put" "b" cbBoth)))
      (if (or (= xstatus "oboth") (= xstatus "oup"))
           (seq (invoke clist "add" cbUp) 
                (invoke cbclist "add" cbUp) 
                (invoke cbmap "put" "u" cbUp)))
      (if (or (= xstatus "oboth") (= xstatus "odn"))          
          (seq  (invoke clist "add" cbDown) 
                (invoke cbclist "add" cbDown)
                (invoke cbmap "put" "d" cbDown)))
      (update tabmenu "stateChangedClosure" changeClosure)
      (apply extendSEMenu graph clist)
     ) ))

 (apply logDev "jmouseClicked.lsp loaded")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/json2jkb.lsp ;;;;;;;;;;
;; REQUIRES jutil.lsp

;; (define evidencePath "")
(define evidencePath (concat "file://" (sinvoke "g2d.util.IO" "resolveLinks" "./evidence"))) 

(define initJKB (kbname)
  (let ((kb0 (fetch kbname))
         (kb (if (= kb0 (object null))
                 (object ("g2d.jlambda.Attributable")) 
                 kb0))

        (jkb (object ("bp2pl.KB")))  )
   (seq
    (if (= kb0 (object null)) (setuid kb kbname))
    (setAttr kb "kbname" kbname) 
    (setAttr kb  "jkb" jkb)    
    (update jkb "name" kbname)
    (update jkb "rulemap" (object ("java.util.HashMap")))
    (update jkb "occmap" (object ("java.util.HashMap")))
    (update jkb "erefmap" (object ("java.util.HashMap")))
    (update jkb "modmap" (object ("java.util.HashMap")))
    (update jkb "locmap" (object ("java.util.HashMap")))
    (setAttr jkb "netmap" (object ("java.util.HashMap")))
    (setAttr jkb "dishemap" (object ("java.util.HashMap")))
    (setAttr jkb "counter" (int 0))
    (setAttr kb "evidencePath" evidencePath )
    jkb ) ))


(define jkbNext (jkb)
  (let ((c (getAttr jkb "counter"))) 
    (seq (setAttr jkb "counter" (+ c (int 1)))  c )))



(define jmapf2jkb (jkb map jfun fname)
  (let ((jmap (apply readJSonF fname)))
    (apply jmap2jkb jkb map jfun jmap)))


(define jmap2jkb (jkb map jfun jmap)
  (for jobj (invoke jmap "values") 
   (seq
    (apply jfun map jobj)
   )
))

(define jmapf2jkbX (jkb map jfun fname)
  (let ((jmap (apply readJSonF fname)))
    (apply jmap2jkbX jkb map jfun jmap)))

(define jmap2jkbX (jkb map jfun jmap)
  (for pair (invoke jmap "entrySet") 
   (seq
    (if (isnull (invoke pair "getValue") )
       (invoke java.lang.System.err "println"  (invoke pair "getKey"))
    (apply jfun map (invoke pair "getValue"))
   ))
))

(define loadjkb (kbname dir)
 (let ((jkb (getAttr (fetch kbname) "jkb"))
       (locmap (lookup jkb "locmap"))
       (modmap (lookup jkb "modmap"))
       (erefmap (lookup jkb "erefmap"))
       (occmap (lookup jkb "occmap"))
       (rulemap (lookup jkb "rulemap"))
       (ofun (apply jocc2jkb jkb erefmap modmap locmap))
       (rfun (apply jrule2jkb jkb occmap erefmap modmap locmap))
      )
  (seq 
(apply jmapf2jkb jkb locmap   jloc2jkb  (concat dir "/" "locs.json"))
(apply jmapf2jkb jkb modmap   jmod2jkb  (concat dir "/" "mods.json"))
(apply jmapf2jkb jkb erefmap  eref2jkb  (concat dir "/" "entities.json"))
(apply erefFixup  erefmap)
(apply jmapf2jkb jkb occmap   ofun      (concat dir "/" "occs.json"))
(apply jmapf2jkb jkb rulemap  rfun      (concat dir "/" "rules.json"))
(define getSimpleInfoFun getSTMSimpleInfoFun)
)))



;; { "stype" : "loc",
;;   "name" : String,           // its name (unique in a KB)
;;   "metadata" : JObject       // definition
;;  }
;; Location extends Attributable  
;;   public String name;
;;   public String term;

(define jloc2jkb (locs jobj)
  (if (not (instanceof jobj "java.util.Map"))
   (object null)
  (let ((name (invoke jobj "get" "name")))
    (if (or (isnull name) (!= (invoke jobj "get" "stype") "loc"))
       (object null)
       (let ((loc (object ("bp2pl.Location")))
             (metadata (invoke jobj "get" "metadata") ) )
         (seq
          (update loc "name" name) 
          (invoke locs "put" name loc)
          (if (instanceof metadata "java.util.Map")
              (setAttr loc "metadata" metadata))
          loc )))  )))

(define mtype2msort (mtype)
 (if (= mtype "AAMOD") bp2pl.Modification.AAMOD
 (if (= mtype "ACT") bp2pl.Modification.ACT
 (if (= mtype "OTHER") bp2pl.Modification.OTHER
 (if (= mtype "SMBIND") bp2pl.Modification.SMBIND
 (if (= mtype "FRAG") bp2pl.Modification.FRAG
     (int -1)))))) )

;; { "stype" : "mod",
;;   "name" : String,      // constructed from op (and site if present)
;;   "shortname" : String  // for op
;;   "op" : String,  
;;   "site" : String,      // optional 
;;   "mtype" : MType, 
;;   "cvs" : JArray[CV],          //controlled vocab refs
;;   "metadata" : JObj
;; }
;; MType = {"AAMOD", "ACT", "FRAG", "SMBIND", "OTHER"}

;;  Modification extends Attributable 
;;    public int sort;       
;;    public String name;    // op[@@loc]
;;    public String op;       //  cvterm mapped to PLname
;;    public String site;    // siteop, status.n  aa.n
;;    public ArrayList<HashMap<String,String>> cv;   
;;           // controlled vocab hashmaps term,db,id


(define jmod2jkb (mods jobj)
  (if (not (instanceof jobj "java.util.Map"))
   (object null)
  (let ((name (invoke jobj "get" "name")))
    (if (or (isnull name) (!= (invoke jobj "get" "stype") "mod"))
       (object null)
      (let ((mod (object ("bp2pl.Modification")))
            (shortname (invoke jobj "get" "shortname"))
            (op (invoke jobj "get" "op"))
            (mtype (invoke jobj "get" "mtype"))
            (msort (apply mtype2msort mtype))
            (site (invoke jobj "get" "site"))
            (cvs (invoke jobj "get" "cvs"))
            (metadata  (invoke jobj "get" "metadata"))
           )
        (seq
         (invoke mods "put" name mod)
         (update mod "name" name)
         (update mod "op" op)
         (update mod "sort" msort)
         (if (instanceof site "java.lang.String")
             (update mod "site" site)) 
         (if (instanceof shortname "java.lang.String")
             (setAttr mod "shortname" shortname)) 
         (if (apply cvSpecsP cvs) (update mod "cvs" cvs))
         (if (instanceof metadata "java.util.Map") 
             (setAttr mod "metadata" metadata))
         mod )        
     )  )) ))

(define cvSpecsP (jobj)
  (if (not (instanceof jobj "java.util.List"))
    (boolean false)
    (let ((it (invoke jobj "iterator"))) (apply itPred it isCVSpec))))

(define isCVSpec (jobj)
  (if (instanceof jobj "java.util.Map")
    (and (= (invoke jobj "get" "stype") "cv" )
         (instanceof (invoke jobj "get" "db") "java.lang.String")
         (instanceof (invoke jobj "get" "id") "java.lang.String")
         (instanceof (invoke jobj "get" "term") "java.lang.String")
       )
    (boolean false) ))


;; { "stype" : "sref",
;;   "name" : String,  
;;   "etype" : Etype,   
;;   "xref" : Xref,              // standard refs or null
;;   "metadata" : JObj,
;; }
;; Etype = {"Protein", "Chemical", "DNA", "RNA"}
;; assume jobj is a map
;; An Xref is an object satisfying
;;  {"stype" : "xref", 
;;   "db" : String,  
;;   "id" : String    }      
;; BProteins db is "UNIPROT" "id" is "spnumber", omitted from json metadata
;; SimplReference extends Attributable { 
;;  int sort;
;;  String name;
;;  ArrayList<String> synonyms;
;;  HashMap<String,String> xref;

;; (define ekind2esort (etype)
;;  (if (= etype "Protein") bp2pl.EntityReference.PROT
;;  (if (= etype "Chemical") bp2pl.EntityReference.CHEM
;;  (if (= etype "Gene") bp2pl.EntityReference.DNA
;;  (if (= etype "RNA") bp2pl.EntityReference.RNA
;;  (if (= etype "Signature") bp2pl.EntityReference.SIGNATURE
;;  (if (= etype "Cell") bp2pl.EntityReference.CELL
;;   (int -1) )))))) )
;; 
(define getSynonyms (metadata)
  (if (instanceof metadata "java.util.Map")
    (let ((syn (invoke metadata "get" "synonyms")))
      (if (instanceof syn "java.util.ArrayList")
         syn
        (if (instanceof syn "java.lang.String")
          (let ((syn1 (object ("java.util.ArrayList"))))
            (seq (invoke syn1 "add" syn) syn1))
          (object ("java.util.ArrayList"))
           )))
    (object ("java.util.ArrayList"))
))


(define erefFixup  (erefmap)
  (for jobj (invoke erefmap "values")
    (if (instanceof jobj "bp2pl.GenericReference")
        (apply genericFixup erefmap jobj)
    (if (instanceof jobj "bp2pl.CompositeReference")
        (apply compositeFixup erefmap jobj)
    )) ))

(define genericFixup (erefmap jobj)
  (let ((members (getAttr jobj "members"))
        (membererefs  (if (instanceof members "java.util.ArrayList")
                         (apply names2objs erefmap members)
                         (object ("java.util.ArrayList")))) )
      (update jobj "members" membererefs)
   ))

(define compositeFixup (erefmap jobj)
  (let ((subunits (getAttr jobj "subunits"))
        (subuniterefs  (if (instanceof subunits "java.util.ArrayList")
                         (apply names2objs erefmap subunits)
                         (object ("java.util.ArrayList")))) )
    (update jobj "subunits" subuniterefs)
  ))


(define eref2jkb (erefs jobj)
  (if (not (instanceof jobj "java.util.Map"))
    (object null)
    (let ((stype (invoke jobj "get" "stype"))
          (name (invoke jobj "get" "name")) )
      (if (isnull name)  (object null)
        (if (= stype "sref") (apply sref2jkb erefs jobj name)
          (if (= stype "gref")  (apply gref2jkb erefs jobj name)
            (if (= stype "cref")  (apply cref2jkb erefs jobj name)
               (object null) 
             ))))
        )))


(define sref2jkb (erefs jobj name)
 (let ((sref (object ("bp2pl.SimpleReference")))
       (ekind (apply lookupd jobj "etype" "")) 
;;       (esort (apply ekind2esort ekind)) ;; jkb sort an integer
       (esort (apply plType2Sort ekind)) ;; jkb sort an integer
       (xref (invoke jobj "get" "xref"))
       (metadata (invoke jobj "get" "metadata")) 
       (synonyms (apply getSynonyms metadata))
    )
  (seq 
   (invoke erefs "put" name sref)
   (update sref "name" name)
   (update sref "sort" (if (= (object null) esort) (int -1) esort))
   (if (apply isXref xref) (update sref "xref" xref))
   (if (instanceof synonyms "java.util.ArrayList") (update sref "synonyms" synonyms))
   (if (instanceof metadata "java.util.Map") (setAttr sref "metadata" metadata)) 
   sref ))) 

(define isXref (jobj)
  (if (instanceof jobj "java.util.Map")
    (and (= "xref" (invoke jobj "get" "stype"))
         (instanceof (invoke jobj "get" "db") "java.lang.String")
         (instanceof (invoke jobj "get" "id") "java.lang.String"))
    (boolean false) ))
  
;; { "stype" : "gref",
;;   "name" : String, 
;;   "etype" : "Protein",
;;   "members" : JArray[String], 
;;   "metadata" : JObject  }
;; GenericReference extends Attributable { 
;;  int sort;
;;  String name;
;;  ArrayList<String> synonyms;
;;  ArrayList<EntityReference> members;

(define gref2jkb (erefs jobj name)
  (let ((gref (object ("bp2pl.GenericReference")))
        (ekind (apply lookupd jobj "etype" "")) 
;;        (esort (apply ekind2esort ekind)) ;; jkb sort an integer
        (esort (apply plType2Sort ekind)) ;; jkb sort an integer
        (members (invoke jobj "get" "members"))  ;; already an array
        (metadata (invoke jobj "get" "metadata")) 
        (synonyms (apply getSynonyms metadata))
      )
   (seq 
    (invoke erefs "put" name gref)
    (update gref "name" name)
    (update gref "sort" (if (isnull esort) (int -1) esort))
    (if (instanceof synonyms "java.util.ArrayList") (update gref "synonyms" synonyms))
    (if (instanceof members "java.util.ArrayList")  (setAttr gref "members" members)) 
    (if (instanceof metadata "java.util.Map")  (setAttr gref "metadata" metadata)) 
    gref )))


;; { "stype" : "cref",
;;   "name" : String, 
;;   "etype" : "Protein",
;;   "subunits" : JArray[String], 
;;   "metadata" : JObject }
;; CompositeReference extends Attributable { 
;;  int sort;
;;  String name;
;;  ArrayList<String> synonyms;
;;  ArrayList<EntityReference> subunits;

(define cref2jkb (erefs jobj name) 
 (let ((cref (object ("bp2pl.CompositeReference")))
       (ekind (apply lookupd jobj "etype" "")) 
;;       (esort (apply ekind2esort ekind)) ;; jkb sort an integer
       (esort (apply plType2Sort ekind)) ;; jkb sort an integer
       (subunits (invoke jobj "get" "subunits"))  ;; already an array
       (metadata (invoke jobj "get" "metadata")) 
       (synonyms (apply getSynonyms metadata))
     )
  (seq 
   (invoke erefs "put" name cref)
   (update cref "name" name)
   (update cref "sort" (if (isnull esort) (int -1) esort))
   (if (instanceof synonyms "java.util.ArrayList") (update cref "synonyms" synonyms))
   (if (instanceof metadata "java.util.Map") (setAttr cref "metadata" metadata)) 
   (if (instanceof subunits "java.util.ArrayList") (setAttr cref "subunits" subunits)) 
   cref )))


;; class Occurrence extends Attributable  
;;  String uname;
;;  String shortname;
;;  String name;
;;  ArrayList<Modification> modifiers;
;;  Location location;

(define jocc2jkb (jkb erefs mods locs) (lambda (occs jobj)
  (if (not (instanceof jobj "java.util.Map"))
    (object null)
    (let ((stype (invoke jobj "get" "stype"))
          (name (invoke jobj "get" "name")) )
      (if (isnull name)  (object null)
        (if (= stype "socc") (apply socc2jkb jkb erefs mods locs occs jobj name)
          (if (= stype "cocc") (apply cocc2jkb jkb erefs mods locs occs jobj name)
               (object null) 
             )))
        ))))

;; A simple occurrence specification (socc)  is an object satisyfing 
;; { "stype":"socc",
;;   "name":"String",          //computed from ename,mods,loc
;;   "shortname":"String",     // computed from ename,mods,loc
;;   "ename":String,           // the entity name
;;   "mods":JArray[String],    // modification names
;;   "loc":String              // the location name
;; }
;; 
;; class  SimpleOccurrence extends Occurrence
;;  int PROT = 0;
;;  int CHEM = 1;
;;  int DNA = 2;
;;  int RNA = 3; 
;;  int SIGNATURE = 4; 
;;  int sort;
;;  EntityReference eref;

(define getMods (modmap modspecs)
  (let ((mods (object ("java.util.ArrayList"))))
   (seq
    (for mspec modspecs 
      (let ((mod (if (instanceOf mspec "java.lang.String")
                   (invoke modmap "get" mspec)
                   (if (instanceof mspec "java.util.Map")
                     (apply getSiteMod modmap mspec)
                     (object null)))) )
        (if (not (isnull mod)) (invoke mods "add" mod))            
       ))
    mods )))

;;  "stype" : "sitemod",
;;  "name" : %name,
;;  "op" : %op,
;;  "site" : %site }
;;  clone op mod, fix name and add site info
  
(define getSiteMod (modmap mspec)
  (let ((name (invoke mspec "get" "name"))
        (mod? (invoke modmap "get" name))
        )
    (if (not (isnull mod?))   ;; does it exist?
       mod?                       
      (let ((nmod (object ("bp2pl.Modification")))    ;; make it
            (op (invoke mspec "get" "op"))
            (site (invoke mspec "get" "site"))
            (opmod (invoke modmap "get" op))
;;; 16apr09						
            (neg? (not (isnull (invoke mspec "get" "neg"))))
          )
        (seq
          (invoke modmap "put" name nmod)
          (update nmod "name" name)
          (update nmod "op" op)
          (update nmod "site" site)
          (update nmod "cvs" (lookup opmod "cvs"))
          (setAttr nmod "shortname" (getAttr opmod "shortname"))
          (setAttr nmod "metadata" (getAttr opmod "metadata"))
;;; 16apr09						
					(if neg? (setAttr nmod "neg" "true"))
          nmod
       )))))

(define esort2osort (eref) 
  (if (instanceOf eref "bp2pl.CompositeReference") 
      bp2pl.SimpleOccurrence.PROT
     (if (isobject eref)
         (lookup eref "sort")
         (int -1)
     )
   ))


(define socc2jkb (jkb erefs mods locs occs jobj name) 
  (let ((occ (object ("bp2pl.SimpleOccurrence")))
;;;!!!
;;        (dummy (invoke java.lang.System.err "println" name))
	      (eref (invoke erefs "get" (invoke jobj "get" "ename")))
	      (omods (apply getMods mods (invoke jobj "get" "mods")))
	      (loc (invoke locs "get" (invoke jobj "get" "loc")))
	      ) 
	   (seq 
	    (if (isnull eref) (invoke java.lang.System.err "println" (concat "eref null: " name)))
	    (invoke occs "put" name occ)
	    (update occ "uname"  (concat (apply jkbNext jkb) ""))
	    (update occ "name" name)
	    (update occ "shortname" (invoke jobj "get" "shortname"))
	    (update occ "eref" eref)
	    (update occ "modifiers" omods)
	    (update occ "location" loc)
	    (update occ "sort" (apply esort2osort eref))
	    occ ) ))


;; A complex occurrence specification (cocc) is an object satisyfing
;; { "stype" :"cocc",
;;   "name" : "String",          //computed from component specs
;;   "shortname" : String,       //computed from component specs
;;   "components" : Components,
;;   "loc" : String                         
;; }
;; 
;; Components = JObject[SimpleOccSpec] |  JArray[String],        
;;   where elements of String should be simpleOcc names in the relevant KB
;; class  ComplexOccurrence extends Occurrence 
;;  ArrayList<Occurrence> components;

(define getOccs (jkb erefs mods locs occs components)
  (let ((componentobjs (object ("java.util.ArrayList"))))
    (seq
      (for jobj components 
         (let ((occ (apply getOcc jkb erefs mods locs occs jobj)))
           (if (not (isnull occ)) (invoke componentobjs "add" occ))
         ))
    componentobjs )))

(define getOcc (jkb erefs mods locs occs jobj)
  (let ((name (invoke jobj "get" "name"))
        (occ? (invoke occs "get" "name")) )
   (if (not (isnull occ?)) ;; exists?
     occ?
;;    (apply (apply jocc2jkb jkb erefs mods locs) occs jobj)
      (apply socc2jkb jkb erefs mods locs occs jobj name) 
    )))

(define cocc2jkb (jkb erefs mods locs occs jobj name) 
  (let ((occ (object ("bp2pl.ComplexOccurrence")))
	      (componentmap (invoke jobj "get" "components"))
	      (components (invoke componentmap "values"))
        (componentobjs (apply getOccs jkb erefs mods locs occs components))
	      (loc (invoke locs "get" (invoke jobj "get" "loc")) )
	     )  
	   (seq 
	    (invoke occs "put" name occ)
	    (update occ "uname"  (concat (apply jkbNext jkb) ""))
	    (update occ "name" name)
	    (update occ "shortname" (invoke jobj "get" "shortname"))
	    (update occ "components" componentobjs)
	    (update occ "location" loc)
	    occ )))

;; A rule specification (RuleSpec) is an object with the following fields
;;  "stype" : "rule",
;;  "name" : String,  
;;  "shortname" : String,
;;  "consumed" : Participants,
;;  "produced" : Participants,
;;  "controls" : Participants,
;;  "description" : String,
;;  "evidence" : EvidenceSpec
;;  }
;; Participants = JArray[String]
;;  class Rule extends Attributable { 
;;   String uname;
;;   String name;
;;   String shortname;
;;   ArrayList<Occurrence> produced;
;;   ArrayList<Occurrence> consumed;
;;   ArrayList<Occurrence> controls;
  

(define jrule2jkb (jkb occs erefs mods locs) (lambda (rules jobj)
  (if (not (instanceof jobj "java.util.Map"))
    (object null)
    (let ((stype (invoke jobj "get" "stype"))
          (name (invoke jobj "get" "name")) )
      (if (or (isnull name)  (!= stype "rule")) 
        (object null) 
        (let ((rule (object ("bp2pl.Rule")))
              (consumed (apply names2objs occs (invoke jobj "get" "consumed")))
              (produced (apply names2objs occs (invoke jobj "get" "produced")))
              (controls (apply names2objs occs (invoke jobj "get" "controls"))) 
              (metadata (invoke jobj "get" "metadata"))
           )
          (seq
       	    (invoke rules "put" name rule)
            (update rule "uname"  (concat (apply jkbNext jkb) ""))
            (update rule "name" name)
       	    (update rule "shortname" (invoke jobj "get" "shortname"))
       	    (update rule "consumed" consumed)
       	    (update rule "produced" produced)
       	    (update rule "controls" controls)
            (setAttr rule "evidence" (invoke jobj "get" "evidence"))
            (setAttr rule "description" (invoke jobj "get" "description"))
            (if (instanceof metadata "java.util.Map") 
                (setAttr rule "metadata" metadata))
            rule
            )
          ))) )))

(define fixNids (kbname)
  (let ((kb (fetch kbname))
        (jkb (getAttr kb "jkb")) 
        (rlabs (getAttr kb "rule-labs"))
        (rids (getAttr kb "rule-ids"))
        (olabs (getAttr kb "occ-labs"))
        (oids (getAttr kb "occ-ids"))
        (oents (invoke (lookup jkb "occmap") "entrySet"))
        (rents (invoke (lookup jkb "rulemap") "entrySet"))
      )
   (seq
     (for ent oents 
       (let ((val (invoke ent "getValue"))
             (nid (apply getNid (invoke ent "getKey")  olabs oids)) )
         (update val "uname" 
           (if (= nid (int -1))(concat (lookup val "uname") "#") (concat "" nid)))
        ))
     (for ent rents 
       (let ((val (invoke ent "getValue"))
             (nid (apply getNid (invoke ent "getKey")  rlabs rids)) )
         (update val "uname" 
           (if (= nid (int -1))(concat (lookup val "uname") "#") (concat "" nid)) )
        ))
    ) ))


(define getNid (name  labs ids)
  (let ((ix (apply getIndex labs (lookup labs "length") name (int 0) )) )
    (if (and (>= ix (int 0)) (< ix (lookup ids "length")) )
        (aget ids ix)
        (int -1) )))




(define test ()
(seq
(define fn "test-loc.json")
(define xrdr (object ("java.io.FileReader" (sinvoke "g2d.util.IO" "interpretTilde" fn))))
(define jstr (sinvoke "g2d.util.IO" "file2String" fn))
(define l0  (sinvoke "org.json.simple.JSONValue" "parse" xrdr))
;; (instanceof l0 "org.json.simple.JSONObject")
;; (instanceof l0 "java.util.Map")
;; (instanceof l0 "org.json.simple.JSONArray")
(define l1  (sinvoke "org.json.simple.JSONValue" "parse" jstr))
))


(define test-model ()
(seq

;; (load "../../PLALib/JSON/json2jkb.lsp")



(seq (define jkb (apply initJKB "RKB")) (define locmap (lookup jkb "locmap"))(define modmap (lookup jkb "modmap"))(define erefmap (lookup jkb "erefmap"))(define occmap (lookup jkb "occmap"))(define rulemap (lookup jkb "rulemap")))

(apply jmapf2jkb jkb locmap   jloc2jkb  (concat "JSON" "/" "locs.json"))
(lookup (invoke locmap "get" "TnfR1C") "term")
(getAttr (invoke locmap "get" "TnfR1C") "metadata")
(getAttr (invoke locmap "get" "CLc") "metadata")

(apply jmapf2jkb jkb modmap   jmod2jkb  (concat "JSON" "/" "mods.json"))
(lookup (invoke modmap "get" "GTP") "cvs")
(lookup (invoke modmap "get" "phos") "cvs")
(getAttr (invoke modmap "get" "phos") "metadata")

(apply jmapf2jkb jkb erefmap  eref2jkb  (concat "JSON" "/" "entities.json"))

(lookup (invoke erefmap "get" "Egf") "xref")
(getAttr (invoke erefmap "get" "Egf") "metadata")

(getAttr (invoke erefmap "get" "Pi3k") "subunits")
(getAttr (invoke erefmap "get" "Pi3k") "metadata")

(getAttr (invoke erefmap "get" "Erks") "members")
(getAttr (invoke erefmap "get" "Erks") "metadata")
(lookup (invoke erefmap "get" "HistH1") "members")

(getAttr (invoke erefmap "get" "ANGIOGENESIS") "metadata")
(getAttr (invoke erefmap "get" "Gabs") "members")
(getAttr (invoke erefmap "get" "Gabs") "metadata")

(apply erefFixup  erefmap)

(lookup (invoke erefmap "get" "Pi3k") "subunits")
(lookup (invoke erefmap "get" "Erks") "members")
(lookup (invoke erefmap "get" "Gabs") "members")


(seq (update jkb "occmap" (object ("java.util.HashMap")))(define occmap (lookup jkb "occmap")))

(apply jmapf2jkb jkb occmap (apply jocc2jkb jkb erefmap modmap locmap) (concat "JSON" "/" "occs.json"))

(invoke occmap "keySet")
(lookup (invoke occmap "get" "Egf:EgfR-ubiq@EgfRC") "components")
(lookup (invoke occmap "get" "Egf:EgfR-ubiq@EgfRC") "shortname")
(lookup (invoke occmap "get" "Gab2@CLc") "location")
(lookup (invoke occmap "get" "Gab2@CLc") "uname")
(lookup (invoke occmap "get" "Tab2-phos-ubiq@Tak1C") "modifiers")

(apply jmapf2jkb jkb rulemap  (apply jrule2jkb jkb occmap erefmap modmap locmap) (concat "JSON" "/" "rules.json"))

(invoke rulemap "keySet")
(invoke rulemap "get" "086.Mekk1.irt.Tnf")

(lookup (invoke rulemap "get" "086.Mekk1.irt.Tnf") "shortname")
(lookup (invoke rulemap "get" "086.Mekk1.irt.Tnf") "produced")
(lookup (invoke rulemap "get" "086.Mekk1.irt.Tnf") "consumed")
(lookup (invoke rulemap "get" "086.Mekk1.irt.Tnf") "controls")
(getAttr (invoke rulemap "get" "086.Mekk1.irt.Tnf") "evidence")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; from the top
(load "../../PLALib/JSON/json2jkb.lsp")

(define jkb (apply initJKB "RKB"))
(apply loadjkb "RKB" "JSON")

(seq  (define locmap (lookup jkb "locmap"))(define modmap (lookup jkb "modmap"))(define erefmap (lookup jkb "erefmap"))(define occmap (lookup jkb "occmap"))(define rulemap (lookup jkb "rulemap")))

;; do above tests


(define etest (apply readJSonF (concat "JSON" "/" "etest.json")))

(define emap (object ("java.util.HashMap")))
(apply jmap2jkb jkb emap eref2jkb etest)


(define entities (apply readJSonF (concat "JSON" "/" "entities.json")))

))


(apply logDev "json2jkb.lsp loaded")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/jsonb2jkb.lsp ;;;;;;;;;;
;; REQUIRES jutil.lsp json2jkb.lsp

;; (define evidencePath "")

;; (define jmapf2jkb (jkb map jfun fname)
;;   (let ((jmap (apply readJSonF fname)))
;;     (apply jmap2jkb jkb map jfun jmap)))
;; 
;; (define jmap2jkb (jkb map jfun jmap)
;;   (for jobj (invoke jmap "values") (apply jfun map jobj))
;; )
 
(define jmapf2jkbS (jkb map jfun fname aname)
  (let ((jmap (apply readJSonF fname)))
    (apply jmap2jkb jkb map jfun jmap)
    (if (instanceof aname "java.lang.String")
		   (setAttr jkb aname jmap))		
		))

;; !!!! need to clean up partition into kinds
(define loadbasicjkb (kbname dir)  ;; infospecfile
 (let ((jkb (getAttr (fetch kbname) "jkb"))
       (locmap (lookup jkb "locmap"))
       (modmap (lookup jkb "modmap"))
       (erefmap (lookup jkb "erefmap"))
       (occmap (lookup jkb "occmap"))
       (rulemap (lookup jkb "rulemap"))
       (bfun (lambda (emap jobj) (apply jbasic2jkb locmap modmap emap jobj)))
       (ofun (apply jocc2jkb jkb erefmap modmap locmap))
       (rfun (apply jrule2jkb jkb occmap erefmap modmap locmap))
       (componentInfoSpec (apply readJSonF "componentInfoSpec.json"))
       (siteSpec (apply readJSonF (concat dir "/" "sites.json")))
      )
  (seq 
     (apply jmapf2jkb jkb erefmap bfun (concat dir "/" "locs.json"))
     (apply jmapf2jkb jkb erefmap bfun (concat dir "/" "mods.json"))
     (apply jmapf2jkb jkb erefmap bfun (concat dir "/" "basicOps.json"))
     (apply processErefs  erefmap)  ;; make generic or composite erefs explicit
     (apply logDev "occs")
     (apply jmapf2jkb jkb occmap   ofun      (concat dir "/" "occs.json"))
     (apply logDev "rules")
     (apply jmapf2jkbS jkb rulemap rfun (concat dir "/" "rules.json") 
		                   "jrules")
     (apply processModsX erefmap modmap siteSpec) ;; annotate mods with entity site
     (apply logDev "done")
     (setAttr jkb "componentInfoSpec" componentInfoSpec)
     (setAttr jkb "siteSpec" siteSpec)
     (define getSimpleInfoFun 
        (if (isnull componentInfoSpec) 
            (lambda (eref) (object null))
            (apply  mkBasicSimpleInfoFun componentInfoSpec)
         ))
  )))

;; modname 
;; LOCATIONOPS MODIFICATIONOPS 
;; PROTEINOPS CHEMICALOPS GENEOPS CELLOPS SIGNATUREOPS -- marbles

(define jbasic2jkb (locmap modmap emap jobj)
   (if (not (instanceof jobj "java.util.Map"))
   (object null)
   (let ((modname (invoke jobj "get" "modname"))
         (name (invoke jobj "get" "name"))
        )
     (if (= modname "LOCATIONOPS")
      (seq (invoke jobj "put" "stype" "loc") (apply jloc2jkb locmap jobj))
     (if (= modname "MODIFICATIONOPS")
      (seq (invoke jobj "put" "stype" "mod") 
           (invoke jobj "put" "op" (if (isobject name) name ""))
           (invoke jobj "put" "mtype" "OTHER") 
           (apply jmod2jkb modmap jobj))
     (if (invoke simpleOps "contains" modname)
       (seq (invoke jobj "put" "stype" "sref") 
            (invoke jobj "put" "etype" (apply plOps2Type modname))
            (apply sref2jkb emap jobj name) 
        )
       (object null)  ;;!!! shouldn't happen
      ))) 
   )))

;; make composites and generics explicit
(define processErefs (erefmap)   
  (let ((erefs (invoke erefmap "values"))
        (generics (apply findGenerics erefs))
        (composites (apply findComposites erefs)) )
   (seq 
    (for eref generics 
         (apply toGenericRef erefmap eref (getAttr eref "metadata")))
    (for eref composites 
         (apply toCompositeRef erefmap eref (getAttr eref "metadata")))
   ) ))

(define findGenerics (erefs)
  (let ((generics (object ("java.util.ArrayList"))))
    (seq
      (for eref erefs
        (let ((md (getAttr eref "metadata")))
          (if (and (instanceof md "java.util.Map")
                   (isobject (invoke md "get" "members")))
;;;;                 (= (invoke md "get" "category") "Family")
              (invoke generics "add" eref) )))
       generics)))

(define findComposites (erefs)
  (let ((composites (object ("java.util.ArrayList"))))
    (seq
      (for eref erefs
        (let ((md (getAttr eref "metadata")))
          (if (and (instanceof md "java.util.Map")
                   (= (invoke md "get" "sort") "Composite"))
              (invoke composites "add" eref) )))
       composites)))


;;; make composites and generics explicit
;; why is printing keySet not working?  need to tostring it?
(define XprocessErefs (erefmap)   
 (seq  (invoke java.lang.System.err "println" (invoke erefmap "keySet"))
  (let ((erefs (invoke erefmap "values")))
    (for eref erefs
(seq ;; DEBUG
  (invoke java.lang.System.err "println" (lookup eref "name"))
     (let ((md (getAttr eref "metadata")))
       (if (instanceof md "java.util.Map")
         (let ((sort (invoke md "get" "sort"))
               (category (invoke md "get" "category")) )
           (if (= category "Family") (apply toGenericRef erefmap eref md)
           (if (= sort "Composite") (apply toCompositeRef erefmap eref md)
            ;; ow its really a simpleRef
           ))))) 
)
          ))
)
)

(define toGenericRef (erefmap eref md)
  (let ((members (invoke md "get" "members"))
        (name (lookup eref "name"))
        )
  (if (and (instanceof members "java.util.ArrayList") 
           (> (invoke members "size") (int 0)) )
    (let ((gref (object ("bp2pl.GenericReference")))
           (mrefs (apply names2objs erefmap members))
          )
       (seq
        (invoke erefmap "put" name gref)  ;; override erefmap binding
        (update gref "name" name)
        (update gref "members" mrefs)
        (update gref "sort" bp2pl.EntityReference.PROT)
        (setAttr gref "metadata" md)
       ) ) )
 ))

(define toCompositeRef (erefmap eref md)
  (let ((subunits (invoke md "get" "subunits"))
        (name (lookup eref "name"))
        )
  (if (and (instanceof subunits "java.util.ArrayList") 
           (> (invoke subunits "size") (int 0)) )
    (let ((cref (object ("bp2pl.CompositeReference")))
           (sunits (apply names2objs erefmap subunits))
          )
       (seq
        (invoke erefmap "put" name cref)  ;; override erefmap binding
        (update cref "name" name)
        (update cref "subunits" sunits)
        (update cref "sort" bp2pl.EntityReference.PROT)
        (setAttr cref "metadata" md)
       ) ) )  ))

(define processMods (erefmap modmap) 
   (apply processModsX erefmap modmap (object null))) 

(define _processMods (erefmap modmap) 
  (let ((mods (invoke modmap "values")))
    (for mod mods
     (let ((site (lookup mod "site"))
           (eref (if (instanceof site "java.lang.String")
                     (invoke erefmap "get" site)
                     (object null))) 
           )
           (if (instanceof eref "bp2pl.EntityReference")
               (seq (setAttr mod "eref" eref)
                  ;;  (apply setErefImage eref)
             ))
       )) ))

/*
"TEY":{"stype" : "basicOp",
	 "name" : "TEY",
	 "modname" : "SITEOPS",
	 "metadata" : { "FamilyName" : "Erks", "epitopes" : [ "Erk1 phos(T202/Y204)", "Erk2 phos(T185/Y187)" ], "sort" : "Site" }
},
*/

(define epitopes2emap (elist)
  (let ((res (apply mkMtMap)))
   (for e elist 
    (let ((parts (invoke e "split" "\\s+"))) 
      (if (= (lookup parts "length") (int 2))
        (invoke res "put" (aget parts (int 0))(aget parts (int 1)) )
      )) )
    res))

(define sspec2epi (ss)
  (let ((md (invoke ss "get" "metadata")))
    (if (instanceof md "java.util.Map")
      (invoke md "get" "epitopes")
      (object null) )))

;; if has site and siteSpec(site) defined put emap in metadata
(define processModsX (erefmap modmap siteSpec) 
  (let ((mods (invoke modmap "values")))
    (for mod mods
     (let ((site (lookup mod "site"))
           (eref (if (instanceof site "java.lang.String")
                     (invoke erefmap "get" site)
                     (object null))) 
           (ss   (if (and (instanceof site "java.lang.String")
                           (isobject siteSpec))
                     (invoke siteSpec "get" site)
                     (object null))) 
           (epi (if (instanceof ss "java.util.Map") 
                  (apply sspec2epi ss)
                  (object null)))
           (emap (if (isobject epi) 
                  (apply epitopes2emap epi)
                  (object null)))                     
           )
           (if (instanceof eref "bp2pl.EntityReference")
             (setAttr mod "eref" eref)
            )
           (if (isobject emap) (setAttr mod "epitopeMap" emap) )
       )) ))


(define setImagePath (kbname url)
 (let ((jkb (getAttr (fetch kbname) "jkb")))
   (setAttr jkb "imagePath" url)
))
(define setGraphImagePath (graph)
  (let ((kbname (getAttr graph "kbname"))
        (jkb (getAttr (fetch kbname) "jkb")))
     (update graph "images" (getAttr jkb "imagePath") )
))

(define setModelName (kbname mname)
 (let ((jkb (getAttr (fetch kbname) "jkb")))
   (setAttr jkb "modelName" mname)
   ;; total hack (should be a line by itself in the loader).
   (apply setKBMTitle kbname)
))

(define setKBMTitle (kbname)
 (let ((mname (apply getModelName kbname))
       (kbf  (apply getKBMFrame))
       (title (invoke kbf "getTitle"))
       (ntitle (concat  mname " Manager"))
       )
   (invoke kbf "setTitle" ntitle)
   )
 )

(define getModelName (kbname)
 (let ((jkb (getAttr (fetch kbname) "jkb")))
   (getAttr jkb "modelName")
))


 (apply logDev "jsonb2jkb.lsp loaded")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/setImLabs.lsp ;;;;;;;;;;
/*
useChattyLabels true causes mkNewNode to set the nattrs label to long ow short

shrinkImlabs calls setNodeLabels gname "occ" "imlab"

setNodeLabels 
   (invoke node "setLabel" (getAttr node tag ""))
   (invoke graph "doLayout")
   (invoke panel "setGraph" graph) 

Graph menu ChattyLabels uses "chattylabel"  tag
           Short uses (apply setNodeLabels gname "occ" "label")


setDotAttrs just sets node attrs and node dotAttrs

;;;!!! fixed viewport bug 13jan23
(define setNodeLabels (gname type tag)
  (let ((graph (fetch gname))
        (panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (nodes (invoke graph "getNodesInArray")))
    (seq
      (for node nodes 
         (if (= type (getAttr node "type"))
           (seq
            (invoke node "setBaseDimension" (double 10) (double 10))
            (invoke node "setLabel" (getAttr node tag ""))
            ))  )
      (invoke graph "doLayout")
      (invoke panel "setGraph" graph) 
;;      (apply refreshThumbnail panel graph)
;;      (invoke panel "repaint")
   )) ; seq let
)


The kb setup should set label atttributes
  simpleOcc  shortlabel, chattylabel (imagelabels if there is an imageFile)

  complex occ shortlabels, chattylabels 
     What is the magic for getting images into records?

(define isIM () (try isImmuneModel (catch var (boolean false))))

(apply setImLabs kbname)

/*
imparts is a Hashmap
  marble ename
  pmods  not s or x mod
  smods starts with s
  xmods starts with x
*/

(define socc2imparts (socc)
  (let ((eref (lookup socc "eref"))
        (mods (lookup socc "modifiers"))
        (pmods (object ("java.util.ArrayList")))
        (xmods (object ("java.util.ArrayList")))
        (smods (object ("java.util.ArrayList")))
        (parts (object ("java.util.HashMap")))
     )
  (invoke parts "put" "marble" (lookup eref "name"))
  (apply mods2imods mods smods xmods pmods)
  (invoke parts "put" "pmods" pmods)
  (invoke parts "put" "smods" smods)
  (invoke parts "put" "xmods" xmods)
 parts
))

(define mods2imods (mods smods xmods pmods)
  (for mod mods
    (let ((mname (lookup mod "name")))
      (if (invoke mname "startsWith" "s")
        (invoke smods "add" mname)
        (if (invoke mname "startsWith" "x")
          (invoke xmods "add" mname)
          (invoke pmods "add" mname)
     )))))


// each simple occ has shortlab attr and chattylab attr 
// each complex occ has shortlabs attr and chattylabs attr

(define setImLabs (kbname)
  (let ((kb (fetch kbname))
        (jkb (getAttr kb "jkb"))
        (omap (lookup jkb "occmap"))
        (occs (invoke omap "values"))
       )
  (for occ occs
    (if (instanceof occ "bp2pl.SimpleOccurrence")
        (apply ensureImSoccLab occ)
        (if (instanceof occ "bp2pl.ComplexOccurrence")
            (apply setImCOccLab occ)
   ))
)))


(define ensureImSoccLab (occ)
  //check if already set
  (if (or
      (isnull (getAttr occ "imparts"))
      (isnull (getAttr occ "shortlabel"))
      (isnull (getAttr occ "chattylabel"))
      )
   (apply setImSOccLab occ)
   (boolean true)
 ))

// assume not already set -- repeat is not really a problem
(define setImSOccLab (occ)
  (let ((imparts (apply socc2imparts occ))
        (loc (lookup (lookup occ "location") "name"))
        (slab  (concat 
            (apply shortSimpleThLab imparts)
            "@"
            loc))
        )
    (setAttr occ "imparts" imparts)
    (setAttr occ "shortlabel" slab)
    (setAttr occ "chattylabel" (lookup occ "name"))
))

(define modSuffix (mods)
  (let ((sbuf (object ("java.lang.StringBuffer"))))
    (seq
     (for mod mods (invoke sbuf "append" (concat "-" mod)))
     (invoke sbuf "toString") 
    )) )


(define shortSimpleThLab (imparts)
  (let ((marble (invoke imparts "get" "marble"))
        (pmods (invoke imparts "get" "pmods"))
        (modsuffix (if (> (invoke pmods "size") (int 0))
                       (apply modSuffix pmods)
                       ""))
       )
  (concat marble  modsuffix)
))

(define setImCOccLab (occ)
  (let ((components (lookup occ "components"))
        (shortlabs (object ("java.util.ArrayList")))
        (chattylabs (object ("java.util.ArrayList"))) )
    (for socc components
      (seq (apply ensureImSoccLab socc)
         (invoke shortlabs "add" (getAttr socc "shortlabel"))
         (invoke chattylabs "add" (getAttr socc "chattylabel"))
       ))
    (setAttr occ "shortlabels" shortlabs)
    (setAttr occ "chattylabels" chattylabs)
))

(apply logDev "setImLabs.lsp")
// (g2dexe graphics2d (define isImmuneModel (boolean true)))
// (g2dexe graphics2d (apply setImLabs "RKB"))


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/setImageLabels.lsp ;;;;;;;;;;
/* setting occurrence label attributes when there is an image.
  shortlabel chattylabel
 shortimagelabel chattyimagelabel
  For glycans first set the image attribute of each simple occ

*/


(define getdimensionsLocal (image)
  (try 
   (let ((file (object ("java.io.File" image)))
         (bi (sinvoke "javax.imageio.ImageIO" "read" file))
         (w (invoke bi "getWidth"))
         (h (invoke bi "getHeight"))
         )
     (object ("java.awt.Dimension" w h)))
   (catch e (object null))))

(define getdimensionsRemote (path image)
  (try 
   (let ((bi (sinvoke "g2d.util.Fetch" "getImage" (concat path image)))
         (w (invoke bi "getWidth"))
         (h (invoke bi "getHeight"))
         )
     (object ("java.awt.Dimension" w h)))
   (catch e
     (invoke java.lang.System.err "println" (concat "Image: " image " path " path " exception " e))
     (object null)
     )))
   

(define getScaling (dim)
  (let ((h (lookup dim "height")))
    (if (< h (int 50))
        (int 1)   //guess that they have already been scaled
      (if (< h (int 100))
          (int 3)
        (if (< h (int 200))
            (int 4)
          (if  (< h (int 300))
              (int 6)
            (int 7)
    )))) ))

(define getdesiredDimension (name dim scaling)
  (let ((dh (/ (lookup dim "height") scaling))
        (dw (/ (lookup dim "width") scaling))
        )
    (object ("java.awt.Dimension" dw dh))
    )
  )

(define imageAttr (path image label)
  (let ((dim (if (isobject path)
                 (apply getdimensionsRemote path image)
               (apply getdimensionsLocal image) )))
    (if (isnull dim)
        ;; image is missing 
        (object null)
      (let ((sb (object ("java.lang.StringBuffer")))
            (scaling (apply getScaling dim))
            (ddim (apply getdesiredDimension image dim scaling))
            (h (lookup ddim "height"))
            (w (lookup ddim "width"))
            )
        ;;(invoke java.lang.System.err "println" (concat "scaling: " scaling))
        (if (= scaling (int 1))
            (apply imageAttrUnscaled image label sb w h)
          (apply imageAttrScaled image label sb w h) 
          )
        (invoke sb "toString")
        )
      )
    )
  )

(define imageAttrScaled (image label sb w h)
  (invoke sb "append" "<<TABLE border=\"0\" cellborder=\"0\">\n<TR><TD width=")
  (invoke sb "append" (concat "\"" w "\""))
  (invoke sb "append" (concat " height=\"" h "\" fixedsize=\"true\"><IMG SRC=\""))
  (invoke sb "append" image)
  (invoke sb "append" "\" scale=\"true\"/></TD><td><font point-size=\"14\">")
  (invoke sb "append" label)
  (invoke sb "append" "</font></td></TR>\n</TABLE>>")
  )

(define imageAttrUnscaled (image label sb w h)
  (invoke sb "append" "<<TABLE border=\"0\" cellborder=\"0\">\n<TR><TD><IMG SRC=\"")
  (invoke sb "append" image)
  (invoke sb "append" "\"/></TD><td><font point-size=\"14\">")
  (invoke sb "append" label)
  (invoke sb "append" "</font></td></TR>\n</TABLE>>")
  )

;; 13oct06 clt to use PngID
(define XsetGlycanImage (occ)
  (let ((modifiers (lookup occ "modifiers") )
        (modifier (if (> (invoke modifiers "size") (int 0)) 
                      (invoke modifiers "get" (int 0))
                      (object null)))
       (eref (if (isobject modifier) (getAttr modifier "eref") (object null)))
       (keggid (if (isobject eref) 
                  (let ((md (getAttr eref "metadata")))
                     (if (isobject md) (invoke md "get" "KeggGlycID") (object null)))
                  (object null)) )
       (image  (if (isobject keggid) (concat "Pngs/" keggid ".png") (object null)))
    )
  (if (isobject image) (setAttr occ "image" image))
  image
))

(define setGlycanImage (occ)
  (let ((modifiers (lookup occ "modifiers") )
        (modifier (if (> (invoke modifiers "size") (int 0)) 
                      (invoke modifiers "get" (int 0))
                      (object null)))
       (eref (if (isobject modifier) (getAttr modifier "eref") (object null)))
       (md  (if (isobject eref) 
                (getAttr eref "metadata")
                (object null)))
       (pngid (if (isobject md) (invoke md "get" "PngID") (object null)))
       (keggid (if (isobject md) (invoke md "get" "KeggGlycID") (object null)))
       (image (if (isobject pngid)
                  (concat "Pngs/" pngid ".png") 
                  (if (isobject keggid) 
                      (concat "Pngs/" keggid ".png")
                      (object null))))
       )
  (if (isobject image) (setAttr occ "image" image))
  image
))


(define locsepchar "@")

(define setGlycanLabels (socc path)
  (let ((image (apply setGlycanImage socc))
        (name (lookup socc "name"))
        (sname (lookup socc "shortname"))
        (ename (lookup (lookup socc "eref") "name"))
        (loc (lookup (lookup socc "location") "name"))
       )
;; (invoke java.lang.System.err "println" name)
 (if (isobject image)
   (seq (setAttr socc "shortimagelabel"  (apply imageAttr path image ename))
        (setAttr socc "chattyimagelabel"  
                 (apply imageAttr path image (concat ename locsepchar loc)))
  ))
 (setAttr socc "shortlabel"  sname)
 (setAttr socc "chattylabel"  name)
))

;; NB must set remote path in kb if client server mode

(define setGlycanLabelsKB (kbname)
  (let ((jkb (getAttr (fetch kbname) "jkb"))
        (path  (getAttr jkb "imagePath"))   ;; url to remote site or null
        (occmap (lookup jkb "occmap"))
        (occs (invoke occmap "values"))
       )
   (for occ occs
     (if (instanceof occ "bp2pl.SimpleOccurrence")
        (apply setGlycanLabels occ path)
        (if (instanceof occ "bp2pl.ComplexOccurrence")
            (apply setComplexOccLabels occ)
     )) 
  )))

(define setComplexOccLabels (occ)
  (let ((components (lookup occ "components")))
    (setAttr occ "shortlabels" (apply objs2vals components "shortname"))
    (setAttr occ "chattylabels" (apply objs2vals components "name"))
 ))

(define setSimpleOccLabels (occ)
  (seq
    (setAttr occ "shortlabel" (lookup occ "shortname"))
    (setAttr occ "chattylabel" (lookup occ "name"))
 ))

(define setStandardLabelsKB (kbname)
  (let ((jkb (getAttr (fetch kbname) "jkb"))
        (occmap (lookup jkb "occmap"))
        (occs (invoke occmap "values"))
       )
   (for occ occs
     (if (instanceof occ "bp2pl.SimpleOccurrence")
        (apply setSimpleOccLabels occ)
        (if (instanceof occ "bp2pl.ComplexOccurrence")
            (apply setComplexOccLabels occ)
     )) 
  )))

(apply logDev "setImageLabs.lsp")
/*
In Glycan model
if remote
(apply setImagePath kbname url)  ;; in jsonb2jkb
(apply setGlycanLabelsKB kbname)




*/

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/setDotAttrs.lsp ;;;;;;;;;;
;; assumes each occ has labels set or reduces to old short v chatty label
;; setting should be done in the load-pl file -- a configuration matter

;; default non-chatty
(define setDotAttrs (graph)(apply setDotAttrsX graph useChattyLabels))

(define setDotAttrsX (graph chatty?)
  (let ((kbname (getAttr graph "kbname"))
        (jkb (getAttr (fetch kbname) "jkb"))
        (occmap (lookup jkb "occmap"))
        (nodes (invoke graph "getNodesInArray"))
      )
    (for nd nodes 
      (if (= (getAttr nd "type") "occ")
        (let ((clab (getAttr nd "chattylabel"))   
              (occ (invoke occmap "get" clab))
              )
        (if (instanceof occ "bp2pl.SimpleOccurrence")
            (apply setDotSimpleAttr graph nd  occ clab chatty?) 
        (if (instanceof occ "bp2pl.ComplexOccurrence")
            (apply setDotComplexAttr graph nd  occ clab chatty?) 
         )) ;; if if
      )))  ;; let if for
))

// two cases, image or not -- has imlab or not
// (apply imageAttr graph image clab)

(define setDotSimpleAttr (graph nd occ clab chatty?)
  (let ((imagelab (getAttr occ (if chatty? "chattyimagelabel" "shortimagelabel")))
        (plainlab (getAttr occ (if chatty? "chattylabel" "shortlabel")))
      )
   (if (isobject imagelab) 
      (let ((nattrs (lookup nd "dotNodeAttributes")))
        (setAttr nd "ilabel"  imagelab)
        (invoke nattrs "setDotAttribute" g2d.graph.DotAttributes.SHAPE "box")
        (invoke nattrs "setDotAttribute" g2d.graph.DotAttributes.STYLE 
                       "\"filled,rounded\"")
        )
      (seq
         (invoke nd "setBaseDimension" (double 10) (double 10))
         (invoke nd "setLabel"
            (if (isobject plainlab) 
              plainlab 
              (if chatty? (getAttr nd "chattylabel" "") (getAttr nd "label" ""))))
       )
    )))


// for now assume its a record attr, no image stuff
(define setDotComplexAttr (graph nd occ clab chatty?)
  (let ((labels (getAttr occ (if chatty? "chattylabels" "shortlabels"))))
    (if (isobject labels)
       (setAttr nd "rlabel"  (apply mrecordAttr labels))
       (seq
;; clt -- is this needed?
         (invoke nd "setBaseDimension" (double 10) (double 10))
         (invoke nd "setLabel" clab)
        ))
 ))

(define lbrace "{")(define rbrace "}")
(define lbchar (char '{'))(define rbchar (char '}'))

(define mrecordAttr (arr) 
  (let ((sbuf (object ("java.lang.StringBuffer"))))
    (seq (invoke sbuf "append" lbrace)
        (for elt arr (invoke sbuf "append" (concat " " elt " |")))
        (invoke sbuf "setCharAt" (invoke sbuf "lastIndexOf" "|") rbchar)
       (invoke sbuf "toString")
    )))

(apply logDev "setDotAttrs.lsp")

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/garudaIO.lsp ;;;;;;;;;;
;; assuming Protein.UniProt is the metadata tag for the uniprot number of a prot
;; need componentInfoSpec.json for all models!


;; returns an arraylist of uniprot names
(define exportUniprot (gname fname)
  (let ((uidlist (apply graph2uniprots gname)))
     (sinvoke "g2d.util.IO" "collection2File" uidlist fname (object null) (boolean false))) )

(define graph2uniprots (gname)
  (let ((graph (fetch gname))
        (uplist (object ("java.util.ArrayList"))) )
  (if (isobject graph)(apply graph2uniprotX graph uplist) uplist)  ))

(define graph2uniprotX (graph uplist)
  (let ((kbname (getAttr graph "kbname"))
        (jkb (getAttr (fetch kbname) "jkb"))
        (occmap (lookup jkb "occmap"))
        (erefmap (lookup jkb "erefmap"))
        (nodes (invoke graph "getNodesInArray"))
        (ci (getAttr jkb "componentInfoSpec"))
        (componentInfoSpec 
          (if (instanceof ci "java.util.Map") ci (object ("java.util.HashMap"))))
        (protspec (invoke componentInfoSpec "get" "Protein"))
        (upspec (if (instanceof protspec "java.util.Map")
                 (invoke protspec "get" "UniProt")
                 (object null) ))
        (uptag (if (instanceof upspec "java.util.Map")
                 (invoke upspec "get" "mdtag")
                 (object null) ))        
     )
  (if (isnull uptag) uplist ;; can't export usefully
  (seq
;;   (invoke java.lang.System.err "println" (concat "uptag: " uptag))
   (for nd nodes  
    (if (= (getAttr nd "type") "occ")
      (let ((clab (getAttr nd "chattylabel"))   
            (occ (invoke occmap "get" clab))
;;          (dummy (seq (invoke java.lang.System.err "println" (concat "clab: " clab)) "x"))
           )
        (if (instanceof occ "bp2pl.SimpleOccurrence")
            (apply eref2uniprots  uptag uplist (lookup occ "eref")) 
            (if (instanceof occ "bp2pl.ComplexOccurrence")
               (for occ0 (lookup occ "components")
               (apply eref2uniprots uptag uplist (lookup occ0 "eref")))
             (object null)
         )) ;; if if
      )))  ;; let if for
      uplist
    )) ))

(define eref2uniprots (uptag uplist eref)
 (seq
;;  (invoke java.lang.System.err "println" (concat "eref: " (lookup eref "name")))
 (if (instanceof eref "bp2pl.CompositeReference")
    (for eref0 (lookup eref "subunits") (apply eref2uniprots uptag uplist eref0))
 (if (instanceof eref "bp2pl.GenericReference")
    (for eref0 (lookup eref "members") (apply eref2uniprots uptag uplist eref0))
 (if (instanceof eref "bp2pl.SimpleReference")
     (apply sref2uniprots uptag uplist eref)
  ;; do nothing
)))
)
)

(define sref2uniprots (uptag uplist eref)
  (let ((md (getAttr eref "metadata"))
        (uid (if (instanceof md "java.util.Map") (invoke md "get" uptag)
                 (object null)))
         )
(seq
;;    (invoke java.lang.System.err "println" (concat "eref: " (lookup eref "name")))
;;    (invoke java.lang.System.err "println" (concat "uid: " uid))
    (if (and (isobject uid) (not (invoke uplist "contains" uid)))
          (invoke uplist "add" uid))
)
  ))

;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/jnet2graph.lsp ;;;;;;;;;;
/*

{
"rids":["001.EgfR.irt.Egf","116.Gab1.irt.Egf","116x.Gab1.irt.Egf","172.Pi3k.irt.Egf","197.Sos1.irt.Egf","529.Hras.irt.Egf"],
"op":"dishnet",
"args":"dish0",
"name":"pnet1",
"init":["Egf@XOut","EgfR@CLm","Sos1@CLc","Gabs@CLc","Pi3k@CLc","Hras-GDP@CLi"],
"parent":"RKB",
"type":"pnet",
"kbname":"RKB"}

{
"rids":["001.EgfR.irt.Egf","116.Gab1.irt.Egf","116x.Gab1.irt.Egf","172.Pi3k.irt.Egf","197.Sos1.irt.Egf","529.Hras.irt.Egf"],
"op":"subnet",
"args":{"goals":["Gab1-phos@CLi"],
        "avoids":[],
         "hides":[]},
"name":"pnet3",
"init":["Egf@XOut","EgfR@CLm","Sos1@CLc","Gabs@CLc","Pi3k@CLc","Hras-GDP@CLi"],
"parent":"pnet1",
"type":"pnet",
"kbname":"RKB"
}

*/
(define readNet (fname)
 (let ((jnet (apply readJSonF fname)))
   (if (isnull jnet) (object null)
      (let ((name (invoke jnet "get" "name"))
            (kbname (invoke jnet "get" "kbname"))
            (jkb (if (isobject kbname) (getAttr (fetch kbname) "jkb") (object null) ))
            (netmap (if (isobject jkb) (getAttr jkb "netmap") (object null)))
            ) 
         (if (and (isobject netmap) (isobject name)) (invoke netmap "put" name jnet))
        name ))))

(define getGoals (jnet)
 (let ((op (invoke jnet "get" "op")))
   (if (or (= op "subnet") (= op "pathnet"))
       (invoke (invoke jnet "get" "args") "get" "goals")
       (object ("java.util.ArrayList")))
  ))
(define getAvoids (jnet)
 (let ((op (invoke jnet "get" "op")))
   (if (or (= op "subnet") (= op "pathnet"))
       (invoke (invoke jnet "get" "args") "get" "avoids")
       (object ("java.util.ArrayList")))
  ))

(define getHides (jnet)
 (let ((op (invoke jnet "get" "op")))
   (if (or (= op "subnet") (= op "pathnet"))
       (invoke (invoke jnet "get" "args") "get" "hides")
       (object ("java.util.ArrayList")))
  ))


(define makeNetTitle (gname requestor requestop requestargs)
  (let ((contention ":"))
    (if (= requestop "dishnet")
        (concat gname contention requestargs)
     (if (= requestop "subnet")
         (concat gname contention "S(" requestor ")")
      (if (= requestop "pathnet")
          (concat gname contention "P(" requestor ")")
        (if (= requestop "explore")
            (concat gname contention "E(" requestor ")")
         (if (= requestop "compare")
             (concat gname contention "C(" requestor "," requestargs ")")
            "Mystery")))))
  ) )

(define formatjquery (args padding)
  (let ((mt (object ("java.util.ArrayList")))
        (goals  (apply lookupd args "goals" mt))
        (avoids  (apply lookupd args "avoids" mt))
        (hides  (apply lookupd args "hides" mt))
        (sb (object ("java.lang.StringBuffer")))
       )
    (invoke sb "append" (concat padding  "Goals:  " (invoke goals "toString") "\n")) 
    (invoke sb "append" (concat padding  "Avoids:  " (invoke avoids "toString") "\n")) 
    (invoke sb "append" (concat padding  "Hides:  " (invoke hides "toString") "\n")) 
    (invoke sb "toString")
))


 (define makeNetDescription (gname requestor requestop requestargs) 
   (let (
         (padding " ")
         (spadding "    ")
         (ppadding "    ")
         (contention ": ") )
     (if (= requestop "dishnet")
         (concat gname contention "DishNet(" requestor ", " requestargs ")")
       (if (= requestop "subnet")
           (let ((gname1 requestor)
                 (descriptor1 (lookup (fetch gname1) "description" ))
                 (child1 (apply indentation gname1 descriptor1 padding))
                 (query (if (instanceof requestargs "java.util.Map")
                            (apply formatjquery requestargs spadding) 
                            "noQuery") )
                 )
               (concat gname contention 
                       "SubNet(" gname1 ") with \n" query "\n" child1) )
         (if (= requestop "pathnet")
           (let ((gname1 requestor)
                 (descriptor1 (lookup (fetch gname1) "description" ))
                 (child1 (apply indentation gname1 descriptor1 padding))
                 (query (if (instanceof requestargs "java.util.Map")
                            (apply formatjquery requestargs spadding) 
                            "noQuery"))
                )
               (concat gname contention 
                       "PathNet(" gname1 ") with \n" query "\n" child1) ) 
           (if (= requestop "explore")
               (concat gname contention "[" requestor "].E(" requestargs ")")
             (if (= requestop "compare")
                 (let ((gname1 requestor)
                       (gname2 requestargs)
                       (descriptor1 (lookup (fetch requestor) "description" ))
                       (descriptor2 (lookup (fetch requestargs) "description" ))
                       (child1 (apply indentation gname1 descriptor1 padding))
                       (child2 (apply indentation gname2 descriptor2 padding))
                       )
                   (concat gname contention
                          "Compare(" gname1 ", " gname2 ")\n\n"  child1 "\n" child2) )
               "Mystery")))))
     )
   )
 
(define newEdgeNd (graph src tgt bidir?)
  (let ((color (if (= bidir? "true") bidirEdgeColor  unidirEdgeColor))
        (e (object ("g2d.graph.IOPEdge" src tgt color))) )
    (seq 
      ; can replace "dashed" by "dotted"
     (if (= bidir? "true")  (invoke e "setStyle" "dashed"))
     (invoke e "setDoubleEnded" (boolean false)) 
     (setAttr e "bidir" bidir?)
     (invoke graph "addEdge" e)
     e))
) ;newEdgeNd

(define mkOStr (occs0 occs1)
  (let ((strb (object ("java.lang.StringBuffer"))))
    (seq
      (for o occs0 (invoke strb "append" (concat (lookup o "uname") " ")))
      (for o occs1 (invoke strb "append" (concat (lookup o "uname") " ")))
      (invoke (invoke strb "toString") "trim")
  )))

(define getOccNodes (graph occs inits goals colorC mouseClickedC)
  (let ((onodes (object ("java.util.ArrayList"))))
    (for occ occs 
      (let ((clab (lookup occ "name"))
            (nd (invoke graph "getNode" clab)) )
        (if (isobject nd) 
            (invoke onodes "add" nd)
            (invoke onodes "add"
              (apply addONode graph occ inits goals colorC mouseClickedC))
         )
     ))
    onodes
  ) )


(define addONode (graph occ inits goals colorC mouseClickedC)
  (let ((clab (lookup occ "name"))
        (lab (lookup occ "shortname"))
        (nid (lookup occ "uname"))
        (ival (if (invoke inits "contains" clab) "true" "false"))
        (sval (if (invoke goals "contains" clab) "goal" "none"))
        (tags (array java.lang.String  "init" "status") )
        (vals (array java.lang.String  ival sval))
         )
     (apply newOccNode graph mouseClickedC  nid lab clab tags vals colorC)
   ))



(define addTransition (graph  rule inits goals  colorC mouseClickedC)
  (let ((consumed (lookup rule "consumed"))
      (produced (lookup rule "produced"))
      (controls (lookup rule "controls"))
      (lab (lookup rule "shortname"))
      (nid (lookup rule "uname"))
      (clab (lookup rule "name"))
      (prestr (apply mkOStr consumed controls))
      (poststr (apply mkOStr produced controls))
      (tags (array java.lang.String  "status" "pre" "post") )
      (vals (array java.lang.String  "none" prestr poststr))
      (rnode (apply newRuleNode graph mouseClickedC nid lab clab tags vals colorC))
      (inodes (apply getOccNodes graph consumed  inits goals colorC mouseClickedC))
      (onodes (apply getOccNodes graph produced  inits goals colorC mouseClickedC))
      (bnodes (apply getOccNodes graph controls  inits goals colorC mouseClickedC))
     )
;;; make edges
;;     (for nd inodes (apply newEdgeNd graph nd rnode (boolean false)))
     (for nd inodes (apply newEdgeNd graph nd rnode "false"))
     (for nd onodes (apply newEdgeNd graph rnode nd "false"))
     (for nd bnodes (apply newEdgeNd graph nd rnode "true"))
     (setAttr rnode "inodes" inodes)
     (setAttr rnode "onodes" onodes)
     (setAttr rnode "bnodes" bnodes)
   ))


/*
most graph fields set by
            
  IOPGraph(String name, String title, String description, IOPGraph parent, 
           Closure colorC, Closure toolBarC, Closure menuBarC)


 String images; // GlycoSTM = "http://iandev.sri.com/~pl/Images/GlycoSTM/";
 (apply  setGraphImagePath graph)  ;; sets images field using jkb attr by config file

If setting fields of raw graph
  IOPGraph getParent()
  void setParent(IOPGraph parent) 

Closures 
    //(lambda (panel graph) ...)
    public Closure panelClosure = null; 
   //(lambda (self event) ...)
    public Closure mouseClickedClosure = null;
    (update graph "toolBarClosure" 
       (lambda (panel graph) 
           (apply toolBarFun (lookup panel "toolBar") gname graph panel pgraph))) 
    (update graph "menuBarClosure" 
                (lambda (panel graph) 
                  (apply menuBarFun gname graph panel)))

*/
 
 

;;; assume jnet is hashmap
(define jnet2graph (kbname netname)
  (let ((kb (fetch kbname))
        (jkb (if (instanceof kb "g2d.jlambda.Attributable") 
               (getAttr kb "jkb")
               (object null)) )
        (rulemap (lookup jkb "rulemap"))
        (netmap (getAttr jkb "netmap"))
        (jnet (invoke netmap "get" netname))
        (gname (invoke jnet "get" "name"))
        (type (invoke jnet "get" "type"))
        (requestor (invoke jnet "get" "parent"))
        (requestop (invoke jnet "get" "op"))
        (requestargs (invoke jnet "get" "args"))
        (parent (if (= requestor kbname) (object null) (fetch requestor)))
        (rids (invoke jnet "get" "rids"))
        (inits (apply lookupd jnet "init" (object ("java.util.ArrayList"))))
        (goals (apply getGoals jnet))
        (title (apply makeNetTitle gname requestor requestop requestargs))
        (description (apply makeNetDescription gname requestor requestop requestargs))
        (toolBarC
          (if (= type "pnet")
                (lambda (panel graph) 
                     (apply toolBarFunPnet (lookup panel "toolBar") 
                                 gname graph panel parent))
           (if (= type "xnet")
                (lambda (panel graph) 
                     (apply toolBarFunXnet (lookup panel "toolBar") 
                                 gname graph panel parent))
              (object null)))) 
        (menuBarC 
          (if (= type "pnet")
              (lambda (panel graph) (apply menuBarFunBase gname graph panel))
          (if (= type "xnet")
              (lambda (panel graph) (apply menuBarFunBase gname graph panel))
              (object null))))
        (colorC 
          (if (= type "pnet") colorPnetNode
            (if (= type "xnet") colorXnetNode (object null))))
        (graph (object ("g2d.graph.IOPGraph"
             gname title description parent colorC toolBarC  menuBarC)))
        (mouseClickedC
          (if (= type "pnet") (apply mkPnetMouseClickedClosure graph)
            (if (= type "xnet") (apply mkXnetMouseClickedClosure graph))) )
         )
   (seq
     (setAttr graph "kbname" kbname)
     (setAttr graph "requestor" requestor)
     (setAttr graph "requestop" requestop)
     (setAttr graph "requestargs" requestargs)
     (setAttr graph "mouseClickedClosure" mouseClickedC)
     (update graph "mouseClickedClosure" mouseClickedC)
      ;; add rnode onodes edges
     (for r rids 
        (apply addTransition graph (invoke rulemap "get" r) 
                    inits goals colorC mouseClickedC))
     (setuid graph gname) 
     graph
   )))

(define showJGraph (graph selections)
   (seq
;; 13jun19 clt fancy nodes
     (apply setDotAttrs graph)
     (invoke graph "setStrokeWidth" (float 1.0))
     ;; do layout with dot by default
     (invoke graph "doLayout" (object null))
     (sinvoke "g2d.pla.PLAUtils" "launchTab"  graph selections)
;; get progressbar attr from KBM, if not null, setvisible false
     (apply closeProgressd)
     )
   )

;;; assume jnet is hashmap
(define displayJnet (jnet)
  (let ((kbname (invoke jnet "get" "kbname"))
        (kb (fetch kbname))
        (jkb (if (instanceof  kb "g2d.Attributable") 
               (getAttr kb "jkb")
               (object null)) )
        (type (invoke jnet "get" "type"))
         )
   (if (instanceof jkb "bp2pl.KB")
      (let ((graph (apply jnet2graph kbname jkb jnet))) 
          (apply showJGraph graph (= type "pnet"))
      )
      (object null) ) ))


;;;;;;;;;; ../Tools/makeg2dlib loaded G2dLib/export-import-lists.lsp ;;;;;;;;;;
;; assuming Protein.UniProt is the metadata tag for the uniprot number of a prot
;; need componentInfoSpec.json for all models!


;; returns an arraylist of uniprot names
(define exportUniprot (gname fname)
  (let ((xidlist (apply graph2Xnames gname "bprot2uniprot")))
     (sinvoke "g2d.util.IO" "collection2File" xidlist fname (object null) (boolean false))) )

;; returns an arraylist of hugo names
(define exportHugo (gname fname)
  (let ((xidlist (apply graph2Xnames gname "bprot2hugo")))
     (sinvoke "g2d.util.IO" "collection2File" xidlist fname (object null) (boolean false))) )

(define graph2Xs (gname mapname)
  (let ((graph (fetch gname))
        (xlist (object ("java.util.ArrayList"))) )
  (if (isobject graph)(apply graph2Xnames graph mapname xlist) xlist)  ))

(define graph2Xnames (graph mapname xlist)
  (let ((kbname (getAttr graph "kbname"))
        (jkb (getAttr (fetch kbname) "jkb"))
        (occmap (lookup jkb "occmap"))
        (b2x0 (getAttr jkb mapname))
        (b2x (if (isobject b2x0) 
                 b2x0
                 (seq (apply initNameMaps jkb) (getAttr jkb mapname))) )
        (nodes (invoke graph "getNodesInArray"))
        (bplist (object ("java.util.ArrayList")))
        (mfun (lambda (bprot xlist) 
                (let ((x (invoke b2x "get" bprot)))
                  (if (isobject x) (apply setAdd xlist x) ))))
       )
   (seq
     (for nd nodes  
      (if (= (getAttr nd "type") "occ")
        (let ((clab (getAttr nd "chattylabel"))   
              (occ (invoke occmap "get" clab))
;; (dummy (seq (invoke java.lang.System.err "println" (concat "clab: " clab)) "x"))   
           )
         (apply occ2bprots occ bplist)
         (apply map bplist mfun xlist) 
        )
      ))
   xlist
) ))

;; add bprots in occ to bplist
(define occ2bprots (occ bplist)
  (if (instanceof occ "bp2pl.SimpleOccurrence")
      (apply eref2bprots bplist (lookup occ "eref")) 
      (if (instanceof occ "bp2pl.ComplexOccurrence")
          (for occ0 (lookup occ "components")
             (apply eref2bprots bplist (lookup occ0 "eref")))
          ;; do nothing
       )) ) ;; if if

;; add bprots (names of srefs) in eref to bplist
(define eref2bprots (bplist eref)
 (seq
;;  (invoke java.lang.System.err "println" (concat "eref: " (lookup eref "name")))
 (if (instanceof eref "bp2pl.CompositeReference")
    (for eref0 (lookup eref "subunits") (apply eref2bprots bplist eref0))
 (if (instanceof eref "bp2pl.GenericReference")
    (for eref0 (lookup eref "members") (apply eref2bprots bplist eref0))
 (if (instanceof eref "bp2pl.SimpleReference")
     (let ((name (lookup eref "name")))
       (if (not (invoke bplist "contains" name)) (invoke bplist "add" name)
      ))
  ;; do nothing
  ))) ;; ifs
))

(define initNameMaps (jkb)
  (let ((erefmap (lookup jkb "erefmap"))
        (erefs (invoke erefmap "values"))
        (bp2hugo (object ("java.util.HashMap")))
        (bp2uniprot (object ("java.util.HashMap")))
        (uniprot2hugo (object ("java.util.HashMap")))
        (hugo2uniprot (object ("java.util.HashMap")))
        (ci (getAttr jkb "componentInfoSpec"))
        (componentInfoSpec 
          (if (instanceof ci "java.util.Map") ci (object ("java.util.HashMap"))))
        (protspec (invoke componentInfoSpec "get" "Protein"))
        (upspec (if (instanceof protspec "java.util.Map")
                 (invoke protspec "get" "UniProt")
                 (object null) ))
        (uptag (if (instanceof upspec "java.util.Map")
                 (invoke upspec "get" "mdtag")
                 (object null) ))        
        (hugospec (if (instanceof protspec "java.util.Map")
                 (invoke protspec "get" "HUGO")
                 (object null) ))
        (hugotag (if (instanceof hugospec "java.util.Map")
                 (invoke hugospec "get" "mdtag")
                 (object null) ))        
       )
   (setAttr jkb "bprot2hugo" bp2hugo)
   (setAttr jkb "bprot2uniprot" bp2uniprot)
   (setAttr jkb "hugo2uniprot" hugo2uniprot)
   (setAttr jkb "uniprot2hugo" uniprot2hugo)
   (if (or (isnull uptag) (isnull hugotag)) 
       (boolean false)
     (for eref erefs 
      (if (instanceof eref "bp2pl.SimpleReference")
       (let ((bprot (lookup eref "name"))
             (md (getAttr eref "metadata"))
             (uid (if (instanceof md "java.util.Map") (invoke md "get" uptag)
                      (object null)))
             (hid (if (instanceof md "java.util.Map") (invoke md "get" hugotag)
                      (object null)))
             )
          (seq
            (if (isobject uid) (invoke bp2uniprot "put" bprot uid))
            (if (isobject hid) (invoke bp2hugo "put" bprot hid))
            (if (and (isobject uid) (isobject hid))
              (seq (invoke uniprot2hugo "put" uid hid)
                   (invoke hugo2uniprot "put" hid uid)) )
         
           ))
         ;; do nothing
        )))
     ))


;;;;;;;;;;;;;;;;;;;;   import for painting ;;;;;;;;;;;;;;;;;;;;;
;; returns arrl of arrays (line splits)
(define loadData (filename sep)
  (let ((res (object ("java.util.ArrayList")))
        (fun (lambda (line) (invoke line "split" sep)))
        )
     (sinvoke g2d.util.IO "file2Collection" res filename fun (boolean true))
    res
))


(define paintGName (gname filter cfun)
  (let ((graph (fetch gname)))
   (if (isobject graph) (apply paintGraph graph filter cfun) (object null))
  ))

(define paintGraph (graph filter cFun)
  (let ((panel (sinvoke "g2d.pla.PLAUtils" "getPLAPanel" graph))
        (nodes (invoke graph "getNodesInArray")))
     (for node nodes 
        (let ((res (apply filter node)))
          (if (isobject res) (invoke node "setFillColor" (apply cFun res))) ))
     (invoke panel "repaint") 
))

(define paintUniprot (gname fname sep)
  (let ((graph (fetch gname))
        (kbname (if (isobject graph) (getAttr graph "kbname") (object null)))
        (jkb (getAttr (fetch kbname) "jkb"))
        (occmap (lookup jkb "occmap"))
        (xmap (getAttr jkb "uniprot2bprot"))
        (uidlist (object ("java.util.ArrayList")))
       )
     (sinvoke "g2d.util.IO" "file2Collection" uidlist fname 
              (object null) (boolean true))
      (apply paintGraph gname 
              (lambda (node) (apply nodeHas occmap xmap uidlist node))
              (lambda (res) java.awt.Color.red) )
    ))


(define nodeHas (occmap xmap names nd)
  (if (= (getAttr nd "type") "occ")
    (let ((clab (getAttr nd "chattylabel"))   
          (occ (invoke occmap "get" clab))
          (bplist (object ("java.util.ArrayList")))
          (xbplist (object ("java.util.ArrayList")))
         )
     (apply occ2bprots occ bplist)
    ;; intersect names xmap(bplist)
     (apply mapTest names 
        (lambda (name) (invoke names "contains" (invoke xmap "get" name))))
)))

(define mapTest (col test) (apply mapTestX (invoke col "iterator") test))

(define mapTestX (iter test)
 (if (invoke iter "hasNext")
   (if (apply test (invoke iter "next")) 
     (boolean true)
     (apply mapTestX iter test))
   (boolean false)
))





