
;; returns an arraylist of uniprot names
(define exportGlycanIds (kbname fname)
  (let ((gidlist (apply kb2gids kbname)))
     (sinvoke "g2d.util.IO" "collection2File" gidlist fname (object null) (boolean false))) )

(define kb2gids (kbname)
  (let ((jkb (getAttr (fetch kbname) "jkb"))
        (glist (object ("java.util.ArrayList"))) 
        (erefmap  (if (isobject jkb) (lookup jkb "erefmap") (object null) ))
        (erefs (if (isobject erefmap) 
               (invoke erefmap "values") (object ("java.util.ArrayList")) ))
        )
   (for eref erefs
     (if (= (lookup eref "sort")  bp2pl.EntityReference.GLYCAN)
       (let ((md (getAttr eref "metadata"))
             (gid (apply getGlycanId md)) )
          (if (isobject gid) (invoke glist "add" gid))
          )
    ))
  glist
))

(define getGlycanId (md)
  (let ((kegg (if (instanceof md "java.util.HashMap")
                  (invoke md "get" "KeggID") (object null))) )
    (if (instanceof kegg "java.lang.String") kegg
      (if (instanceof kegg "java.util.ArrayList")
         (apply findGId kegg (invoke kegg "size") (int 0))
         (object null)
      )) ))

(define findGId (arrl len cur)
 (if (>= cur len)
   (object null)  
   (let ((id (invoke arrl "get" cur)))
     (if (invoke id "startsWith" "G")
         id
         (apply findGId arrl len (+ cur (int 1)))
    ))))

(define glycanIdCheck (kbname)
  (let ((jkb (getAttr (fetch kbname) "jkb"))
        (glist (object ("java.util.ArrayList"))) 
        (erefmap  (if (isobject jkb) (lookup jkb "erefmap") (object null) ))
        (erefs (if (isobject erefmap) 
               (invoke erefmap "values") (object ("java.util.ArrayList")) ))
        )
   (for eref erefs
     (if (= (lookup eref "sort")  bp2pl.EntityReference.GLYCAN)
       (let ((md (getAttr eref "metadata"))
             (gid (apply getGlycanId md))
             (name (lookup eref "name"))  )
         (if (apply GnameBad name gid) (invoke glist "add" name) )
        )
   ))
  glist
))

(define GnameBad (name gid)
 (not (invoke gid "endsWith" (invoke name "substring" (int 1))) )
)

/*
Does ;; no longer work?
;; Line 35, 11 characters in: no viable alternative at input '(objectnul'
;; the actual text was (object nul)	
badG [Dermatan, Chondroitin, G3532, G38]
*/