;; Dot output type codes
; int DOT   = 0;
; int PNG   = 1;
; int JPG   = 2;
; int GIF   = 3;
; int PS    = 4;
; int PS2   = 5;
; int EPS   = 6;
; int XDOT  = 7;
; int SVG   = 8;
; int SVGZ  = 9;

;; default to xdot if not supported
(define xType2DotCode (xtype)
 (if (invoke xtype "equalsIgnoreCase" "SVG") g2d.graph.Dot.SVG
 (if (invoke xtype "equalsIgnoreCase" "PNG") g2d.graph.Dot.PNG
 (if (invoke xtype "equalsIgnoreCase" "EPS") g2d.graph.Dot.EPS
 (if (invoke xtype "equalsIgnoreCase" "GIF") g2d.graph.Dot.GIF
 (if (invoke xtype "equalsIgnoreCase" "JPG") g2d.graph.Dot.JPG
      g2d.graph.Dot.XDOT ))))))

(define exportGraphAs (gname xtype fname)
  (let ((graph (fetch gname))
        (dtype (apply xType2DotCode xtype))
        (question (invoke graph "makeDotInput"))
       )
   (if (= dtype g2d.graph.Dot.DEFAULT_DOT_FORMAT)
       (sinvoke "g2d.util.IO" "string2File" question fname)
       (let ((answer (sinvoke "g2d.graph.Dot" "askDot" dtype question)))
           (sinvoke "g2d.util.IO" "string2File" answer fname)
        ))) )

;;;  String question = graph.makeDotInput();
;;;  if(type != Dot.DEFAULT_DOT_FORMAT){
;;;      //its a non-dot format; better get dot to produce it.
;;;      String answer = Dot.askDot(type, question);
;;;      IO.string2File(answer,f);
;;;  } else {
;;;      //just output pure pre-layout dot
;;;      IO.string2File(question,f);
;;;  }

;; 
(define galleryExport (gname description gdir glab)
  (let ((graph (fetch gname)))
    (seq 
      (apply exportGraphAs gname "SVG" (concat gdir "/" glab ".svg"))
      (apply exportJSONgraph gname description gdir glab)
)))
