/*
 * Decompiled with CFR 0.152.
 */
package rmp;

import java.util.ArrayList;
import rmp.BitmaskHelper;
import rmp.Transition;
import rmp.TransitionList;

public class Path
implements Cloneable {
    private int length;
    private int[] transitions;
    private ArrayList<Tuple> cardinalities;

    private Path() {
    }

    public Path(int n) {
        this.transitions = BitmaskHelper.makeBitmask(new int[0], n);
        this.cardinalities = new ArrayList();
    }

    public boolean equals(Path path) {
        boolean bl = BitmaskHelper.EQUALS(path.transitions, this.transitions);
        if (!bl) {
            return false;
        }
        for (Tuple tuple : this.cardinalities) {
            for (Tuple tuple2 : path.cardinalities) {
                if (tuple.transID != tuple2.transID || tuple.card == tuple2.card) continue;
                return false;
            }
        }
        return true;
    }

    public Path(int[] nArray, ArrayList<Tuple> arrayList) {
        this.transitions = nArray;
        this.cardinalities = arrayList;
    }

    public int[] getTransitions() {
        return this.transitions;
    }

    public ArrayList<Tuple> getCardinalities() {
        return this.cardinalities;
    }

    public Object clone() {
        Path path = new Path();
        path.transitions = new int[this.transitions.length];
        for (int i = 0; i < path.transitions.length; ++i) {
            path.transitions[i] = this.transitions[i];
        }
        path.cardinalities = new ArrayList();
        for (Tuple tuple : this.cardinalities) {
            Tuple tuple2 = new Tuple();
            tuple2.card = tuple.card;
            tuple2.transID = tuple.transID;
            path.cardinalities.add(tuple2);
        }
        path.length = this.length;
        return path;
    }

    public void addTransition(int n, int n2) {
        int[] nArray = BitmaskHelper.makeBitmask(new int[]{n}, n2);
        boolean bl = BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, this.transitions), nArray);
        if (bl) {
            boolean bl2 = false;
            for (Tuple tuple : this.cardinalities) {
                if (tuple.transID != n) continue;
                ++tuple.card;
                bl2 = true;
                break;
            }
            if (!bl2) {
                Tuple tuple = new Tuple();
                tuple.transID = n;
                tuple.card = 2;
                this.cardinalities.add(tuple);
            }
        } else {
            this.transitions = BitmaskHelper.OR(nArray, this.transitions);
        }
        ++this.length;
    }

    public int length() {
        return this.length;
    }

    public boolean isSuperset(Path path) {
        boolean bl = BitmaskHelper.EQUALS(BitmaskHelper.AND(path.transitions, this.transitions), this.transitions);
        if (!bl) {
            return false;
        }
        for (Tuple tuple : this.cardinalities) {
            boolean bl2 = false;
            for (Tuple tuple2 : path.cardinalities) {
                if (tuple2.transID != tuple.transID) continue;
                if (tuple.card > tuple2.card) {
                    System.err.println(tuple.transID);
                    System.err.println(tuple.card);
                    System.err.println(tuple2.transID);
                    System.err.println(tuple2.card + "\n");
                    return false;
                }
                bl2 = true;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public String toString(TransitionList transitionList) {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < transitionList.size(); ++i) {
            int[] nArray = BitmaskHelper.makeBitmask(new int[]{i}, transitionList.size());
            if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, this.transitions), nArray)) continue;
            String string2 = "";
            for (Tuple tuple : this.cardinalities) {
                if (tuple.transID != i) continue;
                string2 = tuple.card + "*";
            }
            string = string + (bl ? "" : ", ") + string2 + ((Transition)transitionList.get(i)).getName();
            bl = false;
        }
        return string;
    }

    public ArrayList<String> getTransitionNames(TransitionList transitionList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < transitionList.size(); ++i) {
            int[] nArray = BitmaskHelper.makeBitmask(new int[]{i}, transitionList.size());
            if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, this.transitions), nArray)) continue;
            arrayList.add(((Transition)transitionList.get(i)).getName());
        }
        return arrayList;
    }

    public ArrayList<Transition> getTransitions(TransitionList transitionList) {
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        for (int i = 0; i < transitionList.size(); ++i) {
            int[] nArray = BitmaskHelper.makeBitmask(new int[]{i}, transitionList.size());
            if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, this.transitions), nArray)) continue;
            arrayList.add((Transition)transitionList.get(i));
        }
        return arrayList;
    }

    class Tuple {
        public int transID;
        public int card;

        Tuple() {
        }

        public String toString() {
            return "(" + this.transID + "," + this.card + ")";
        }
    }
}

