/*
 * Decompiled with CFR 0.152.
 */
package rmp;

import rmp.BitmaskHelper;
import rmp.Model;
import rmp.State;
import rmp.Transition;
import rmp.TransitionList;

public class ComputeStubbornSetAlternative {
    public static int countEnabledTransitions(Model model, State state, boolean[] blArray) {
        TransitionList transitionList = model.getTransitions();
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i] || !((Transition)transitionList.get(i)).isEnabled(state)) continue;
            ++n;
        }
        return n;
    }

    public static boolean[] computeSmallestStubbornSet(Model model, State state) {
        TransitionList transitionList = model.getTransitions();
        int n = -1;
        boolean[] blArray = null;
        for (int i = 0; i < transitionList.size(); ++i) {
            if (!((Transition)transitionList.get(i)).isEnabled(state)) continue;
            boolean[] blArray2 = ComputeStubbornSetAlternative.computeStubbornSet(model, state, i);
            int n2 = ComputeStubbornSetAlternative.countEnabledTransitions(model, state, blArray2);
            if (n2 == 1) {
                return blArray2;
            }
            if (n != -1 && n2 >= n) continue;
            blArray = blArray2;
            n = n2;
        }
        return blArray;
    }

    public static boolean[] computeStubbornSet(Model model, State state, int n) {
        boolean[] blArray = new boolean[model.getTransitions().size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        try {
            ComputeStubbornSetAlternative.computeStubbornSet(model, state, blArray, n);
        }
        catch (Exception exception) {
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = true;
            }
        }
        return blArray;
    }

    public static void computeStubbornSet(Model model, State state, boolean[] blArray, int n) throws Exception {
        block6: {
            TransitionList transitionList = model.getTransitions();
            if (blArray[n]) break block6;
            blArray[n] = true;
            if (((Transition)transitionList.get(n)).isEnabled(state)) {
                int[] nArray = ((Transition)transitionList.get(n)).getReadMask();
                int[] nArray2 = ((Transition)transitionList.get(n)).getPreMask();
                int[] nArray3 = BitmaskHelper.OR(nArray, nArray2);
                int[] nArray4 = ((Transition)transitionList.get(n)).getPostMask();
                int[] nArray5 = BitmaskHelper.OR(nArray, nArray4);
                for (int i = 0; i < model.getSpeciesList().size(); ++i) {
                    int[] nArray6 = BitmaskHelper.makeBitmask(new int[]{i}, model.getSpeciesList().size());
                    if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray6, nArray3), nArray6)) continue;
                    for (int j = 0; j < model.getTransitions().size(); ++j) {
                        if (j == n) continue;
                        int[] nArray7 = ((Transition)transitionList.get(j)).getReadMask();
                        int[] nArray8 = ((Transition)transitionList.get(j)).getPreMask();
                        int[] nArray9 = BitmaskHelper.OR(nArray7, nArray8);
                        int[] nArray10 = ((Transition)transitionList.get(j)).getPostMask();
                        int[] nArray11 = BitmaskHelper.OR(nArray7, nArray10);
                        if (BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray6, nArray11), nArray6) && BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray6, nArray5), nArray6) || !BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray6, nArray9), nArray6)) continue;
                        ComputeStubbornSetAlternative.computeStubbornSet(model, state, blArray, j);
                    }
                }
            } else {
                int n2 = ((Transition)transitionList.get(n)).getViolatingPreplace(model, state);
                if (n2 == -1) {
                    throw new Exception();
                }
                TransitionList transitionList2 = model.getProperPretransitions(n2);
                for (int i = 0; i < transitionList2.size(); ++i) {
                    int n3 = model.getTransitions().indexOf(transitionList2.get(i));
                    ComputeStubbornSetAlternative.computeStubbornSet(model, state, blArray, n3);
                }
            }
        }
    }

    public static boolean[] computeStubbornSet(Model model, State state) {
        TransitionList transitionList = model.getTransitions();
        for (int i = 0; i < transitionList.size(); ++i) {
            if (!((Transition)transitionList.get(i)).isEnabled(state)) continue;
            return ComputeStubbornSetAlternative.computeStubbornSet(model, state, i);
        }
        return null;
    }
}

