/*
 * Decompiled with CFR 0.152.
 */
package rmp;

import rmp.BitmaskHelper;
import rmp.ExtendedHashSet;
import rmp.Model;
import rmp.Path;
import rmp.PathList;
import rmp.Queue;
import rmp.State;
import rmp.Transition;
import rmp.TransitionList;

public class ComputeMinimalPaths {
    public static PathList compute(Model model, boolean bl) {
        return ComputeMinimalPaths.compute(model, null, bl);
    }

    public static PathList compute(Model model, int[] nArray, boolean bl) {
        int[] nArray2 = model.getGoalMask();
        State state = model.getInitialState();
        TransitionList transitionList = model.getTransitions();
        Queue<StateTuple> queue = new Queue<StateTuple>();
        PathList pathList = new PathList();
        ExtendedHashSet<StateTuple> extendedHashSet = new ExtendedHashSet<StateTuple>();
        queue.enqueue(new StateTuple(state, new Path(transitionList.size())));
        extendedHashSet.add(new StateTuple(state, new Path(transitionList.size())));
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        while (queue.size() > 0) {
            StateTuple stateTuple = (StateTuple)queue.dequeue();
            if (++n2 >= n * 10000) {
                ++n;
                if (bl) {
                    System.err.println("Depth:  " + n3 + "\tnumProcessed:  " + n2 + "   Queue: " + queue.size());
                }
            }
            if (n3 < stateTuple.path.length()) {
                n3 = stateTuple.path.length();
                if (bl) {
                    System.err.println("Depth:  " + n3 + "\tnumProcessed:  " + n2 + "   Queue: " + queue.size());
                }
            }
            if (BitmaskHelper.EQUALS(BitmaskHelper.AND(stateTuple.state.getVars(), nArray2), nArray2)) {
                if (pathList.isSuperset(stateTuple.path)) continue;
                pathList.addPath(stateTuple.path);
                continue;
            }
            for (int i = 0; i < transitionList.size(); ++i) {
                State state2;
                int[] nArray3 = BitmaskHelper.makeBitmask(new int[]{i}, transitionList.size());
                if (nArray != null && !BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray3, nArray), nArray3) || (state2 = ((Transition)transitionList.get(i)).applyTransition(stateTuple.state)) == null) continue;
                Path path = (Path)stateTuple.path.clone();
                path.addTransition(i, transitionList.size());
                StateTuple stateTuple2 = new StateTuple(state2, path);
                if (extendedHashSet.contains(stateTuple2) || pathList.isSuperset(path)) continue;
                queue.enqueue(stateTuple2);
                extendedHashSet.add(stateTuple2);
            }
        }
        if (bl) {
            System.err.println("Total number of (state,path) tuples:  " + extendedHashSet.size());
        }
        if (bl) {
            System.err.println("Number of accepted paths:  " + pathList.size());
        }
        return pathList;
    }

    static class StateTuple {
        State state;
        Path path;

        public StateTuple(State state, Path path) {
            this.state = state;
            this.path = path;
        }

        public int hashCode() {
            return this.state.hashCode();
        }

        public boolean equals(Object object) {
            return ((StateTuple)object).path.isSuperset(this.path) && this.state.equals(((StateTuple)object).state);
        }
    }
}

