/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.pf.util.DateUtil;

public class SimpleDate
implements Serializable,
Comparable,
Cloneable {
    private static final long serialVersionUID = 90001L;
    protected static final SimpleDateFormat SORT_FORMAT = new SimpleDateFormat("yyyyMMdd");
    protected static final SimpleDateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    protected static final SimpleDateFormat GERMAN_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    protected static final SimpleDateFormat BRITISH_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    protected static final SimpleDateFormat US_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    private Calendar calendar = new GregorianCalendar();

    protected Calendar getCalendar() {
        return this.calendar;
    }

    protected void setCalendar(Calendar newValue) {
        this.calendar = newValue;
    }

    public static SimpleDate parseSortDate(String dateString) throws ParseException {
        Date date = SORT_FORMAT.parse(dateString);
        return new SimpleDate(date);
    }

    public static SimpleDate parseGermanDate(String dateString) throws ParseException {
        Date date = GERMAN_FORMAT.parse(dateString);
        return new SimpleDate(date);
    }

    public static SimpleDate parseBritishDate(String dateString) throws ParseException {
        Date date = BRITISH_FORMAT.parse(dateString);
        return new SimpleDate(date);
    }

    public static SimpleDate parseUSDate(String dateString) throws ParseException {
        Date date = US_FORMAT.parse(dateString);
        return new SimpleDate(date);
    }

    public static SimpleDate parseISO8601Date(String dateString) throws ParseException {
        Date date = ISO8601_FORMAT.parse(dateString);
        return new SimpleDate(date);
    }

    public SimpleDate() {
        this(new Date());
    }

    public SimpleDate(GregorianCalendar gregorianCalendar) {
        this.setCalendar(gregorianCalendar);
    }

    public SimpleDate(Date date) {
        this.setInternalDate(date);
    }

    public SimpleDate(int year, int month, int day) {
        this(DateUtil.current().newDate(year, month, day));
    }

    public int getYear() {
        return this.getCalendar().get(1);
    }

    public int getMonth() {
        return this.getCalendar().get(2) + 1;
    }

    public int getDay() {
        return this.getCalendar().get(5);
    }

    public String asSortString() {
        return SORT_FORMAT.format(this.getInternalDate());
    }

    public String asISO8601String() {
        return ISO8601_FORMAT.format(this.getInternalDate());
    }

    public String asGermanString() {
        return GERMAN_FORMAT.format(this.getInternalDate());
    }

    public String asBritishString() {
        return BRITISH_FORMAT.format(this.getInternalDate());
    }

    public String asUSString() {
        return US_FORMAT.format(this.getInternalDate());
    }

    public Date asDate() {
        return this.getInternalDate();
    }

    public String toString() {
        return this.asISO8601String();
    }

    public boolean equals(Object object) {
        if (object instanceof SimpleDate) {
            SimpleDate simpleDate = (SimpleDate)object;
            return this.compareTo(simpleDate) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.asSortString().hashCode();
    }

    public int compareTo(Object object) {
        if (object instanceof SimpleDate) {
            SimpleDate simpleDate = (SimpleDate)object;
            return this.asSortString().compareTo(simpleDate.asSortString());
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleDate clone = new SimpleDate();
        clone.setCalendar((Calendar)this.getCalendar().clone());
        return clone;
    }

    protected Date getInternalDate() {
        return this.getCalendar().getTime();
    }

    protected void setInternalDate(Date date) {
        this.getCalendar().setTime(date);
    }
}

