/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.pf.bif.filter.IObjectFilter;
import org.pf.util.AssociationList;
import org.pf.util.CollectionEnumeration;
import org.pf.util.EmptyList;
import org.pf.util.EmptyMap;
import org.pf.util.EmptySet;
import org.pf.util.EnumerationIterator;
import org.pf.util.ObjectArrayIterator;
import org.pf.util.ObjectCollectionFilter;

public class CollectionUtil {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static CollectionUtil singleton = new CollectionUtil();

    public static CollectionUtil current() {
        return singleton;
    }

    protected CollectionUtil() {
    }

    public Properties propertiesStartingWith(Properties source, String prefix) {
        return this.propertiesStartingWith(source, prefix, true);
    }

    public Properties propertiesStartingWith(Properties source, String prefix, boolean cutPrefix) {
        Properties result = new Properties();
        this.copyPropertiesStartingWith(source, result, prefix, cutPrefix);
        return result;
    }

    public void copyPropertiesStartingWith(Properties source, Properties destination, String prefix, boolean cutPrefix) {
        Enumeration<Object> keys = null;
        String key = null;
        String value = null;
        int indexAfterPrefix = 0;
        if (source == null || destination == null || prefix == null) {
            return;
        }
        keys = source.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            value = source.getProperty(key);
            if (cutPrefix) {
                if (key.length() <= prefix.length()) continue;
                indexAfterPrefix = prefix.length();
                if (indexAfterPrefix > 0 && !prefix.endsWith(".") && key.charAt(indexAfterPrefix) == '.') {
                    ++indexAfterPrefix;
                }
                key = key.substring(indexAfterPrefix);
            }
            destination.setProperty(key, value);
        }
    }

    public Object[] copy(Object[] objects) {
        if (objects == null) {
            return null;
        }
        int size = objects.length;
        Object[] copy = (Object[])Array.newInstance(objects.getClass().getComponentType(), size);
        System.arraycopy(objects, 0, copy, 0, size);
        return copy;
    }

    public Object[] copy(Object[] objects, IObjectFilter filter) {
        return this.copy(objects, filter, false);
    }

    public Collection copy(Collection objects, IObjectFilter filter) {
        return this.copyCollection(objects, filter, false);
    }

    public Map copy(Map map, IObjectFilter filter) {
        return this.copyMap(map, filter, false);
    }

    public Object[] reverseCopy(Object[] array) {
        Object[] copy = this.copy(array);
        this.reverse(copy);
        return copy;
    }

    public void reverse(Object[] array) {
        if (array != null) {
            int i = 0;
            int j = array.length - 1;
            while (i < j) {
                Object temp = array[i];
                array[i] = array[j];
                array[j] = temp;
                ++i;
                --j;
            }
        }
    }

    public void addAll(Collection collection, Object[] objects) {
        this.addAll(collection, objects, false);
    }

    public void addAllNew(Collection collection, Object[] objects) {
        this.addAll(collection, objects, true);
    }

    public Object[] append(Object[] objects, Object object) {
        Class<?> componentType = object == null ? objects.getClass().getComponentType() : object.getClass();
        Object[] appObj = (Object[])Array.newInstance(componentType, 1);
        appObj[0] = object;
        return this.append(objects, appObj);
    }

    public Object[] append(Object[] objects, Object[] appendObjects) {
        if (objects == null) {
            return appendObjects;
        }
        if (appendObjects == null) {
            return objects;
        }
        Class<?> componentType = objects.getClass().getComponentType();
        Object[] newObjects = (Object[])Array.newInstance(componentType, objects.length + appendObjects.length);
        System.arraycopy(objects, 0, newObjects, 0, objects.length);
        System.arraycopy(appendObjects, 0, newObjects, objects.length, appendObjects.length);
        return newObjects;
    }

    public int[] append(int[] values, int[] appendValues) {
        int[] newValues = null;
        if (values == null) {
            values = EMPTY_INT_ARRAY;
        }
        if (appendValues == null) {
            appendValues = EMPTY_INT_ARRAY;
        }
        newValues = new int[values.length + appendValues.length];
        System.arraycopy(values, 0, newValues, 0, values.length);
        System.arraycopy(appendValues, 0, newValues, values.length, appendValues.length);
        return newValues;
    }

    public long[] append(long[] values, long[] appendValues) {
        long[] newValues = null;
        if (values == null) {
            values = EMPTY_LONG_ARRAY;
        }
        if (appendValues == null) {
            appendValues = EMPTY_LONG_ARRAY;
        }
        newValues = new long[values.length + appendValues.length];
        System.arraycopy(values, 0, newValues, 0, values.length);
        System.arraycopy(appendValues, 0, newValues, values.length, appendValues.length);
        return newValues;
    }

    public int indexOfIdentical(Object[] objArray, Object searchObj) {
        return this.indexOfObject(objArray, searchObj, true);
    }

    public int indexOf(Object[] objArray, Object searchObj) {
        return this.indexOfObject(objArray, searchObj, false);
    }

    public int indexOf(Object[] objArray, IObjectFilter filter) {
        if (this.isNullOrEmpty(objArray)) {
            return -1;
        }
        if (filter == null) {
            return -1;
        }
        int i = 0;
        while (i < objArray.length) {
            if (filter.matches(objArray[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object[] objArray, IObjectFilter filter) {
        if (this.isNullOrEmpty(objArray)) {
            return -1;
        }
        if (filter == null) {
            return -1;
        }
        int i = objArray.length - 1;
        while (i >= 0) {
            if (filter.matches(objArray[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int indexOf(List list, IObjectFilter filter) {
        if (this.isNullOrEmpty(list)) {
            return -1;
        }
        if (filter == null) {
            return -1;
        }
        int i = 0;
        while (i < list.size()) {
            if (filter.matches(list.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(List list, IObjectFilter filter) {
        if (this.isNullOrEmpty(list)) {
            return -1;
        }
        if (filter == null) {
            return -1;
        }
        int i = list.size() - 1;
        while (i >= 0) {
            if (filter.matches(list.get(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public boolean containsIdentical(Object[] objArray, Object searchObj) {
        return this.indexOfIdentical(objArray, searchObj) >= 0;
    }

    public boolean contains(Object[] objArray, Object searchObj) {
        return this.indexOf(objArray, searchObj) >= 0;
    }

    public boolean contains(int[] valueArray, int value) {
        if (valueArray != null) {
            int i = 0;
            while (i < valueArray.length) {
                if (valueArray[i] == value) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean contains(long[] valueArray, long value) {
        if (valueArray != null) {
            int i = 0;
            while (i < valueArray.length) {
                if (valueArray[i] == value) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object[] copyWithoutIdentical(Object[] objArray, Object[] skipArray) {
        ObjectCollectionFilter filter = new ObjectCollectionFilter(skipArray, true);
        return this.copyWithout(objArray, (IObjectFilter)filter);
    }

    public Object[] copyWithout(Object[] objArray, Object[] skipArray) {
        ObjectCollectionFilter filter = new ObjectCollectionFilter(skipArray, false);
        return this.copyWithout(objArray, (IObjectFilter)filter);
    }

    public Object[] copyWithout(Object[] objArray, IObjectFilter filter) {
        return this.copy(objArray, filter, true);
    }

    public Collection copyWithout(Collection objects, IObjectFilter filter) {
        return this.copyCollection(objects, filter, true);
    }

    public Map copyWithout(Map map, IObjectFilter filter) {
        return this.copyMap(map, filter, true);
    }

    public Iterator iterator(Object[] objects) {
        return new ObjectArrayIterator(objects);
    }

    public Object[] removeNull(Object[] array) {
        if (array == null) {
            return array;
        }
        return this.removeFromArray(array, null);
    }

    public Object[] toArray(Collection objects, Class elementType) {
        if (objects == null || elementType == null) {
            return null;
        }
        Object[] resultArray = (Object[])Array.newInstance(elementType, objects.size());
        objects.toArray(resultArray);
        return resultArray;
    }

    public Object[] toArray(Collection objects) {
        if (this.isNullOrEmpty(objects)) {
            return null;
        }
        return this.toArray(objects, objects.iterator().next().getClass());
    }

    public List toList(Object[] objects) {
        if (objects == null) {
            return null;
        }
        ArrayList list = new ArrayList(objects.length);
        this.addAll(list, objects);
        return list;
    }

    public boolean isNullOrEmpty(Collection collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public boolean isNullOrEmpty(Object[] array) {
        if (array == null) {
            return true;
        }
        return array.length == 0;
    }

    public boolean isNullOrEmpty(Map map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public boolean isNullOrEmpty(AssociationList associationList) {
        if (associationList == null) {
            return true;
        }
        return associationList.isEmpty();
    }

    public Iterator asIterator(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        return new EnumerationIterator(enumeration);
    }

    public List asList(Enumeration enumeration) {
        ArrayList list = new ArrayList();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (object == null) continue;
                list.add(object);
            }
        }
        return list;
    }

    public Enumeration asEnumeration(Collection collection) {
        return new CollectionEnumeration(collection);
    }

    public Enumeration asEnumeration(Object[] objects) {
        List list = this.toList(objects);
        return this.asEnumeration(list);
    }

    protected void addAll(Collection collection, Object[] objects, boolean justNew) {
        if (collection == null || objects == null) {
            return;
        }
        int i = 0;
        while (i < objects.length) {
            if (objects[i] != null) {
                if (justNew) {
                    if (!collection.contains(objects[i])) {
                        collection.add(objects[i]);
                    }
                } else {
                    collection.add(objects[i]);
                }
            }
            ++i;
        }
    }

    protected int indexOfObject(Object[] objArray, Object searchObj, boolean identical) {
        if (objArray == null || objArray.length == 0) {
            return -1;
        }
        boolean found = false;
        int i = 0;
        while (i < objArray.length) {
            if (objArray[i] == null) {
                if (searchObj == null) {
                    found = true;
                }
            } else {
                found = identical ? objArray[i] == searchObj : objArray[i].equals(searchObj);
            }
            if (found) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Object[] removeFromArray(Object[] array, Object[] removeObjects) {
        Object[] result;
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        int i = 0;
        while (i < array.length) {
            boolean remains;
            if (removeObjects == null) {
                remains = array[i] != null;
            } else {
                boolean bl = remains = !this.contains(removeObjects, array[i]);
            }
            if (remains) {
                list.add(array[i]);
            }
            ++i;
        }
        try {
            result = (Object[])Array.newInstance(array.getClass().getComponentType(), list.size());
        }
        catch (NegativeArraySizeException e) {
            result = new Object[]{};
        }
        list.toArray(result);
        return result;
    }

    protected Object[] copy(Object[] objArray, IObjectFilter filter, boolean without) {
        if (objArray == null) {
            return null;
        }
        if (filter == null) {
            if (without) {
                return this.copy(objArray);
            }
            return (Object[])Array.newInstance(objArray.getClass().getComponentType(), 0);
        }
        ArrayList<Object> result = new ArrayList<Object>(objArray.length);
        int i = 0;
        while (i < objArray.length) {
            if (filter.matches(objArray[i])) {
                if (!without) {
                    result.add(objArray[i]);
                }
            } else if (without) {
                result.add(objArray[i]);
            }
            ++i;
        }
        return this.toArray(result, objArray.getClass().getComponentType());
    }

    protected Collection copyCollection(Collection objects, IObjectFilter filter, boolean without) {
        Collection result;
        if (objects == null) {
            return null;
        }
        try {
            result = (Collection)objects.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create new result collection.", e);
        }
        if (filter == null) {
            if (without) {
                result.addAll(objects);
            }
        } else {
            for (Object element : objects) {
                if (filter.matches(element)) {
                    if (without) continue;
                    result.add(element);
                    continue;
                }
                if (!without) continue;
                result.add(element);
            }
        }
        return result;
    }

    protected Map copyMap(Map map, IObjectFilter filter, boolean without) {
        Map result;
        if (map == null) {
            return null;
        }
        try {
            result = (Map)map.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create new result map.", e);
        }
        if (filter == null) {
            if (without) {
                result.putAll(map);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                if (filter.matches(entry)) {
                    if (without) continue;
                    result.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!without) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }
}

