/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import org.pf.bif.text.IMutableStringPair;
import org.pf.bif.text.IStringPair;

public class StringPair
implements IMutableStringPair {
    public static final StringPair[] EMPTY_ARRAY = new StringPair[0];
    public static final int NULL_HASHCODE = Void.TYPE.hashCode();
    private String string1 = null;
    private String string2 = null;

    public String getString1() {
        return this.string1;
    }

    public void setString1(String newValue) {
        this.string1 = newValue;
    }

    public String getString2() {
        return this.string2;
    }

    public void setString2(String newValue) {
        this.string2 = newValue;
    }

    public StringPair() {
    }

    public StringPair(String string) {
        this.setString1(string);
        this.setString2(string);
    }

    public StringPair(String s1, String s2) {
        this.setString1(s1);
        this.setString2(s2);
    }

    public StringPair(IStringPair pair) {
        this.setString1(pair.getString1());
        this.setString2(pair.getString2());
    }

    public StringPair(String[] strings) {
        if (strings == null || strings.length != 2) {
            throw new IllegalArgumentException("The given strings array does not exactly consist of 2 string elements!");
        }
        this.setString1(strings[0]);
        this.setString2(strings[1]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IStringPair) {
            IStringPair pair = (IStringPair)obj;
            return this.isEqual(this.getString1(), pair.getString1()) && this.isEqual(this.getString2(), pair.getString2());
        }
        return false;
    }

    public int hashCode() {
        int hash = NULL_HASHCODE;
        ++hash;
        if (this.getString1() != null) {
            hash ^= this.getString1().hashCode();
        }
        hash += 2;
        if (this.getString2() != null) {
            hash ^= this.getString2().hashCode();
        }
        return hash;
    }

    public String[] asArray() {
        String[] strings = new String[]{this.getString1(), this.getString2()};
        return strings;
    }

    public String asString(String separator) {
        int len = 0;
        String s1 = this.getString1();
        if (s1 == null) {
            s1 = "";
        } else {
            len += s1.length();
        }
        String s2 = this.getString2();
        if (s2 == null) {
            s2 = "";
        } else {
            len += s2.length();
        }
        if (separator == null) {
            separator = "";
        } else {
            len += separator.length();
        }
        StringBuffer buffer = new StringBuffer(len);
        buffer.append(s1);
        buffer.append(separator);
        buffer.append(s2);
        return buffer.toString();
    }

    public String toString() {
        return this.asString(this.getDefaultSeparator());
    }

    public String getDefaultSeparator() {
        return ":";
    }

    protected boolean isEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }
}

