/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import org.pf.text.StringScanner;

public class StringExaminer
extends StringScanner {
    private boolean ignoreCase = false;

    protected boolean ignoreCase() {
        return this.ignoreCase;
    }

    protected void ignoreCase(boolean newValue) {
        this.ignoreCase = newValue;
    }

    public StringExaminer(String stringToExamine) {
        this(stringToExamine, false);
    }

    public StringExaminer(String stringToExamine, boolean ignoreCase) {
        super(stringToExamine);
        this.ignoreCase(ignoreCase);
    }

    public boolean skipAfter(String matchString) {
        int index = 0;
        if (matchString == null || matchString.length() == 0) {
            return false;
        }
        index = this.findPositionOf(matchString);
        if (index < 0) {
            return false;
        }
        this.setPosition(index + matchString.length());
        return true;
    }

    public int findPositionOf(String matchString) {
        char ch = '-';
        char matchChar = ' ';
        int startPos = -1;
        int foundPos = -1;
        int index = 0;
        if (matchString == null) {
            return -1;
        }
        if (matchString.length() == 0) {
            return this.getPosition();
        }
        int savedPosition = this.getPosition();
        try {
            ch = this.nextChar();
            while (this.endNotReached(ch) && foundPos < 0) {
                matchChar = matchString.charAt(index);
                if (this.charsAreEqual(ch, matchChar)) {
                    if (startPos < 0) {
                        startPos = this.getPosition() - 1;
                    }
                    if (++index >= matchString.length()) {
                        foundPos = startPos;
                        continue;
                    }
                    ch = this.nextChar();
                    continue;
                }
                startPos = -1;
                if (index == 0) {
                    ch = this.nextChar();
                    continue;
                }
                index = 0;
            }
            int n = foundPos;
            return n;
        }
        finally {
            this.setPosition(savedPosition);
        }
    }

    public boolean skipBefore(String matchString) {
        boolean found = this.skipAfter(matchString);
        if (found) {
            this.skip(0 - matchString.length());
        }
        return found;
    }

    public String peekUpToEnd() {
        return this.upToEnd(true);
    }

    public String upToEnd() {
        return this.upToEnd(false);
    }

    public String peekUpToPosition(int pos) {
        StringBuffer strBuffer = new StringBuffer(this.length() - this.getPosition() + 1);
        this.appendUpToPosition(strBuffer, pos, true);
        return strBuffer.toString();
    }

    public String upToPosition(int pos) {
        StringBuffer strBuffer = new StringBuffer(this.length() - this.getPosition() + 1);
        this.appendUpToPosition(strBuffer, pos);
        return strBuffer.toString();
    }

    public void appendUpToPosition(StringBuffer strBuffer, int pos) {
        this.appendUpToPosition(strBuffer, pos, false);
    }

    protected boolean charsAreEqual(char char1, char char2) {
        return this.ignoreCase() ? Character.toUpperCase(char1) == Character.toUpperCase(char2) : char1 == char2;
    }

    protected String upToEnd(boolean peek) {
        char result = '-';
        int lastPosition = 0;
        StringBuffer tempBuffer = new StringBuffer(100);
        lastPosition = this.getPosition();
        try {
            result = this.nextChar();
            while (this.endNotReached(result)) {
                tempBuffer.append(result);
                result = this.nextChar();
            }
        }
        finally {
            if (peek) {
                this.setPosition(lastPosition);
            }
        }
        return tempBuffer.toString();
    }

    protected void appendUpToPosition(StringBuffer strBuffer, int pos, boolean peek) {
        if (pos <= this.getPosition()) {
            return;
        }
        int lastPosition = this.getPosition();
        try {
            do {
                char result = this.nextChar();
                strBuffer.append(result);
            } while (this.getPosition() < pos);
        }
        finally {
            if (peek) {
                this.setPosition(lastPosition);
            }
        }
    }
}

