/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pf.text.MatchElement;
import org.pf.text.MatchRuleException;
import org.pf.text.MatchRuleTypeConverter;
import org.pf.text.MatchRuleVisitor;
import org.pf.text.StringPattern;

public class MatchAttribute
extends MatchElement
implements Serializable {
    public static final int OPERATOR_EQUALS = 1;
    public static final int OPERATOR_GREATER = 2;
    public static final int OPERATOR_LESS = 3;
    public static final int OPERATOR_GREATER_OR_EQUAL = 4;
    public static final int OPERATOR_LESS_OR_EQUAL = 5;
    private static MatchRuleTypeConverter TYPE_CONVERTER = new MatchRuleTypeConverter();
    private int operator = 1;
    private String attributeName = null;
    private StringPattern[] patterns = null;
    private boolean ignoreCaseInName = false;
    private Object valueType = null;
    private Float[] floatValues = null;
    private Double[] doubleValues = null;
    private BigDecimal[] bigDecimalValues = null;
    private Integer[] integerValues = null;
    private Long[] longValues = null;
    private Date[] dateValues = null;

    protected int operator() {
        return this.operator;
    }

    protected void operator(int newValue) {
        this.operator = newValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String newValue) {
        this.attributeName = newValue;
    }

    public StringPattern[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(StringPattern[] newValue) {
        this.patterns = newValue;
    }

    public boolean ignoreCaseInName() {
        return this.ignoreCaseInName;
    }

    protected void ignoreCaseInName(boolean newValue) {
        this.ignoreCaseInName = newValue;
    }

    protected Object getValueType() {
        return this.valueType;
    }

    protected void setValueType(Object newValue) {
        this.valueType = newValue;
    }

    public MatchAttribute() {
    }

    public MatchAttribute(String name) {
        this.setAttributeName(name);
    }

    public boolean isAttribute() {
        return true;
    }

    public void setPattern(StringPattern aPattern) {
        StringPattern[] p = new StringPattern[]{aPattern};
        this.setPatterns(p);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(40);
        boolean hasValueList = false;
        if (this.getNot()) {
            str.append('!');
        }
        str.append(this.getAttributeName());
        boolean bl = hasValueList = this.getPatterns().length > 1;
        if (hasValueList) {
            str.append('{');
            int i = 0;
            while (i < this.getPatterns().length) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(this.getPatterns()[i].getPattern());
                ++i;
            }
            str.append('}');
        } else {
            switch (this.operator()) {
                case 1: {
                    str.append('=');
                    break;
                }
                case 2: {
                    str.append('>');
                    break;
                }
                case 4: {
                    str.append('>');
                    str.append('=');
                    break;
                }
                case 3: {
                    str.append('<');
                    break;
                }
                case 5: {
                    str.append('<');
                    str.append('=');
                }
            }
            str.append(this.getPatterns()[0].toString());
        }
        return str.toString();
    }

    public void setEqualsOperator() {
        this.operator(1);
    }

    public void setGreaterOperator() {
        this.operator(2);
    }

    public void setLessOperator() {
        this.operator(3);
    }

    public void setGreaterOrEqualOperator() {
        this.operator(4);
    }

    public void setLessOrEqualOperator() {
        this.operator(5);
    }

    public void setDatatype(Object type) throws MatchRuleException {
        if (type == null || type == String.class) {
            this.setValueType(null);
            return;
        }
        this.convertToType(type);
        this.setValueType(type);
    }

    protected boolean doMatch(Map dictionary) {
        Object value = null;
        value = this.valueInMap(dictionary);
        if (value == null) {
            return false;
        }
        if (this.isTyped()) {
            return this.doTypedMatch(value);
        }
        if (value instanceof String) {
            return this.matchValue(value);
        }
        if (value instanceof String[]) {
            return this.matchValueArray((Object[])value);
        }
        if (value instanceof Collection) {
            return this.matchValueCollection((Collection)value);
        }
        if (value instanceof Integer) {
            return this.matchValue(value);
        }
        if (value instanceof Integer[]) {
            return this.matchValueArray((Object[])value);
        }
        return false;
    }

    protected boolean doTypedMatch(Object object) {
        Object value = object;
        if (!this.isCorrectType(value)) {
            value = TYPE_CONVERTER.convertToType(object, this.getValueType());
        }
        if (this.isCorrectType(value)) {
            try {
                if (this.getValueType() == Float.class) {
                    return this.doFloatMatch(value);
                }
                if (this.getValueType() == Double.class) {
                    return this.doDoubleMatch(value);
                }
                if (this.getValueType() == BigDecimal.class) {
                    return this.doBigDecimalMatch(value);
                }
                if (this.getValueType() == Integer.class) {
                    return this.doIntegerMatch(value);
                }
                if (this.getValueType() == Long.class) {
                    return this.doLongMatch(value);
                }
                if (this.getValueType() instanceof SimpleDateFormat) {
                    return this.doDateMatch(value);
                }
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return false;
    }

    protected boolean isCorrectType(Object value) {
        if (this.getValueType() instanceof SimpleDateFormat && value.getClass() == Date.class) {
            return true;
        }
        return this.getValueType() == this.getTypeOf(value);
    }

    protected boolean doFloatMatch(Object value) {
        Float[] dataValues = (Float[])this.toArray(value, Float.class);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.floatValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doDoubleMatch(Object value) {
        Double[] dataValues = (Double[])this.toArray(value, Double.class);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.doubleValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doBigDecimalMatch(Object value) {
        BigDecimal[] dataValues = (BigDecimal[])this.toArray(value, BigDecimal.class);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.bigDecimalValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doIntegerMatch(Object value) {
        Integer[] dataValues = (Integer[])this.toArray(value, Integer.class);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.integerValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doLongMatch(Object value) {
        Long[] dataValues = (Long[])this.toArray(value, Long.class);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.longValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doDateMatch(Object value) {
        Date[] dataValues = (Date[])this.toArray(value, Date.class);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.dateValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchValueArray(Object[] values) {
        int i = 0;
        while (i < values.length) {
            if (this.matchValue(values[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchValueCollection(Collection values) {
        Iterator iterator = values.iterator();
        String value = null;
        while (iterator.hasNext()) {
            try {
                value = (String)iterator.next();
                if (!this.matchValue(value)) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean matchValue(Object value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        while (i < this.getPatterns().length) {
            String strValue;
            StringPattern pattern = this.getPatterns()[i];
            if (this.operator() == 1 && pattern.hasWildcard() ? pattern.matches(strValue = value.toString()) : (value instanceof String ? this.compare((String)value, pattern.toString(), pattern.getIgnoreCase()) : value instanceof Integer && this.compare((Integer)value, pattern.toString()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchValueAgainstValues(Comparable value, Object[] values) {
        if (value == null) {
            return false;
        }
        int i = 0;
        while (i < values.length) {
            int result = value.compareTo(values[i]);
            if (this.compareIntegers(result, 0)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean compare(String value, String ruleValue, boolean ignoreCase) {
        int result = ignoreCase ? value.compareToIgnoreCase(ruleValue) : value.compareTo(ruleValue);
        return this.compareIntegers(result, 0);
    }

    protected boolean compare(Integer value, String ruleValue) {
        int ruleIntValue;
        try {
            ruleIntValue = Integer.parseInt(ruleValue);
        }
        catch (RuntimeException e) {
            return false;
        }
        return this.compareIntegers(value, ruleIntValue);
    }

    protected boolean compareIntegers(int a, int b) {
        switch (this.operator()) {
            case 1: {
                return a == b;
            }
            case 4: {
                return a >= b;
            }
            case 5: {
                return a <= b;
            }
            case 2: {
                return a > b;
            }
            case 3: {
                return a < b;
            }
        }
        return false;
    }

    protected void ignoreCase(boolean ignoreIt) {
        int i = 0;
        while (i < this.getPatterns().length) {
            this.getPatterns()[i].setIgnoreCase(ignoreIt);
            ++i;
        }
    }

    protected void multiCharWildcardMatchesEmptyString(boolean yesOrNo) {
        int i = 0;
        while (i < this.getPatterns().length) {
            this.getPatterns()[i].multiCharWildcardMatchesEmptyString(yesOrNo);
            ++i;
        }
    }

    protected void apply(MatchRuleVisitor visitor) {
        String[] values = new String[this.getPatterns().length];
        int i = 0;
        while (i < this.getPatterns().length) {
            values[i] = this.getPatterns()[i].getPattern();
            ++i;
        }
        visitor.attribute(this.getAttributeName(), this.operator(), values, this.getAnd(), this.getNot());
    }

    protected Object valueInMap(Map map) {
        String attrName = this.nameOfAttribute(map);
        if (attrName == null) {
            return null;
        }
        return map.get(attrName);
    }

    protected String nameOfAttribute(Map map) {
        String name = this.getAttributeName();
        if (this.ignoreCaseInName()) {
            Set keyNames = map.keySet();
            for (String key : keyNames) {
                if (!name.equalsIgnoreCase(key)) continue;
                return key;
            }
            name = null;
        }
        return name;
    }

    protected void convertToType(Object type) throws MatchRuleException {
        String[] strValues = new String[this.getPatterns().length];
        int i = 0;
        while (i < this.getPatterns().length) {
            strValues[i] = this.getPatterns()[i].getPattern();
            ++i;
        }
        if (type == Float.class) {
            this.convertToFloat(strValues);
            return;
        }
        if (type == Double.class) {
            this.convertToDouble(strValues);
            return;
        }
        if (type == BigDecimal.class) {
            this.convertToBigDecimal(strValues);
            return;
        }
        if (type == Integer.class) {
            this.convertToInteger(strValues);
            return;
        }
        if (type == Long.class) {
            this.convertToLong(strValues);
            return;
        }
        if (type instanceof SimpleDateFormat) {
            this.convertToDate(strValues, (SimpleDateFormat)type);
            return;
        }
        throw new MatchRuleException("Type " + type + " not supported.");
    }

    protected void convertToFloat(String[] strValues) throws MatchRuleException {
        this.floatValues = new Float[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.floatValues[i] = Float.valueOf(strValues[i]);
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], Float.class);
            }
            ++i;
        }
    }

    protected void convertToDouble(String[] strValues) throws MatchRuleException {
        this.doubleValues = new Double[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.doubleValues[i] = Double.valueOf(strValues[i]);
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], Double.class);
            }
            ++i;
        }
    }

    protected void convertToBigDecimal(String[] strValues) throws MatchRuleException {
        this.bigDecimalValues = new BigDecimal[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.bigDecimalValues[i] = new BigDecimal(strValues[i]);
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], BigDecimal.class);
            }
            ++i;
        }
    }

    protected void convertToInteger(String[] strValues) throws MatchRuleException {
        this.integerValues = new Integer[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.integerValues[i] = Integer.valueOf(strValues[i]);
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], Integer.class);
            }
            ++i;
        }
    }

    protected void convertToLong(String[] strValues) throws MatchRuleException {
        this.longValues = new Long[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.longValues[i] = Long.valueOf(strValues[i]);
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], Long.class);
            }
            ++i;
        }
    }

    protected void convertToDate(String[] strValues, SimpleDateFormat dateFormat) throws MatchRuleException {
        this.dateValues = new Date[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.dateValues[i] = dateFormat.parse(strValues[i]);
            }
            catch (ParseException e) {
                throw new MatchRuleException("Unable to convert '" + strValues[i] + "' to Date with format \"" + dateFormat.toPattern() + "\" for attribute <" + this.getAttributeName() + ">");
            }
            ++i;
        }
    }

    protected MatchRuleException createTypeConversionException(String value, Class type) {
        return new MatchRuleException("Unable to convert '" + value + "' to " + type + " for attribute <" + this.getAttributeName() + ">");
    }

    protected boolean isTyped() {
        return this.getValueType() != null;
    }

    protected Class getTypeOf(Object object) {
        try {
            if (object instanceof List) {
                return ((List)object).get(0).getClass();
            }
            if (object instanceof Collection) {
                return ((Collection)object).iterator().next().getClass();
            }
            if (object.getClass().isArray()) {
                return object.getClass().getComponentType();
            }
            return object.getClass();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected Object[] toArray(Object object, Class type) {
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            Object[] array = (Object[])Array.newInstance(type, coll.size());
            return coll.toArray(array);
        }
        if (object.getClass().isArray()) {
            return (Object[])object;
        }
        Object[] array = (Object[])Array.newInstance(type, 1);
        array[0] = object;
        return array;
    }

    protected void applyDatatypes(Map datatypes) throws MatchRuleException {
        this.setDatatype(this.valueInMap(datatypes));
    }

    protected Collection newCollectionOfType(Class collectionType) {
        try {
            return (Collection)collectionType.newInstance();
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }
}

