/*
 * Decompiled with CFR 0.152.
 */
package org.pf.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pf.reflect.Dynamic;
import org.pf.reflect.ReflectionException;

public class ReflectUtil {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final Constructor[] EMPTY_CONSTRUCTOR_ARRAY = new Constructor[0];
    private static final int NOT_FOUND = -1;
    private static ReflectUtil currentInstance = new ReflectUtil();
    private ClassLoader loader = null;

    public static ReflectUtil current() {
        return currentInstance;
    }

    protected ReflectUtil() {
    }

    public ReflectUtil(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public boolean classExists(String className) {
        return this.findClass(className) != null;
    }

    public Class findClass(String className) {
        Class<?> clazz = null;
        if (className == null) {
            return null;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        try {
            clazz = this.getLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public Class[] getInterfacesOf(Object object) {
        if (object == null) {
            return EMPTY_CLASS_ARRAY;
        }
        return this.getInterfacesOf(object.getClass());
    }

    public Class[] getInterfacesOf(Class aClass) {
        HashSet result = new HashSet(20);
        if (aClass != null) {
            this.collectInterfaces(result, aClass);
        }
        if (result.isEmpty()) {
            return EMPTY_CLASS_ARRAY;
        }
        return result.toArray(new Class[result.size()]);
    }

    public Method findMethod(Class aClass, String methodName, Class[] paramTypes, int modifiers) {
        Method method = null;
        Method[] methods = null;
        Class[] types = null;
        Class[] lookupParamTypes = null;
        Class superclass = null;
        int index = 0;
        lookupParamTypes = paramTypes == null ? EMPTY_CLASS_ARRAY : paramTypes;
        methods = aClass.getDeclaredMethods();
        index = 0;
        while (index < methods.length) {
            if (methods[index].getName().equals(methodName) && this.compatibleTypes(lookupParamTypes, types = methods[index].getParameterTypes()) && (methods[index].getModifiers() & modifiers) == modifiers) {
                return methods[index];
            }
            ++index;
        }
        superclass = aClass.getSuperclass();
        if (superclass != null) {
            method = this.findMethod(superclass, methodName, lookupParamTypes, modifiers);
        }
        return method;
    }

    public Method findMethod(Class aClass, String methodName, Class[] paramTypes) {
        return this.findMethod(aClass, methodName, paramTypes, 0);
    }

    public Method getMethod(Object obj, String methodName, Class[] paramTypes) {
        if (obj == null) {
            return null;
        }
        return this.findMethod(obj.getClass(), methodName, paramTypes);
    }

    public List getMethodsOf(Object obj) {
        Class<?> aClass = null;
        aClass = obj.getClass();
        return this.getMethodsOf(aClass);
    }

    public List getMethodsOf(Class aClass) {
        ArrayList methods = new ArrayList(40);
        this.addInheritedMethods(methods, aClass.getSuperclass());
        this.addMethodsToList(methods, aClass.getDeclaredMethods());
        return methods;
    }

    public List getConstructorsOf(Object object) {
        return this.getConstructorsOf(object.getClass());
    }

    public List getConstructorsOf(Class aClass) {
        ArrayList constructors = new ArrayList(10);
        Constructor<?>[] constructorArray = aClass.getDeclaredConstructors();
        int i = 0;
        while (i < constructorArray.length) {
            constructors.add(constructorArray[i]);
            ++i;
        }
        return constructors;
    }

    public List getFieldsOf(Object obj) {
        Class<?> aClass = null;
        aClass = obj.getClass();
        return this.getFieldsOf(aClass);
    }

    public List getFieldsOf(Class aClass) {
        ArrayList fields = new ArrayList(30);
        this.addInheritedFields(fields, aClass.getSuperclass());
        this.addFieldsToList(fields, aClass.getDeclaredFields());
        return fields;
    }

    public Field findField(Class aClass, String name, int modifiers) {
        if (aClass == null || name == null) {
            throw new IllegalArgumentException("Given class or field name is null");
        }
        List fields = this.getFieldsOf(aClass);
        for (Field field : fields) {
            if (!name.equals(field.getName()) || (field.getModifiers() & modifiers) != modifiers) continue;
            return field;
        }
        return null;
    }

    public Field findField(Class aClass, String name) {
        return this.findField(aClass, name, 0);
    }

    public Field getField(Object obj, String name) {
        if (obj == null || name == null) {
            throw new IllegalArgumentException("Given object or field name is null");
        }
        return this.findField(obj.getClass(), name);
    }

    public Object getValueOf(Object obj, String name) throws NoSuchFieldException {
        Object value = null;
        boolean saveAccessibility = false;
        Field field = this.getField(obj, name);
        if (field == null) {
            throw new NoSuchFieldException("Field name: " + name);
        }
        saveAccessibility = field.isAccessible();
        field.setAccessible(true);
        try {
            try {
                value = field.get(obj);
            }
            catch (NullPointerException nullPointerException) {
                field.setAccessible(saveAccessibility);
            }
            catch (IllegalAccessException ex1) {
                throw new IllegalAccessError(ex1.getMessage());
            }
        }
        finally {
            field.setAccessible(saveAccessibility);
        }
        return value;
    }

    public void setValueOf(Object obj, String name, Object value) throws NoSuchFieldException {
        this.setValueOf(obj, name, value, false);
    }

    public void setValueOf(Object obj, String name, char value) throws NoSuchFieldException {
        this.setValueOf(obj, name, new Character(value), true);
    }

    public void setValueOf(Object obj, String name, int value) throws NoSuchFieldException {
        this.setValueOf(obj, name, new Integer(value), true);
    }

    public void setValueOf(Object obj, String name, byte value) throws NoSuchFieldException {
        this.setValueOf(obj, name, new Byte(value), true);
    }

    public void setValueOf(Object obj, String name, boolean value) throws NoSuchFieldException {
        this.setValueOf(obj, name, value ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public void setValueOf(Object obj, String name, long value) throws NoSuchFieldException {
        this.setValueOf(obj, name, new Long(value), true);
    }

    public void setValueOf(Object obj, String name, short value) throws NoSuchFieldException {
        this.setValueOf(obj, name, new Short(value), true);
    }

    public void setValueOf(Object obj, String name, double value) throws NoSuchFieldException {
        this.setValueOf(obj, name, new Double(value), true);
    }

    public void setValueOf(Object obj, String name, float value) throws NoSuchFieldException {
        this.setValueOf(obj, name, new Float(value), true);
    }

    public boolean hasPublicMethod(Class aClass, String methodName, Class[] paramTypes) {
        if (aClass == null) {
            return false;
        }
        Method method = this.findMethod(aClass, methodName, paramTypes, 1);
        return method != null;
    }

    public boolean hasPublicMethod(Object obj, String methodName, Class[] paramTypes) {
        if (obj == null) {
            return false;
        }
        return this.hasPublicMethod(obj.getClass(), methodName, paramTypes);
    }

    public boolean isPackageVisible(Field field) {
        if (field == null) {
            return false;
        }
        return this.isDefaultVisibility(field.getModifiers());
    }

    public boolean isPackageVisible(Method method) {
        if (method == null) {
            return false;
        }
        return this.isDefaultVisibility(method.getModifiers());
    }

    public boolean isDefaultVisibility(int modifiers) {
        int explicitVisibility = 7;
        return (modifiers & 7) == 0;
    }

    public String getVisibility(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return "public";
        }
        if (Modifier.isProtected(modifiers)) {
            return "protected";
        }
        if (Modifier.isPrivate(modifiers)) {
            return "private";
        }
        return "";
    }

    public Object newInstance(Class aClass) {
        return this.newInstance(aClass, null);
    }

    public Object newInstance(Class aClass, Object param) {
        return this.newInstance(aClass, new Object[]{param});
    }

    public Object newInstance(Class aClass, Object param1, Object param2) {
        return this.newInstance(aClass, new Object[]{param1, param2});
    }

    public Object newInstance(Class aClass, Object[] params) {
        Exception ex = null;
        Class[] paramTypes = this.getTypesFromParameters(params);
        Constructor constructor = this.findConstructor(aClass, paramTypes);
        if (constructor != null) {
            boolean accessible = constructor.isAccessible();
            constructor.setAccessible(true);
            try {
                Object t = constructor.newInstance(params);
                return t;
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                constructor.setAccessible(accessible);
            }
            throw new ReflectionException(ex);
        }
        return null;
    }

    public Object newInstance(String className) {
        return this.newInstance(className, null);
    }

    public Object newInstance(String className, Object param) {
        return this.newInstance(className, new Object[]{param});
    }

    public Object newInstance(String className, Object param1, Object param2) {
        return this.newInstance(className, new Object[]{param1, param2});
    }

    public Object newInstance(String className, Object[] params) {
        Class<?> clazz = null;
        try {
            clazz = this.getLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        return this.newInstance(clazz, params);
    }

    public Constructor findConstructor(Class aClass, Class[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        Constructor<?>[] constructors = aClass.getDeclaredConstructors();
        int i = 0;
        while (i < constructors.length) {
            Class[] types = constructors[i].getParameterTypes();
            if (this.compatibleTypes(paramTypes, types)) {
                return constructors[i];
            }
            ++i;
        }
        return null;
    }

    public Class[] getTypesFromParameters(Object[] params) {
        if (params == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] types = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            types[i] = this.getTypeOf(params[i]);
            ++i;
        }
        return types;
    }

    public Class getTypeOf(Object object) {
        if (object == null) {
            return Object.class;
        }
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Short) {
            return Short.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        if (object instanceof Float) {
            return Float.TYPE;
        }
        if (object instanceof Character) {
            return Character.TYPE;
        }
        if (object instanceof Byte) {
            return Byte.TYPE;
        }
        return object.getClass();
    }

    public boolean contains(Class[] classes, Class aClass) {
        return this.indexOf(classes, aClass) >= 0;
    }

    public int indexOf(Class[] classes, Class aClass) {
        if (this.isNullOrEmpty(classes) || aClass == null) {
            return -1;
        }
        int i = 0;
        while (i < classes.length) {
            if (aClass.equals(classes[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean implementsInterface(Object object, Class anInterface) {
        if (object == null || anInterface == null) {
            return false;
        }
        return this.implementsInterface(object.getClass(), anInterface);
    }

    public boolean implementsInterface(Class aClass, Class anInterface) {
        if (aClass == null || anInterface == null) {
            return false;
        }
        if (aClass.isInterface() || !anInterface.isInterface()) {
            return false;
        }
        Class[] interfaces = this.getInterfacesOf(aClass);
        return this.contains(interfaces, anInterface);
    }

    public Object[] toArray(Collection coll, String methodName, Class elementType) {
        int i = 0;
        if (coll == null) {
            return null;
        }
        Object[] objects = (Object[])Array.newInstance(elementType, coll.size());
        for (Object element : coll) {
            objects[i] = "this".equals(methodName) ? element : Dynamic.invoke(element, methodName);
            ++i;
        }
        return objects;
    }

    public String[] toStringArray(Collection coll, String methodName) {
        return (String[])this.toArray(coll, methodName, String.class);
    }

    protected void addMethodsToList(List methodList, Method[] methods) {
        int i = 0;
        while (i < methods.length) {
            methodList.add(methods[i]);
            ++i;
        }
    }

    protected void addInheritedMethods(List methods, Class aClass) throws SecurityException {
        if (aClass != null) {
            this.addInheritedMethods(methods, aClass.getSuperclass());
            this.addMethodsToList(methods, aClass.getDeclaredMethods());
        }
    }

    protected void addFieldsToList(List fieldList, Field[] fields) {
        int i = 0;
        while (i < fields.length) {
            fieldList.add(fields[i]);
            ++i;
        }
    }

    protected void addInheritedFields(List fields, Class aClass) throws SecurityException {
        if (aClass != null) {
            this.addInheritedFields(fields, aClass.getSuperclass());
            this.addFieldsToList(fields, aClass.getDeclaredFields());
        }
    }

    protected void setValueOf(Object obj, String name, Object value, boolean isPrimitive) throws NoSuchFieldException {
        boolean saveAccessibility = false;
        Field field = this.getField(obj, name);
        if (field == null) {
            throw new NoSuchFieldException("Field name: " + name);
        }
        saveAccessibility = field.isAccessible();
        field.setAccessible(true);
        try {
            try {
                if (isPrimitive) {
                    if (value instanceof Character) {
                        field.setChar(obj, ((Character)value).charValue());
                    } else if (value instanceof Integer) {
                        field.setInt(obj, (Integer)value);
                    } else if (value instanceof Long) {
                        field.setLong(obj, (Long)value);
                    } else if (value instanceof Boolean) {
                        field.setBoolean(obj, (Boolean)value);
                    } else if (value instanceof Double) {
                        field.setDouble(obj, (Double)value);
                    } else if (value instanceof Float) {
                        field.setFloat(obj, ((Float)value).floatValue());
                    } else if (value instanceof Byte) {
                        field.setByte(obj, (Byte)value);
                    } else if (value instanceof Short) {
                        field.setShort(obj, (Short)value);
                    }
                } else {
                    field.set(obj, value);
                }
            }
            catch (NullPointerException nullPointerException) {
                field.setAccessible(saveAccessibility);
            }
            catch (IllegalAccessException ex1) {
                throw new IllegalAccessError(ex1.getMessage());
            }
        }
        finally {
            field.setAccessible(saveAccessibility);
        }
    }

    protected boolean compatibleTypes(Class[] paramTypes, Class[] signatureTypes) {
        if (paramTypes == null) {
            return signatureTypes == null;
        }
        if (signatureTypes == null) {
            return false;
        }
        if (paramTypes.length != signatureTypes.length) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.length) {
            if (!signatureTypes[i].isAssignableFrom(paramTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void collectInterfaces(Set result, Class aClass) {
        if (aClass == null) {
            return;
        }
        if (aClass.isInterface()) {
            result.add(aClass);
        } else {
            this.collectInterfaces(result, aClass.getSuperclass());
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.collectInterfaces(result, interfaces[i]);
            ++i;
        }
    }

    protected boolean isNullOrEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    protected boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    protected ClassLoader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.getClass().getClassLoader();
    }
}

