/*
 * Decompiled with CFR 0.152.
 */
package org.pf.reflect;

import java.lang.reflect.Modifier;

public class Modifiers {
    public static final String VIS_PUBLIC = "public";
    public static final String VIS_PROTECTED = "protected";
    public static final String VIS_PRIVATE = "private";
    public static final String VIS_DEFAULT = "";
    private int bits = 0;

    public int getBits() {
        return this.bits;
    }

    protected void setBits(int newValue) {
        this.bits = newValue;
    }

    public Modifiers() {
    }

    public Modifiers(int initialValue) {
        this.setBits(initialValue);
    }

    public void reset() {
        this.setBits(0);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getBits());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getBits());
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getBits());
    }

    public boolean isNative() {
        return Modifier.isNative(this.getBits());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getBits());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getBits());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getBits());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getBits());
    }

    public boolean isStrict() {
        return Modifier.isStrict(this.getBits());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getBits());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.getBits());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.getBits());
    }

    public boolean isDefaultVisibility() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public String toString() {
        return Modifier.toString(this.getBits());
    }

    public boolean equals(Object object) {
        if (object instanceof Modifiers) {
            Modifiers mod = (Modifiers)object;
            return this.getBits() == mod.getBits();
        }
        return false;
    }

    public int hashCode() {
        return this.getBits();
    }

    public void setAbstract() {
        this.setModifier(1024);
    }

    public void setFinal() {
        this.setModifier(16);
    }

    public void setInterface() {
        this.setModifier(512);
    }

    public void setNative() {
        this.setModifier(256);
    }

    public void setPrivate() {
        this.setDefaultVisibility();
        this.setModifier(2);
    }

    public void setProtected() {
        this.setDefaultVisibility();
        this.setModifier(4);
    }

    public void setPublic() {
        this.setDefaultVisibility();
        this.setModifier(1);
    }

    public void setStatic() {
        this.setModifier(8);
    }

    public void setStrict() {
        this.setModifier(2048);
    }

    public void setSynchronized() {
        this.setModifier(32);
    }

    public void setTransient() {
        this.setModifier(128);
    }

    public void setVolatile() {
        this.setModifier(64);
    }

    public void setDefaultVisibility() {
        this.unsetModifier(7);
    }

    public void setVisibility(String visibility) {
        if (VIS_PUBLIC.equals(visibility)) {
            this.setPublic();
            return;
        }
        if (VIS_PROTECTED.equals(visibility)) {
            this.setProtected();
            return;
        }
        if (VIS_PRIVATE.equals(visibility)) {
            this.setPrivate();
            return;
        }
        this.setDefaultVisibility();
    }

    public void unsetAbstract() {
        this.unsetModifier(1024);
    }

    public void unsetFinal() {
        this.unsetModifier(16);
    }

    public void unsetInterface() {
        this.unsetModifier(512);
    }

    public void unsetNative() {
        this.unsetModifier(256);
    }

    public void unsetPrivate() {
        this.unsetModifier(2);
    }

    public void unsetProtected() {
        this.unsetModifier(4);
    }

    public void unsetPublic() {
        this.unsetModifier(1);
    }

    public void unsetStatic() {
        this.unsetModifier(8);
    }

    public void unsetStrict() {
        this.unsetModifier(2048);
    }

    public void unsetSynchronized() {
        this.unsetModifier(32);
    }

    public void unsetTransient() {
        this.unsetModifier(128);
    }

    public void unsetVolatile() {
        this.unsetModifier(64);
    }

    protected void setModifier(int mod) {
        this.setBits(this.getBits() | mod);
    }

    protected void unsetModifier(int mod) {
        this.setBits(this.getBits() & ~mod);
    }
}

