/*
 * Decompiled with CFR 0.152.
 */
package org.pf.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.pf.file.Classpath;
import org.pf.file.ClasspathElement;
import org.pf.file.FileUtil;
import org.pf.plugin.ClassRegistry;
import org.pf.plugin.LoggerProvider;
import org.pf.plugin.PluginUtil;

public class PluginCollector {
    protected static final String DEBUG_PREFIX = "org.pf.plugin.PluginCollector: ";
    public static boolean DEBUG = "true".equals(System.getProperty("org.pf.plugin.PluginCollector.debug"));
    private ClassRegistry classRegistry = null;

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    protected void setClassRegistry(ClassRegistry newValue) {
        this.classRegistry = newValue;
    }

    public PluginCollector() {
        this(null);
    }

    public PluginCollector(ClassRegistry registry) {
        this.setClassRegistry(registry == null ? new ClassRegistry() : registry);
    }

    public ClassRegistry loadPluginsViaClassLoader(String filename) {
        InputStream stream = this.getClass().getResourceAsStream(filename);
        if (stream != null) {
            if (DEBUG) {
                this.debug("Reading plugin file " + filename + "via classloader.");
            }
            this.readMapping(stream, filename);
        } else if (DEBUG) {
            this.debug("Classloader could not find file " + filename);
        }
        return this.getClassRegistry();
    }

    public ClassRegistry loadPlugins(String filename) {
        return this.loadPlugins(filename, this.getPluginClasspath());
    }

    public ClassRegistry loadPlugins(String filename, String classpath) {
        this.readPlugins(filename, classpath);
        return this.getClassRegistry();
    }

    public ClassRegistry loadPlugins(String filename, Classpath classpath) {
        this.readPlugins(filename, classpath);
        return this.getClassRegistry();
    }

    protected void readPlugins(String filename, String strClasspath) {
        Classpath classpath = new Classpath(strClasspath);
        classpath.removeDuplicates();
        this.readPlugins(filename, classpath);
    }

    protected void readPlugins(String filename, Classpath classpath) {
        if (DEBUG) {
            this.debug("Lookup file <" + filename + "> in <" + classpath + ">");
        }
        ClasspathElement[] elements = classpath.elementsContaining(filename);
        int i = 0;
        while (i < elements.length) {
            if (DEBUG) {
                this.debug("Found file <" + filename + "> in <" + elements[i].getName() + ">");
            }
            this.readMapping(elements[i], filename);
            ++i;
        }
    }

    protected void readMapping(ClasspathElement element, String filename) {
        InputStream stream = null;
        try {
            stream = element.open(filename);
        }
        catch (IOException ex) {
            if (DEBUG) {
                this.debug("Error when opening file <" + filename + "> in <" + element.getName() + "> : " + ex.toString());
            }
            return;
        }
        this.readMapping(stream, filename);
    }

    protected void readMapping(InputStream stream, String filename) {
        try {
            try {
                Properties properties = new Properties();
                properties.load(stream);
                this.addMappings(properties);
            }
            catch (IOException ex) {
                if (DEBUG) {
                    this.debug("Failed to load properties from file " + filename + "    : " + ex.toString());
                }
                this.fileUtil().close(stream);
            }
        }
        finally {
            this.fileUtil().close(stream);
        }
    }

    protected void addMappings(Properties properties) {
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            if (DEBUG) {
                this.debug("Register plugin key=" + string + " | value=" + value);
            }
            this.getClassRegistry().register((Object)string, value);
        }
    }

    protected Classpath getPluginClasspath() {
        return PluginUtil.current().getPluginClasspath();
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }

    protected void debug(String text) {
        LoggerProvider.getLogger().logDebug(DEBUG_PREFIX + text);
    }
}

