/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.List;
import org.pf.joi.AbstractObjectSpy;
import org.pf.joi.ArraySpy;
import org.pf.joi.BasicInspector;
import org.pf.joi.ClassAssociations;
import org.pf.joi.CommonFunctions;
import org.pf.joi.ExportProvider;
import org.pf.joi.InspectionWindowController;
import org.pf.joi.InspectorRegistry;
import org.pf.joi.ObjectSpy;
import org.pf.reflect.ClassInfo;
import org.pf.text.StringUtil;

public abstract class Inspector
extends MouseAdapter {
    protected static final String PROG_NAME = "Java Object Inspector";
    protected static final String PROG_ID = "JOI";
    protected static final String PROG_VERSION = "V3.0";
    protected static final String PROG_COPYRIGHT = "Copyright (c) 1999-2010, by Manfred Duchrow";
    protected static final String PROG_SIGNATURE = "JOI V3.0";
    protected static final String PROG_FULL_SIGNATURE = "Java Object Inspector V3.0";
    protected static final String ActionSeparator = "|";
    protected static final String ExportPrefix = "Export|";
    protected static final String ImportPrefix = "Import|";
    public static final String INSPECTOR_MAPPING_FILENAME = "META-INF/joi.inspector";
    public static final String INSPECTOR_MAPPING_FILENAME_CLASSLOADER = "/META-INF/joi-cl.inspector";
    public static final String INSPECTOR_MAPPING_FILENAME_ALL = "/META-INF/joi-all.inspector";
    public static final String EXPORTER_MAPPING_FILENAME = "META-INF/joi.exporter";
    public static final String EXPORTER_MAPPING_FILENAME_CLASSLOADER = "/META-INF/joi-cl.exporter";
    public static final String EXPORTER_MAPPING_FILENAME_ALL = "/META-INF/joi-all.exporter";
    private static List controllerRegistry = new ArrayList();
    private static ClassAssociations inspectorBinding = null;
    private static ClassAssociations exportProviderRegistry = null;
    private static boolean haltCurrentProccess = false;
    private AbstractObjectSpy inspectedObject = null;

    protected static List getControllerRegistry() {
        return controllerRegistry;
    }

    protected static void setControllerRegistry(List newValue) {
        controllerRegistry = newValue;
    }

    protected static ClassAssociations getInspectorBinding() {
        return inspectorBinding;
    }

    protected static void setInspectorBinding(ClassAssociations newValue) {
        inspectorBinding = newValue;
    }

    protected static ClassAssociations getExportProviderRegistry() {
        return exportProviderRegistry;
    }

    protected static void setExportProviderRegistry(ClassAssociations newValue) {
        exportProviderRegistry = newValue;
    }

    protected static boolean getHaltCurrentProccess() {
        return haltCurrentProccess;
    }

    protected static void setHaltCurrentProccess(boolean newValue) {
        haltCurrentProccess = newValue;
    }

    protected AbstractObjectSpy getInspectedObject() {
        return this.inspectedObject;
    }

    protected void setInspectedObject(AbstractObjectSpy newValue) {
        this.inspectedObject = newValue;
    }

    public static Inspector basicInspect(Object obj) {
        return Inspector.basicInspect(null, obj);
    }

    public static Inspector basicInspect(String name, Object obj) {
        return Inspector.launchInspectorOn(new BasicInspector(), name, obj);
    }

    public static Inspector inspect(Object obj) {
        return Inspector.inspect(null, obj);
    }

    public static Inspector inspect(String name, Object obj) {
        return Inspector.launchInspectorOn(Inspector.getInspectorFor(obj), name, obj);
    }

    public static void basicInspectWait(Object obj) {
        Inspector.basicInspectWait(null, obj);
    }

    public static void basicInspectWait(String name, Object obj) {
        Inspector.basicInspect(name, obj);
        Inspector.halt();
    }

    public static void inspectWait(Object obj) {
        Inspector.inspectWait(null, obj);
    }

    public static void inspectWait(String name, Object obj) {
        Inspector.inspect(name, obj);
        Inspector.halt();
    }

    public static void bindInspector(String className, String inspectorName) {
        Inspector.inspectorBinding();
        Inspector.basicBindInspector(className, inspectorName);
    }

    public static AbstractObjectSpy getBasicObjectSpy(Object obj) {
        return Inspector.getBasicObjectSpy(null, obj);
    }

    public static AbstractObjectSpy getBasicObjectSpy(String name, Object obj) {
        BasicInspector inspector = null;
        inspector = new BasicInspector();
        return inspector.objectSpyFor(name, obj);
    }

    public static AbstractObjectSpy getObjectSpy(Object obj) {
        return Inspector.getObjectSpy(null, obj);
    }

    public static AbstractObjectSpy getObjectSpy(String name, Object obj) {
        BasicInspector inspector = null;
        inspector = Inspector.getInspectorFor(obj);
        return inspector.objectSpyFor(name, obj);
    }

    public static String fullIdentification() {
        return PROG_FULL_SIGNATURE;
    }

    public static String shortIdentification() {
        return PROG_SIGNATURE;
    }

    public static void deactivateHalt() {
        Inspector.setHaltCurrentProccess(false);
    }

    public static void halt() {
        Inspector.setHaltCurrentProccess(true);
        Inspector.waitWhileHaltActive();
    }

    public static String getProgSignature() {
        return PROG_SIGNATURE;
    }

    public static void main(String[] args) {
        Inspector.inspectWait("System Properties", System.getProperties());
        System.exit(0);
    }

    protected static BasicInspector inspectIn(InspectionWindowController controller, int where, String name, Object obj) {
        BasicInspector inspector = Inspector.getInspectorFor(obj);
        Inspector.openInspectorIn(controller, where, inspector, name, obj);
        return inspector;
    }

    protected static BasicInspector basicInspectIn(InspectionWindowController controller, int where, String name, Object obj) {
        BasicInspector inspector = new BasicInspector();
        Inspector.openInspectorIn(controller, where, inspector, name, obj);
        return inspector;
    }

    protected static BasicInspector openInspectorIn(InspectionWindowController controller, int where, BasicInspector inspector, String name, Object obj) {
        inspector.inspectObject(name, obj);
        controller.openNewInspector(inspector, where);
        return inspector;
    }

    protected static Inspector launchInspectorOn(BasicInspector inspector, String name, Object obj) {
        inspector.inspectObject(name, obj);
        InspectionWindowController controller = new InspectionWindowController();
        Inspector.registerController(controller);
        controller.start(inspector);
        return inspector;
    }

    protected static BasicInspector getInspectorFor(Object obj) {
        BasicInspector inspector = null;
        ClassInfo inspectorClassInfo = null;
        if (obj != null && (inspectorClassInfo = Inspector.findInspectorClassInfoFor(obj)) != null) {
            inspector = (BasicInspector)inspectorClassInfo.createInstance();
        }
        if (inspector == null) {
            inspector = new BasicInspector();
        }
        return inspector;
    }

    protected static ClassInfo findInspectorClassInfoFor(Object object) {
        return Inspector.inspectorBinding().findForClassOfObject(object.getClass(), object);
    }

    protected static ClassAssociations inspectorBinding() {
        if (Inspector.getInspectorBinding() == null) {
            Inspector.initializeInspectorBinding();
        }
        return Inspector.getInspectorBinding();
    }

    protected static void initializeInspectorBinding() {
        Inspector.setInspectorBinding(new InspectorRegistry());
        CommonFunctions.loadPluginDefinitions(Inspector.getInspectorBinding(), INSPECTOR_MAPPING_FILENAME, INSPECTOR_MAPPING_FILENAME_CLASSLOADER, INSPECTOR_MAPPING_FILENAME_ALL);
    }

    protected static void basicBindInspector(String className, String inspectorName) {
        Inspector.getInspectorBinding().register((Object)className, inspectorName);
    }

    protected static void registerController(InspectionWindowController controller) {
        Inspector.getControllerRegistry().add(controller);
    }

    protected static void unregisterController(InspectionWindowController controller) {
        Inspector.getControllerRegistry().remove(controller);
    }

    protected static boolean anyInspectorActive() {
        return Inspector.getControllerRegistry().size() > 0;
    }

    protected static boolean isHaltActive() {
        return Inspector.getHaltCurrentProccess() && Inspector.anyInspectorActive();
    }

    protected static void waitWhileHaltActive() {
        while (Inspector.isHaltActive()) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static ClassAssociations exportProviderRegistry() {
        if (Inspector.getExportProviderRegistry() == null) {
            Inspector.initializeExportProviderRegistry();
        }
        return Inspector.getExportProviderRegistry();
    }

    protected static void initializeExportProviderRegistry() {
        Inspector.setExportProviderRegistry(new ClassAssociations<ExportProvider>(ExportProvider.class));
        CommonFunctions.loadPluginDefinitions(Inspector.getExportProviderRegistry(), EXPORTER_MAPPING_FILENAME, EXPORTER_MAPPING_FILENAME_CLASSLOADER, EXPORTER_MAPPING_FILENAME_ALL);
    }

    protected static void closeAllControllers() {
        InspectionWindowController[] controller = new InspectionWindowController[Inspector.getControllerRegistry().size()];
        Inspector.getControllerRegistry().toArray(controller);
        int index = 0;
        while (index < controller.length) {
            controller[index].terminate();
            ++index;
        }
    }

    protected static String getAboutInfoText() {
        String text = null;
        text = "JOI - Java Object Inspector V3.0\n\n";
        text = String.valueOf(text) + PROG_COPYRIGHT + "\n\n";
        text = String.valueOf(text) + "All Rights Reserved.\n";
        return text;
    }

    protected static ExportProvider findExporterNamed(String exporterId) {
        ExportProvider exportProvider = null;
        String key = exporterId;
        if (key.startsWith(ExportPrefix)) {
            key = StringUtil.current().suffix(key, ExportPrefix);
        }
        exportProvider = (ExportProvider)Inspector.exportProviderRegistry().newInstance(key);
        return exportProvider;
    }

    protected Inspector() {
    }

    protected void inspectObject(String name, Object obj) {
        AbstractObjectSpy ospy = null;
        ospy = this.objectSpyFor(name, obj);
        this.setInspectedObject(ospy);
    }

    protected AbstractObjectSpy objectSpyFor(Object obj) {
        AbstractObjectSpy ospy = null;
        ospy = obj != null && obj.getClass().isArray() ? new ArraySpy(obj) : new ObjectSpy(obj);
        return ospy;
    }

    protected AbstractObjectSpy objectSpyFor(String name, Object obj) {
        AbstractObjectSpy ospy = null;
        ospy = this.objectSpyFor(obj);
        if (name != null) {
            ospy.setName(name);
        }
        return ospy;
    }
}

