/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.lang.reflect.Modifier;
import org.pf.joi.AbstractObjectSpy;
import org.pf.joi.Spy;

public abstract class ElementSpy
extends Spy
implements Comparable {
    private static final Class[] EDITABLE_CLASSES = new Class[]{String.class, Integer.class, Long.class, Boolean.class, Character.class, Short.class, Byte.class, Float.class, Double.class};
    private AbstractObjectSpy container = null;

    protected AbstractObjectSpy getContainer() {
        return this.container;
    }

    protected void setContainer(AbstractObjectSpy aValue) {
        this.container = aValue;
    }

    public ElementSpy(AbstractObjectSpy object) {
        this.setContainer(object);
    }

    public boolean isElementSpy() {
        return true;
    }

    public int getModifiers() {
        return 1;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof ElementSpy)) {
            return -1;
        }
        ElementSpy eSpy = (ElementSpy)obj;
        return this.getName().compareTo(eSpy.getName());
    }

    public void setValue(Object newValue) throws Exception {
        if (this.isEditable()) {
            if (this.isCorrectType(newValue)) {
                this.modifyValue(newValue);
            } else {
                throw new Exception("Incompatible type: " + newValue.getClass().getName());
            }
        }
    }

    public boolean isEditable() {
        if (this.getContainer().allowsElementModification()) {
            if (Modifier.isFinal(this.getModifiers())) {
                return false;
            }
            Class type = this.getCurrentType();
            int i = 0;
            while (i < EDITABLE_CLASSES.length) {
                if (type.isAssignableFrom(EDITABLE_CLASSES[i])) {
                    return true;
                }
                ++i;
            }
            if (type.isPrimitive()) {
                return true;
            }
        }
        return false;
    }

    public boolean is_Integer_or_int() {
        return this.is_int() || this.getCurrentType() == Integer.class;
    }

    public boolean is_Long_or_long() {
        return this.is_long() || this.getCurrentType() == Long.class;
    }

    public boolean is_Short_or_short() {
        return this.is_short() || this.getCurrentType() == Short.class;
    }

    public boolean is_Byte_or_byte() {
        return this.is_byte() || this.getCurrentType() == Byte.class;
    }

    public boolean is_Float_or_float() {
        return this.is_float() || this.getCurrentType() == Float.class;
    }

    public boolean is_Double_or_double() {
        return this.is_double() || this.getCurrentType() == Double.class;
    }

    public boolean is_Character_or_char() {
        return this.is_char() || this.getCurrentType() == Character.class;
    }

    public boolean is_Boolean_or_boolean() {
        return this.is_boolean() || this.getCurrentType() == Boolean.class;
    }

    protected Class getCurrentType() {
        return this.getType();
    }

    protected boolean isCorrectType(Object obj) {
        Class type = this.getType();
        if (type.isPrimitive()) {
            if (this.is_int() && obj instanceof Integer) {
                return true;
            }
            if (this.is_long() && obj instanceof Long) {
                return true;
            }
            if (this.is_boolean() && obj instanceof Boolean) {
                return true;
            }
            if (this.is_char() && obj instanceof Character) {
                return true;
            }
            if (this.is_short() && obj instanceof Short) {
                return true;
            }
            if (this.is_byte() && obj instanceof Byte) {
                return true;
            }
            if (this.is_double() && obj instanceof Double) {
                return true;
            }
            if (this.is_float() && obj instanceof Float) {
                return true;
            }
        } else if (obj == null) {
            return true;
        }
        return this.getType().isInstance(obj);
    }

    protected void modifyValue(Object newValue) throws Exception {
        this.getContainer().setElementValue(this, newValue);
    }
}

