/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pf.plugin.ClassRegistry;
import org.pf.reflect.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassAssociations<T>
extends ClassRegistry<T> {
    ClassAssociations() {
    }

    public ClassAssociations(Class<T> typeOfRegisteredClasses) {
        super(typeOfRegisteredClasses);
    }

    @Override
    public String[] keys() {
        Set<Object> keySet = this.registry().keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    protected ClassInfo findForClassOfObject(Class aClass, Object object) {
        ClassInfo result = null;
        int index = 0;
        if (aClass != null) {
            result = this.getClassInfo(aClass);
            if (result != null && !this.canBeUsed(result, object)) {
                result = null;
            }
            if (result == null) {
                Class<?>[] interfaces = aClass.getInterfaces();
                while (result == null && index < interfaces.length) {
                    result = this.findForClassOfObject(interfaces[index], object);
                    ++index;
                }
                if (result != null && !this.canBeUsed(result, object)) {
                    result = null;
                }
                if (result == null && !aClass.isInterface() && (result = this.findForClassOfObject(this.getSuperclassOf(aClass), object)) != null && !this.canBeUsed(result, object)) {
                    result = null;
                }
            }
        }
        return result;
    }

    protected Class getSuperclassOf(Class aClass) {
        if (aClass.isArray()) {
            Class<?> superclass = aClass.getComponentType().getSuperclass();
            if (superclass == null || superclass == Object.class) {
                return Object.class;
            }
            Object array = Array.newInstance(superclass, 0);
            return array.getClass();
        }
        return aClass.getSuperclass();
    }

    protected boolean canBeUsed(ClassInfo classInfo, Object object) {
        try {
            Object pluginObject = classInfo.createInstance();
            return pluginObject != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected ClassInfo getClassInfo(Class aClass) {
        return this.get(this.nameOfClass(aClass));
    }

    protected String nameOfClass(Class aClass) {
        if (aClass.isArray()) {
            return String.valueOf(this.nameOfClass(aClass.getComponentType())) + "[]";
        }
        return aClass.getName();
    }

    protected Map getMapping() {
        String[] keys = this.keys();
        HashMap<String, String> mapping = new HashMap<String, String>(keys.length);
        int i = 0;
        while (i < keys.length) {
            mapping.put(keys[i], this.getClassName(keys[i]));
            ++i;
        }
        return mapping;
    }
}

