/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import org.pf.text.StringUtil;
import org.pf.util.NamedText;

class PropertiesFileElement
extends NamedText {
    protected static final String COMMENT_INDICATOR = "#";
    protected static final String ASSIGNMENT_CHAR = "=";
    protected static final int TYPE_UNKNOWN = -1;
    protected static final int TYPE_EMPTY = 0;
    protected static final int TYPE_COMMENT = 1;
    protected static final int TYPE_PROPERTY = 2;
    private String line = null;
    private int type = -1;
    private boolean deleted = false;

    protected String getLine() {
        return this.line;
    }

    protected void setLine(String newValue) {
        this.line = newValue;
    }

    protected int getType() {
        return this.type;
    }

    protected void setType(int newValue) {
        this.type = newValue;
    }

    protected boolean deleted() {
        return this.deleted;
    }

    protected void deleted(boolean newValue) {
        this.deleted = newValue;
    }

    protected PropertiesFileElement(String line) {
        super(null, null);
        this.setLine(line);
        this.init();
    }

    protected PropertiesFileElement(String name, String value) {
        this(String.valueOf(name.trim()) + ASSIGNMENT_CHAR + value.trim());
    }

    public void changeValue(String newValue) {
        if (this.isProperty() && newValue != null) {
            String newLine = this.str().replaceAll(this.getLine(), this.text(), newValue);
            this.setLine(newLine);
            this.text(newValue);
        }
    }

    public boolean becomeComment() {
        if (this.isProperty()) {
            String newLine = COMMENT_INDICATOR + this.getLine();
            this.setLine(newLine);
            this.init();
            return this.isComment();
        }
        return false;
    }

    public boolean becomeProperty() {
        if (this.isComment()) {
            String newLine = this.str().suffix(this.getLine(), COMMENT_INDICATOR);
            this.setLine(newLine);
            this.init();
            return this.isProperty();
        }
        return false;
    }

    public boolean isProperty() {
        return this.getType() == 2;
    }

    public boolean isEmptyLine() {
        return this.getType() == 0;
    }

    public boolean isComment() {
        return this.getType() == 1;
    }

    public void undelete() {
        this.deleted(false);
    }

    protected void init() {
        String trimmedLine = this.line.trim();
        if (trimmedLine.length() == 0) {
            this.setType(0);
            return;
        }
        if (trimmedLine.startsWith(COMMENT_INDICATOR)) {
            this.setType(1);
            return;
        }
        if (trimmedLine.indexOf(ASSIGNMENT_CHAR) < 0) {
            this.setType(-1);
            return;
        }
        String[] keyValue = this.str().splitNameValue(trimmedLine, ASSIGNMENT_CHAR);
        this.name(keyValue[0].trim());
        this.text(keyValue[1].trim());
        this.setType(2);
    }

    protected String inspectString() {
        return this.getLine();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

